/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.utils.ExportHelper;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.util.MapWriter;
import biz.elabor.prebilling.util.PrintMapWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import org.homelinux.elabor.calendar.Month;

public class LetstdPrintMapWriter
extends PrintMapWriter {
    protected static final String HEADER = "#LT0000..............................................................................................";
    private static final NumberFormat HEADER_FORMATTER = new DecimalFormat("00");
    private final int anno;
    private final Month mese;
    private final PrebillingConfiguration configuration;
    private final String headerMatr;
    private final DateFormat timestampFormat;

    public LetstdPrintMapWriter(int anno, Month mese, PrebillingConfiguration configuration) {
        this.anno = anno;
        this.mese = mese;
        this.configuration = configuration;
        int lunghezzaMatricola = this.configuration.getLunghezzaMatricola();
        this.headerMatr = ExportHelper.fixedLength("", lunghezzaMatricola).replaceAll(" ", ".");
        this.timestampFormat = StrategyCommonHelper.getTimestampFormat();
    }

    @Override
    protected void printDispatcher(String idEsecuzione, String azienda, MapWriter mapWriter, String preSpec, String pivSpev, Date timestamp) throws FileNotFoundException {
        this.printDispatcher(idEsecuzione, mapWriter, String.valueOf(preSpec) + azienda + "-", pivSpev, timestamp);
    }

    @Override
    protected void printReseller(String idEsecuzione, String azienda, MapWriter mapWriter, String preSpec, String pivSpec, Date timestamp) throws FileNotFoundException {
        File folder = ConfigurationHelper.getResellerTmpLettureFolder(this.configuration, idEsecuzione, azienda, Funzionalita.LETTURE);
        this.print(mapWriter, folder, String.valueOf(azienda) + "-" + preSpec, pivSpec, timestamp);
    }

    public void printDispatcher(String idEsecuzione, MapWriter mapWriter, String preSpec, String pivSpec, Date timestamp) throws FileNotFoundException {
        if (!mapWriter.isEmpty()) {
            File folder = ConfigurationHelper.getDispatcherTmpLettureFolder(this.configuration, idEsecuzione, Funzionalita.LETTURE);
            this.print(mapWriter, folder, preSpec, pivSpec, timestamp);
        }
    }

    private void print(MapWriter mapWriter, File folder, String preSpec, String pivSpec, Date timestamp) throws FileNotFoundException {
        String timestampStr = this.timestampFormat.format(timestamp);
        String meseStr = String.valueOf(this.mese.getIndex());
        String fileName = "let-std-" + preSpec + this.anno + "-" + meseStr + "-" + pivSpec + "-" + timestampStr + ".txt";
        File file = new File(folder, fileName);
        this.print(mapWriter, file);
    }

    private void print(MapWriter mapWriter, File file) throws FileNotFoundException {
        if (!mapWriter.isEmpty()) {
            boolean header = !file.exists();
            try (PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));){
                if (header) {
                    String lettura = String.valueOf(HEADER_FORMATTER.format(this.mese.getIndex())) + HEADER_FORMATTER.format(this.anno - 2000);
                    printWriter.print(String.valueOf(HEADER.replace("0000", lettura)) + this.headerMatr + "\r\n");
                }
                mapWriter.flush(printWriter);
            }
        }
    }
}

