/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.prebilling.common.AbstractFileCopyStrategy;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.web.xml.IsolableServiceStrategy;
import biz.elabor.prebilling.web.xml.Partition;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.homelinux.elabor.file.FileSystemTools;
import org.homelinux.elabor.file.NotDirectoryException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class FileCopyStrategy
extends AbstractFileCopyStrategy
implements ServiceStrategy,
IsolableServiceStrategy {
    private final Funzionalita funzionalita;
    private final PrebillingConfiguration configuration;

    public FileCopyStrategy(Funzionalita funzionalita, PrebillingConfiguration configuration, TalkManager talkManager) {
        super(configuration, talkManager);
        this.funzionalita = funzionalita;
        this.configuration = configuration;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        Logger logger = status.getLogger();
        String idEsecuzione = status.getIdEsecuzione();
        return this.execute(idEsecuzione, logger);
    }

    @Override
    protected void copyDispatcher(String idEsecuzione, Logger logger) throws NotDirectoryException, IOException {
        File destination;
        File source = ConfigurationHelper.getDispatcherTmpFolder(this.configuration, idEsecuzione, this.funzionalita);
        if (source.exists()) {
            destination = this.configuration.getDispatcherOutputFolder();
            destination.mkdirs();
            FileSystemTools.folderCopy(source, destination, logger);
        }
        if ((source = ConfigurationHelper.getMiddlewareTmpFolder(this.configuration, idEsecuzione, this.funzionalita)).exists()) {
            destination = this.configuration.getMiddlewareOutputFolder();
            destination.mkdirs();
            FileSystemTools.folderCopy(source, destination, logger);
        }
    }

    @Override
    protected File[] getResellerTmpFolders(String idEsecuzione) {
        return ConfigurationHelper.getResellerTmpFolders(this.configuration, idEsecuzione, this.funzionalita);
    }

    @Override
    protected File getResellerFolder(String id) {
        return this.configuration.getResellerOutputFolder(id);
    }

    @Override
    protected File getExecutionTmpFolder(String idEsecuzione) {
        return ConfigurationHelper.getExecutionTmpFolder(this.configuration, idEsecuzione);
    }

    @Override
    public boolean executePartition(ServiceStatus status, Partition partition) {
        return this.execute(status);
    }
}

