/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.ExtendedLT;
import biz.elabor.prebilling.model.misure.InvalidFasciaValue;
import biz.elabor.prebilling.model.misure.MappaMisureAzienda;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraNonoraria;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.MnoPod;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.model.statomisure.StatoPnoHandler;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.model.statopod.StatoPodHelper;
import biz.elabor.prebilling.model.statopod.StatoPodMisuraHandler;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StatoMisuraHandler;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.GestFile16Helper;
import biz.elabor.prebilling.services.common.LettureTecnichePTH;
import biz.elabor.prebilling.services.common.PraticaTardivaHandler;
import biz.elabor.prebilling.services.common.SmisHandlingException;
import biz.elabor.prebilling.services.common.SmisObsoletoException;
import biz.elabor.prebilling.services.common.Status;
import biz.elabor.prebilling.services.common.SwitchoutHelper;
import biz.elabor.prebilling.services.common.TipoPrestazione;
import biz.elabor.prebilling.services.common.statopod.LettureTecnicheTH;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodCheckException;
import biz.elabor.prebilling.services.common.statopod.StatoPodInvalidoException;
import biz.elabor.prebilling.services.common.statopod.StatoPodObsoletoException;
import biz.elabor.prebilling.services.letture.CurrentMisuraHandler;
import biz.elabor.prebilling.services.letture.MisuraHandler;
import biz.elabor.prebilling.services.letture.MisureAzienda;
import biz.elabor.prebilling.services.letture.statopod.MontaggioStatoPodHandler;
import biz.elabor.prebilling.services.letture.statopod.SmontaggioStatoPodHandler;
import biz.elabor.prebilling.services.volture.ExtMno;
import biz.elabor.prebilling.util.MapWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.arrays.ArrayHelper;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.exceptions.BasicKeyException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.structures.StructuresHelper;
import org.homelinux.elabor.structures.extractors.KeyExtractor;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.structures.safe.SafeMap;
import org.homelinux.elabor.text.Format;

public class ExportLettureTecnicheStrategy
implements ServiceStrategy {
    private static final DateFormat SHORT_DATE_FORMAT = new SimpleDateFormat("dd/MM/yy");
    private static final DecimalFormat OUTPUT_DOUBLE_FORMAT = Format.newDecimalFormat(Locale.ITALIAN, "+000000000.000");
    private static final StatoPodMisuraHandler MISURA_HANDLER = new CurrentMisuraHandler();
    private static final Date END_OF_TIME = CalendarTools.getEndOfTime();
    private static final PraticaTardivaHandler PT_HANDLER = new LettureTecnichePTH();
    private final Funzionalita funzionalita;
    private final int anno;
    private final Month mese;
    private final PrebillingConfiguration configuration;
    private final MisureDao misureDao;
    private final TalkManager talkManager;
    private final int lunghezzaMatricola;
    private final SmontaggioStatoPodHandler smontaggioSPH;
    private final MontaggioStatoPodHandler montaggioSPH;
    private final StatoMisuraHandler statoSmisHandler;
    private final StatoMisuraHandler statoPnoHandler;
    private PrintWriter log;
    private final DateFormat timestampFormat;
    private final DateFormat dataFormat;
    private final DecimalFormat doubleFormat;
    private final String filterPod;

    public ExportLettureTecnicheStrategy(Funzionalita funzionalita, int anno, Month mese, String filterPod, PrebillingConfiguration configuration, MisureDao misureDao, TalkManager talkManager) {
        this.funzionalita = funzionalita;
        this.anno = anno;
        this.mese = mese;
        this.configuration = configuration;
        this.misureDao = misureDao;
        this.talkManager = talkManager;
        this.lunghezzaMatricola = this.configuration.getLunghezzaMatricola();
        this.smontaggioSPH = new SmontaggioStatoPodHandler("MISURE_POD_NON_ORARI", false, misureDao, MISURA_HANDLER);
        LettureTecnicheTH lettureTecnicheTH = new LettureTecnicheTH();
        this.montaggioSPH = new MontaggioStatoPodHandler(lettureTecnicheTH, misureDao);
        this.statoSmisHandler = funzionalita.getStatoSmisHandler();
        this.statoPnoHandler = new StatoPnoHandler();
        this.timestampFormat = StrategyCommonHelper.getTimestampFormat();
        this.dataFormat = StrategyHelper.getDataFormat();
        this.doubleFormat = BasicRecordCreatorHelper.getDoubleFormat();
        this.filterPod = filterPod;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        this.handleExtra(status);
        boolean ok = true;
        for (MisureAzienda misureAzienda : status.getPnos()) {
            String azienda = misureAzienda.getKey();
            String className = this.getClass().getSimpleName();
            PrebillingContext.setContext(className, "azienda: " + azienda);
            ok &= this.exportAzienda(status, misureAzienda);
        }
        return ok &= this.print(status);
    }

    private void handleExtra(ServiceStatus status) {
        int ritardo = this.configuration.getGgcoflet();
        Date timeout = this.configuration.getTimeout(ritardo);
        ListMap<String, PraticaVolo> piv = status.getPiv();
        for (List list : piv) {
            try {
                for (PraticaVolo pratica : list) {
                    if (pratica.isHandled()) continue;
                    String codicePod = pratica.getCodicePod();
                    if (this.filterPod != null && !this.filterPod.isEmpty() && !this.filterPod.equals(codicePod)) continue;
                    this.handleExtra(pratica, timeout, status);
                }
            }
            catch (DataNotFoundException exc) {
                String message = exc.getMessage();
                Warning sentence = new Warning("export.gesfile.strategy", message);
                sentence.setCss("alert-danger");
                sentence.addParam(exc.getKey());
                this.talkManager.addSentence(sentence);
            }
        }
    }

    private void handleExtra(PraticaVolo pratica, Date timeout, ServiceStatus status) throws DataNotFoundException {
        String azienda = pratica.getCodiceReseller();
        String codicePod = pratica.getCodicePod();
        String codicePrestazione = pratica.getCodicePrestazione();
        SpecificaTecnica specificaTecnica = pratica.getSpecificaTecnica();
        Date dataPratica = specificaTecnica.getData();
        MappaMisureAzienda pno = status.getPnos();
        TipoPrestazione tipoPrestazione = TipoPrestazione.create(codicePrestazione);
        if (tipoPrestazione.check(dataPratica, timeout) && !ExportLettureTecnicheStrategy.existsSwitchout(azienda, codicePod, dataPratica, pno)) {
            PodMap podMap = status.getPodMap();
            Pod pod = podMap.get(codicePod);
            try {
                Mno mno = tipoPrestazione.getMno(pod, pratica, PT_HANDLER, this.misureDao);
                mno.setCdaziend(azienda);
                Date dataMisura = CalendarTools.previousDay(dataPratica);
                mno.setDataMisura(dataMisura);
                pno.addSwitchout(pod, mno);
            }
            catch (DataNotFoundException dataNotFoundException) {
                // empty catch block
            }
        }
    }

    private static boolean existsSwitchout(String azienda, String codicePod, Date dataPratica, MappaMisureAzienda pno) {
        boolean exists = false;
        MisureAzienda misureAzienda = (MisureAzienda)pno.get(azienda);
        if (misureAzienda != null) {
            try {
                SafeMap<String, MnoPod> misure = misureAzienda.getMisure();
                MnoPod misura = (MnoPod)misure.get(codicePod);
                for (Mno switchout : misura.getSwitchout()) {
                    Date dataMisura = switchout.getDataMisura();
                    Date dataSwitchout = CalendarTools.nextDay(dataMisura);
                    if (!dataSwitchout.equals(dataPratica)) continue;
                    exists = true;
                }
            }
            catch (DataNotFoundException dataNotFoundException) {
                // empty catch block
            }
        }
        return exists;
    }

    private boolean print(ServiceStatus status) {
        boolean ok;
        try {
            String idEsecuzione = status.getIdEsecuzione();
            Map<String, MapWriter> riconfWriter = status.getRiconfigurazioniVoltureIVWriter();
            for (Map.Entry<String, MapWriter> entry : riconfWriter.entrySet()) {
                this.printAzienda(idEsecuzione, entry, "Volture-IV-VNO-misure", "");
            }
            Map<String, MapWriter> misureTecnicheWriter = status.getMisureTecnicheWriter();
            for (Map.Entry<String, MapWriter> entry : misureTecnicheWriter.entrySet()) {
                this.printAzienda(idEsecuzione, entry, "let-tec", "PREBILLING");
            }
            this.printDispatcher(status);
            ok = true;
        }
        catch (FileNotFoundException exc) {
            Warning sentence = new Warning("export.gesfile.strategy", "file.createFailed");
            sentence.setCss("alert-danger");
            sentence.addParam(exc.getMessage());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }

    private void printAzienda(String idEsecuzione, Map.Entry<String, MapWriter> entry, String prefix, String tipoRec) throws FileNotFoundException {
        String azienda = entry.getKey();
        MapWriter mapWriter = entry.getValue();
        this.printAzienda(idEsecuzione, azienda, mapWriter, prefix, tipoRec);
    }

    private void printDispatcher(ServiceStatus status) throws FileNotFoundException {
        String idEsecuzione = status.getIdEsecuzione();
        File dispatcherFolder = ConfigurationHelper.getDispatcherTmpImportFolder(this.configuration, idEsecuzione, this.funzionalita);
        MapWriter misureDispatcherWriter = status.getMisureTecnicheDispatcherWriter();
        this.print("dispatcher", misureDispatcherWriter, dispatcherFolder, "let-tec", "PREBILLING");
    }

    private boolean exportAzienda(ServiceStatus status, MisureAzienda misureAzienda) {
        boolean ok;
        String azienda = misureAzienda.getKey();
        try {
            Reseller reseller = StrategyHelper.getReseller(azienda, status);
            boolean handleStato = reseller.isHandleStato();
            ArrayList<ExtendedLT> misureLog = new ArrayList<ExtendedLT>();
            for (MnoPod mnoPod : misureAzienda.getMisure()) {
                String codicePod = mnoPod.getKey();
                Map<String, String> suspendedPod = status.getSuspendedPod();
                String descrizione = suspendedPod.get(codicePod);
                if (descrizione == null) {
                    this.write(status, misureLog, handleStato, mnoPod);
                    continue;
                }
                Collection<Mno> pnos = mnoPod.getMisurePno();
                Date endDate = CalendarTools.getNextMese(this.anno, this.mese);
                status.addMnoSospesi(pnos, ErroriElaborazione.EXCLUDING_ERROR, descrizione, endDate);
            }
            this.print(azienda, misureLog, status);
            ok = true;
        }
        catch (FileNotFoundException exc) {
            Warning sentence = new Warning("export.gesfile.strategy", "file.createFailed");
            sentence.setCss("alert-danger");
            sentence.addParam(exc.getMessage());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        catch (DataNotFoundException exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("export.gesfile.strategy", message);
            sentence.setCss("alert-danger");
            sentence.addParam(exc.getKey());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }

    private void write(ServiceStatus status, List<ExtendedLT> misureLog, boolean handleStato, MnoPod mnoPod) {
        Pod pod = mnoPod.getPod();
        String azienda = pod.getAzienda();
        String context = this.getClass().getSimpleName();
        PrebillingContext.setContext(context, "pod: " + pod.getCodice());
        Collection<Mno> pnoTecniche = mnoPod.getMisureTecniche();
        Collection<Mno> pnoSospette = mnoPod.getMisureSospette();
        Collection<ExtMno> smis = mnoPod.getSmis();
        Collection<Mno> switchout = mnoPod.getSwitchout();
        Set<Date> smisDates = ExportLettureTecnicheStrategy.getDates(smis);
        String codicePod = mnoPod.getKey();
        Collection<Mno> prepared = this.prepare(pnoTecniche, pnoSospette);
        Date endDate = CalendarTools.getNextMese(this.anno, this.mese);
        try {
            StatusTransaction transaction = new StatusTransaction(azienda, status, this.configuration);
            this.write(transaction, pod, prepared, misureLog, smisDates, handleStato);
            this.writeSwitchout(transaction, pod, switchout, smis);
            this.writeSmis(transaction, pod, smis, handleStato);
            transaction.handleDeferredStatiPod();
            transaction.commit(pod);
        }
        catch (BasicKeyException exc) {
            String message = exc.getMessage();
            String key = exc.getKey();
            Message sentence = new Message("export.gesfile.strategy", message);
            sentence.setCss("alert-danger");
            sentence.addParam(key);
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
            status.addSmisSospesi(smis, errore, descrizione);
            status.addMnoSospesi(switchout, errore, descrizione, endDate);
            status.addMnoSospesi(prepared, errore, descrizione, endDate);
        }
        catch (RuntimeException exc) {
            String descrizione = StrategyHelper.handleRuntimeException(exc, codicePod, "export.gesfile.strategy", this.talkManager, status);
            status.addSmisSospesi(smis, ErroriElaborazione.EXCLUDING_ERROR, descrizione);
            status.addMnoSospesi(switchout, ErroriElaborazione.EXCLUDING_ERROR, descrizione, endDate);
            status.addMnoSospesi(prepared, ErroriElaborazione.EXCLUDING_ERROR, descrizione, endDate);
        }
    }

    private void writeSwitchout(StatusTransaction transaction, Pod pod, Collection<Mno> switchout, Collection<ExtMno> smis) throws DataNotFoundException, InvalidFasciaValue {
        Date blockDate = ExportLettureTecnicheStrategy.getFirstDate(smis);
        List<Mno> reverted = ArrayHelper.reverse(switchout);
        for (Mno mno : reverted) {
            try {
                boolean handled = SwitchoutHelper.addSwitchout(pod, mno, blockDate, transaction, this.misureDao, this.configuration);
                MisuraHandler handler = SwitchoutHelper.getMisuraHandler(mno, this.configuration, this.talkManager);
                String azienda = pod.getAzienda();
                if (handled) {
                    StatusTransaction.handleElaborato(pod, azienda, mno, handler, this.doubleFormat, transaction);
                    continue;
                }
                ErroriElaborazione errore = ErroriElaborazione.OBSOLETO;
                String message = errore.getMessage();
                Message sentence = new Message("export.stdlet.strategy", message);
                String codicePod = pod.getCodice();
                sentence.addParam(codicePod);
                DateFormat dateFormat = StrategyHelper.getDataFormat();
                sentence.addParam(dateFormat.format(mno.getDataMisura()));
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                MnoResult result = new MnoResult(mno, errore, descrizione);
                handler.addObsoleto(result, transaction);
            }
            catch (SmisHandlingException exc) {
                String message = exc.getMessage();
                String key = exc.getKey();
                Message sentence = new Message("export.gesfile.strategy", message);
                sentence.setCss("alert-danger");
                sentence.addParam(key);
                String codicePrestazione = exc.getCodicePrestazione();
                sentence.addParam(codicePrestazione);
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
                transaction.addPnoSospeso(new MnoResult(mno, errore, descrizione));
            }
        }
    }

    private static Date getFirstDate(Collection<ExtMno> smis) {
        Date date = CalendarTools.getEndOfTime();
        for (ExtMno current : smis) {
            Mno mno = current.getMno();
            Date currDate = mno.getDataMisura();
            if (!currDate.before(date)) continue;
            date = currDate;
        }
        return date;
    }

    private static Set<Date> getDates(Collection<ExtMno> smis) {
        HashSet<Date> dates = new HashSet<Date>();
        KeyExtractor<Date, ExtMno> extractor = new KeyExtractor<Date, ExtMno>(){

            @Override
            public Date getKey(ExtMno element) {
                Mno mno = element.getMno();
                return mno.getDataMisura();
            }
        };
        StructuresHelper.buildCollection(dates, smis, extractor);
        return dates;
    }

    private void writeSmis(StatusTransaction transaction, Pod pod, Collection<ExtMno> smis, boolean handleStato) throws PraticaAnnullataException {
        Date endDate = CalendarTools.getNextMese(this.anno, this.mese);
        Iterator<ExtMno> iterator = smis.iterator();
        boolean handlingSmis = false;
        while (iterator.hasNext()) {
            ErroriElaborazione errore;
            ExtMno extMnoPrev = iterator.next();
            Mno mnoPrev = extMnoPrev.getMno();
            if (!mnoPrev.getDataMisura().before(endDate)) continue;
            ExtMno extMno = iterator.next();
            Mno mno = extMno.getMno();
            try {
                List<MnoResult> results;
                String message;
                ExportLettureTecnicheStrategy.checkMatricolaSmis(pod, mno);
                if (ExportLettureTecnicheStrategy.noBlockingPiv(mno, transaction)) {
                    if (handlingSmis) {
                        message = "smis.handling";
                        errore = ErroriElaborazione.HANDLING_SMIS;
                        results = this.handleError(extMnoPrev, mno, pod, "SMIS", message, errore);
                        transaction.addSmisSospesi(results);
                        continue;
                    }
                    this.smontaggioSPH.setOffset(0);
                    this.montaggioSPH.setOffset(0);
                    this.handleSmis(extMnoPrev, extMno, pod, handleStato, transaction);
                    handlingSmis = true;
                    continue;
                }
                if (ExportLettureTecnicheStrategy.prioritaryCP1(mnoPrev, transaction)) {
                    this.smontaggioSPH.setOffset(2);
                    this.montaggioSPH.setOffset(2);
                    transaction.handleDeferredStatiPod();
                    StatoPod statoPod = transaction.getLastStatoPod();
                    extMnoPrev.getHandler().setForcedStatoPod(statoPod);
                    extMno.getHandler().setForcedStatoPod(statoPod);
                    this.handleSmis(extMnoPrev, extMno, pod, handleStato, transaction);
                    continue;
                }
                message = "blocking.piv";
                errore = ErroriElaborazione.BLOCKING_PIV;
                results = this.handleError(extMnoPrev, mno, pod, null, message, errore);
                transaction.addSmisSospesi(results);
            }
            catch (DataNotFoundException exc) {
                errore = StrategyHelper.getErroreElaborazione(exc);
                String message = exc.getMessage();
                String key = exc.getKey();
                Message sentence = new Message("export.gesfile.strategy", message);
                sentence.addParam(key);
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                MnoResult result = new MnoResult(mnoPrev, errore, descrizione);
                transaction.addSmisSospeso(result);
                result = new MnoResult(mno, errore, descrizione);
                transaction.addSmisSospeso(result);
            }
            catch (StatoPodCheckException exc) {
                throw new RuntimeException(exc);
            }
            catch (SmisObsoletoException exc) {
                Message sentence = new Message("export.gesfile.strategy", "smis.obsoleto");
                sentence.addParam(exc.getCodicePod());
                Date dataMisura = exc.getDataMisura();
                sentence.addParam(this.dataFormat.format(dataMisura));
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                MnoResult result = new MnoResult(mnoPrev, ErroriElaborazione.SMIS_OBSOLETO, descrizione);
                transaction.addSmisObsoleto(result);
                result = new MnoResult(mno, ErroriElaborazione.SMIS_OBSOLETO, descrizione);
                transaction.addSmisObsoleto(result);
            }
        }
    }

    private static void checkMatricolaSmis(Pod pod, Mno mno) throws SmisObsoletoException {
        Date dataMisura;
        String matricolaPod;
        String matricolaMno;
        String raccolta = mno.getRaccolta();
        if ("M".equals(raccolta) && (matricolaMno = mno.getMatricolaAtt()).equals(matricolaPod = pod.getMatricola(dataMisura = mno.getDataMisura())) && ExportLettureTecnicheStrategy.isAllineato(pod, mno, dataMisura)) {
            String codicePod = pod.getCodice();
            throw new SmisObsoletoException(codicePod, dataMisura);
        }
    }

    private static boolean isAllineato(Pod pod, Mno mno, Date dataMisura) {
        double kaPod = pod.getKa(dataMisura);
        double krPod = pod.getKr(dataMisura);
        double kpPod = pod.getKp(dataMisura);
        double kaMno = mno.getKa().doubleValue();
        double krMno = mno.getKr().doubleValue();
        double kpMno = mno.getKp().doubleValue();
        return kaPod == kaMno && krPod == krMno && kpPod == kpMno;
    }

    private static boolean prioritaryCP1(Mno mno, StatusTransaction transaction) {
        boolean ok = false;
        String codicePod = mno.getCodicePod();
        Date dataMovimento = mno.getDataMovimento();
        ListMap<String, PraticaVolo> piv = transaction.getPiv();
        List pivList = (List)piv.get(codicePod);
        if (pivList != null) {
            for (PraticaVolo pratica : pivList) {
                String codicePrestazione = pratica.getCodicePrestazione();
                SpecificaTecnica dateSpec = pratica.getSpecificaTecnica();
                Date dataPratica = dateSpec.getData();
                if (!codicePrestazione.equals("COF") || !dataPratica.equals(dataMovimento)) continue;
                ok = true;
            }
        }
        return ok;
    }

    private void handleSmis(ExtMno extMnoPrev, ExtMno extMno, Pod pod, boolean handleStato, StatusTransaction transaction) throws StatoPodInvalidoException, StatoPodObsoletoException, DataNotFoundException {
        Mno mnoPrev = extMnoPrev.getMno();
        Mno mno = extMno.getMno();
        String matricolaPod = pod.getMatricolaAttiva();
        if ("FITTIZIA".equals(matricolaPod)) {
            String message = "matricola.fittizia";
            ErroriElaborazione errore = ErroriElaborazione.SMIS_FITTIZIA;
            List<MnoResult> results = this.handleError(extMnoPrev, mno, pod, null, message, errore);
            transaction.addSmisSospesi(results);
        } else if (ExportLettureTecnicheStrategy.matricolaObsoleta(mnoPrev, mno, pod)) {
            String message = "smis.obsoleto";
            ErroriElaborazione errore = ErroriElaborazione.SMIS_OBSOLETO;
            List<MnoResult> results = this.handleError(extMnoPrev, mno, pod, null, message, errore);
            transaction.addSmisObsoleti(results);
        } else {
            this.writeSostituzioneRiprogrammazione(transaction, extMno, extMnoPrev, pod, pod, handleStato, this.statoSmisHandler);
        }
    }

    private static boolean matricolaObsoleta(Mno mnoPrev, Mno mno, Pod pod) {
        Date dataSmontaggio = mnoPrev.getDataMisura();
        Date inizio = pod.getInizioConvenzionale();
        String matricolaMno = mno.getMatricolaAtt();
        String matricolaPod = pod.getMatricolaAttiva();
        return dataSmontaggio.equals(inizio) && matricolaMno.equals(matricolaPod);
    }

    private List<MnoResult> handleError(ExtMno extMnoPrev, Mno mno, Pod pod, String prestazione, String message, ErroriElaborazione errore) {
        ArrayList<MnoResult> results = new ArrayList<MnoResult>();
        Message sentence = new Message("export.gesfile.strategy", message);
        sentence.setCss("alert-warning");
        String podCode = pod.getCodice();
        sentence.addParam(podCode);
        sentence.addParam(prestazione);
        this.talkManager.addSentence(sentence);
        String descrizione = this.talkManager.getMessage(sentence);
        if (extMnoPrev.isReal()) {
            Mno mnoPrev = extMnoPrev.getMno();
            results.add(new MnoResult(mnoPrev, errore, descrizione));
        }
        results.add(new MnoResult(mno, errore, descrizione));
        return results;
    }

    private Collection<Mno> prepare(Collection<Mno> pnoTecniche, Collection<Mno> pnoSospette) {
        ArrayList<Mno> prepared = new ArrayList<Mno>();
        prepared.addAll(pnoTecniche);
        ElaborCalendar calendar = new ElaborCalendar(this.anno, this.mese);
        Date startDate = calendar.getDate();
        for (Mno sospetta : pnoSospette) {
            Date date = sospetta.getDataMisura();
            if (date.before(startDate)) {
                prepared.add(0, sospetta);
                continue;
            }
            prepared.add(sospetta);
        }
        return prepared;
    }

    private void print(String azienda, List<ExtendedLT> listAllineatiLog, ServiceStatus status) throws FileNotFoundException {
        MapWriter misureTecnicheWriter = status.getMisureTecnicheWriter(azienda);
        String idEsecuzione = status.getIdEsecuzione();
        this.printAzienda(idEsecuzione, azienda, misureTecnicheWriter, "let-tec", "PREBILLING");
        File dispatcherFolder = ConfigurationHelper.getDispatcherTmpLettureFolder(this.configuration, idEsecuzione, this.funzionalita);
        this.printLog(azienda, listAllineatiLog, dispatcherFolder);
    }

    public void printAzienda(String idEsecuzione, String azienda, MapWriter mapWriter, String prefix, String tipoRec) throws FileNotFoundException {
        File resellerFolder = ConfigurationHelper.getResellerTmpImportFolder(this.configuration, idEsecuzione, azienda, this.funzionalita);
        this.print(azienda, mapWriter, resellerFolder, prefix, tipoRec);
    }

    private void printLog(String azienda, List<ExtendedLT> listAllineatiLog, File dispatcherFolder) throws FileNotFoundException {
        if (!listAllineatiLog.isEmpty()) {
            String annoMeseFilename = this.funzionalita.getAnnoMeseFilename(this.anno, this.mese);
            String scartateFileName = "let-scartate-" + azienda + annoMeseFilename + "-" + this.timestampFormat.format(new Date()) + ".txt";
            File logFile = new File(dispatcherFolder, scartateFileName);
            this.log = new PrintWriter(logFile);
            try {
                for (ExtendedLT toExport : listAllineatiLog) {
                    MisuraNonoraria mno = toExport.getMno();
                    Pod pod = toExport.getPod();
                    this.printLog("lettura rimozione scartata", pod, mno);
                }
            }
            finally {
                this.log.close();
            }
        }
    }

    private void print(String azienda, MapWriter mapWriter, File folder, String prefix, String sottoTipo) throws FileNotFoundException {
        if (!mapWriter.isEmpty()) {
            String annoMeseFilename = this.funzionalita.getAnnoMeseFilename(this.anno, this.mese);
            String timestamp = this.timestampFormat.format(new Date());
            String fileName = String.valueOf(prefix) + "-" + azienda + annoMeseFilename + "-" + timestamp + ".txt";
            File file = new File(folder, fileName);
            try (PrintWriter printer = new PrintWriter(file);){
                GestFile16Helper.printGestFile16Header(printer, sottoTipo, this.lunghezzaMatricola);
                mapWriter.flush(printer);
            }
            mapWriter.reset();
        }
    }

    private void write(StatusTransaction transaction, Pod pod, Collection<Mno> pnoTecniche, List<ExtendedLT> misureLog, Set<Date> smisDates, boolean handleStato) {
        Status status = Status.UNKNOWN;
        Mno mnoPrev = null;
        Pod podPrev = null;
        for (Mno mno : pnoTecniche) {
            MnoResult result;
            String descrizione;
            Date dataMisura = mno.getDataMisura();
            if (smisDates.contains(dataMisura)) {
                ErroriElaborazione errore = ErroriElaborazione.LET_TEC_SU_SMIS;
                String message = errore.getMessage();
                Message sentence = new Message("export.gesfile.strategy", message);
                String codice = pod.getCodice();
                sentence.addParam(codice);
                sentence.addParam(this.dataFormat.format(dataMisura));
                this.talkManager.addSentence(sentence);
                descrizione = this.talkManager.getMessage(sentence);
                result = new MnoResult(mno, errore, descrizione);
                transaction.addPnoEscluso(result);
                continue;
            }
            try {
                if (SwitchoutHelper.checkSwitchOut(pod, mno, true)) {
                    SwitchoutHelper.addSwitchout(pod, mno, END_OF_TIME, transaction, this.misureDao, this.configuration);
                    MnoResult result2 = new MnoResult(mno, ErroriElaborazione.OK, "");
                    transaction.addPnoElaborato(result2);
                    continue;
                }
                Date dataLett = dataMisura;
                switch (status) {
                    case UNKNOWN: {
                        Date dataInst = mno.getDataInst();
                        if (dataInst.before(dataLett)) {
                            Date dataVoltura = mno.getDataVoltura();
                            if (dataLett.equals(dataVoltura)) {
                                status = Status.ACTIVE;
                                break;
                            }
                            status = Status.CLOSED;
                            break;
                        }
                        this.logAttivazione(transaction, mno, pod, misureLog);
                        status = Status.ACTIVE;
                        break;
                    }
                    case ACTIVE: {
                        status = Status.CLOSED;
                        break;
                    }
                    case CLOSED: {
                        ElaborCalendar calendar = new ElaborCalendar(dataLett);
                        calendar.addGiorni(-1);
                        Date dataPrev = mnoPrev.getDataMisura();
                        if (dataPrev.equals(calendar.getDate())) {
                            this.checkSostituzioneRiprogrammazione(transaction, mno, mnoPrev, pod, podPrev, handleStato);
                        } else {
                            this.logRimozione(transaction, mnoPrev, podPrev, misureLog);
                            this.logAttivazione(transaction, mno, pod, misureLog);
                        }
                        status = Status.ACTIVE;
                    }
                }
                mnoPrev = mno;
                podPrev = pod;
            }
            catch (BasicKeyException exc) {
                ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
                String message = exc.getMessage();
                Message sentence = new Message("export.gesfile.strategy", message);
                this.talkManager.addSentence(sentence);
                descrizione = this.talkManager.getMessage(sentence);
                result = new MnoResult(mno, errore, descrizione);
                transaction.addPnoSospeso(result);
            }
        }
        if (status == Status.CLOSED) {
            this.logRimozione(transaction, mnoPrev, podPrev, misureLog);
        }
    }

    private void checkSostituzioneRiprogrammazione(StatusTransaction transaction, Mno mno, Mno mnoPrev, Pod pod, Pod podPrev, boolean handleStato) {
        if (ExportLettureTecnicheStrategy.noBlockingPiv(mno, transaction)) {
            this.writeSostituzioneRiprogrammazione(mno, mnoPrev, pod, podPrev, handleStato, transaction);
        } else {
            Message sentence = new Message("export.gesfile.strategy", "blocking.piv");
            sentence.setCss("alert-warning");
            String podCode = pod.getCodice();
            sentence.addParam(podCode);
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            ErroriElaborazione errore = ErroriElaborazione.BLOCKING_PIV;
            MnoResult result = new MnoResult(mnoPrev, errore, descrizione);
            this.statoPnoHandler.addSospeso(result, transaction);
            result = new MnoResult(mno, errore, descrizione);
            this.statoPnoHandler.addSospeso(result, transaction);
        }
    }

    private void writeSostituzioneRiprogrammazione(Mno mno, Mno mnoPrev, Pod pod, Pod podPrev, boolean handleStato, StatusTransaction transaction) {
        try {
            ExtMno extMno = new ExtMno(mno);
            ExtMno extMnoPrev = new ExtMno(mnoPrev);
            this.writeSostituzioneRiprogrammazione(transaction, extMno, extMnoPrev, pod, podPrev, handleStato, this.statoPnoHandler);
        }
        catch (DataNotFoundException exc) {
            String messaggio = exc.getMessage();
            String key = exc.getKey();
            String descrizione = this.getDescrizione(messaggio, key);
            ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
            MnoResult result = new MnoResult(mnoPrev, errore, descrizione);
            this.statoPnoHandler.addEscluso(result, transaction);
            result = new MnoResult(mno, errore, descrizione);
            this.statoPnoHandler.addEscluso(result, transaction);
        }
        catch (StatoPodInvalidoException exc) {
            String messaggio = exc.getMessage();
            String key = exc.getKey();
            String descrizione = this.getDescrizione(messaggio, key);
            ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
            MnoResult result = new MnoResult(mnoPrev, errore, descrizione);
            this.statoPnoHandler.addEscluso(result, transaction);
            result = new MnoResult(mno, errore, descrizione);
            this.statoPnoHandler.addEscluso(result, transaction);
        }
        catch (StatoPodObsoletoException exc) {
            String messaggio = exc.getMessage();
            String key = exc.getKey();
            Date date = exc.getDate();
            String[] params = new String[]{key, this.dataFormat.format(date)};
            String descrizione = this.getDescrizione(messaggio, Arrays.asList(params));
            ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
            MnoResult result = new MnoResult(mnoPrev, errore, descrizione);
            transaction.addPnoObsoleto(result);
            result = new MnoResult(mno, errore, descrizione);
            transaction.addPnoObsoleto(result);
        }
    }

    private static boolean noBlockingPiv(Mno mno, StatusTransaction transaction) {
        boolean ok = true;
        String codicePod = mno.getCodicePod();
        Date dataMisura = mno.getDataMisura();
        Date dataMovimento = mno.getDataMovimento();
        ListMap<String, PraticaVolo> piv = transaction.getPiv();
        List pivList = (List)piv.get(codicePod);
        if (pivList != null) {
            for (PraticaVolo pratica : pivList) {
                SpecificaTecnica dateSpec = pratica.getSpecificaTecnica();
                Date dataPratica = dateSpec.getData();
                if (dataPratica.after(dataMisura) || dataPratica.equals(dataMovimento) && pratica.getCodicePrestazione().equals("COF")) continue;
                ok = false;
            }
        }
        return ok;
    }

    private String getDescrizione(String messaggio, String param) {
        return this.getDescrizione(messaggio, Arrays.asList(param));
    }

    private String getDescrizione(String messaggio, List<String> params) {
        Message sentence = new Message("export.gesfile.strategy", messaggio);
        sentence.setParams(params);
        this.talkManager.addSentence(sentence);
        return this.talkManager.getMessage(sentence);
    }

    private void logRimozione(StatusTransaction transaction, Mno mno, Pod pod, List<ExtendedLT> misure) {
        if (ExportLettureTecnicheStrategy.checkRimozioneToPrint(mno, pod)) {
            ExtendedLT misura = new ExtendedLT(mno, null, pod, null, true, "", "", "6");
            misure.add(misura);
            String azienda = pod.getAzienda();
            mno.setCdaziend(azienda);
            transaction.addPnoElaborato(new MnoResult(mno, ErroriElaborazione.OK, ""));
            transaction.count("flussi_non_orari_tecnici");
        } else {
            Message sentence = new Message("export.gesfile.strategy", "lettura.sospesa");
            sentence.addParam(pod.getCodice());
            sentence.addParam(SHORT_DATE_FORMAT.format(mno.getDataMisura()));
            sentence.setCss("alert-warning");
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            transaction.addPnoSospeso(new MnoResult(mno, ErroriElaborazione.LETTURA_TECNICA_SOSPESA, descrizione));
        }
    }

    private void logAttivazione(StatusTransaction transaction, Mno mno, Pod pod, List<ExtendedLT> misure) {
        if (ExportLettureTecnicheStrategy.checkAttivazioneToPrint(mno, pod)) {
            ExtendedLT misura = new ExtendedLT(mno, null, pod, null, true, "", "", "6");
            misure.add(misura);
            String azienda = pod.getAzienda();
            mno.setCdaziend(azienda);
            transaction.addPnoElaborato(new MnoResult(mno, ErroriElaborazione.OK, ""));
            transaction.count("flussi_non_orari_tecnici");
        } else {
            Message sentence = new Message("export.gesfile.strategy", "lettura.sospesa");
            sentence.addParam(pod.getCodice());
            sentence.addParam(SHORT_DATE_FORMAT.format(mno.getDataMisura()));
            sentence.setCss("alert-warning");
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            transaction.addPnoSospeso(new MnoResult(mno, ErroriElaborazione.LETTURA_TECNICA_SOSPESA, descrizione));
        }
    }

    private static boolean checkAttivazioneToPrint(MisuraNonoraria pno, Pod pod) {
        Date dataMisura = pno.getDataMisura();
        Date fine = pod.getFine();
        Date inizio = pod.getInizioConsumi();
        boolean misuraDopoFine = ExportLettureTecnicheStrategy.checkMisuraDopoFinePod(fine, dataMisura);
        return inizio.equals(dataMisura) || misuraDopoFine;
    }

    private static boolean checkMisuraDopoFinePod(Date fine, Date dataMisura) {
        boolean misuraDopoFine = false;
        if (fine != null) {
            misuraDopoFine = dataMisura.after(fine);
        }
        return misuraDopoFine;
    }

    private static boolean checkRimozioneToPrint(MisuraNonoraria pno, Pod pod) {
        Date dataMisura = pno.getDataMisura();
        Date fine = pod.getFine();
        Date inizio = pod.getInizioConsumi();
        boolean fineUgualeDataMis = ExportLettureTecnicheStrategy.checkFinePodUgualeDataMisura(fine, dataMisura);
        return fineUgualeDataMis || dataMisura.before(inizio);
    }

    private static boolean checkFinePodUgualeDataMisura(Date fine, Date dataMisura) {
        boolean fineUgualeDataMisura = false;
        if (fine != null) {
            fineUgualeDataMisura = fine.equals(dataMisura);
        }
        return fineUgualeDataMisura;
    }

    private void printLog(String title, Pod pod, MisuraNonoraria pno) {
        Misura misura = pno.getMisura();
        Date date = misura.getDate();
        boolean misuraAttiva = pod.isMisuraAttiva(date);
        boolean misuraReattiva = pod.isMisuraReattiva(date);
        boolean misuraPotenza = pod.isMisuraPotenza(date);
        this.log.println(String.valueOf(title) + ";" + pno.getCodicePod() + ";" + SHORT_DATE_FORMAT.format(pno.getDataMisura()) + ";" + ExportLettureTecnicheStrategy.format(misuraAttiva, misura.getAttiva(FasciaOraria.F1).getNetto()) + ";" + ExportLettureTecnicheStrategy.format(misuraAttiva, misura.getAttiva(FasciaOraria.F2).getNetto()) + ";" + ExportLettureTecnicheStrategy.format(misuraAttiva, misura.getAttiva(FasciaOraria.F3).getNetto()) + ";" + ExportLettureTecnicheStrategy.format(misuraReattiva, misura.getReattiva(FasciaOraria.F1).getNetto()) + ";" + ExportLettureTecnicheStrategy.format(misuraReattiva, misura.getReattiva(FasciaOraria.F2).getNetto()) + ";" + ExportLettureTecnicheStrategy.format(misuraReattiva, misura.getReattiva(FasciaOraria.F3).getNetto()) + ";" + ExportLettureTecnicheStrategy.format(misuraPotenza, misura.getPotenza(FasciaOraria.F1).getNetto()) + ";" + ExportLettureTecnicheStrategy.format(misuraPotenza, misura.getPotenza(FasciaOraria.F2).getNetto()) + ";" + ExportLettureTecnicheStrategy.format(misuraPotenza, misura.getPotenza(FasciaOraria.F3).getNetto()) + ";");
    }

    private static String format(boolean misura, double value) {
        return misura ? OUTPUT_DOUBLE_FORMAT.format(value) : "";
    }

    private void writeSostituzioneRiprogrammazione(StatusTransaction transaction, ExtMno extMno, ExtMno extMnoPrev, Pod pod, Pod podPrev, boolean handleStato, StatoMisuraHandler statoMisuraHandler) throws StatoPodInvalidoException, StatoPodObsoletoException, DataNotFoundException {
        String tipoRec;
        Mno mno = extMno.getMno();
        Mno mnoPrev = extMnoPrev.getMno();
        String matrPrev = mnoPrev.getMatricolaAtt();
        String matr = mno.getMatricolaAtt();
        boolean monorario = matr != null && matrPrev != null && matr.equals(matrPrev);
        String string = tipoRec = monorario ? "6" : "5";
        if (handleStato) {
            StatoPodHelper.handleSmisStatoPod(transaction, extMno, extMnoPrev, pod, podPrev, this.smontaggioSPH, this.montaggioSPH);
        }
        ExtendedLT misura = new ExtendedLT(mno, mnoPrev, pod, podPrev, monorario, "GM1", "INS", tipoRec);
        ExportLettureTecnicheStrategy.handleMisura(extMno, extMnoPrev, pod, misura, statoMisuraHandler, transaction);
    }

    private static void handleMisura(ExtMno extMno, ExtMno extMnoPrev, Pod pod, ExtendedLT misura, StatoMisuraHandler statoMisuraHandler, StatusTransaction transaction) {
        MnoResult result;
        transaction.addMisuraTecnica(misura);
        String azienda = pod.getAzienda();
        if (extMnoPrev.isReal()) {
            Mno mnoPrev = extMnoPrev.getMno();
            mnoPrev.setCdaziend(azienda);
            result = new MnoResult(mnoPrev, ErroriElaborazione.OK, "");
            statoMisuraHandler.addElaborato(result, transaction);
        }
        if (extMno.isReal()) {
            Mno mno = extMno.getMno();
            mno.setCdaziend(azienda);
            result = new MnoResult(mno, ErroriElaborazione.OK, "");
            statoMisuraHandler.addElaborato(result, transaction);
        }
    }
}

