/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.prebilling.common.AbstractCheckStatusStrategy;
import biz.elabor.prebilling.common.dao.StatoElaborazione;
import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class CheckStatusStrategy
extends AbstractCheckStatusStrategy
implements ServiceStrategy {
    private final Funzionalita funzionalita;
    private final String ambito;
    private final List<String> ambiti;
    private final PrebillingConfiguration configuration;
    private final PrebillingDao prebillingDao;

    private CheckStatusStrategy(Funzionalita funzionalita, String ambito, List<String> ambiti, String azienda, String message, PrebillingConfiguration configuration, PrebillingDao prebillingDao, TalkManager talkManager) {
        super(azienda, message, talkManager);
        this.funzionalita = funzionalita;
        this.ambito = ambito;
        this.ambiti = ambiti;
        this.configuration = configuration;
        this.prebillingDao = prebillingDao;
    }

    public CheckStatusStrategy(Funzionalita funzionalita, Destinatari destinatari, String azienda, String message, PrebillingConfiguration configuration, PrebillingDao prebillingDao, TalkManager talkManager) {
        this(funzionalita, CheckStatusStrategy.getAmbito(destinatari, azienda), destinatari.getAmbiti(azienda), azienda, message, configuration, prebillingDao, talkManager);
    }

    public CheckStatusStrategy(Funzionalita funzionalita, String azienda, String message, PrebillingConfiguration configuration, PrebillingDao prebillingDao, TalkManager talkManager) {
        this(funzionalita, CheckStatusStrategy.getAmbito(null, azienda), CheckStatusStrategy.buildAmbiti(azienda), azienda, message, configuration, prebillingDao, talkManager);
    }

    @Override
    public boolean execute(ServiceStatus status) {
        String idEsecuzione = status.getIdEsecuzione();
        Date date = this.configuration.getToDay();
        return this.execute(date, idEsecuzione);
    }

    @Override
    protected File getTmpFolder(String idEsecuzione) {
        return ConfigurationHelper.getTmpFolder(this.configuration, idEsecuzione, this.funzionalita);
    }

    @Override
    protected StatoElaborazione getStato() throws DataNotFoundException {
        return this.prebillingDao.getStato(this.funzionalita, this.ambiti);
    }

    @Override
    protected void saveStato(TipoStato stato, Date date, String idEsecuzione) {
        this.prebillingDao.saveStato(this.funzionalita, this.ambito, stato, date, idEsecuzione);
    }

    public static String getAmbito(Destinatari destinatari, String azienda) {
        return String.valueOf(destinatari == null ? "" : String.valueOf(destinatari.name()) + "-") + (azienda.isEmpty() ? "*" : azienda);
    }

    private static List<String> buildAmbiti(String azienda) {
        return Arrays.asList(azienda);
    }
}

