/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.TipoLetStd;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.Pratica;
import biz.elabor.prebilling.model.misure.MisuraPdo;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.common.AbstractBasicTPManager;
import biz.elabor.prebilling.services.common.PraticaTardivaHandler;
import java.util.Date;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.db.DataNotFoundException;

abstract class AbstractGenericTPManager
extends AbstractBasicTPManager {
    AbstractGenericTPManager() {
    }

    @Override
    public void addSwitchOut(String destinazione, String codicePrestazione, MisuraPod misura, StatusTransaction transaction) {
    }

    @Override
    public void addMisuraOrariaPeriodo(MisuraPdo misuraPdo, StatusTransaction transaction) {
        transaction.addMisuraOrariaPeriodo(misuraPdo, TipoLetStd.NOPIV);
    }

    @Override
    public boolean check(Date dataPratica, Date timeout) {
        return false;
    }

    @Override
    public Mno getMno(Pod pod, Pratica pratica, PraticaTardivaHandler handler, MisureDao misureDao) throws DataNotFoundException {
        Mno mno;
        Date dataPratica = pratica.getSpecificaTecnica().getData();
        Date dataMisuraDesiderata = CalendarTools.previousDay(dataPratica);
        try {
            String codicePod = pod.getCodice();
            mno = AbstractGenericTPManager.getMisuraCP1Tardiva(codicePod, dataPratica, handler, misureDao);
            Date dataMisura = mno.getDataMisura();
            Date dataMax = pod.getDataMax();
            if (dataMisura.before(dataMax)) {
                mno = handler.buildMnoFromPod(pod, dataPratica);
            }
        }
        catch (DataNotFoundException exc) {
            mno = handler.buildMnoFromPod(pod, dataPratica);
        }
        mno.setDataMisura(dataMisuraDesiderata);
        return mno;
    }

    private static Mno getMisuraCP1Tardiva(String codicePod, Date dataPratica, PraticaTardivaHandler handler, MisureDao misureDao) throws DataNotFoundException {
        Mno mno;
        try {
            mno = handler.getPnoCP1Tardiva(codicePod, dataPratica, ALL_TIPI_DATO, misureDao);
        }
        catch (DataNotFoundException exc) {
            mno = handler.getPdo2GRCP1Tardiva(codicePod, dataPratica, ALL_TIPI_DATO, misureDao);
        }
        return mno;
    }
}

