/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.services.StrategyHelper;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Locale;
import org.homelinux.elabor.text.Format;
import org.homelinux.elabor.tools.MathUtils;

public abstract class AbstractExportNoCrmService {
    protected static final String TESTATA = "D65;POD;DATAEVASIO;MATRICOLA1";
    protected static final DecimalFormat DECIMAL_FORMAT_OUT = Format.newDecimalFormat(Locale.ITALIAN, "0.000");
    protected static final DecimalFormat DECIMAL_FORMAT_K_OUT = Format.newDecimalFormat(Locale.ITALIAN, "0.000000");
    protected static final DecimalFormat DECIMAL_FORMAT_MISURE = Format.newDecimalFormat(Locale.ITALIAN, "0.000+");
    private static final DecimalFormat DECIMAL_FORMAT_IN = Format.newDecimalFormat(Locale.US, "0.000");
    protected final PrebillingConfiguration configuration;
    protected final DateFormat dataFormat;
    protected final DateFormat timestampFormat;

    public AbstractExportNoCrmService(PrebillingConfiguration configuration) {
        this.configuration = configuration;
        this.dataFormat = StrategyHelper.getDataFormat();
        this.timestampFormat = StrategyCommonHelper.getTimestampFormat();
    }

    public String fixCifre(String cifre) {
        return cifre == null || cifre.trim().isEmpty() ? this.configuration.getCifreStd() : cifre.trim();
    }

    public String getDato(String stringValue, double value, DecimalFormat format, double last, int nCifre) {
        return stringValue == null ? "" : this.getDato(value, format, last, nCifre);
    }

    public String getDato(String stringValue, DecimalFormat format, double last, int nCifre) {
        String dato;
        if (stringValue == null) {
            dato = "";
        } else {
            try {
                double value = DECIMAL_FORMAT_IN.parse(stringValue).doubleValue();
                dato = this.getDato(value, format, last, nCifre);
            }
            catch (Exception exc) {
                throw new RuntimeException(exc);
            }
        }
        return dato;
    }

    private String getDato(double original, DecimalFormat format, double last, int nCifre) {
        double value = original;
        if (this.configuration.isTrunking()) {
            value = MathUtils.floor(value, nCifre);
        }
        return AbstractExportNoCrmService.getDato(value, format, last);
    }

    public static String getDato(double original, DecimalFormat format, double last) {
        double value = original >= last - 1.0 && original < last ? last : original;
        return format.format(value);
    }
}

