/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.SnfResult;
import biz.elabor.prebilling.services.common.AbstractExportNoCrmService;
import biz.elabor.prebilling.services.switched.SnfD65;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.tools.StringUtils;

public abstract class AbstractD65CsvService
extends AbstractExportNoCrmService {
    private final TalkManager talkManager;
    private final boolean forceCifre;

    protected abstract String getPrestazione();

    protected abstract void printTipoDato(SnfD65 var1, PrintWriter var2);

    protected abstract void printSegnantiAttiva(SnfD65 var1, PrintWriter var2);

    protected abstract void printSegnantiReattiva(SnfD65 var1, PrintWriter var2);

    protected abstract void printSegnantiPotenza(SnfD65 var1, PrintWriter var2);

    protected abstract void printPotDisp(SnfD65 var1, PrintWriter var2);

    protected abstract void printPotImp(SnfD65 var1, PrintWriter var2);

    public AbstractD65CsvService(PrebillingConfiguration configuration, boolean forceCifre, TalkManager talkManager) {
        super(configuration);
        this.talkManager = talkManager;
        this.forceCifre = forceCifre;
    }

    public boolean export(String azienda, List<? extends SnfD65> snfs, File file, ServiceStatus status) {
        boolean ok;
        try {
            PrintWriter writer = new PrintWriter(file);
            writer.println("D65;POD;DATAEVASIO;MATRICOLA1");
            for (SnfD65 snfD65 : snfs) {
                this.printSnf(snfD65, writer);
                String flusso = snfD65.getCodiceFlusso();
                status.count(azienda, flusso, 1);
                status.addSnfElaborato(new SnfResult(snfD65, ErroriElaborazione.OK, ""));
            }
            writer.close();
            ok = true;
        }
        catch (FileNotFoundException exc) {
            Warning warning = new Warning("export.switch.no.crm", "file.createFailed");
            warning.setCss("alert-danger");
            warning.addParam(file.getAbsolutePath());
            this.talkManager.addSentence(warning);
            ok = false;
        }
        return ok;
    }

    private void printSnf(SnfD65 snf, PrintWriter writer) {
        Date date = snf.getDate();
        String codice = snf.getCodicePod();
        PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + codice);
        writer.print(";");
        writer.print(codice.trim());
        writer.print(";");
        writer.print(this.dataFormat.format(date));
        writer.print(";");
        writer.print(";");
        writer.print(";");
        writer.print(";");
        String cifreAtt = snf.getCifreAtt();
        if (!StringUtils.isEmpty(cifreAtt) || this.forceCifre) {
            String fixCifreAtt = this.fixCifre(cifreAtt);
            writer.print(fixCifreAtt);
        }
        writer.print(";");
        this.printSegnantiAttiva(snf, writer);
        writer.print(";");
        writer.print(";");
        writer.print(";");
        String cifreRea = snf.getCifreRea();
        if (!StringUtils.isEmpty(cifreRea) || this.forceCifre) {
            String fixCifreRea = this.fixCifre(cifreRea);
            writer.print(fixCifreRea);
        }
        writer.print(";");
        this.printSegnantiReattiva(snf, writer);
        writer.print(";");
        writer.print(";");
        writer.print(";");
        String cifrePot = snf.getCifrePot();
        if (!StringUtils.isEmpty(cifrePot) || this.forceCifre) {
            String fixCifrePot = this.fixCifre(cifrePot);
            writer.print(fixCifrePot);
        }
        writer.print(";");
        this.printSegnantiPotenza(snf, writer);
        writer.print(";");
        writer.print(";");
        writer.print(";");
        writer.print(";");
        writer.print(";");
        writer.print(";");
        writer.print(";");
        writer.print(snf.getTrattamento().getFasce());
        writer.print(";");
        writer.print(";");
        writer.print(";");
        String Ka = this.getDato(snf.getKaString(), DECIMAL_FORMAT_K_OUT, 0.0, 0);
        if (!Ka.isEmpty()) {
            writer.print(Ka);
        }
        writer.print(";");
        writer.print(";");
        writer.print(this.getPrestazione());
        writer.print(";");
        String Kr = this.getDato(snf.getKrString(), DECIMAL_FORMAT_K_OUT, 0.0, 0);
        if (!Kr.isEmpty()) {
            writer.print(Kr);
        }
        writer.print(";");
        String Kp = this.getDato(snf.getKpString(), DECIMAL_FORMAT_K_OUT, 0.0, 0);
        if (!Kp.isEmpty()) {
            writer.print(Kp);
        }
        writer.print(";");
        this.printTipoDato(snf, writer);
        writer.print(";");
        writer.print(AbstractD65CsvService.safeTrim(snf.getCodiceTariffa()));
        writer.print(";");
        writer.print(AbstractD65CsvService.safeTrim(snf.getServizioTutela()));
        writer.print(";");
        writer.print((Object)snf.getTrattamento());
        writer.print(";");
        writer.print(AbstractD65CsvService.safeTrim(snf.getTensione()));
        writer.print(";");
        this.printPotImp(snf, writer);
        writer.print(";");
        this.printPotDisp(snf, writer);
        writer.print(";");
        writer.println("*");
    }

    protected static String safeFormat(Number value) {
        return value == null ? "" : DECIMAL_FORMAT_OUT.format(value);
    }

    private static String safeTrim(String value) {
        return value == null ? "" : value.trim();
    }
}

