/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.cessazioni;

import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.calendar.CalendarMap;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.misure.InvalidFasciaValue;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraPdo;
import biz.elabor.prebilling.model.misure.MisureHelper;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.model.statomisure.PdoResult;
import biz.elabor.prebilling.services.CalendarNotFoundException;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.MisuraAccumulator;
import biz.elabor.prebilling.services.common.SmisHandlingException;
import biz.elabor.prebilling.services.common.SwitchoutHelper;
import biz.elabor.prebilling.services.common.TipoPrestazione;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodInvalidoException;
import biz.elabor.prebilling.services.common.statopod.StatoPodObsoletoException;
import biz.elabor.prebilling.services.consolidamento.SplitConsolidamentoStrategy;
import biz.elabor.prebilling.services.letture.MisuraHandler;
import biz.elabor.prebilling.services.letture.RecordStatoLettureStrategy;
import biz.elabor.prebilling.services.letture.statopod.PdoSwitchoutStatoPodHandler;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.exceptions.BasicKeyException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;

public class ExportCessazioniStrategy
implements ServiceStrategy {
    private final int anno;
    private final Month mese;
    private final PrebillingConfiguration configuration;
    private final MisureDao misureDao;
    private final TalkManager talkManager;
    private final DecimalFormat doubleFormat;

    public ExportCessazioniStrategy(int anno, Month mese, PrebillingConfiguration configuration, MisureDao misureDao, TalkManager talkManager) {
        this.anno = anno;
        this.mese = mese;
        this.configuration = configuration;
        this.misureDao = misureDao;
        this.talkManager = talkManager;
        this.doubleFormat = BasicRecordCreatorHelper.getDoubleFormat();
    }

    @Override
    public boolean execute(ServiceStatus status) {
        ListMap<String, PraticaVolo> pivMapList = status.getPiv();
        PodMap podMap = status.getPodMap();
        for (Map.Entry entry : pivMapList.entrySet()) {
            String codicePod = (String)entry.getKey();
            try {
                this.consolidate(codicePod, status);
                Pod pod = podMap.getOnly(codicePod);
                List pivList = (List)pivMapList.get(codicePod);
                this.execute(pod, pivList, status);
                this.recordStatoLetture(status);
            }
            catch (DataNotFoundException exc) {
                String message = exc.getMessage();
                String key = exc.getKey();
                Message sentence = new Message(Funzionalita.CESSAZIONI.name(), message);
                sentence.addParam(key);
                this.talkManager.addSentence(sentence);
            }
        }
        return true;
    }

    private void recordStatoLetture(ServiceStatus status) {
        RecordStatoLettureStrategy recordLettureStrategy = new RecordStatoLettureStrategy(this.misureDao, this.talkManager);
        recordLettureStrategy.execute(status);
        status.resetLetture();
    }

    private void consolidate(String codicePod, ServiceStatus status) {
        SplitConsolidamentoStrategy splitConsolidamentoStrategy = new SplitConsolidamentoStrategy(this.anno, this.mese, codicePod, this.configuration, this.misureDao, this.talkManager);
        splitConsolidamentoStrategy.execute(status);
    }

    private void execute(Pod pod, List<PraticaVolo> pivList, ServiceStatus status) {
        String codicePod = pod.getCodice();
        Date endDate = CalendarTools.getNextMese(this.anno, this.mese);
        for (PraticaVolo piv : pivList) {
            String message;
            Date dataPrestazione = piv.getSpecificaTecnica().getData();
            String codiceDisp = piv.getCodiceDisp();
            List<Mno> misure = this.getMisure(codicePod, dataPrestazione, codiceDisp);
            Pdo pdo = this.getPdo(codicePod, dataPrestazione);
            try {
                this.execute(pod, piv, misure, pdo, status);
            }
            catch (BasicKeyException exc) {
                message = exc.getMessage();
                String key = exc.getKey();
                Message sentence = new Message(Funzionalita.CESSAZIONI.name(), message);
                sentence.addParam(key);
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
                status.addMnoSospesi(misure, errore, descrizione, endDate);
            }
            catch (CalendarNotFoundException exc) {
                message = exc.getMessage();
                Message sentence = new Message(Funzionalita.CESSAZIONI.name(), message);
                sentence.addParam(exc.getKey());
                sentence.addParam(exc.getCodicePod());
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                PdoResult result = new PdoResult(pdo, ErroriElaborazione.CALENDARIO_NOTFOUND, descrizione);
                status.addPdoSospeso(result);
            }
            catch (RuntimeException exc) {
                String descrizione = StrategyHelper.handleRuntimeException(exc, codicePod, Funzionalita.CESSAZIONI.name(), this.talkManager, status);
                status.addMnoSospesi(misure, ErroriElaborazione.EXCLUDING_ERROR, descrizione, endDate);
            }
        }
    }

    public Pdo getPdo(String codicePod, Date dataPrestazione) {
        Pdo pdo;
        try {
            ElaborCalendar calendar = new ElaborCalendar(dataPrestazione);
            int annoPrestazione = calendar.getAnno();
            Month mesePrestazione = calendar.getMese();
            pdo = this.misureDao.getPdo(codicePod, annoPrestazione, mesePrestazione, null, StrategyHelper.STATI);
        }
        catch (DataNotFoundException exc) {
            pdo = null;
        }
        return pdo;
    }

    public List<Mno> getMisure(String codicePod, Date dataPrestazione, String codiceDisp) {
        List<Mno> misureNonorarie = this.misureDao.getPnoPeriodo(this.anno, this.mese, codicePod, StrategyHelper.STATI);
        List<Mno> misureOrarie = this.misureDao.getPdo2GRFinoMese(this.anno, this.mese, codicePod, StrategyHelper.STATI);
        Comparator comparator = (mno1, mno2) -> mno1.getDataMisura().compareTo(mno2.getDataMisura());
        misureOrarie.sort(comparator);
        List<Mno> misure = MisureHelper.merge(misureOrarie, misureNonorarie);
        try {
            Mno vno = this.misureDao.getVno(codicePod, dataPrestazione, codiceDisp);
            misure = ExportCessazioniStrategy.merge(misure, vno);
        }
        catch (DataNotFoundException dataNotFoundException) {
            // empty catch block
        }
        return misure;
    }

    private static List<Mno> merge(List<Mno> misure, Mno vno) {
        return MisureHelper.merge(misure, Arrays.asList(vno));
    }

    private void execute(Pod pod, PraticaVolo piv, List<Mno> misureSegnanti, Pdo pdo, ServiceStatus status) throws DataNotFoundException, SmisHandlingException, InvalidFasciaValue, StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException, CalendarNotFoundException {
        String codicePrestazione = piv.getCodicePrestazione();
        Date dataPrestazione = piv.getSpecificaTecnica().getData();
        Date dataOut = "VT4".equals(codicePrestazione) ? CalendarTools.previousDay(dataPrestazione) : dataPrestazione;
        String codiceReseller = piv.getCodiceReseller();
        StatusTransaction transaction = new StatusTransaction(codiceReseller, status, this.configuration);
        Date blockDate = CalendarTools.getEndOfTime();
        Mno misuraSegnante = ExportCessazioniStrategy.getMisura(misureSegnanti, dataOut);
        if (misuraSegnante != null) {
            SwitchoutHelper.addSwitchout(pod, misuraSegnante, blockDate, transaction, this.misureDao, this.configuration);
            MisuraHandler handler = SwitchoutHelper.getMisuraHandler(misuraSegnante, this.configuration, this.talkManager);
            StatusTransaction.handleElaborato(pod, codiceReseller, misuraSegnante, handler, this.doubleFormat, transaction);
            this.handleObsoleti(pod, misureSegnanti, misuraSegnante, transaction);
        } else if (pdo != null) {
            TipoPrestazione tipoPrestazione = piv.getTipoPrestazione();
            PdoSwitchoutStatoPodHandler handler = new PdoSwitchoutStatoPodHandler(this.misureDao);
            CalendarMap calendarMap = transaction.getCalendarMap();
            RilMese rilMese = pdo.getRilMese();
            MisuraAccumulator accumulator = new MisuraAccumulator(rilMese, calendarMap, this.configuration);
            Misura misura = accumulator.buildMisuraRaw(false, dataOut);
            Date dataMisura = misura.getDate();
            if (dataMisura.equals(dataOut)) {
                pdo.setCdaziend(codiceReseller);
                MisuraPdo misuraPdo = new MisuraPdo(pod, pdo, misura);
                SwitchoutHelper.addSwitchout(tipoPrestazione, piv, misuraPdo, transaction, this.configuration, handler);
                PdoResult result = new PdoResult(pdo, ErroriElaborazione.OK, "");
                transaction.addPdoElaborato(result);
                String codiceFlusso = pdo.getFirstCodiceFlusso();
                transaction.count(codiceFlusso);
            }
        }
        transaction.handleDeferredStatiPod();
        transaction.commit(pod);
    }

    private void handleObsoleti(Pod pod, List<Mno> misureSegnanti, Mno misuraSegnante, StatusTransaction transaction) {
        String reseller = pod.getAzienda();
        for (Mno mno : misureSegnanti) {
            if (mno.getFirstId() == misuraSegnante.getFirstId()) break;
            mno.setCdaziend(reseller);
            ErroriElaborazione errore = ErroriElaborazione.OBSOLETO;
            Message sentence = new Message(Funzionalita.CESSAZIONI.name(), errore.getMessage());
            String codicePod = pod.getCodice();
            sentence.addParam(codicePod);
            Date dataMisura = mno.getDataMisura();
            DateFormat dateFormatter = StrategyHelper.getDataFormat();
            sentence.addParam(dateFormatter.format(dataMisura));
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            MnoResult result = new MnoResult(mno, errore, descrizione);
            String flusso = mno.getCodiceFlusso();
            if (flusso.startsWith("PDO") || flusso.startsWith("RFO")) {
                transaction.addPdo2GRObsoleto(result);
                continue;
            }
            transaction.addPnoObsoleto(result);
        }
    }

    private static Mno getMisura(List<Mno> misure, Date dataOut) {
        Mno misura = null;
        for (Mno mno : misure) {
            String codiceFlusso;
            Date dataMisura = mno.getDataMisura();
            Date dataMisuraOut = ExportCessazioniStrategy.getDataMisuraOut(dataMisura, codiceFlusso = mno.getCodiceFlusso(), dataOut);
            if (dataMisuraOut.after(dataOut)) break;
            if (!dataMisuraOut.equals(dataOut)) continue;
            misura = mno;
            misura.setDataMisura(dataMisuraOut);
        }
        return misura;
    }

    public static Date getDataMisuraOut(Date dataMisura, String codiceFlusso, Date dataOut) {
        Date dataMisuraOut = codiceFlusso.startsWith("VNO") ? CalendarTools.previousDay(dataMisura) : ((codiceFlusso.startsWith("PDO") || codiceFlusso.startsWith("RFO")) && dataOut.equals(CalendarTools.previousDay(dataMisura)) ? dataOut : dataMisura);
        return dataMisuraOut;
    }
}

