/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.cessazioni;

import biz.elabor.misure.model.WorkingPeriod;
import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.services.StrategiesManager;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.cessazioni.ExportCessazioniStrategy;
import biz.elabor.prebilling.services.common.CheckStatusStrategy;
import biz.elabor.prebilling.services.common.FileCopyStrategy;
import biz.elabor.prebilling.services.common.GetCalendarStrategy;
import biz.elabor.prebilling.services.common.GetPivStrategy;
import biz.elabor.prebilling.services.common.GetPrestazioniStrategy;
import biz.elabor.prebilling.services.common.GetResellersStrategy;
import biz.elabor.prebilling.services.common.GetSmartPodStrategy;
import biz.elabor.prebilling.services.common.UpdateStatusStrategy;
import biz.elabor.prebilling.services.letture.ExportSwitchOutStrategy;
import biz.elabor.prebilling.services.letture.GetDispatchingFlussiStrategy;
import biz.elabor.prebilling.services.letture.RecordLettureStrategy;
import biz.elabor.prebilling.services.letture.RecordStatoLettureStrategy;
import biz.elabor.prebilling.web.common.AbstractStrategiesHandler;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class CessazioniStrategiesHandler
extends AbstractStrategiesHandler {
    private final String annoTxt;
    private final String meseTxt;

    public CessazioniStrategiesHandler(String annoTxt, String meseTxt, ConfigurationInstance configurationInstance, TalkManager talkManager) {
        super(configurationInstance, talkManager);
        this.annoTxt = annoTxt;
        this.meseTxt = meseTxt;
    }

    @Override
    public StrategiesManager buildStrategiesManager() throws InvalidParameterValue {
        StrategiesManager manager = new StrategiesManager(this.configuration);
        WorkingPeriod wp = StrategyHelper.checkWorkingPeriod(this.annoTxt, this.meseTxt, this.configuration);
        int anno = wp.getYear();
        Month mese = wp.getMonth();
        manager.addStrategy(new CheckStatusStrategy(Funzionalita.CESSAZIONI, "*", "letture.check", this.configuration, this.prebillingDao, this.talkManager));
        manager.addStrategy(new GetPrestazioniStrategy(this.misureDao));
        manager.addStrategy(new GetCalendarStrategy(this.configuration, this.prebillingDao));
        manager.addStrategy(new GetResellersStrategy(this.prebillingDao));
        manager.addStrategy(new GetDispatchingFlussiStrategy(this.prebillingDao));
        manager.addStrategy(new GetPivStrategy(anno, mese, "", "", this.giadaDao, StrategyHelper.CESSAZIONI_CDUNIPRE_LIST));
        manager.addStrategy(new GetSmartPodStrategy(anno, mese, "", this.configuration, this.giadaDao));
        manager.addStrategy(new ExportCessazioniStrategy(anno, mese, this.configuration, this.misureDao, this.talkManager));
        manager.addStrategy(new ExportSwitchOutStrategy(Funzionalita.CESSAZIONI, anno, mese, this.configuration, this.talkManager));
        manager.addStrategy(new RecordLettureStrategy(this.misureDao, this.talkManager));
        manager.addStrategy(new RecordStatoLettureStrategy(this.misureDao, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.CESSAZIONI, "*", TipoStato.COPIA_FILE, this.configuration, this.prebillingDao));
        manager.addStrategy(new FileCopyStrategy(Funzionalita.CESSAZIONI, this.configuration, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.CESSAZIONI, "*", TipoStato.NO_ESECUZIONE, this.configuration, this.prebillingDao));
        return manager;
    }
}

