/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.attivazioni;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.services.common.AbstractD65CsvService;
import biz.elabor.prebilling.services.switched.SnfD65;
import java.io.PrintWriter;
import java.util.Map;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class D65PrestazioniCsvService
extends AbstractD65CsvService {
    private final String prestazione;

    public D65PrestazioniCsvService(String prestazione, PrebillingConfiguration configuration, TalkManager talkManager) {
        super(configuration, false, talkManager);
        this.prestazione = prestazione;
    }

    @Override
    protected void printSegnantiAttiva(SnfD65 snf, PrintWriter writer) {
        Map<String, Map<String, String>> datiPod = snf.getDatiPod();
        Map<String, String> misura = datiPod.get("Misura");
        String eaF1 = misura.get("EaF1");
        String eaF2 = misura.get("EaF2");
        String eaF3 = misura.get("EaF3");
        this.print(eaF1, eaF2, eaF3, 0, writer);
    }

    private void print(String valueF1, String valueF2, String valueF3, int nCifre, PrintWriter writer) {
        writer.print(this.getDato(valueF1, DECIMAL_FORMAT_MISURE, 0.0, nCifre));
        writer.print(";");
        writer.print(this.getDato(valueF2, DECIMAL_FORMAT_MISURE, 0.0, nCifre));
        writer.print(";");
        writer.print(this.getDato(valueF3, DECIMAL_FORMAT_MISURE, 0.0, nCifre));
        writer.print(";");
    }

    @Override
    protected void printSegnantiReattiva(SnfD65 snf, PrintWriter writer) {
        Map<String, Map<String, String>> datiPod = snf.getDatiPod();
        Map<String, String> misura = datiPod.get("Misura");
        String erF1 = misura.get("ErF1");
        String erF2 = misura.get("ErF2");
        String erF3 = misura.get("ErF3");
        this.print(erF1, erF2, erF3, 0, writer);
    }

    @Override
    protected void printSegnantiPotenza(SnfD65 snf, PrintWriter writer) {
        Map<String, Map<String, String>> datiPod = snf.getDatiPod();
        Map<String, String> misura = datiPod.get("Misura");
        String potF1 = misura.get("PotF1");
        String potF2 = misura.get("PotF2");
        String potF3 = misura.get("PotF3");
        this.print(potF1, potF2, potF3, 1, writer);
    }

    @Override
    protected String getPrestazione() {
        return this.prestazione;
    }

    @Override
    protected void printTipoDato(SnfD65 snf, PrintWriter writer) {
        Map<String, Map<String, String>> datiPod = snf.getDatiPod();
        Map<String, String> misura = datiPod.get("Misura");
        String tipoDato = misura.get("TipoDato");
        writer.print(tipoDato);
    }

    @Override
    protected void printPotDisp(SnfD65 snf, PrintWriter writer) {
    }

    @Override
    protected void printPotImp(SnfD65 snf, PrintWriter writer) {
    }
}

