/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services;

import biz.elabor.prebilling.model.giada.DefaultPodMap;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.RigaPod;
import biz.elabor.prebilling.services.StrategyHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import junit.framework.TestCase;
import org.homelinux.elabor.calendar.Month;

public class StrategyHelperTest
extends TestCase {
    private static final Date INIZIO = new Date(0L);
    private static final Date MIDDLE = new Date(1000000L);
    private static final Date END = new Date(2000000L);

    public void testFillPodMap() {
        ArrayList<RigaPod> righePod = new ArrayList<RigaPod>();
        DefaultPodMap podMap = new DefaultPodMap();
        String codice = StrategyHelper.fillPodMap(righePod, 2019, Month.AUGUST, podMap);
        StrategyHelperTest.assertEquals("", codice);
        Iterator<Pod> iterator = podMap.iterator();
        StrategyHelperTest.assertFalse(iterator.hasNext());
        righePod.add(new RigaPod("pod1", "azienda", false, 0, INIZIO, null, null, null, false, false, false, null, false, null, null, "dispatcher", null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, false, INIZIO, null, null));
        podMap = new DefaultPodMap();
        codice = StrategyHelper.fillPodMap(righePod, 2019, Month.AUGUST, podMap);
        StrategyHelperTest.assertEquals("", codice);
        iterator = podMap.iterator();
        StrategyHelperTest.assertFalse(iterator.hasNext());
        righePod.add(new RigaPod("pod1", "azienda", false, 0, MIDDLE, null, null, null, false, false, false, null, false, null, null, "dispatcher", null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, false, MIDDLE, null, null));
        podMap = new DefaultPodMap();
        codice = StrategyHelper.fillPodMap(righePod, 2019, Month.AUGUST, podMap);
        StrategyHelperTest.assertEquals("", codice);
        iterator = podMap.iterator();
        StrategyHelperTest.assertFalse(iterator.hasNext());
        righePod.add(new RigaPod("pod2", "azienda", false, 0, INIZIO, null, null, null, false, false, false, null, false, null, null, "dispatcher", null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, false, INIZIO, null, null));
        podMap = new DefaultPodMap();
        codice = StrategyHelper.fillPodMap(righePod, 2019, Month.AUGUST, podMap);
        StrategyHelperTest.assertEquals("pod1", codice);
        iterator = podMap.iterator();
        StrategyHelperTest.assertTrue(iterator.hasNext());
        righePod.add(new RigaPod("pod3", "azienda", false, 0, INIZIO, null, null, null, false, false, false, null, false, null, null, "dispatcher", null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, false, INIZIO, null, null));
        podMap = new DefaultPodMap();
        codice = StrategyHelper.fillPodMap(righePod, 2019, Month.AUGUST, podMap);
        StrategyHelperTest.assertEquals("pod2", codice);
        iterator = podMap.iterator();
        StrategyHelperTest.assertTrue(iterator.hasNext());
        righePod.add(new RigaPod("pod3", "azienda", false, 0, MIDDLE, null, null, null, false, false, false, null, false, null, null, "dispatcher", null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, false, MIDDLE, null, null));
        podMap = new DefaultPodMap();
        codice = StrategyHelper.fillPodMap(righePod, 2019, Month.AUGUST, podMap);
        StrategyHelperTest.assertEquals("pod2", codice);
        iterator = podMap.iterator();
        StrategyHelperTest.assertTrue(iterator.hasNext());
        righePod.add(new RigaPod("pod3", "azienda", false, 0, END, null, null, null, false, false, false, null, false, null, null, "dispatcher", null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, false, END, null, null));
        podMap = new DefaultPodMap();
        codice = StrategyHelper.fillPodMap(righePod, 2019, Month.AUGUST, podMap);
        StrategyHelperTest.assertEquals("pod2", codice);
        iterator = podMap.iterator();
        StrategyHelperTest.assertTrue(iterator.hasNext());
        righePod.add(new RigaPod("pod4", "azienda", false, 0, END, null, null, null, false, false, false, null, false, null, null, "dispatcher", null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, false, END, null, null));
        podMap = new DefaultPodMap();
        codice = StrategyHelper.fillPodMap(righePod, 2019, Month.AUGUST, podMap);
        StrategyHelperTest.assertEquals("pod3", codice);
        iterator = podMap.iterator();
        StrategyHelperTest.assertTrue(iterator.hasNext());
    }
}

