/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.services.ServiceStrategy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.homelinux.elabor.tools.MemoryTools;

public class StrategiesManager {
    private final List<ServiceStrategy> strategies;
    private final PrebillingConfiguration configuration;

    public StrategiesManager(PrebillingConfiguration configuration) {
        this.configuration = configuration;
        this.strategies = new ArrayList<ServiceStrategy>();
    }

    public void addStrategy(ServiceStrategy strategy) {
        this.strategies.add(strategy);
    }

    public boolean execute(ServiceStatus status) {
        boolean logMemory = this.configuration.isLogMemory();
        Logger logger = status.getLogger();
        boolean ok = true;
        Iterator<ServiceStrategy> iterator = this.strategies.iterator();
        while (ok && iterator.hasNext()) {
            ServiceStrategy strategy = iterator.next();
            String className = strategy.getClass().getSimpleName();
            logger.info(String.valueOf(className) + " start");
            PrebillingContext.setContext(className, "start");
            ok = strategy.execute(status);
            logger.info(String.valueOf(className) + " end");
            if (!logMemory) continue;
            MemoryTools.logMemory(logger, className);
        }
        return ok;
    }
}

