/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.StatusManager;
import biz.elabor.prebilling.model.TipoLetStd;
import biz.elabor.prebilling.model.calendar.CalendarMap;
import biz.elabor.prebilling.model.calendar.OffertaCommerciale;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.misure.ExtendedLT;
import biz.elabor.prebilling.model.misure.InvalidFasciaValue;
import biz.elabor.prebilling.model.misure.MappaMisureAzienda;
import biz.elabor.prebilling.model.misure.MisuraContatorePdo;
import biz.elabor.prebilling.model.misure.MisuraContatorePod;
import biz.elabor.prebilling.model.misure.MisuraNonoraria;
import biz.elabor.prebilling.model.misure.MisuraNonorariaPod;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.misure.MisureHelper;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.MnoPod;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.Sof;
import biz.elabor.prebilling.model.misure.Trattamento;
import biz.elabor.prebilling.model.prebilling.DispatchingFlussi;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.model.statomisure.PdoResult;
import biz.elabor.prebilling.model.statomisure.SnfResult;
import biz.elabor.prebilling.model.statomisure.SofResult;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.model.statopod.UpdateStatoPod;
import biz.elabor.prebilling.services.DeferredStatoPod;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.WriteCsvSwitchoutService;
import biz.elabor.prebilling.services.common.WriteGestfile16Service;
import biz.elabor.prebilling.services.common.WriteXmlSwitchoutService;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodInvalidoException;
import biz.elabor.prebilling.services.common.statopod.StatoPodObsoletoException;
import biz.elabor.prebilling.services.letture.MisuraHandler;
import biz.elabor.prebilling.services.letture.MisuraMno;
import biz.elabor.prebilling.services.letture.MisureAzienda;
import biz.elabor.prebilling.services.letture.TrattamentoHandler;
import biz.elabor.prebilling.services.letture.WriteLetstdService;
import biz.elabor.prebilling.services.switched.SnfD65;
import biz.elabor.prebilling.services.volture.model.Voltura;
import biz.elabor.prebilling.util.MapWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.structures.CountMap;
import org.homelinux.elabor.structures.Counter;
import org.homelinux.elabor.structures.listmap.BasicListMap;
import org.homelinux.elabor.structures.listmap.DefaultListMapKey;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.structures.listmap.ListMapKey;
import org.homelinux.elabor.structures.listmap.SafeListMap;
import org.homelinux.elabor.structures.safe.SafeMap;

public class StatusTransaction
implements StatusManager {
    private final ServiceStatus status;
    private final PrebillingConfiguration configuration;
    private final List<PdoResult> pdoSospesi;
    private final List<PdoResult> pdoElaborati;
    private final CountMap<String> countMap;
    private final ListMap<String, MisuraPod> switchoutCrm;
    private final ListMap<String, MisuraPod> switchoutNocrm;
    private final List<MisuraPod> rettificheSwitchout;
    private final List<MisuraPod> rettificheSwitchoutDispatcher;
    private final List<StatoPod> statiPod;
    private final List<Voltura> misureOrarieVolturaNoCrm;
    private final ListMap<TipoLetStd, MisuraPod> misureOrariePeriodo;
    private final ListMap<TipoLetStd, MisuraMno> misureNonorariePeriodo;
    private final List<MisuraMno> misureDisallineate;
    private final List<ExtendedLT> misureTecniche;
    private final Map<String, ListMapKey<String, MisuraMno>> misureRettifica;
    private final Map<String, ListMapKey<String, MisuraMno>> misureRettificaIV;
    private final List<MnoResult> pdo2GRElaborati;
    private final List<MnoResult> pdo2GRSospesi;
    private final List<MnoResult> pdo2GRObsoleti;
    private final List<MnoResult> pnoElaborati;
    private final List<MnoResult> pnoSospesi;
    private final List<MnoResult> pnoObsoleti;
    private final List<MnoResult> smisSospesi;
    private final List<MnoResult> smisObsoleti;
    private final List<MnoResult> pnoEsclusi;
    private final List<MnoResult> smisElaborati;
    private final List<MnoResult> smisEsclusi;
    private final List<MnoResult> vnoElaborati;
    private final List<MnoResult> vnoEsclusi;
    private final List<PdoResult> pdoObsoleti;
    private final List<MnoResult> snmSospesi;
    private final List<MnoResult> snmObsoleti;
    private final List<SnfResult> snfObsoleti;
    private final List<SnfResult> snfSospesi;
    private final List<SofResult> sofSospesi;
    private final List<SofResult> sofObsoleti;
    private final List<MnoResult> snmElaborati;
    private final List<MnoResult> vnoSospesi;
    private final List<MnoResult> vnoObsoleti;
    private final List<SnfD65> snfNoCrm;
    private final List<SnfD65> snfCrm;
    private final List<Sof> sofNoCrm;
    private final List<Sof> sofCrm;
    private final List<UpdateStatoPod> updateStatiRichiesta;
    private String azienda;
    private ListMap<String, MisuraContatorePod> riconfigurazioni;
    private List<DeferredStatoPod> deferredStatoPod;
    private List<ExtendedLT> riconfVoltureIV;
    private List<MisuraNonorariaPod> misureLateProcessing;
    private List<MisuraNonoraria> letture;
    private List<MnoResult> pdo2GREsclusi;
    private ListMap<String, Mno> rsnRnv;
    private List<MisuraMno> rettificheMno;
    private List<SnfResult> snfElaborati;

    public StatusTransaction(String azienda, ServiceStatus status, PrebillingConfiguration configuration) {
        this.status = status;
        this.configuration = configuration;
        this.pdoSospesi = new ArrayList<PdoResult>();
        this.pdoElaborati = new ArrayList<PdoResult>();
        this.countMap = new CountMap();
        this.switchoutCrm = new BasicListMap<String, MisuraPod>();
        this.switchoutNocrm = new BasicListMap<String, MisuraPod>();
        this.statiPod = new ArrayList<StatoPod>();
        this.misureOrarieVolturaNoCrm = new ArrayList<Voltura>();
        this.misureOrariePeriodo = new BasicListMap<TipoLetStd, MisuraPod>();
        this.misureNonorariePeriodo = new BasicListMap<TipoLetStd, MisuraMno>();
        this.misureDisallineate = new ArrayList<MisuraMno>();
        this.misureTecniche = new ArrayList<ExtendedLT>();
        this.misureRettifica = new HashMap<String, ListMapKey<String, MisuraMno>>();
        this.misureRettificaIV = new HashMap<String, ListMapKey<String, MisuraMno>>();
        this.rettificheSwitchout = new ArrayList<MisuraPod>();
        this.rettificheSwitchoutDispatcher = new ArrayList<MisuraPod>();
        this.pdo2GRElaborati = new ArrayList<MnoResult>();
        this.pdo2GRSospesi = new ArrayList<MnoResult>();
        this.pdo2GRObsoleti = new ArrayList<MnoResult>();
        this.pnoElaborati = new ArrayList<MnoResult>();
        this.pnoSospesi = new ArrayList<MnoResult>();
        this.pnoObsoleti = new ArrayList<MnoResult>();
        this.smisSospesi = new ArrayList<MnoResult>();
        this.smisObsoleti = new ArrayList<MnoResult>();
        this.pnoEsclusi = new ArrayList<MnoResult>();
        this.smisElaborati = new ArrayList<MnoResult>();
        this.smisEsclusi = new ArrayList<MnoResult>();
        this.vnoElaborati = new ArrayList<MnoResult>();
        this.vnoEsclusi = new ArrayList<MnoResult>();
        this.pdoObsoleti = new ArrayList<PdoResult>();
        this.snmSospesi = new ArrayList<MnoResult>();
        this.snmObsoleti = new ArrayList<MnoResult>();
        this.snfObsoleti = new ArrayList<SnfResult>();
        this.snfSospesi = new ArrayList<SnfResult>();
        this.sofSospesi = new ArrayList<SofResult>();
        this.sofObsoleti = new ArrayList<SofResult>();
        this.snmElaborati = new ArrayList<MnoResult>();
        this.vnoObsoleti = new ArrayList<MnoResult>();
        this.snfNoCrm = new ArrayList<SnfD65>();
        this.snfCrm = new ArrayList<SnfD65>();
        this.sofNoCrm = new ArrayList<Sof>();
        this.sofCrm = new ArrayList<Sof>();
        this.vnoSospesi = new ArrayList<MnoResult>();
        this.updateStatiRichiesta = new ArrayList<UpdateStatoPod>();
        this.riconfigurazioni = new BasicListMap<String, MisuraContatorePod>();
        this.azienda = azienda;
        this.deferredStatoPod = new ArrayList<DeferredStatoPod>();
        this.riconfVoltureIV = new ArrayList<ExtendedLT>();
        this.misureLateProcessing = new ArrayList<MisuraNonorariaPod>();
        this.letture = new ArrayList<MisuraNonoraria>();
        this.pdo2GREsclusi = new ArrayList<MnoResult>();
        this.rsnRnv = new BasicListMap<String, Mno>();
        this.rettificheMno = new ArrayList<MisuraMno>();
        this.snfElaborati = new ArrayList<SnfResult>();
    }

    public void commit(Pod pod) {
        this.addMisureRettifica(pod);
        String codicePod = pod.getCodice();
        this.commit(codicePod);
    }

    public void commit(String codicePod) {
        this.addPdoSospesi();
        this.addPdoElaborati();
        this.addStatiPod();
        this.addMisureOrarieVolturaNoCrm();
        this.addMisureOrariePeriodo(codicePod);
        this.addMisureNonorariePeriodo(codicePod);
        this.addRettificheMno(codicePod);
        this.addMisureTecniche();
        this.addMisureDisallineate();
        this.addSwitchout();
        this.addRettificheSwitchOut();
        this.addRettificheSwitchOutDispatcher();
        this.addPdo2GRElaborati();
        this.addPdo2GRSospesi();
        this.addPdo2GRObsoleti();
        this.addPdo2GREsclusi();
        this.addPnoElaborati();
        this.addPnoSospesi();
        this.addPnoObsoleti();
        this.addSmisSospesi();
        this.addSmisObsoleti();
        this.addPnoEsclusi();
        this.addSmisElaborati();
        this.addSmisEsclusi();
        this.addVnoElaborati();
        this.addVnoEsclusi();
        this.addPdoObsoleti();
        this.snmSospesi();
        this.snmObsoleti();
        this.snfObsoleti();
        this.snfSospesi();
        this.sofSospesi();
        this.sofObsoleti();
        this.snmElaborati();
        this.vnoObsoleti();
        this.snfNoCrm();
        this.snfCrm();
        this.sofNoCrm();
        this.sofCrm();
        this.vnoSospesi();
        this.updateStatiRichiesta();
        this.addRiconfigurazioni();
        this.addMisureLateProcessing();
        this.addLetture();
        this.addRnsRnv();
        this.addSnfElaborati();
        this.count();
    }

    private void addSnfElaborati() {
        for (SnfResult result : this.snfElaborati) {
            this.status.addSnfElaborato(result);
        }
    }

    private void addLetture() {
        this.status.addLetture(this.letture);
    }

    private void addMisureLateProcessing() {
        for (MisuraNonorariaPod misura : this.misureLateProcessing) {
            this.status.addMisuraLateProcessing(misura);
        }
    }

    private void updateStatiRichiesta() {
        for (UpdateStatoPod update : this.updateStatiRichiesta) {
            this.status.addUpdateStatiRichiesta(update);
        }
    }

    private void vnoSospesi() {
        for (MnoResult result : this.vnoSospesi) {
            this.status.addVnoSospeso(result);
        }
    }

    private void sofCrm() {
        for (Sof snf : this.sofCrm) {
            this.status.addSofCrm(snf);
        }
    }

    private void sofNoCrm() {
        for (Sof sof : this.sofNoCrm) {
            this.status.addSofNoCrm(sof);
        }
    }

    private void snfCrm() {
        for (SnfD65 snfD65 : this.snfCrm) {
            this.status.addSnfCrm(snfD65);
        }
    }

    private void snfNoCrm() {
        for (SnfD65 snf : this.snfNoCrm) {
            this.status.addSnfNoCrm(snf);
        }
    }

    private void vnoObsoleti() {
        for (MnoResult result : this.vnoObsoleti) {
            this.status.addVnoObsoleto(result);
        }
    }

    private void snmElaborati() {
        for (MnoResult result : this.snmElaborati) {
            this.status.addSnmElaborato(result);
            this.status.addLettura((MisuraNonoraria)result.getRecord());
        }
    }

    private void sofObsoleti() {
        for (SofResult result : this.sofObsoleti) {
            this.status.addSofObsoleto(result);
        }
    }

    private void sofSospesi() {
        for (SofResult result : this.sofSospesi) {
            this.status.addSofSospeso(result);
        }
    }

    private void snfObsoleti() {
        for (SnfResult result : this.snfObsoleti) {
            this.status.addSnfObsoleto(result);
        }
    }

    private void snfSospesi() {
        for (SnfResult result : this.snfSospesi) {
            this.status.addSnfSospeso(result);
        }
    }

    private void snmObsoleti() {
        for (MnoResult result : this.snmObsoleti) {
            this.status.addSnmObsoleto(result);
        }
    }

    private void snmSospesi() {
        for (MnoResult result : this.snmSospesi) {
            this.status.addSnmSospeso(result);
        }
    }

    private void addPdoObsoleti() {
        for (PdoResult result : this.pdoObsoleti) {
            this.status.addPdoObsoleto(result);
        }
    }

    private void addVnoEsclusi() {
        for (MnoResult result : this.vnoEsclusi) {
            this.status.addVnoEscluso(result);
        }
    }

    private void addVnoElaborati() {
        for (MnoResult result : this.vnoElaborati) {
            this.status.addVnoElaborato(result);
        }
    }

    private void addSmisEsclusi() {
        for (MnoResult result : this.smisEsclusi) {
            this.status.addSmisEscluso(result);
        }
    }

    private void addSmisElaborati() {
        for (MnoResult result : this.smisElaborati) {
            this.status.addSmisElaborato(result);
        }
    }

    private void addPnoEsclusi() {
        for (MnoResult result : this.pnoEsclusi) {
            this.status.addPnoEscluso(result);
        }
    }

    private void addSmisSospesi() {
        for (MnoResult result : this.smisSospesi) {
            this.status.addSmisSospeso(result);
        }
    }

    private void addSmisObsoleti() {
        for (MnoResult result : this.smisObsoleti) {
            this.status.addSmisObsoleto(result);
        }
    }

    private void addPnoObsoleti() {
        for (MnoResult result : this.pnoObsoleti) {
            this.status.addPnoObsoleto(result);
        }
    }

    private void addPdo2GRSospesi() {
        for (MnoResult result : this.pdo2GRSospesi) {
            this.status.addPdo2GRSospeso(result);
        }
    }

    private void addPdo2GRObsoleti() {
        for (MnoResult result : this.pdo2GRObsoleti) {
            this.status.addPdo2GRObsoleto(result);
        }
    }

    private void addPdo2GREsclusi() {
        for (MnoResult result : this.pdo2GREsclusi) {
            this.status.addPdo2GREscluso(result);
        }
    }

    private void addPdo2GRElaborati() {
        for (MnoResult result : this.pdo2GRElaborati) {
            this.status.addPdo2GRElaborato(result);
        }
    }

    private void addPnoSospesi() {
        for (MnoResult result : this.pnoSospesi) {
            this.status.addPnoSospeso(result);
        }
    }

    private void addPnoElaborati() {
        for (MnoResult result : this.pnoElaborati) {
            this.status.addPnoElaborato(result);
        }
    }

    public void addRiconfigurazionePdo2GR(Mno mno, MisuraContatorePdo misuraPdo) {
        this.riconfigurazioni.add("let-tec", misuraPdo);
        MnoResult result = new MnoResult(mno, ErroriElaborazione.OK, "");
        this.status.addPdo2gElaborato(result);
    }

    private void addRiconfigurazioni() {
        if (this.azienda != null) {
            this.status.addRiconfigurazioni(this.azienda, this.riconfigurazioni);
        }
    }

    private void addMisureOrariePeriodo(String codicePod) {
        if (this.azienda != null) {
            for (Map.Entry entry : this.misureOrariePeriodo.entrySet()) {
                String dispatcher;
                TipoLetStd tipo = (TipoLetStd)((Object)entry.getKey());
                List values = (List)entry.getValue();
                WriteLetstdService service = new WriteLetstdService(codicePod, this.configuration);
                Pod pod = ((MisuraPod)values.get(0)).getPod();
                MapWriter mapWriter = StrategyHelper.checkDispatcher(pod, dispatcher = this.configuration.getCodiceDispatcher()) ? this.status.getMisureDispatcherWriter(tipo) : this.status.getMisureOrarieWriter(this.azienda, tipo);
                TrattamentoHandler handler = Trattamento.O.getHandler();
                service.write(values, mapWriter, handler, false);
            }
        }
    }

    private void addMisureDisallineate() {
        if (this.azienda != null) {
            WriteGestfile16Service service = new WriteGestfile16Service(this.configuration, this.status);
            MapWriter misureTecnicheWriter = this.status.getMisureTecnicheWriter(this.azienda);
            service.writeDisallineate(misureTecnicheWriter, this.misureDisallineate);
        }
    }

    private void addMisureTecniche() {
        if (this.azienda != null) {
            WriteGestfile16Service service = new WriteGestfile16Service(this.configuration, this.status);
            MapWriter misureTecnicheWriter = this.status.getMisureTecnicheWriter(this.azienda);
            service.writeTecnicheReseller(misureTecnicheWriter, this.misureTecniche);
            MapWriter misureTecnicheDispatcherWriter = this.status.getMisureTecnicheDispatcherWriter();
            service.writeTecnicheDispatcher(misureTecnicheDispatcherWriter, this.misureTecniche);
            MapWriter riconfVoltureIVWriter = this.status.getRiconfigurazioniVoltureIVWriter(this.azienda);
            service.writeRiconfigurazioniVoltureIV(riconfVoltureIVWriter, this.riconfVoltureIV);
            this.addLetture(this.misureTecniche);
            this.addLetture(this.riconfVoltureIV);
        }
    }

    private void addLetture(List<ExtendedLT> misure) {
        for (ExtendedLT misuraTecnica : misure) {
            MisuraNonoraria mnoPrev = misuraTecnica.getMnoPrev();
            MisuraNonoraria mno = misuraTecnica.getMno();
            if (!mno.getDataMisura().equals(mnoPrev.getDataMisura()) && mnoPrev.getCodicePod() != null) {
                this.status.addLettura(mnoPrev);
            }
            this.status.addLettura(mno);
        }
    }

    private void addMisureNonorariePeriodo(String codicePod) {
        if (this.azienda != null) {
            for (Map.Entry entry : this.misureNonorariePeriodo.entrySet()) {
                TipoLetStd tipo = (TipoLetStd)((Object)entry.getKey());
                List values = (List)entry.getValue();
                WriteLetstdService service = new WriteLetstdService(codicePod, this.configuration);
                MisuraMno misuraMno = (MisuraMno)values.get(0);
                Pod pod = misuraMno.getPod();
                Trattamento trattamento = misuraMno.getTrattamento();
                TrattamentoHandler handler = trattamento.getHandler();
                String dispatcher = this.configuration.getCodiceDispatcher();
                MapWriter mapWriter = StrategyHelper.checkDispatcher(pod, dispatcher) ? this.status.getMisureDispatcherWriter(tipo) : this.status.getMisureNonorarieWriter(this.azienda, tipo);
                service.write(values, mapWriter, handler, false);
                this.status.addLetture(values);
            }
        }
    }

    private void addRettificheMno(String codicePod) {
        if (!this.rettificheMno.isEmpty()) {
            WriteLetstdService service = new WriteLetstdService(codicePod, this.configuration);
            MisuraMno misuraMno = this.rettificheMno.get(0);
            Trattamento trattamento = misuraMno.getTrattamento();
            TrattamentoHandler handler = trattamento.getHandler();
            MapWriter mapWriter = this.status.getMisureDispatcherWriter(TipoLetStd.RETT);
            service.write(this.rettificheMno, mapWriter, handler, true);
            this.status.addLetture(this.rettificheMno);
        }
    }

    private void addMisureRettifica(Pod pod) {
        if (this.azienda != null) {
            Map<String, Map<String, MapWriter>> rettificheIVWriter;
            Map<String, Map<String, MapWriter>> rettificheWriter;
            String dispatcher = this.configuration.getCodiceDispatcher();
            if (StrategyHelper.checkDispatcher(pod, dispatcher)) {
                rettificheWriter = this.status.getRettificheDispatcherWriter();
                rettificheIVWriter = this.status.getRettificheIVDispatcherWriter();
            } else {
                rettificheWriter = this.status.getRettificheResellerWriter();
                rettificheIVWriter = this.status.getRettificheIVResellerWriter();
            }
            String codicePod = pod.getCodice();
            this.addMisureRettifica(codicePod, this.misureRettifica, rettificheWriter);
            this.addMisureRettifica(codicePod, this.misureRettificaIV, rettificheIVWriter);
        }
    }

    private void addMisureRettifica(String codicePod, Map<String, ListMapKey<String, MisuraMno>> rettifiche, Map<String, Map<String, MapWriter>> writer) {
        if (!rettifiche.isEmpty()) {
            StrategyHelper.addMisureRettifica(codicePod, this.azienda, rettifiche, writer, this.status);
            for (ListMapKey<String, MisuraMno> valuesMap : rettifiche.values()) {
                for (Map.Entry entry : valuesMap.entrySet()) {
                    List misure = (List)entry.getValue();
                    this.status.addLetture(misure);
                }
            }
        }
    }

    private void addSwitchout() {
        if (this.azienda != null) {
            List switchoutPrestazione;
            for (Map.Entry entry : this.switchoutCrm.entrySet()) {
                String codicePrestazione = (String)entry.getKey();
                MapWriter xmlMapWriter = this.status.getSwitchoutXmlWriter(String.valueOf(this.azienda) + "|" + codicePrestazione);
                WriteXmlSwitchoutService xmlService = new WriteXmlSwitchoutService(codicePrestazione, xmlMapWriter, this.configuration);
                switchoutPrestazione = (List)entry.getValue();
                xmlService.write(switchoutPrestazione);
                for (MisuraPod misuraPod : switchoutPrestazione) {
                    this.status.addLettura(misuraPod);
                }
            }
            for (Map.Entry entry : this.switchoutNocrm.entrySet()) {
                String key = (String)entry.getKey();
                MapWriter csvMapWriter = this.status.getSwitchoutCsvWriter(String.valueOf(this.azienda) + "|" + key);
                WriteCsvSwitchoutService csvService = new WriteCsvSwitchoutService(csvMapWriter, this.configuration);
                switchoutPrestazione = (List)entry.getValue();
                csvService.write(switchoutPrestazione);
                for (MisuraPod misuraPod : switchoutPrestazione) {
                    this.status.addLettura(misuraPod);
                }
            }
        }
    }

    private void addRettificheSwitchOut() {
        if (this.azienda != null) {
            MapWriter csvMapWriter = this.status.getRettificheSwitchoutCsvWriter(this.azienda);
            WriteCsvSwitchoutService csvService = new WriteCsvSwitchoutService(csvMapWriter, this.configuration);
            csvService.write(this.rettificheSwitchout);
        }
    }

    private void addRettificheSwitchOutDispatcher() {
        this.status.addRettificheSwitchoutDispatcher(this.rettificheSwitchoutDispatcher);
    }

    private void addMisureOrarieVolturaNoCrm() {
        for (Voltura voltura : this.misureOrarieVolturaNoCrm) {
            this.status.addMisuraOrariaVolturaNoCrm(this.azienda, voltura);
        }
    }

    private void addStatiPod() {
        this.status.addStatiPod(this.statiPod);
    }

    private void count() {
        for (Map.Entry entry : this.countMap.entrySet()) {
            String flusso = (String)entry.getKey();
            Counter value = (Counter)entry.getValue();
            int count = value.getCount();
            this.status.count(this.azienda, flusso, count);
        }
    }

    private void addPdoSospesi() {
        for (PdoResult result : this.pdoSospesi) {
            this.status.addPdoSospeso(result);
        }
    }

    private void addPdoElaborati() {
        for (PdoResult result : this.pdoElaborati) {
            this.status.addPdoElaborato(this.azienda, result);
        }
    }

    public void addPdoSospeso(PdoResult result) {
        this.pdoSospesi.add(result);
    }

    public void addPdoElaborato(PdoResult result) {
        this.pdoElaborati.add(result);
    }

    public void count(String flusso) {
        this.countMap.increment(flusso);
    }

    public void count(String flusso, int weight) {
        this.countMap.increment(flusso, weight);
    }

    public void addSwitchOut(String destinazione, String codicePrestazione, MisuraPod misura) {
        if (destinazione == null) {
            this.switchoutCrm.add(codicePrestazione, misura);
        } else {
            String key = String.valueOf(codicePrestazione) + "|" + destinazione;
            this.switchoutNocrm.add(key, misura);
        }
    }

    public void addStatiPod(List<StatoPod> stati) {
        this.statiPod.addAll(stati);
    }

    public void addVolturaNoCrm(Voltura voltura) {
        this.misureOrarieVolturaNoCrm.add(voltura);
    }

    public void addMisuraOrariaPeriodo(MisuraPod misura, TipoLetStd tipo) {
        this.misureOrariePeriodo.add(tipo, misura);
    }

    public void addMisuraNonorariaPeriodo(MisuraMno misura, TipoLetStd tipo) {
        this.misureNonorariePeriodo.add(tipo, misura);
    }

    public void addRettificaMno(MisuraMno misuraMno) {
        this.rettificheMno.add(misuraMno);
    }

    public void addMisuraDisallineata(MisuraMno misura) {
        this.misureDisallineate.add(misura);
    }

    public void addMisuraTecnica(ExtendedLT misura) {
        this.misureTecniche.add(misura);
    }

    public void addMisuraRettifica(MisuraMno misura) {
        Date dataMisura;
        String codiceFlusso = misura.getCodiceFlusso();
        Pod pod = misura.getPod();
        boolean rnvIV = pod.isPodNuovo(dataMisura = misura.getDataMisura()) && codiceFlusso.startsWith("RNV");
        Map<String, ListMapKey<String, MisuraMno>> misure = rnvIV ? this.misureRettificaIV : this.misureRettifica;
        ListMapKey<String, MisuraMno> misureFlusso = misure.get(codiceFlusso);
        if (misureFlusso == null) {
            misureFlusso = new DefaultListMapKey<String, MisuraMno>();
            misure.put(codiceFlusso, misureFlusso);
        }
        misureFlusso.add(misura);
    }

    public void addRettificaSwitchOut(MisuraPod misura) {
        this.rettificheSwitchout.add(misura);
    }

    public void addRettificaSwitchOutDispatcher(MisuraPod misura) {
        String codiceFlusso = misura.getCodiceFlusso();
        this.count(codiceFlusso);
        this.rettificheSwitchoutDispatcher.add(misura);
    }

    public void addPdo2GRElaborato(MnoResult result) {
        this.pdo2GRElaborati.add(result);
    }

    public void addPdo2GRSospeso(MnoResult result) {
        this.pdo2GRSospesi.add(result);
    }

    public void addPdo2GRObsoleto(MnoResult result) {
        this.pdo2GRObsoleti.add(result);
    }

    public void addPnoElaborato(MnoResult result) {
        this.pnoElaborati.add(result);
    }

    public void addPnoSospeso(MnoResult result) {
        this.pnoSospesi.add(result);
    }

    public void addPnoObsoleto(MnoResult result) {
        this.pnoObsoleti.add(result);
    }

    public void addSmisObsoleto(MnoResult result) {
        this.smisObsoleti.add(result);
    }

    public void addSmisSospeso(MnoResult result) {
        this.smisSospesi.add(result);
    }

    public void addPnoEscluso(MnoResult result) {
        this.pnoEsclusi.add(result);
    }

    public void addSmisElaborato(MnoResult result) {
        this.smisElaborati.add(result);
    }

    public void addSmisEscluso(MnoResult result) {
        this.smisEsclusi.add(result);
    }

    public void addVnoElaborato(MnoResult result) {
        this.vnoElaborati.add(result);
    }

    public void addVnoEscluso(MnoResult result) {
        this.vnoEsclusi.add(result);
    }

    public void addPdoObsoleto(PdoResult result) {
        this.pdoObsoleti.add(result);
    }

    public void addSnmSospeso(MnoResult result) {
        this.snmSospesi.add(result);
    }

    public void addSnmObsoleto(MnoResult result) {
        this.snmObsoleti.add(result);
    }

    public void addSnfObsoleto(SnfResult result) {
        this.snfObsoleti.add(result);
    }

    public void addSnfSospeso(SnfResult result) {
        this.snfSospesi.add(result);
    }

    public void addSofSospeso(SofResult result) {
        this.sofSospesi.add(result);
    }

    public void addSofObsoleto(SofResult result) {
        this.sofObsoleti.add(result);
    }

    public void addSnmElaborato(MnoResult result) {
        this.snmElaborati.add(result);
    }

    public void addSnfCrm(SnfD65 snfD65) {
        this.snfCrm.add(snfD65);
    }

    public void addSnfNoCrm(SnfD65 snfD65) {
        this.snfNoCrm.add(snfD65);
    }

    public void addSofNoCrm(Sof sof) {
        this.sofNoCrm.add(sof);
    }

    public void addSofCrm(Sof sof) {
        this.sofCrm.add(sof);
    }

    public void addVnoSospeso(MnoResult result) {
        this.vnoSospesi.add(result);
    }

    public void addVnoObsoleto(MnoResult result) {
        this.vnoObsoleti.add(result);
    }

    public void addVnoSospesi(List<Mno> vnoList, ErroriElaborazione errore, String descrizione) {
        for (Mno vno : vnoList) {
            this.vnoSospesi.add(new MnoResult(vno, errore, descrizione));
        }
    }

    public CalendarMap getCalendarMap() {
        return this.status.getCalendarMap();
    }

    public DispatchingFlussi getDispatchingFlussi() {
        return this.status.getDispatchingFlussi();
    }

    public SafeListMap<String, Prestazione> getPrestazioni() {
        return this.status.getPrestazioni();
    }

    public ListMap<String, PraticaVolo> getPiv() {
        return this.status.getPiv();
    }

    public Map<String, PraticaVolo> getVirtualPiv() {
        return this.status.getVirtualPiv();
    }

    public SafeMap<String, Reseller> getResellers() {
        return this.status.getResellers();
    }

    public PodMap getPodMap() {
        return this.status.getPodMap();
    }

    public void addUpdateStatoRichiesta(StatoPod riferimento, String statoRicMovRif) {
        UpdateStatoPod statoPod = new UpdateStatoPod(riferimento, statoRicMovRif);
        this.updateStatiRichiesta.add(statoPod);
    }

    public Map<Date, Map<String, Pdo>> getRfos() {
        return this.status.getRfoMap();
    }

    public void setAzienda(String azienda) {
        this.azienda = azienda;
    }

    public OffertaCommerciale getOffertaCommerciale(String codiceOfferta) {
        return this.status.getOffertaCommerciale(codiceOfferta);
    }

    public PraticaVolo getPiv(String codicePod) throws DataNotFoundException {
        return StrategyHelper.getPiv(codicePod, null, this.status);
    }

    public void addRiconfigurazione(String key, MisuraContatorePdo misuraPdo) {
        misuraPdo.setSegnali(true);
        this.riconfigurazioni.add(key, misuraPdo);
    }

    public Map<String, Mno> getRiconfigurazioniPod2GR() {
        return this.status.getRiconfigurazioniPod2GR();
    }

    public void addSmisSospesi(List<MnoResult> results) {
        for (MnoResult result : results) {
            this.addSmisSospeso(result);
        }
    }

    public void addSmisObsoleti(List<MnoResult> results) {
        for (MnoResult result : results) {
            this.addSmisObsoleto(result);
        }
    }

    public void addDeferredStatoPod(DeferredStatoPod newDeferredStatoPod) {
        this.deferredStatoPod.add(newDeferredStatoPod);
    }

    public void handleDeferredStatiPod() throws StatoPodInvalidoException, StatoPodObsoletoException, DataNotFoundException, PraticaAnnullataException {
        for (DeferredStatoPod current : this.deferredStatoPod) {
            current.resume(this.statiPod, this);
        }
        this.deferredStatoPod = new ArrayList<DeferredStatoPod>();
    }

    public static String handleElaborato(Pod pod, String azienda, Mno mno, MisuraHandler handler, DecimalFormat format, StatusTransaction transaction) throws InvalidFasciaValue {
        String codiceFlusso = mno.getCodiceFlusso();
        String flusso = codiceFlusso.startsWith("RNO") || codiceFlusso.equalsIgnoreCase("PDO2G") || codiceFlusso.equalsIgnoreCase("RFO2G") ? codiceFlusso : (StrategyHelper.MOROSITA.contains(codiceFlusso.toUpperCase()) ? "morosit\u00e0" : "flussi_non_orari_periodo");
        mno.setCdaziend(azienda);
        MisureHelper.checkFasce(mno, format);
        handler.addElaborato(pod, mno, transaction);
        return flusso;
    }

    public StatoPod getLastStatoPod() {
        return this.statiPod.isEmpty() ? null : this.statiPod.get(this.statiPod.size() - 1);
    }

    public MnoPod getPno(Pod pod) {
        MnoPod mnoPod;
        SafeMap<String, MnoPod> misure;
        MappaMisureAzienda pno = this.status.getPnos();
        MisureAzienda misureAzienda = (MisureAzienda)pno.get(this.azienda);
        SafeMap<String, MnoPod> safeMap = misure = misureAzienda == null ? null : misureAzienda.getMisure();
        if (misure == null) {
            mnoPod = new MnoPod(pod);
        } else {
            try {
                mnoPod = (MnoPod)misure.get(pod.getCodice());
            }
            catch (DataNotFoundException exc) {
                mnoPod = new MnoPod(pod);
            }
        }
        return mnoPod;
    }

    public MappaMisureAzienda getPnos() {
        return this.status.getPnos();
    }

    public void addRiconfigurazioneVolturaIV(ExtendedLT misura) {
        this.riconfVoltureIV.add(misura);
    }

    public ServiceStatus getStatus() {
        return this.status;
    }

    public void addMisuraLateProcessing(MisuraNonorariaPod misura) {
        this.misureLateProcessing.add(misura);
    }

    public void addLettura(MisuraNonoraria lettura) {
        this.letture.add(lettura);
    }

    public void addPdo2GREscluso(MnoResult result) {
        this.pdo2GREsclusi.add(result);
    }

    public void addRsnRnv(String codicePod, Mno mno) {
        this.rsnRnv.add(codicePod, mno);
    }

    private void addRnsRnv() {
        this.status.addRsvRnv(this.rsnRnv);
    }

    @Override
    public String getIdEsecuzione() {
        return this.status.getIdEsecuzione();
    }

    @Override
    public void count(String counter, String codiceProcesso) {
        this.count(codiceProcesso);
    }

    @Override
    public void addSnfElaborato(SnfResult result) {
        this.snfElaborati.add(result);
    }
}

