/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.StatusManager;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.MappaMisureAzienda;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.MnoPod;
import biz.elabor.prebilling.model.misure.Snf;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.SegnaleNotHandledException;
import biz.elabor.prebilling.services.AbstractMnoStatoPodHandler;
import biz.elabor.prebilling.services.ExtD65;
import biz.elabor.prebilling.services.PrestazioniStatoPodChecker;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.attivazioni.D65PrestazioniCsvService;
import biz.elabor.prebilling.services.common.AbstractD65CsvService;
import biz.elabor.prebilling.services.common.D65CrmService;
import biz.elabor.prebilling.services.common.PrestazioneNotFoundException;
import biz.elabor.prebilling.services.common.SmisHandlingException;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodChecker;
import biz.elabor.prebilling.services.common.statopod.StatoPodInvalidoException;
import biz.elabor.prebilling.services.common.statopod.StatoPodObsoletoException;
import biz.elabor.prebilling.services.letture.MisuraMno;
import biz.elabor.prebilling.services.letture.MisureAzienda;
import biz.elabor.prebilling.services.switched.SnfD65;
import biz.elabor.prebilling.services.volture.ExtMno;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.exceptions.KeyException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.BasicListMap;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.structures.listmap.SafeListMap;
import org.homelinux.elabor.structures.safe.SafeMap;

public abstract class AbstractPrestazioniStrategy
implements ServiceStrategy {
    private static final Collection<? extends String> NCIFRE = Arrays.asList("cifreatt", "cifrerea", "cifrepot");
    private final Funzionalita funzionalita;
    private final AbstractMnoStatoPodHandler statoPodHandler;
    private final PrebillingConfiguration configuration;
    private final MisureDao misureDao;
    private final TalkManager talkManager;
    private final List<String> flussi;
    private final List<String> prestazioni;
    private final Set<String> banned;
    private final StatoPodChecker<Mno> checker;

    public AbstractPrestazioniStrategy(Funzionalita funzionalita, AbstractMnoStatoPodHandler statoPodHandler, PrebillingConfiguration configuration, MisureDao misureDao, TalkManager talkManager, List<String> flussi, List<String> prestazioni) {
        this.funzionalita = funzionalita;
        this.statoPodHandler = statoPodHandler;
        this.configuration = configuration;
        this.misureDao = misureDao;
        this.talkManager = talkManager;
        this.flussi = flussi;
        this.banned = new HashSet<String>(D65CrmService.BANNED_D65);
        this.banned.addAll(NCIFRE);
        this.prestazioni = prestazioni;
        this.checker = new PrestazioniStatoPodChecker();
    }

    @Override
    public boolean execute(ServiceStatus status) {
        boolean ok = true;
        try {
            this.checkPrestazioni(status);
            ListMap<String, PraticaVolo> pivMapList = status.getPiv();
            LinkedHashMap<String, ListMap<String, ExtD65>> noCrmMap = new LinkedHashMap<String, ListMap<String, ExtD65>>();
            for (Map.Entry entry : pivMapList.entrySet()) {
                List pivList = (List)entry.getValue();
                ok = this.executePod(pivList, noCrmMap, status);
                if (!ok) break;
            }
            this.exportD65Csv(noCrmMap, status);
        }
        catch (SegnaleNotHandledException | PrestazioneNotFoundException | DataNotFoundException exc) {
            ok = false;
            String message = exc.getMessage();
            Message sentence = new Message(this.funzionalita.name(), message);
            String reseller = ((KeyException)((Object)exc)).getKey();
            sentence.addParam(reseller);
            this.talkManager.addSentence(sentence);
        }
        return ok;
    }

    private List<Mno> getMno(String codicePod, Date dataPratica) {
        return this.misureDao.getMnoPrestazione(codicePod, dataPratica, StrategyHelper.STATI, this.flussi);
    }

    private boolean executePod(List<PraticaVolo> pratiche, Map<String, ListMap<String, ExtD65>> noCrmMap, ServiceStatus status) throws DataNotFoundException {
        boolean ok = true;
        SafeMap<String, Reseller> resellers = status.getResellers();
        PraticaVolo pratica = pratiche.get(0);
        String codiceReseller = pratica.getCodiceReseller();
        String codicePod = pratica.getCodicePod();
        Reseller reseller = (Reseller)resellers.get(codiceReseller);
        boolean handleStato = reseller.isHandleStato();
        Collection<ExtMno> smis = AbstractPrestazioniStrategy.getSmis(codicePod, codiceReseller, status);
        for (PraticaVolo piv : pratiche) {
            ok = this.executePiv(piv, smis, handleStato, noCrmMap, status);
            if (!ok) break;
        }
        return ok;
    }

    private static Collection<ExtMno> getSmis(String codicePod, String codiceReseller, ServiceStatus status) throws DataNotFoundException {
        MappaMisureAzienda pnos = status.getPnos();
        MisureAzienda misureAzienda = (MisureAzienda)pnos.get(codiceReseller);
        Collection<ExtMno> smis = new ArrayList<ExtMno>();
        if (misureAzienda != null) {
            SafeMap<String, MnoPod> misure = misureAzienda.getMisure();
            MnoPod mnoPod = (MnoPod)misure.get(codicePod);
            smis = mnoPod.getSmis();
        }
        return smis;
    }

    private boolean executePiv(PraticaVolo piv, Collection<ExtMno> smis, boolean handleStato, Map<String, ListMap<String, ExtD65>> noCrmMap, ServiceStatus status) throws DataNotFoundException {
        boolean ok = true;
        String codicePod = piv.getCodicePod();
        Date dataPratica = piv.getSpecificaTecnica().getData();
        String codiceReseller = piv.getCodiceReseller();
        List<Mno> mnos = this.getMno(codicePod, dataPratica);
        if (!mnos.isEmpty()) {
            Collections.sort(mnos, (o1, o2) -> {
                String f1 = o1.getCodiceFlusso().replace("2G", "");
                String f2 = o2.getCodiceFlusso().replace("2G", "");
                return f2.compareTo(f1);
            });
            Mno head = mnos.get(0);
            head.setCdaziend(codiceReseller);
            List<Mno> obsoleti = mnos.subList(1, mnos.size());
            try {
                AbstractPrestazioniStrategy.checkSmis(piv, smis);
                ok = this.executeMno(head, piv, handleStato, noCrmMap, status);
            }
            catch (SmisHandlingException exc) {
                ErroriElaborazione errore = ErroriElaborazione.HANDLING_SMIS;
                String message = errore.getMessage();
                Message sentence = new Message(this.funzionalita.name(), message);
                sentence.addParam(exc.getKey());
                sentence.addParam(piv.getCodicePrestazione());
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                MnoResult result = new MnoResult(head, errore, descrizione);
                status.addPnoSospeso(result);
            }
            StrategyHelper.addMnoObsoleti(obsoleti, codiceReseller, status, this.talkManager);
        }
        return ok;
    }

    private static void checkSmis(PraticaVolo piv, Collection<ExtMno> smis) throws SmisHandlingException {
        SpecificaTecnica specificaTecnica = piv.getSpecificaTecnica();
        Date dtAppTec = specificaTecnica.getData();
        for (ExtMno extMno : smis) {
            Mno mno = extMno.getMno();
            Date dataPrestazione = mno.getDataMisura();
            if (dataPrestazione.after(dtAppTec) || !mno.isSmisMontaggio()) continue;
            String codicePod = piv.getCodicePod();
            throw new SmisHandlingException(codicePod, piv.getCodicePrestazione());
        }
    }

    private boolean executeMno(Mno mno, PraticaVolo piv, boolean handleStato, Map<String, ListMap<String, ExtD65>> noCrmMap, ServiceStatus status) throws DataNotFoundException {
        boolean ok;
        String codiceReseller = piv.getCodiceReseller();
        String destinazione = this.getDestinazione(mno, piv, status);
        String crmKey = destinazione == null ? "middleware" : codiceReseller;
        StatusTransaction transaction = new StatusTransaction(crmKey, status, this.configuration);
        try {
            String codicePrestazione = piv.getCodicePrestazione();
            if (handleStato) {
                String codPratAtt = piv.getCodPratAtt();
                this.handleStatoPod(mno, codicePrestazione, codPratAtt, transaction);
            }
            MnoResult result = new MnoResult(mno, ErroriElaborazione.OK, "");
            transaction.addPnoElaborato(result);
            Date fixDataMisura = CalendarTools.previousDay(mno.getDataPrestazione());
            transaction.addLettura(new MisuraMno(null, mno, fixDataMisura));
            if (destinazione == null) {
                ok = this.exportD65Xml(mno, piv, transaction);
            } else {
                SnfD65 snfD65 = AbstractPrestazioniStrategy.buildD65(mno, piv);
                ListMap<String, ExtD65> resellerMap = noCrmMap.get(crmKey);
                if (resellerMap == null) {
                    resellerMap = new BasicListMap<String, ExtD65>();
                    noCrmMap.put(crmKey, resellerMap);
                }
                ExtD65 extD65 = new ExtD65(destinazione, snfD65);
                resellerMap.add(codicePrestazione, extD65);
                ok = true;
            }
            transaction.commit("");
        }
        catch (PraticaAnnullataException | StatoPodInvalidoException | StatoPodObsoletoException | DataNotFoundException exc) {
            ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
            String message = errore.getMessage();
            Message sentence = new Message(this.funzionalita.name(), message);
            sentence.setParams(exc.getParams());
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            MnoResult result = new MnoResult(mno, errore, descrizione);
            status.addPnoSospeso(result);
            ok = true;
        }
        return ok;
    }

    private void checkPrestazioni(ServiceStatus status) throws SegnaleNotHandledException, PrestazioneNotFoundException {
        SafeListMap<String, Prestazione> prestazioniMap = status.getPrestazioni();
        this.statoPodHandler.check(prestazioniMap, this.prestazioni, this.flussi);
    }

    private void handleStatoPod(Mno mno, String prestazione, String codPratAtt, StatusTransaction transaction) throws StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException, DataNotFoundException {
        this.statoPodHandler.handleStato(mno, prestazione, codPratAtt, transaction, this.checker);
    }

    private AbstractD65CsvService getCsvService(String prestazione) {
        return new D65PrestazioniCsvService(prestazione, this.configuration, this.talkManager);
    }

    private String getDestinazione(Mno mno, PraticaVolo piv, ServiceStatus status) throws DataNotFoundException {
        String flusso = mno.getCodiceFlusso().replace("2G", "");
        String codicePrestazione = piv.getCodicePrestazione();
        String azienda = piv.getCodiceReseller();
        return StrategyHelper.getDestinazione(this.configuration, flusso, azienda, codicePrestazione, status);
    }

    private static SnfD65 buildD65(Mno mno, PraticaVolo piv) {
        String codicePratica = piv.getCodPratAtt();
        String id = mno.getFirstId();
        String codicePod = mno.getCodicePod();
        String pivaUtente = mno.getPivaUtente();
        String pivaDistributore = mno.getPivaDistributore();
        String codContrDisp = mno.getCodContrDisp();
        Date dataPrestazione = mno.getDataPrestazione();
        String cdaziend = mno.getCdaziend();
        String nomeFile = mno.getNomeFile();
        Map<String, Map<String, String>> datiPod = mno.getDatiPod();
        Map<String, String> datiPdp = datiPod.get("DatiPdp");
        datiPdp.put("PivaDistributore", pivaDistributore);
        String codicePrestazione = piv.getCodicePrestazione();
        return new Snf(id, codicePrestazione, codicePod, pivaUtente, pivaDistributore, codContrDisp, dataPrestazione, codicePratica, cdaziend, nomeFile, datiPod, "65", "misure_pod_non_orari");
    }

    private boolean exportD65Xml(Mno mno, PraticaVolo piv, StatusTransaction transaction) {
        String codicePod = mno.getCodicePod();
        D65CrmService service = new D65CrmService(this.funzionalita, this.configuration, this.talkManager, this.banned);
        ArrayList<SnfD65> toExport = new ArrayList<SnfD65>();
        SnfD65 snfD65 = AbstractPrestazioniStrategy.buildD65(mno, piv);
        toExport.add(snfD65);
        String codicePrestazione = piv.getCodicePrestazione();
        String prefix = String.valueOf(codicePrestazione.toLowerCase()) + "-pod";
        return service.export(toExport, prefix, codicePod, codicePrestazione, false, (StatusManager)transaction);
    }

    private void exportD65Csv(Map<String, ListMap<String, ExtD65>> noCrmMap, ServiceStatus status) {
        for (Map.Entry<String, ListMap<String, ExtD65>> entry : noCrmMap.entrySet()) {
            String azienda = entry.getKey();
            ListMap<String, ExtD65> noCrmSnf = entry.getValue();
            for (Map.Entry prestazioneEntry : noCrmSnf.entrySet()) {
                String prestazione = (String)prestazioneEntry.getKey();
                AbstractD65CsvService d65CsvService = this.getCsvService(prestazione);
                String timestamp = StrategyCommonHelper.getTimestampFormat().format(new Date());
                String fileName = String.valueOf(prestazione) + "-D65-" + azienda + "-" + timestamp + ".csv";
                String idEsecuzione = status.getIdEsecuzione();
                List extD65 = (List)prestazioneEntry.getValue();
                String destinazione = ((ExtD65)extD65.get(0)).getDestinazione();
                File folder = ConfigurationHelper.getResellerTmpImportFolder(this.configuration, idEsecuzione, azienda, this.funzionalita, destinazione);
                File file = new File(folder, fileName);
                d65CsvService.export(azienda, extD65, file, status);
            }
        }
    }
}

