/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.tariffe;

import biz.elabor.misure.model.fasce.CalendarioFasceGiornaliero;
import biz.elabor.misure.model.fasce.CalendarioFasceMensile;
import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.model.InvalidCurvaRilevazioniException;
import biz.elabor.prebilling.model.indici.CurvaIndiciGiornaliera;
import biz.elabor.prebilling.model.indici.IndiceOrario;
import biz.elabor.prebilling.model.indici.InvalidCurvaIndiciException;
import biz.elabor.prebilling.model.misure.MisureHelper;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilQuarto;
import biz.elabor.prebilling.model.tariffe.AbstractTariffa;
import biz.elabor.prebilling.model.tariffe.DettaglioTariffa;
import biz.elabor.prebilling.model.tariffe.PrezzoExtractor;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.tools.MathUtils;

public class TariffaFasce
extends AbstractTariffa {
    private double[] totale = new double[FasciaOraria.values().length];
    private double[] qtMisura = new double[FasciaOraria.values().length];
    private double[] qtMisuraEffettiva = new double[FasciaOraria.values().length];

    public TariffaFasce(Date date, double coeffUM, double qtconfla, double[] prezziDeafult, double emtaruni, double emspread, double emspreneg, PrezzoExtractor extractor) {
        super(date, coeffUM, qtconfla, prezziDeafult, emtaruni, emspread, emspreneg, extractor);
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    public void add(CurvaIndiciGiornaliera curva, RilGiorno rilGiorno, double kAttiva, CalendarioFasceMensile calendarioFasce) throws InvalidCurvaIndiciException, InvalidCurvaRilevazioniException {
        Date currDate = curva.getData();
        ElaborCalendar calendar = new ElaborCalendar(currDate);
        int giorno = calendar.getGiorno();
        CalendarioFasceGiornaliero cfg = calendarioFasce.getFasciaGiornaliera(giorno);
        if (curva.size() != cfg.size()) {
            throw new InvalidCurvaIndiciException();
        }
        if (rilGiorno.size() != curva.size() * 4) {
            throw new InvalidCurvaRilevazioniException(currDate);
        }
        Iterator cIterator = curva.iterator();
        Iterator rIterator = rilGiorno.iterator();
        while (cIterator.hasNext() && rIterator.hasNext()) {
            double attiva = 0.0;
            int index = 0;
            while (index < 4) {
                RilQuarto rQuarto = (RilQuarto)rIterator.next();
                attiva += MisureHelper.getAttiva(rQuarto) * kAttiva;
                ++index;
            }
            IndiceOrario cOra = (IndiceOrario)cIterator.next();
            int ora = cOra.getOra();
            FasciaOraria fascia = cfg.getFascia(ora);
            double prezzo = MathUtils.round(cOra.getPrezzo() * this.coeffUM, 8);
            double attivaEfficace = this.extractor.getConsumoEfficace(attiva, this.qtconfla, this.emtaruni, this.emspreneg);
            double costoFascia = MathUtils.round(prezzo * attivaEfficace, 8);
            int n2 = fascia.ordinal();
            this.totale[n2] = this.totale[n2] + costoFascia;
            int n3 = fascia.ordinal();
            this.qtMisura[n3] = this.qtMisura[n3] + attiva;
            int n4 = fascia.ordinal();
            this.qtMisuraEffettiva[n4] = this.qtMisuraEffettiva[n4] + attivaEfficace;
            DettaglioTariffa dettaglio = new DettaglioTariffa(currDate, ora, kAttiva, attiva, prezzo, fascia, this.qtconfla, attivaEfficace, costoFascia, prezzo);
            this.dettagli.add(dettaglio);
        }
    }

    @Override
    public double getValue(FasciaOraria fascia) {
        int ordinal = fascia.ordinal();
        double quantita = this.qtMisura[ordinal];
        return quantita == 0.0 ? 0.0 : (this.extractor.isFlat() ? this.prezziDefault[ordinal] : MathUtils.round(this.totale[ordinal] / quantita, 8));
    }

    @Override
    public double getQtMisura() {
        double value = 0.0;
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            value += this.getQtMisura(fascia);
            ++n3;
        }
        return value;
    }

    @Override
    public double getQtMisuraEffettiva() {
        double value = 0.0;
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            value += this.getQtMisuraEffettiva(fascia);
            ++n3;
        }
        return value;
    }

    @Override
    public double getQtMisura(FasciaOraria fascia) {
        double fasciaValue = this.qtMisura[fascia.ordinal()];
        double fasciaValueEffettivo = this.qtMisuraEffettiva[fascia.ordinal()];
        return this.extractor.getQtMisura(fasciaValueEffettivo, fasciaValue);
    }

    @Override
    public double getQtMisuraEffettiva(FasciaOraria fascia) {
        return this.qtMisuraEffettiva[fascia.ordinal()];
    }

    @Override
    public List<DettaglioTariffa> getDettagli() {
        return this.dettagli;
    }

    @Override
    public double getTotale(FasciaOraria fascia) {
        return this.totale[fascia.ordinal()];
    }

    @Override
    public double getPrezzoMedioPonderatoNetto(FasciaOraria fascia) {
        return this.getValue(fascia);
    }
}

