/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.tariffe;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.model.tariffe.DettaglioTariffa;
import biz.elabor.prebilling.model.tariffe.MisuraFasceQuantita;
import java.util.Date;
import java.util.List;

public class TariffaApplicazione {
    private final MisuraFasceQuantita tariffa;
    private final String codIndiceApplicato;
    private final int tipoApplicazione;

    public TariffaApplicazione(MisuraFasceQuantita tariffa, int tipoApplicazione, String codIndiceApplicato) {
        this.tariffa = tariffa;
        this.tipoApplicazione = tipoApplicazione;
        this.codIndiceApplicato = codIndiceApplicato;
    }

    public Date getDataValidita() {
        return this.tariffa.getDate();
    }

    public MisuraFasceQuantita getTariffa() {
        return this.tariffa;
    }

    public double getQtMisura() {
        return this.tariffa.getQtMisura();
    }

    public double getQtMisuraEffettiva() {
        return this.tariffa.getQtMisuraEffettiva();
    }

    public double getQtMisuraEffettiva(FasciaOraria fascia) {
        return this.tariffa.getQtMisuraEffettiva(fascia);
    }

    public List<DettaglioTariffa> getDettagli() {
        return this.tariffa.getDettagli();
    }

    public String getCodIndiceApplicato() {
        return this.codIndiceApplicato;
    }

    public double getQtMisura(FasciaOraria fascia) {
        return this.tariffa.getQtMisura(fascia);
    }

    public int getTipoApplicazione() {
        return this.tipoApplicazione;
    }
}

