/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.tariffe;

import biz.elabor.prebilling.common.model.TipoFlatVisitor;
import biz.elabor.prebilling.common.model.TipoProfilo;
import biz.elabor.prebilling.util.EleProfiler;
import biz.elabor.prebilling.util.EleTipoProfiloVisitor;
import biz.elabor.prebilling.util.ZeroEleProfiler;

public class EleTipoFlatVisitor
implements TipoFlatVisitor {
    private final TipoProfilo tipoProfilo;
    private final int anno;
    private EleProfiler profiler;

    public EleTipoFlatVisitor(TipoProfilo tipoProfilo, int anno) {
        this.tipoProfilo = tipoProfilo;
        this.anno = anno;
    }

    private void buildProfiler() {
        EleTipoProfiloVisitor visitor = new EleTipoProfiloVisitor(this.anno);
        this.tipoProfilo.accept(visitor);
        this.profiler = visitor.getProfiler();
    }

    @Override
    public void visitNonFlat() {
        this.profiler = new ZeroEleProfiler();
    }

    @Override
    public void visitFlat() {
        this.buildProfiler();
    }

    @Override
    public void visitResiduo() {
        this.buildProfiler();
    }

    @Override
    public void visitResiduoPositivo() {
        this.buildProfiler();
    }

    @Override
    public void visitResiduoNegativo() {
        this.buildProfiler();
    }

    @Override
    public void visitSpread() {
    }

    @Override
    public void visitResiduoNegativoMinoritario() {
        this.buildProfiler();
    }

    public double getConsumoFlat(double qtconfla) {
        return this.profiler.getConsumoFlatOra(qtconfla);
    }
}

