/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.statopod;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraPdo;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.statopod.AbstractStatoPod;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.model.statopod.StatoPodHelper;
import java.util.Date;

public class VolturaPdoStatoPod
extends AbstractStatoPod {
    private String servizio;
    private String pod;
    private String cf;
    private String piva;
    private String pivaDistributore;
    private String pivaReseller;
    private String pivaDispatcher;
    private String codiceDispacciamento;
    private String stato;
    private String flagResidente;
    private Date dataMovimento;
    private int numeroProgressivo;
    private Date dataAttivazione;
    private Date dataCessazione;
    private String cdunipre;
    private String cdFlusso;
    private String tabellaRiferimento;
    private String chiaveTabellaRiferimento;
    private String toponimo;
    private String via;
    private String civico;
    private String comuneCatastale;
    private String cap;
    private boolean flagOrario;
    private String cdtardis;
    private int tensione;
    private String livelloTensione;
    private double potenzaContr;
    private double potenzaDisp;
    private boolean flmisCon;
    private boolean flmisRea;
    private boolean flmisPot;
    private double inmisCon;
    private double inmisRea;
    private double inmisPot;
    private double nuLetA01;
    private double nuLetA02;
    private double nuLetA03;
    private double nuLetR01;
    private double nuLetR02;
    private double nuLetR03;
    private double nuLetP01;
    private double nuLetP02;
    private double nuLetP03;
    private double nuLetB01;
    private double nuLetB02;
    private double nuLetB03;
    private String nuMatrA;
    private String nuMatrR;
    private String nuMatrP;
    private String modContatoreA;
    private String modContatoreR;
    private String modContatoreP;
    private String modContatoreBio;
    private boolean flazzconA;
    private boolean flazzconR;
    private boolean flazzconP;
    private int nuCifreA;
    private int nuCifreR;
    private int nuCifreP;
    private int nnFascia;
    private String statoRic;
    private final Misura misura;
    private final String codiceOfferta;

    public VolturaPdoStatoPod(Prestazione prestazione, String flusso, MisuraPdo misuraPod, StatoPod riferimento, int numeroProgressivo, String codiceOfferta) {
        super(riferimento.getServizioTutela(), riferimento.getDataPrestazione(), riferimento.getId(), riferimento.getCpGestore(), riferimento.getCpUtente(), riferimento.getResidenza());
        String cdConMag = riferimento.getModContatoreA();
        Pdo pdo = misuraPod.getPdo();
        this.servizio = riferimento.getServizio();
        this.pod = pdo.getCodicePod();
        this.cf = riferimento.getCf();
        this.piva = riferimento.getPiva();
        this.pivaDistributore = pdo.getPivaDistributore();
        this.pivaReseller = riferimento.getPivaReseller();
        this.pivaDispatcher = pdo.getPivaUtente();
        this.codiceDispacciamento = pdo.getCodContrDisp();
        this.stato = prestazione.getStato();
        this.flagResidente = riferimento.getFlagResidente();
        this.dataMovimento = misuraPod.getDataMisura();
        this.numeroProgressivo = numeroProgressivo;
        this.dataAttivazione = this.findDataAttivazione(prestazione, riferimento);
        this.dataCessazione = this.getDataCessazione(prestazione, misuraPod);
        this.cdunipre = prestazione.getPrestazione();
        this.cdFlusso = flusso;
        this.tabellaRiferimento = "MISURE_POD_ORARI";
        this.chiaveTabellaRiferimento = pdo.getId().iterator().next();
        this.toponimo = riferimento.getToponimo();
        this.via = riferimento.getVia();
        this.civico = riferimento.getCivico();
        this.comuneCatastale = riferimento.getComuneCatastale();
        this.cap = riferimento.getCap();
        this.flagOrario = true;
        this.cdtardis = riferimento.getCdtardis();
        this.tensione = riferimento.getTensione();
        this.livelloTensione = riferimento.getLivelloTensione();
        this.potenzaContr = riferimento.getPotenzaContr();
        this.potenzaDisp = riferimento.getPotenzaDisp();
        this.flmisCon = true;
        this.flmisRea = true;
        this.flmisPot = true;
        this.nnFascia = 3;
        this.nuLetA01 = prestazione.getStato().equals("C") ? misuraPod.getAttiva(FasciaOraria.F1) : 0.0;
        this.nuLetA02 = prestazione.getStato().equals("C") ? misuraPod.getAttiva(FasciaOraria.F2) : 0.0;
        this.nuLetA03 = prestazione.getStato().equals("C") ? misuraPod.getAttiva(FasciaOraria.F3) : 0.0;
        this.nuLetR01 = prestazione.getStato().equals("C") ? misuraPod.getReattiva(FasciaOraria.F1) : 0.0;
        this.nuLetR02 = prestazione.getStato().equals("C") ? misuraPod.getReattiva(FasciaOraria.F2) : 0.0;
        this.nuLetR03 = prestazione.getStato().equals("C") ? misuraPod.getReattiva(FasciaOraria.F3) : 0.0;
        this.nuLetP01 = prestazione.getStato().equals("C") ? misuraPod.getPotenza(FasciaOraria.F1) : 0.0;
        this.nuLetP02 = prestazione.getStato().equals("C") ? misuraPod.getPotenza(FasciaOraria.F2) : 0.0;
        this.nuLetP03 = prestazione.getStato().equals("C") ? misuraPod.getPotenza(FasciaOraria.F3) : 0.0;
        this.nuLetB01 = prestazione.getStato().equals("C") ? misuraPod.getCommerciale(FasciaOraria.F1) : 0.0;
        this.nuLetB02 = prestazione.getStato().equals("C") ? misuraPod.getCommerciale(FasciaOraria.F2) : 0.0;
        this.nuLetB03 = prestazione.getStato().equals("C") ? misuraPod.getCommerciale(FasciaOraria.F3) : 0.0;
        this.nuMatrA = riferimento.getNuMatrA();
        this.nuMatrR = riferimento.getNuMatrR();
        this.nuMatrP = riferimento.getNuMatrP();
        this.modContatoreA = cdConMag;
        this.modContatoreR = cdConMag;
        this.modContatoreP = cdConMag;
        this.modContatoreBio = cdConMag;
        this.flazzconA = true;
        this.flazzconR = true;
        this.flazzconP = true;
        this.nuCifreA = riferimento.getNuCifreA();
        this.nuCifreR = riferimento.getNuCifreR();
        this.nuCifreP = riferimento.getNuCifreP();
        this.inmisCon = StatoPodHelper.getDoubleNullable(misuraPod.getKa());
        this.inmisRea = StatoPodHelper.getDoubleNullable(misuraPod.getKr());
        this.inmisPot = StatoPodHelper.getDoubleNullable(misuraPod.getKp());
        this.statoRic = prestazione.getStatoRichiesta();
        this.misura = misuraPod.getMisura();
        this.codiceOfferta = codiceOfferta;
    }

    @Override
    public Date findDataAttivazione(Prestazione prestazione, StatoPod riferimento) {
        return this.getNextDataAttivazione(prestazione, riferimento);
    }

    @Override
    public String getStatoRic() {
        return this.statoRic;
    }

    @Override
    public String getStato() {
        return this.stato;
    }

    @Override
    public Date getDataCessazione() {
        return this.dataCessazione;
    }

    @Override
    public Date getDataMovimento() {
        return this.dataMovimento;
    }

    @Override
    public String getServizio() {
        return this.servizio;
    }

    @Override
    public String getPod() {
        return this.pod;
    }

    @Override
    public String getCf() {
        return this.cf;
    }

    @Override
    public String getPiva() {
        return this.piva;
    }

    @Override
    public String getPivaDistributore() {
        return this.pivaDistributore;
    }

    @Override
    public String getPivaReseller() {
        return this.pivaReseller;
    }

    @Override
    public String getPivaDispatcher() {
        return this.pivaDispatcher;
    }

    @Override
    public String getCodiceDispacciamento() {
        return this.codiceDispacciamento;
    }

    @Override
    public String getFlagResidente() {
        return this.flagResidente;
    }

    @Override
    public int getNuprogre() {
        return this.numeroProgressivo;
    }

    @Override
    public Date getDataAttivazione() {
        return this.dataAttivazione;
    }

    @Override
    public String getCdunipre() {
        return this.cdunipre;
    }

    @Override
    public String getCdFlusso() {
        return this.cdFlusso;
    }

    @Override
    public String getTabellaRiferimento() {
        return this.tabellaRiferimento;
    }

    @Override
    public String getChiaveTabellaRiferimento() {
        return this.chiaveTabellaRiferimento;
    }

    @Override
    public String getToponimo() {
        return this.toponimo;
    }

    @Override
    public String getVia() {
        return this.via;
    }

    @Override
    public String getCivico() {
        return this.civico;
    }

    @Override
    public String getComuneCatastale() {
        return this.comuneCatastale;
    }

    @Override
    public String getCap() {
        return this.cap;
    }

    @Override
    public boolean getFlagOrario() {
        return this.flagOrario;
    }

    @Override
    public String getCdtardis() {
        return this.cdtardis;
    }

    @Override
    public int getTensione() {
        return this.tensione;
    }

    @Override
    public String getLivelloTensione() {
        return this.livelloTensione;
    }

    @Override
    public double getPotenzaContr() {
        return this.potenzaContr;
    }

    @Override
    public double getPotenzaDisp() {
        return this.potenzaDisp;
    }

    @Override
    public boolean getFlmisCon() {
        return this.flmisCon;
    }

    @Override
    public boolean getFlmisRea() {
        return this.flmisRea;
    }

    @Override
    public boolean getFlmisPot() {
        return this.flmisPot;
    }

    @Override
    public double getNuLetA01() {
        return this.nuLetA01;
    }

    @Override
    public double getNuLetA02() {
        return this.nuLetA02;
    }

    @Override
    public double getNuLetA03() {
        return this.nuLetA03;
    }

    @Override
    public double getNuLetR01() {
        return this.nuLetR01;
    }

    @Override
    public double getNuLetR02() {
        return this.nuLetR02;
    }

    @Override
    public double getNuLetR03() {
        return this.nuLetR03;
    }

    @Override
    public double getNuLetP01() {
        return this.nuLetP01;
    }

    @Override
    public double getNuLetP02() {
        return this.nuLetP02;
    }

    @Override
    public double getNuLetP03() {
        return this.nuLetP03;
    }

    @Override
    public double getInmisCon() {
        return this.inmisCon;
    }

    @Override
    public double getInmisRea() {
        return this.inmisRea;
    }

    @Override
    public double getInmisPot() {
        return this.inmisPot;
    }

    @Override
    public String getNuMatrA() {
        return this.nuMatrA;
    }

    @Override
    public String getNuMatrR() {
        return this.nuMatrR;
    }

    @Override
    public String getNuMatrP() {
        return this.nuMatrP;
    }

    @Override
    public String getModContatoreA() {
        return this.modContatoreA;
    }

    @Override
    public String getModContatoreR() {
        return this.modContatoreR;
    }

    @Override
    public String getModContatoreP() {
        return this.modContatoreP;
    }

    @Override
    public boolean isFlazzconA() {
        return this.flazzconA;
    }

    @Override
    public boolean isFlazzconR() {
        return this.flazzconR;
    }

    @Override
    public boolean isFlazzconP() {
        return this.flazzconP;
    }

    @Override
    public int getNuCifreA() {
        return this.nuCifreA;
    }

    @Override
    public int getNuCifreR() {
        return this.nuCifreR;
    }

    @Override
    public int getNuCifreP() {
        return this.nuCifreP;
    }

    @Override
    public int getNnFascia() {
        return this.nnFascia;
    }

    @Override
    public boolean isPraticaAnnullata() {
        return false;
    }

    @Override
    public boolean isFlMisBio() {
        return this.misura.hasCommerciale();
    }

    @Override
    public double getInMisBio() {
        return 0.0;
    }

    @Override
    public double getNuLetBio01() {
        return this.nuLetB01;
    }

    @Override
    public double getNuLetBio02() {
        return this.nuLetB02;
    }

    @Override
    public double getNuLetBio03() {
        return this.nuLetB03;
    }

    @Override
    public String getNuMatricBio() {
        return this.misura.hasCommerciale() ? this.nuMatrA : "";
    }

    @Override
    public String getModContatoreBio() {
        return this.misura.hasCommerciale() ? this.modContatoreBio : "";
    }

    @Override
    public boolean isFlAzzConBio() {
        return false;
    }

    @Override
    public int getNuCifreBio() {
        return 0;
    }

    @Override
    public String getCodiceOfferta() {
        return this.codiceOfferta;
    }
}

