/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.statopod;

import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.DatiFunzionali;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.statopod.ContatoreStatoPodChecker;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.common.SmisMno;
import biz.elabor.prebilling.services.common.statopod.NullStatoPodChecker;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.ReferenceHandler;
import biz.elabor.prebilling.services.common.statopod.StatoPodChecker;
import biz.elabor.prebilling.services.common.statopod.StatoPodInvalidoException;
import biz.elabor.prebilling.services.common.statopod.StatoPodObsoletoException;
import biz.elabor.prebilling.services.letture.statopod.MontaggioStatoPodHandler;
import biz.elabor.prebilling.services.letture.statopod.SmontaggioStatoPodHandler;
import biz.elabor.prebilling.services.volture.ExtMno;
import java.util.Date;
import java.util.Set;
import org.homelinux.elabor.db.DataNotFoundException;

public class StatoPodHelper {
    private StatoPodHelper() {
    }

    public static double getDoubleNullable(Number value) {
        return value == null ? 0.0 : value.doubleValue();
    }

    public static boolean exists(String value) {
        return value != null && !value.isEmpty();
    }

    public static void handleSmisStatoPod(StatusTransaction transaction, ExtMno extMno, ExtMno extMnoPrev, Pod pod, Pod podPrev, SmontaggioStatoPodHandler smontaggioSPH, MontaggioStatoPodHandler montaggioSPH) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException {
        Mno currMno = extMno.getMno();
        SmisMno currMisuraMno = new SmisMno(pod, currMno);
        Mno prevMno = extMnoPrev.getMno();
        SmisMno prevMisuraMno = new SmisMno(podPrev, prevMno);
        ReferenceHandler<MisuraPod> prevRefHandler = extMnoPrev.getHandler();
        ReferenceHandler<MisuraPod> currRefHandler = extMno.getHandler();
        Set<String> idMno = prevMno.getId();
        Date dataMisura = prevMno.getDataMisura();
        StatoPodHelper.handleSmisStatoPod(idMno, dataMisura, prevMisuraMno, currMisuraMno, prevRefHandler, currRefHandler, smontaggioSPH, montaggioSPH, transaction);
    }

    public static void handleSmisStatoPod(Set<String> idMno, Date dataMisura, MisuraPod prevMisuraMno, MisuraPod currMisuraMno, ReferenceHandler<MisuraPod> prevRefHandler, ReferenceHandler<MisuraPod> currRefHandler, SmontaggioStatoPodHandler smontaggioSPH, MontaggioStatoPodHandler montaggioSPH, StatusTransaction transaction) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException {
        try {
            String id = idMno.iterator().next();
            StatoPodChecker<MisuraPod> checker = new ContatoreStatoPodChecker();
            smontaggioSPH.handleStato(prevMisuraMno, "GM1", "RIM", "", dataMisura, dataMisura, id, transaction, checker, prevRefHandler);
            checker = new NullStatoPodChecker();
            montaggioSPH.handleStato(currMisuraMno, "GM1", "INS", "", dataMisura, dataMisura, id, transaction, checker, currRefHandler);
        }
        catch (PraticaAnnullataException exc) {
            throw new RuntimeException(exc);
        }
    }

    public static String getFlagResidente(DatiFunzionali datiFunzionali) {
        String residenza = datiFunzionali.getResidenza();
        return residenza == null || residenza.isEmpty() ? " " : residenza.substring(0, 1);
    }
}

