/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.statopod;

import biz.elabor.prebilling.model.misure.Sof;
import biz.elabor.prebilling.model.misure.Trattamento;
import biz.elabor.prebilling.model.statopod.AbstractNoncommercialeStatoPod;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.model.statopod.StatoPodHelper;
import biz.elabor.prebilling.services.StrategyHelper;
import java.util.Date;

public class SofStatoPod
extends AbstractNoncommercialeStatoPod {
    private String servizio;
    private String pod;
    private String cf;
    private String piva;
    private String pivaDistributore;
    private String pivaReseller;
    private String pivaDispatcher;
    private String codiceDispacciamento;
    private String stato;
    private String flagResidente;
    private Date dataMovimento;
    private final int numeroProgressivo;
    private Date dataAttivazione;
    private Date dataCessazione;
    private String cdunipre;
    private String cdFlusso;
    private String tabellaRiferimento;
    private String chiaveTabellaRiferimento;
    private String toponimo;
    private String via;
    private String civico;
    private String comuneCatastale;
    private String cap;
    private boolean flagOrario;
    private String cdtardis;
    private int tensione;
    private String livelloTensione;
    private double potenzaContr;
    private double potenzaDisp;
    private boolean flmisCon;
    private boolean flmisRea;
    private boolean flmisPot;
    private double inmisCon;
    private double inmisRea;
    private double inmisPot;
    private double nuLetA01;
    private double nuLetA02;
    private double nuLetA03;
    private double nuLetR01;
    private double nuLetR02;
    private double nuLetR03;
    private double nuLetP01;
    private double nuLetP02;
    private double nuLetP03;
    private String nuMatrA;
    private String nuMatrR;
    private String nuMatrP;
    private String modContatoreA;
    private String modContatoreR;
    private String modContatoreP;
    private String modContatoreBio;
    private boolean flazzconA;
    private boolean flazzconR;
    private boolean flazzconP;
    private int nuCifreA;
    private int nuCifreR;
    private int nuCifreP;
    private int nnFascia;
    private String statoRic;
    private String servizioTutela;
    private final Date dataPrestazione;
    private final boolean flMisBio;
    private final double inMisBio;
    private final String nuMatricBio;
    private final boolean flAzzConBio;
    private final String codiceOfferta;

    public SofStatoPod(Prestazione prestazione, String flusso, Sof sof, StatoPod riferimento, int numeroProgressivo) {
        super(riferimento, riferimento.getCpGestore(), riferimento.getCpUtente(), StatoPodHelper.getFlagResidente(sof));
        String codiceFlusso = sof.getCodiceFlusso();
        this.tensione = Integer.parseInt(sof.getTensione());
        Trattamento trattamento = sof.getTrattamento();
        String tipoMisuratore = sof.getTipoMisuratore();
        String tarDis = sof.getCodiceTariffa();
        String cdConMag = StrategyHelper.getKeyCdConMag(codiceFlusso, null, this.tensione, trattamento, tipoMisuratore, true, false, false, tarDis);
        this.servizio = riferimento.getServizio();
        this.pod = sof.getCodicePod();
        this.cf = riferimento.getCf();
        this.piva = riferimento.getPiva();
        this.pivaDistributore = sof.getPivaDistributore();
        this.pivaReseller = riferimento.getPivaReseller();
        this.pivaDispatcher = sof.getPivaUtente();
        this.codiceDispacciamento = sof.getCodContrDisp();
        this.stato = prestazione.getStato();
        this.flagResidente = riferimento.getFlagResidente();
        this.dataMovimento = sof.getDataMovimento();
        this.numeroProgressivo = numeroProgressivo;
        this.dataAttivazione = riferimento.getDataAttivazione();
        this.dataCessazione = null;
        this.cdunipre = prestazione.getPrestazione();
        this.cdFlusso = flusso;
        this.tabellaRiferimento = "SW_DATI_FUNZ_POD_ORARI";
        this.chiaveTabellaRiferimento = sof.getFirstId();
        this.toponimo = riferimento.getToponimo();
        this.via = riferimento.getVia();
        this.civico = riferimento.getCivico();
        this.comuneCatastale = riferimento.getComuneCatastale();
        this.cap = riferimento.getCap();
        this.flagOrario = trattamento.isOrario();
        this.cdtardis = sof.getCodiceTariffa();
        this.livelloTensione = this.tensione < 1000 ? "0" : "1";
        this.potenzaContr = sof.getPotImp().doubleValue();
        this.potenzaDisp = sof.getPotDisp().doubleValue();
        this.flmisCon = true;
        this.flmisRea = true;
        this.flmisPot = true;
        this.nnFascia = trattamento.getFasce();
        this.nuLetA01 = 0.0;
        this.nuLetA02 = 0.0;
        this.nuLetA03 = 0.0;
        this.nuLetR01 = 0.0;
        this.nuLetR02 = 0.0;
        this.nuLetR03 = 0.0;
        this.nuLetP01 = 0.0;
        this.nuLetP02 = 0.0;
        this.nuLetP03 = 0.0;
        this.nuMatrA = "ORARIA";
        this.nuMatrR = "ORARIA";
        this.nuMatrP = "ORARIA";
        this.modContatoreA = cdConMag;
        this.modContatoreR = cdConMag;
        this.modContatoreP = cdConMag;
        this.flazzconA = true;
        this.flazzconR = true;
        this.flazzconP = true;
        this.nuCifreA = 0;
        this.nuCifreR = 0;
        this.nuCifreP = 0;
        this.inmisCon = 1.0;
        this.inmisRea = 1.0;
        this.inmisPot = 1.0;
        this.statoRic = prestazione.getStatoRichiesta();
        this.servizioTutela = sof.getServizioTutela();
        this.flMisBio = sof.isCommerciale();
        this.inMisBio = this.flMisBio ? 1 : 0;
        this.nuMatricBio = this.flMisBio ? "ORARIA" : "";
        this.flAzzConBio = this.flMisBio;
        this.modContatoreBio = this.flMisBio ? cdConMag : "";
        this.codiceOfferta = sof.getCodiceOfferta();
        this.dataPrestazione = riferimento.getDataPrestazione();
    }

    @Override
    public Date getDataPrestazione() {
        return this.dataPrestazione;
    }

    @Override
    public String getStatoRic() {
        return this.statoRic;
    }

    @Override
    public String getStato() {
        return this.stato;
    }

    @Override
    public Date getDataCessazione() {
        return this.dataCessazione;
    }

    @Override
    public Date getDataMovimento() {
        return this.dataMovimento;
    }

    @Override
    public String getServizio() {
        return this.servizio;
    }

    @Override
    public String getPod() {
        return this.pod;
    }

    @Override
    public String getCf() {
        return this.cf;
    }

    @Override
    public String getPiva() {
        return this.piva;
    }

    @Override
    public String getPivaDistributore() {
        return this.pivaDistributore;
    }

    @Override
    public String getPivaReseller() {
        return this.pivaReseller;
    }

    @Override
    public String getPivaDispatcher() {
        return this.pivaDispatcher;
    }

    @Override
    public String getCodiceDispacciamento() {
        return this.codiceDispacciamento;
    }

    @Override
    public String getFlagResidente() {
        return this.flagResidente;
    }

    @Override
    public int getNuprogre() {
        return this.numeroProgressivo;
    }

    @Override
    public Date getDataAttivazione() {
        return this.dataAttivazione;
    }

    @Override
    public String getCdunipre() {
        return this.cdunipre;
    }

    @Override
    public String getCdFlusso() {
        return this.cdFlusso;
    }

    @Override
    public String getTabellaRiferimento() {
        return this.tabellaRiferimento;
    }

    @Override
    public String getChiaveTabellaRiferimento() {
        return this.chiaveTabellaRiferimento;
    }

    @Override
    public String getToponimo() {
        return this.toponimo;
    }

    @Override
    public String getVia() {
        return this.via;
    }

    @Override
    public String getCivico() {
        return this.civico;
    }

    @Override
    public String getComuneCatastale() {
        return this.comuneCatastale;
    }

    @Override
    public String getCap() {
        return this.cap;
    }

    @Override
    public boolean getFlagOrario() {
        return this.flagOrario;
    }

    @Override
    public String getCdtardis() {
        return this.cdtardis;
    }

    @Override
    public int getTensione() {
        return this.tensione;
    }

    @Override
    public String getLivelloTensione() {
        return this.livelloTensione;
    }

    @Override
    public double getPotenzaContr() {
        return this.potenzaContr;
    }

    @Override
    public double getPotenzaDisp() {
        return this.potenzaDisp;
    }

    @Override
    public boolean getFlmisCon() {
        return this.flmisCon;
    }

    @Override
    public boolean getFlmisRea() {
        return this.flmisRea;
    }

    @Override
    public boolean getFlmisPot() {
        return this.flmisPot;
    }

    @Override
    public double getNuLetA01() {
        return this.nuLetA01;
    }

    @Override
    public double getNuLetA02() {
        return this.nuLetA02;
    }

    @Override
    public double getNuLetA03() {
        return this.nuLetA03;
    }

    @Override
    public double getNuLetR01() {
        return this.nuLetR01;
    }

    @Override
    public double getNuLetR02() {
        return this.nuLetR02;
    }

    @Override
    public double getNuLetR03() {
        return this.nuLetR03;
    }

    @Override
    public double getNuLetP01() {
        return this.nuLetP01;
    }

    @Override
    public double getNuLetP02() {
        return this.nuLetP02;
    }

    @Override
    public double getNuLetP03() {
        return this.nuLetP03;
    }

    @Override
    public double getInmisCon() {
        return this.inmisCon;
    }

    @Override
    public double getInmisRea() {
        return this.inmisRea;
    }

    @Override
    public double getInmisPot() {
        return this.inmisPot;
    }

    @Override
    public String getNuMatrA() {
        return this.nuMatrA;
    }

    @Override
    public String getNuMatrR() {
        return this.nuMatrR;
    }

    @Override
    public String getNuMatrP() {
        return this.nuMatrP;
    }

    @Override
    public String getModContatoreA() {
        return this.modContatoreA;
    }

    @Override
    public String getModContatoreR() {
        return this.modContatoreR;
    }

    @Override
    public String getModContatoreP() {
        return this.modContatoreP;
    }

    @Override
    public String getModContatoreBio() {
        return this.modContatoreBio;
    }

    @Override
    public boolean isFlazzconA() {
        return this.flazzconA;
    }

    @Override
    public boolean isFlazzconR() {
        return this.flazzconR;
    }

    @Override
    public boolean isFlazzconP() {
        return this.flazzconP;
    }

    @Override
    public int getNuCifreA() {
        return this.nuCifreA;
    }

    @Override
    public int getNuCifreR() {
        return this.nuCifreR;
    }

    @Override
    public int getNuCifreP() {
        return this.nuCifreP;
    }

    @Override
    public int getNnFascia() {
        return this.nnFascia;
    }

    @Override
    public boolean isPraticaAnnullata() {
        return false;
    }

    @Override
    public String getServizioTutela() {
        return this.servizioTutela;
    }

    @Override
    public boolean isFlMisBio() {
        return this.flMisBio;
    }

    @Override
    public double getInMisBio() {
        return this.inMisBio;
    }

    @Override
    public String getNuMatricBio() {
        return this.nuMatricBio;
    }

    @Override
    public boolean isFlAzzConBio() {
        return this.flAzzConBio;
    }

    @Override
    public String getCodiceOfferta() {
        return this.codiceOfferta;
    }
}

