/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.statopod;

import biz.elabor.prebilling.model.misure.MisuraD65;
import biz.elabor.prebilling.model.statopod.AbstractBasicStatoPod;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.StatoPod;
import java.util.Date;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;

public abstract class AbstractStatoPod
extends AbstractBasicStatoPod {
    private final String servizioTutela;
    private final Set<String> id;
    private final Date dataPrestazione;

    public abstract Date findDataAttivazione(Prestazione var1, StatoPod var2);

    public AbstractStatoPod(String servizioTutela, Date dataPrestazione, Set<String> id, String cpGestore, String cpUtente, String residenza) {
        super(cpGestore, cpUtente, residenza);
        this.servizioTutela = servizioTutela;
        this.dataPrestazione = dataPrestazione;
        this.id = id;
    }

    @Override
    public Date getDataPrestazione() {
        return this.dataPrestazione;
    }

    @Override
    public Set<String> getId() {
        return this.id;
    }

    protected Date getDataCessazione(Prestazione prestazione, MisuraD65 mno) {
        String stato = prestazione.getStato();
        return stato.equals("C") ? (mno.getCodiceFlusso().matches("P.O2G") ? mno.getDataMovimento() : mno.getDataMisura()) : null;
    }

    public Date getNextDataAttivazione(Prestazione prestazione, StatoPod riferimento) {
        Date dataAttivazione = riferimento.getDataAttivazione();
        String stato = prestazione.getStato();
        String codicePrestazione = prestazione.getPrestazione();
        if (!stato.equals("C") && !codicePrestazione.equals("VT1")) {
            dataAttivazione = CalendarTools.nextDay(dataAttivazione);
        }
        return dataAttivazione;
    }

    @Override
    public String getServizioTutela() {
        return this.servizioTutela;
    }
}

