/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.pra;

import biz.elabor.prebilling.dao.DistributoreSotteso;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.pra.PraMensile;
import java.util.LinkedHashMap;
import java.util.Map;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;

public class PraMap {
    private final MisureDao misureDao;
    private final Map<String, DistributoreSotteso> pivaMap;
    private final Map<String, PraMensile> praMap;
    private final boolean ricalendarizzato;

    public PraMap(MisureDao misureDao, boolean ricalendarizzato, Map<String, DistributoreSotteso> pivaMap) {
        this.misureDao = misureDao;
        this.pivaMap = pivaMap;
        this.ricalendarizzato = ricalendarizzato;
        this.praMap = new LinkedHashMap<String, PraMensile>();
    }

    public PraMensile get(String pivaDistributore, int idZona, int anno, Month mese) throws DataNotFoundException {
        DistributoreSotteso distributoreSotteso = this.pivaMap.get(pivaDistributore);
        String pivaDistrRif = distributoreSotteso == null ? pivaDistributore : distributoreSotteso.getPivaRiferimento();
        String key = String.valueOf(pivaDistrRif) + "|" + idZona + "|" + anno + "|" + mese.getIndex();
        PraMensile praMensile = this.praMap.get(key);
        if (praMensile == null) {
            praMensile = this.ricalendarizzato ? this.misureDao.getPraRicalendarizzato(pivaDistrRif, idZona, anno, mese) : this.misureDao.getPraEsatto(pivaDistrRif, idZona, anno, mese);
            this.praMap.put(key, praMensile);
        }
        return praMensile;
    }
}

