/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.misure;

import biz.elabor.misure.model.WorkingPeriod;
import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.model.misure.DatiFlussoMisura;
import biz.elabor.prebilling.model.misure.MisureHelper;
import biz.elabor.prebilling.model.misure.RilData;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.misure.Trattamento;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.homelinux.elabor.structures.KeyRecord;
import org.homelinux.elabor.structures.listmap.BasicListMap;
import org.homelinux.elabor.structures.listmap.ListMap;

public class Pdo
extends DatiFlussoMisura
implements KeyRecord<String> {
    private final boolean stimata;
    private final Map<String, Map<String, String>> datiPod;
    private final String codPratAtt;
    private final ListMap<Date, RilData> rilMap;
    private RilMese rilMese;
    private boolean tariffaElaborata;
    private boolean tariffaResellerElaborata;
    private final Date dataImport;

    public Pdo(String id, boolean stimata, RilMese rilMese, String pIvaUtente, String pIvaDistributore, String codContrDisp, String codPratAtt, String cdaziend, Map<String, Map<String, String>> datiPod, String tipoRettifica, String motivazione, Date dataRilevazione, String nomeFile) {
        this(id, stimata, rilMese, pIvaUtente, pIvaDistributore, codContrDisp, codPratAtt, cdaziend, datiPod, tipoRettifica, motivazione, dataRilevazione, nomeFile, "65", null, "R", null, null);
    }

    public Pdo(String id, boolean stimata, RilMese rilMese, String pIvaUtente, String pIvaDistributore, String codContrDisp, String codPratAtt, String cdaziend, Map<String, Map<String, String>> datiPod, String tipoRettifica, String motivazione, Date dataRilevazione, String nomeFile, String delibera, String idTipoMisura, String regime, String causaOstativa, Date dataImport) {
        super(pIvaUtente, pIvaDistributore, codContrDisp, cdaziend, tipoRettifica, motivazione, dataRilevazione, nomeFile, id, delibera, idTipoMisura, regime, causaOstativa);
        this.stimata = stimata;
        this.rilMese = rilMese;
        this.datiPod = datiPod;
        this.codPratAtt = codPratAtt;
        this.dataImport = dataImport;
        this.rilMap = new BasicListMap<Date, RilData>();
    }

    public RilMese getRilMese() {
        return this.rilMese;
    }

    public Map<String, Map<String, String>> getDatiPod() {
        return this.datiPod;
    }

    public boolean isStimata() {
        return this.stimata;
    }

    @Override
    public String getKey() {
        return this.getRilMese().getCodicePod();
    }

    @Override
    public String getCodicePod() {
        return this.getKey();
    }

    public Trattamento getTrattamento() {
        return MisureHelper.getTrattamento(this.datiPod);
    }

    public String getCodPratAtt() {
        return this.codPratAtt;
    }

    public String getTensione() {
        Map<String, String> datiPdp = this.datiPod.get("DatiPdp");
        return datiPdp.get("Tensione");
    }

    public String getRaccoltaEstesa() {
        String raccolta = this.getRaccolta();
        return raccolta == null || raccolta.trim().isEmpty() ? this.getTipoRettifica() : raccolta;
    }

    public String getRaccolta() {
        Map<String, String> datiPdp = this.getDatiMisura();
        return datiPdp.get("Raccolta");
    }

    public String getTipoDato() {
        Map<String, String> datiPdp = this.getDatiMisura();
        return datiPdp.get("TipoDato");
    }

    private Map<String, String> getDatiMisura() {
        String nome = this.datiPod.containsKey("Misura") ? "Misura" : "Curva";
        return this.datiPod.get(nome);
    }

    public String getValidato() {
        Map<String, String> datiPdp = this.getDatiMisura();
        return datiPdp.get("Validato");
    }

    public Number getPotMax() {
        Number value;
        Map<String, String> datiPdp = this.getDatiMisura();
        String stringValue = datiPdp.get("PotMax");
        if (stringValue == null) {
            value = null;
        } else {
            try {
                value = this.usEnergyFormat.parse(stringValue);
            }
            catch (ParseException exc) {
                value = null;
            }
        }
        return value;
    }

    public String getMotivazioneStima() {
        Map<String, String> datiPdp = this.getDatiMisura();
        return datiPdp.get("MotivazioneStima");
    }

    private double getDoublePdp(String name) {
        double value;
        Map<String, String> datiPdp = this.datiPod.get("DatiPdp");
        String stringValue = datiPdp.get(name);
        if (stringValue == null) {
            value = 1.0;
        } else {
            try {
                value = this.usEnergyFormat.parse(stringValue).doubleValue();
            }
            catch (ParseException exc) {
                value = 1.0;
            }
        }
        return value;
    }

    public double getKa() {
        return this.getDoublePdp("Ka");
    }

    public double getKr() {
        return this.getDoublePdp("Kr");
    }

    public double getKp() {
        return this.getDoublePdp("Kp");
    }

    public String getKaString() {
        return this.getStringDatiPdP("Ka");
    }

    public String getKrString() {
        return this.getStringDatiPdP("Kr");
    }

    public String getKpString() {
        return this.getStringDatiPdP("Kp");
    }

    private String getStringDatiPdP(String name) {
        Map<String, String> datiPdp = this.datiPod.get("DatiPdp");
        String stringaDatiPdp = datiPdp.get(name);
        return stringaDatiPdp == null ? null : stringaDatiPdp.trim();
    }

    public String getForfait() {
        Map<String, String> datiPdp = this.datiPod.get("DatiPdp");
        return datiPdp.get("Forfait");
    }

    public String getGruppoMisura() {
        Map<String, String> datiPdp = this.datiPod.get("DatiPdp");
        return datiPdp.get("GruppoMis");
    }

    public void setRilMese(RilMese rilMese) {
        this.rilMese = rilMese;
    }

    private String getDato(String keyMap, String name) {
        Map<String, String> datiMisura = this.datiPod.get(keyMap);
        return datiMisura == null ? null : datiMisura.get(name);
    }

    public String getEAF1() {
        return this.getDato("Misura", "EaF1");
    }

    public String getEAF2() {
        return this.getDato("Misura", "EaF2");
    }

    public String getEAF3() {
        return this.getDato("Misura", "EaF3");
    }

    public String getEAF4() {
        return this.getDato("Misura", "EaF4");
    }

    public String getEAF5() {
        return this.getDato("Misura", "EaF5");
    }

    public String getEAF6() {
        return this.getDato("Misura", "EaF6");
    }

    public String getERF1() {
        return this.getDato("Misura", "ErF1");
    }

    public String getERF2() {
        return this.getDato("Misura", "ErF2");
    }

    public String getERF3() {
        return this.getDato("Misura", "ErF3");
    }

    public String getERF4() {
        return this.getDato("Misura", "ErF4");
    }

    public String getERF5() {
        return this.getDato("Misura", "ErF5");
    }

    public String getERF6() {
        return this.getDato("Misura", "ErF6");
    }

    public String getPotF1String() {
        return this.getDato("Misura", "PotF1");
    }

    public String getPotF2String() {
        return this.getDato("Misura", "PotF2");
    }

    public String getPotF3String() {
        return this.getDato("Misura", "PotF3");
    }

    public String getPotF4String() {
        return this.getDato("Misura", "PotF4");
    }

    public String getPotF5String() {
        return this.getDato("Misura", "PotF5");
    }

    public String getPotF6String() {
        return this.getDato("Misura", "PotF6");
    }

    public String getCifreAtt() {
        return this.getDatoZero("DatiPdp", "CifreAtt");
    }

    public String getCifreRea() {
        return this.getDatoZero("DatiPdp", "CifreRea");
    }

    public String getCifrePot() {
        return this.getDatoZero("DatiPdp", "CifrePot");
    }

    private String getDatoZero(String keyMap, String name) {
        String dato = this.getDato(keyMap, name);
        return dato == null ? "0" : dato;
    }

    public void addRilData(Date dataRilevazione, String tipoRettifica, Map<String, Map<String, String>> datiPodRil, RilGiorno rilGiorno) {
        RilData rilData = new RilData(tipoRettifica, datiPodRil, rilGiorno);
        this.rilMap.add(dataRilevazione, rilData);
    }

    public ListMap<Date, RilData> getRilMap() {
        return this.rilMap;
    }

    @Override
    public WorkingPeriod getPeriod() {
        return this.rilMese.getPeriod();
    }

    public Date getStartDate() {
        return this.rilMese.isEmpty() ? new Date(0L) : ((RilGiorno)this.rilMese.get(0)).getDate();
    }

    public String getFirstCodiceFlusso() {
        return this.rilMese.getFirstCodiceFlusso();
    }

    public boolean isReal() {
        return false;
    }

    public StatoMisure getStato() {
        return StatoMisure.ELABORATO;
    }

    public boolean isTariffaElaborata() {
        return this.tariffaElaborata;
    }

    public void setTariffaElaborata(boolean elaborato) {
        this.tariffaElaborata = elaborato;
    }

    public boolean isTariffaResellerElaborata() {
        return this.tariffaResellerElaborata;
    }

    public void setTariffaResellerElaborata(boolean elaborato) {
        this.tariffaResellerElaborata = elaborato;
    }

    @Override
    public String getXmlKey() {
        DateFormat annoMeseFormat = StrategyCommonHelper.getAnnoMeseDateFormat();
        WorkingPeriod period = this.rilMese.getPeriod();
        Date startDate = period.getStartDate();
        String annoMese = annoMeseFormat.format(startDate);
        return String.valueOf(this.getCodicePod()) + "|" + annoMese;
    }

    public Date getDataImport() {
        return this.dataImport;
    }
}

