/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.misure;

import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.MisurePeriodiche;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.services.volture.ExtMno;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.structures.KeyRecord;

public class MnoPod
extends MisurePeriodiche
implements KeyRecord<String> {
    private Pod pod;
    private Set<Mno> misureTecniche;
    private Set<Mno> misureSospette;
    private List<ExtMno> smis;
    private List<Mno> switchout;

    public MnoPod(Pod pod) {
        this.pod = pod;
        this.misureTecniche = new LinkedHashSet<Mno>();
        this.misureSospette = new LinkedHashSet<Mno>();
        this.smis = new ArrayList<ExtMno>();
        this.switchout = new ArrayList<Mno>();
    }

    @Override
    public String getKey() {
        return this.pod.getKey();
    }

    public Pod getPod() {
        return this.pod;
    }

    public Collection<Mno> getMisureTecniche() {
        return this.misureTecniche;
    }

    public Collection<Mno> getMisureSospette() {
        return this.misureSospette;
    }

    public void addMisuraTecnica(Mno mno) {
        this.misureTecniche.add(mno);
    }

    public void addMisuraSospetta(Mno mno) {
        this.misureSospette.add(mno);
    }

    public void addSmis(ExtMno mno) {
        this.smis.add(mno);
    }

    public Collection<ExtMno> getSmis() {
        return this.smis;
    }

    public void addSwitchout(Mno mno) throws DataNotFoundException {
        Date dataSwitchout = this.pod.getSwitchout();
        if (dataSwitchout == null) {
            ErroriElaborazione error = ErroriElaborazione.INVALID_SWITCHOUT_DATE;
            String message = error.getMessage();
            int errore = error.ordinal();
            throw new DataNotFoundException(message, this.pod.getCodice(), errore);
        }
        mno.setDataMisura(dataSwitchout);
        if (!this.exists(mno)) {
            this.switchout.add(mno);
        }
    }

    private boolean exists(Mno mno) {
        boolean exists = false;
        for (Mno current : this.switchout) {
            if (!mno.getId().equals(current.getId())) continue;
            exists = true;
            break;
        }
        return exists;
    }

    public Collection<Mno> getSwitchout() {
        return this.switchout;
    }
}

