/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.misure;

import biz.elabor.misure.model.WorkingPeriod;
import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.dao.creator.RecordCreatorHelper;
import biz.elabor.prebilling.model.MisuraD65Visitor;
import biz.elabor.prebilling.model.misure.DatiFlussoMisura;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraCompleta;
import biz.elabor.prebilling.model.misure.MisuraD65;
import biz.elabor.prebilling.model.misure.MisureHelper;
import biz.elabor.prebilling.model.misure.Trattamento;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.tariffe.LetturaSegnanti;
import biz.elabor.prebilling.services.tariffe.RilevazioneTariffa;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.text.Format;

public class Mno
extends DatiFlussoMisura
implements MisuraD65,
RilevazioneTariffa,
LetturaSegnanti {
    private static final String[] NOMI_MATRICOLE = new String[]{"MatrAtt", "MatrRea", "MatrPot"};
    private final DecimalFormat DOUBLE_FORMAT = Format.newDecimalFormat(Locale.US, "0.000");
    private String codicePod;
    private Misura misura;
    private String codPratAtt;
    private Date dataInst;
    private Date dataVoltura;
    private Map<String, Map<String, String>> datiPod;
    private String tipoMisuratore;
    private Date dataMessaRegime;
    private Date dataPrestazione;
    private final StatoMisure stato;
    private final StatoMisure statoTariffeDisp;
    private final StatoMisure statoTariffeRese;
    private String flussoFunzionale;
    private final DecimalFormat doubleFormat;
    private final boolean forfait;
    private final Date dataInizioPeriodo;
    private final boolean real;
    private final boolean pdo2GR;
    private String codiceFlusso;
    private boolean calcolata;

    public Mno(String id, String flusso, String codicePod, Misura misura, String pIvaUtente, String pIvaDistributore, String codContrDisp, String codPratAtt, String cdaziend, Date dataInst, Date dataVoltura, Map<String, Map<String, String>> datiPod, String motivazione, String tipoMisuratore, Date dataMessaRegime, Date dataRilevazione, Date dataPrestazione, String tipoRettifica, String nomeFile, StatoMisure stato, String regime) {
        this(id, flusso, codicePod, misura, pIvaUtente, pIvaDistributore, codContrDisp, codPratAtt, cdaziend, dataInst, dataVoltura, datiPod, motivazione, tipoMisuratore, dataMessaRegime, dataRilevazione, dataPrestazione, tipoRettifica, nomeFile, "65", "6", stato, null, null, regime, false, null, true, false, null);
    }

    public Mno(String id, String flusso, String codicePod, Misura misura, String pIvaUtente, String pIvaDistributore, String codContrDisp, String codPratAtt, String cdaziend, Date dataInst, Date dataVoltura, Map<String, Map<String, String>> datiPod, String motivazione, String tipoMisuratore, Date dataMessaRegime, Date dataRilevazione, Date dataPrestazione, String tipoRettifica, String nomeFile, String delibera, String idTipoMisura, StatoMisure stato, StatoMisure statoTariffeDisp, StatoMisure statoTariffeRese, String regime, boolean forfait, Date dataInizioPeriodo, boolean real, boolean pdo2GR, String causaOstativa) {
        super(pIvaUtente, pIvaDistributore, codContrDisp, cdaziend, tipoRettifica, motivazione, dataRilevazione, nomeFile, id, delibera, idTipoMisura, regime, causaOstativa);
        this.codiceFlusso = flusso == null ? "" : flusso;
        this.codicePod = codicePod;
        this.misura = misura;
        this.codPratAtt = codPratAtt;
        this.dataInst = dataInst;
        this.dataVoltura = dataVoltura;
        this.datiPod = datiPod;
        this.tipoMisuratore = tipoMisuratore;
        this.dataMessaRegime = dataMessaRegime;
        this.dataPrestazione = dataPrestazione;
        this.stato = stato;
        this.statoTariffeDisp = statoTariffeDisp;
        this.statoTariffeRese = statoTariffeRese;
        this.doubleFormat = BasicRecordCreatorHelper.getDoubleFormat();
        this.usEnergyFormat = StrategyHelper.getUsEnergyFormat();
        this.forfait = forfait;
        this.dataInizioPeriodo = dataInizioPeriodo;
        this.real = real;
        this.pdo2GR = pdo2GR;
        this.calcolata = false;
    }

    public StatoMisure getStato() {
        return this.stato;
    }

    @Override
    public String getKey() {
        return this.codicePod;
    }

    @Override
    public String getCodicePod() {
        return this.codicePod;
    }

    @Override
    public Date getDataMisura() {
        return this.misura.getDate();
    }

    @Override
    public Misura getMisura() {
        return this.misura;
    }

    @Override
    public Map<String, Map<String, String>> getDatiPod() {
        return this.datiPod;
    }

    @Override
    public String getTipoMisuratore() {
        return this.tipoMisuratore;
    }

    public Date getDataMessaRegime2G() {
        return this.dataMessaRegime;
    }

    @Override
    public Date getDataPrestazione() {
        return this.dataPrestazione;
    }

    @Override
    public Number getPotMax() {
        Number value;
        Map<String, String> misuraDatiPod = this.datiPod.get("Misura");
        String stringValue = misuraDatiPod.get("PotMax");
        if (stringValue == null) {
            value = null;
        } else {
            try {
                value = this.usEnergyFormat.parse(stringValue);
            }
            catch (ParseException exc) {
                value = null;
            }
        }
        return value;
    }

    @Override
    public boolean hasAttiva() {
        Map<String, String> misuraDatiPod = this.datiPod.get("Misura");
        return misuraDatiPod.get("EaF1") != null || misuraDatiPod.get("EaM") != null;
    }

    @Override
    public boolean hasReattiva() {
        Map<String, String> misuraDatiPod = this.datiPod.get("Misura");
        return !this.forfait && (misuraDatiPod.get("ErF1") != null || misuraDatiPod.get("ErM") != null);
    }

    @Override
    public boolean hasPotenza() {
        Map<String, String> misuraDatiPod = this.datiPod.get("Misura");
        return !this.forfait && (misuraDatiPod.get("PotF1") != null || misuraDatiPod.get("PotM") != null);
    }

    @Override
    public String getMatricolaAtt() {
        return this.getStringDatiPdP("MatrAtt");
    }

    @Override
    public String getMatricolaRea() {
        return this.getStringDatiPdP("MatrRea");
    }

    @Override
    public String getMatricolaPot() {
        return this.getStringDatiPdP("MatrPot");
    }

    @Override
    public String getCifreAtt() {
        return this.getStringDatiPdP("CifreAtt");
    }

    @Override
    public String getCifreRea() {
        return this.getStringDatiPdP("CifreRea");
    }

    @Override
    public String getCifrePot() {
        return this.getStringDatiPdP("CifrePot");
    }

    @Override
    public Number getKa() {
        return this.getNumberDatiPdP("Ka");
    }

    public void setKa(String ka) {
        this.setDatiPod("Ka", ka);
    }

    public void setKr(String kr) {
        this.setDatiPod("Kr", kr);
    }

    public void setKp(String kp) {
        this.setDatiPod("Kp", kp);
    }

    private void setDatiPod(String name, String value) {
        Map<String, String> datiPdp = this.datiPod.get("DatiPdp");
        datiPdp.put(name, value);
    }

    @Override
    public Number getKr() {
        return this.getNumberDatiPdP("Kr");
    }

    @Override
    public Number getKp() {
        return this.getNumberDatiPdP("Kp");
    }

    @Override
    public String getTipoDato() {
        return this.datiPod.get("Misura").get("TipoDato");
    }

    @Override
    public String getTensione() {
        return this.getStringDatiPdP("Tensione");
    }

    @Override
    public Number getPotContrImp() {
        return this.getNumberDatiPdP("PotContrImp");
    }

    private Number getNumberDatiPdP(String name) {
        Number value;
        try {
            String stringaDatiPdp = this.getStringDatiPdP(name);
            value = stringaDatiPdp == null || stringaDatiPdp.isEmpty() ? (Number)null : (Number)this.doubleFormat.parse(stringaDatiPdp);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return value;
    }

    private String getStringDatiPdP(String name) {
        Map<String, String> datiPdp = this.datiPod == null ? null : this.datiPod.get("DatiPdp");
        String stringaDatiPdp = datiPdp == null ? null : datiPdp.get(name);
        return stringaDatiPdp == null ? null : stringaDatiPdp.trim();
    }

    @Override
    public Number getPotDisp() {
        return this.getNumberDatiPdP("PotDisp");
    }

    public String getPotDispString() {
        return this.getStringDatiPdP("PotDisp");
    }

    public void setPotDisponibile(double potDisponibile) {
        Map<String, String> datiPdp = this.datiPod.get("DatiPdp");
        datiPdp.put("PotDisp", this.doubleFormat.format(potDisponibile));
    }

    public void setPotContrattuale(double potContrattuale) {
        Map<String, String> datiPdp = this.datiPod.get("DatiPdp");
        datiPdp.put("PotContrImp", this.doubleFormat.format(potContrattuale));
    }

    @Override
    public Trattamento getTrattamento() {
        String trattamento = this.getStringDatiPdP("Trattamento");
        return RecordCreatorHelper.getEnum(trattamento, Trattamento.class, Trattamento.F);
    }

    @Override
    public Trattamento getTrattamento(Trattamento defaultValue) {
        String trattamento = this.getStringDatiPdP("Trattamento");
        return RecordCreatorHelper.getEnum(trattamento, Trattamento.class, defaultValue);
    }

    @Override
    public String getCodPratAtt() {
        return this.codPratAtt;
    }

    public Date getDataInst() {
        return this.dataInst;
    }

    @Override
    public Date getDataVoltura() {
        return this.dataVoltura;
    }

    public String getInstMisAttiva() {
        return this.getStringDatiPdP("DataInstMisAtt");
    }

    public String getInstMisReattiva() {
        return this.getStringDatiPdP("DataInstMisRea");
    }

    public String getInstMisPotenza() {
        return this.getStringDatiPdP("DataInstMisPot");
    }

    public String getGruppoMisura() {
        return this.getStringDatiPdP("GruppoMis");
    }

    public String getForfait() {
        return this.getStringDatiPdP("Forfait");
    }

    public String getRaccoltaEstesa() {
        String raccolta = this.getRaccolta();
        return raccolta == null || raccolta.trim().isEmpty() ? this.getTipoRettifica() : raccolta;
    }

    @Override
    public String getRaccolta() {
        Map<String, String> misuraMap = this.datiPod.get("Misura");
        return misuraMap == null ? "" : misuraMap.get("Raccolta");
    }

    public String getValidato() {
        Map<String, String> misuraMap = this.datiPod.get("Misura");
        return misuraMap.get("Validato");
    }

    private String getDato(String keyMap, String name) {
        Map<String, String> datiMisura = this.datiPod.get(keyMap);
        return datiMisura.get(name);
    }

    private double toDouble(String value) {
        double energy;
        try {
            energy = this.DOUBLE_FORMAT.parse(value).doubleValue();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
        return energy;
    }

    @Override
    public String getEAM() {
        return this.getDato("Misura", "EaM");
    }

    @Override
    public double getEAMDouble() {
        return this.toDouble(this.getEAM());
    }

    public String getMotivazioneStima() {
        return this.getDato("Misura", "MotivazioneStima");
    }

    @Override
    public String getEAF1() {
        return this.getDato("Misura", "EaF1");
    }

    @Override
    public double getEAF1Double() {
        return this.toDouble(this.getEAF1());
    }

    @Override
    public String getEAF2() {
        return this.getDato("Misura", "EaF2");
    }

    @Override
    public double getEAF2Double() {
        return this.toDouble(this.getEAF2());
    }

    @Override
    public String getEAF3() {
        return this.getDato("Misura", "EaF3");
    }

    @Override
    public double getEAF3Double() {
        return this.toDouble(this.getEAF3());
    }

    public String getEAF4() {
        return this.getDato("Misura", "EaF4");
    }

    public String getEAF5() {
        return this.getDato("Misura", "EaF5");
    }

    public String getEAF6() {
        return this.getDato("Misura", "EaF6");
    }

    @Override
    public String getERM() {
        return this.getDato("Misura", "ErM");
    }

    @Override
    public double getERMDouble() {
        return this.toDouble(this.getERM());
    }

    @Override
    public String getERF1() {
        return this.getDato("Misura", "ErF1");
    }

    @Override
    public double getERF1Double() {
        return this.toDouble(this.getERF1());
    }

    @Override
    public String getERF2() {
        return this.getDato("Misura", "ErF2");
    }

    @Override
    public double getERF2Double() {
        return this.toDouble(this.getERF2());
    }

    @Override
    public String getERF3() {
        return this.getDato("Misura", "ErF3");
    }

    @Override
    public double getERF3Double() {
        return this.toDouble(this.getERF3());
    }

    public String getERF4() {
        return this.getDato("Misura", "ErF4");
    }

    public String getERF5() {
        return this.getDato("Misura", "ErF5");
    }

    public String getERF6() {
        return this.getDato("Misura", "ErF6");
    }

    public String getERCF1() {
        return this.getDato("Misura", "ErcF1");
    }

    public String getERCF2() {
        return this.getDato("Misura", "ErcF2");
    }

    public String getERCF3() {
        return this.getDato("Misura", "ErcF3");
    }

    public String getERCF4() {
        return this.getDato("Misura", "ErcF4");
    }

    public String getERCF5() {
        return this.getDato("Misura", "ErcF5");
    }

    public String getERCF6() {
        return this.getDato("Misura", "ErcF6");
    }

    public String getERIF1() {
        return this.getDato("Misura", "EriF1");
    }

    public String getERIF2() {
        return this.getDato("Misura", "EriF2");
    }

    public String getERIF3() {
        return this.getDato("Misura", "EriF3");
    }

    public String getERIF4() {
        return this.getDato("Misura", "EriF4");
    }

    public String getERIF5() {
        return this.getDato("Misura", "EriF5");
    }

    public String getERIF6() {
        return this.getDato("Misura", "EriF6");
    }

    @Override
    public String getPotMOrig() {
        return this.getDato("Misura", "PotM");
    }

    @Override
    public String getPotF1Orig() {
        return this.getDato("Misura", "PotF1");
    }

    @Override
    public String getPotF2Orig() {
        return this.getDato("Misura", "PotF2");
    }

    @Override
    public String getPotF3Orig() {
        return this.getDato("Misura", "PotF3");
    }

    public String getPotF4Orig() {
        return this.getDato("Misura", "PotF4");
    }

    public String getPotF5Orig() {
        return this.getDato("Misura", "PotF5");
    }

    public String getPotF6Orig() {
        return this.getDato("Misura", "PotF6");
    }

    @Override
    public String getKaSegnale() {
        return this.getStringDatiPdP("Ka");
    }

    @Override
    public String getKrSegnale() {
        return this.getStringDatiPdP("Kr");
    }

    @Override
    public String getKpSegnale() {
        return this.getStringDatiPdP("Kp");
    }

    public boolean equals(Object object) {
        boolean ok;
        if (object instanceof Mno) {
            Mno mno = (Mno)object;
            Date currDate = mno.misura.getDate();
            Date date = this.misura.getDate();
            ok = this.codicePod.equals(mno.codicePod) && date.equals(currDate);
        } else {
            ok = false;
        }
        return ok;
    }

    public int hashCode() {
        return this.codicePod.hashCode() ^ this.misura.getDate().hashCode();
    }

    @Override
    public Date getDate() {
        return this.getDataMisura();
    }

    @Override
    public Date getDataMovimento() {
        Date dataMisura = this.getDataMisura();
        ElaborCalendar calendar = new ElaborCalendar(dataMisura);
        calendar.addGiorni(1);
        return calendar.getDate();
    }

    @Override
    public void accept(MisuraD65Visitor visitor) {
        visitor.visit(this);
    }

    public void setDataMisura(Date date) {
        Date dataMisura = this.misura.getDate();
        this.calcolata = dataMisura != null && !dataMisura.equals(date);
        this.misura.setDate(date);
    }

    public void setDataVoltura(Date data) {
        this.dataVoltura = data;
    }

    @Override
    public String getCountLabel() {
        return this.getCodiceFlusso();
    }

    public void setMatricole(String matricola) {
        String[] stringArray = NOMI_MATRICOLE;
        int n2 = NOMI_MATRICOLE.length;
        int n3 = 0;
        while (n3 < n2) {
            String name = stringArray[n3];
            this.setDatiPod(name, matricola);
            ++n3;
        }
    }

    public void setFlussoFunzionale(String flussoFunzionale) {
        this.flussoFunzionale = flussoFunzionale;
    }

    @Override
    public String getFlussoFunzionale() {
        return this.flussoFunzionale;
    }

    public double getPotenzaMax() {
        Number potMaxString = this.getPotMax();
        double potMax = potMaxString == null ? Mno.max(this.misura.getPotenza()) : potMaxString.doubleValue();
        return potMax;
    }

    private static double max(MisuraCompleta[] misuraCompletas) {
        double potMax = 0.0;
        MisuraCompleta[] misuraCompletaArray = misuraCompletas;
        int n2 = misuraCompletas.length;
        int n3 = 0;
        while (n3 < n2) {
            MisuraCompleta pot = misuraCompletaArray[n3];
            potMax = Math.max(potMax, pot.getNetto());
            ++n3;
        }
        return potMax;
    }

    public void updatePotenzaMax(double prevPotMax) {
        double thisPotMax = this.getPotenzaMax();
        if (prevPotMax >= thisPotMax) {
            Map<String, String> misuraDatiPod = this.datiPod.get("Misura");
            misuraDatiPod.put("PotMax", this.doubleFormat.format(prevPotMax));
        }
    }

    @Override
    public String getKaString() {
        return this.getKaSegnale();
    }

    @Override
    public String getKrString() {
        return this.getKrSegnale();
    }

    @Override
    public String getKpString() {
        return this.getKpSegnale();
    }

    @Override
    public double getPotMValue() {
        return this.getPotF1Value();
    }

    @Override
    public double getPotF1Value() {
        return this.misura.getPotenza(FasciaOraria.F1).getNetto();
    }

    @Override
    public double getPotF2Value() {
        return this.misura.getPotenza(FasciaOraria.F2).getNetto();
    }

    @Override
    public double getPotF3Value() {
        return this.misura.getPotenza(FasciaOraria.F3).getNetto();
    }

    @Override
    public boolean isForfait() {
        return this.forfait;
    }

    public Date getDataInizioPeriodo() {
        return this.dataInizioPeriodo;
    }

    @Override
    public WorkingPeriod getPeriod() {
        String raccolta;
        Date dataRiferimento = this.getDataMisura();
        String flusso = this.getCodiceFlusso();
        if ("SMIS".equals(flusso) && "M".equals(raccolta = this.getRaccolta())) {
            dataRiferimento = CalendarTools.previousDay(dataRiferimento);
        }
        return new WorkingPeriod(dataRiferimento);
    }

    public boolean isReal() {
        return this.real;
    }

    public boolean isPdo2GR() {
        return this.pdo2GR;
    }

    @Override
    public String getCodiceFlusso() {
        return this.codiceFlusso;
    }

    public void setCodiceFlusso(String codiceFlusso) {
        this.codiceFlusso = codiceFlusso;
    }

    public void setCodPratAtt(String codPratAtt) {
        this.codPratAtt = codPratAtt;
    }

    public void setDataPrestazione(Date dataPrestazione) {
        this.dataPrestazione = dataPrestazione;
    }

    @Override
    public boolean isSmisMontaggio() {
        return this.codiceFlusso.equals("SMIS") && this.getRaccolta().equals("M");
    }

    @Override
    public double getAttiva(FasciaOraria fascia) {
        return this.misura.getAttiva(fascia).getNetto();
    }

    public double getReattiva(FasciaOraria fascia) {
        return this.misura.getReattiva(fascia).getNetto();
    }

    public double getPotenza(FasciaOraria fascia) {
        return this.misura.getPotenza(fascia).getNetto();
    }

    @Override
    public double[] getAttiva() {
        return MisureHelper.getNetti(this.misura.getAttiva());
    }

    public double[] getReattiva() {
        return MisureHelper.getNetti(this.misura.getReattiva());
    }

    public double[] getPotenza() {
        return MisureHelper.getNetti(this.misura.getPotenza());
    }

    @Override
    public boolean isCalcolata() {
        return this.calcolata;
    }

    @Override
    public boolean isStimata() {
        return this.misura.isStimata();
    }

    @Override
    public String getXmlKey() {
        Date dataMisura = this.getDataMisura();
        DateFormat annoMeseFormat = StrategyCommonHelper.getAnnoMeseDateFormat();
        String annoMese = annoMeseFormat.format(dataMisura);
        return String.valueOf(this.codicePod) + "|" + annoMese;
    }

    public StatoMisure getStatoTariffeDisp() {
        return this.statoTariffeDisp;
    }

    public StatoMisure getStatoTariffeRese() {
        return this.statoTariffeRese;
    }

    public void setValues(Mno mno) {
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            double ka = mno.getKa().doubleValue();
            double attiva = mno.getAttiva(fascia);
            this.misura.setAttiva(fascia, attiva, ka);
            double reattiva = mno.getReattiva(fascia);
            this.misura.setReattiva(fascia, reattiva, ka);
            double potenza = mno.getPotenza(fascia);
            this.misura.setPotenza(fascia, potenza, ka);
            ++n3;
        }
    }
}

