/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.misure;

import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.services.StrategyHelper;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class MisurePeriodiche {
    private final Set<Mno> misurePno = new LinkedHashSet<Mno>();
    private final Set<Mno> misurePdo2gr = new LinkedHashSet<Mno>();

    public Collection<Mno> getMisurePno() {
        return this.misurePno;
    }

    public Collection<Mno> getMisurePdo2GR() {
        return this.misurePdo2gr;
    }

    public Mno addMisuraPno(Mno mno) {
        Mno obsoleto = null;
        if (!this.misurePno.add(mno)) {
            String codiceFlusso = mno.getCodiceFlusso();
            if (codiceFlusso.startsWith("RNO") || codiceFlusso.startsWith("DSR") || StrategyHelper.MOROSITA.contains(codiceFlusso.toUpperCase())) {
                obsoleto = MisurePeriodiche.find(this.misurePno, mno);
                String codiceFlussoObsoleto = obsoleto.getCodiceFlusso();
                if (codiceFlussoObsoleto.startsWith("RNO") && !codiceFlusso.startsWith("RNO")) {
                    obsoleto = mno;
                } else {
                    this.misurePno.remove(obsoleto);
                    this.misurePno.add(mno);
                }
            } else {
                obsoleto = mno;
            }
        }
        return obsoleto;
    }

    public boolean addMisuraPdo2GR(Mno mno) {
        boolean obsoleto = false;
        Date dataMisura = mno.getDataMisura();
        for (Mno pno : this.misurePno) {
            if (!pno.getDataMisura().equals(dataMisura)) continue;
            obsoleto = true;
            break;
        }
        if (!obsoleto) {
            this.misurePdo2gr.add(mno);
        }
        return obsoleto;
    }

    private static Mno find(Set<Mno> misure, Mno mno) {
        Mno found = null;
        Iterator<Mno> iterator = misure.iterator();
        while (found == null && iterator.hasNext()) {
            Mno current = iterator.next();
            if (!current.equals(mno)) continue;
            found = current;
        }
        return found;
    }
}

