/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.misure;

import biz.elabor.prebilling.dao.RestrictedResultSet;
import biz.elabor.prebilling.model.misure.InvalidFasciaValue;
import biz.elabor.prebilling.model.misure.MisuraCompleta;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilQuarto;
import biz.elabor.prebilling.model.misure.Trattamento;
import biz.elabor.prebilling.model.misure.ValueGetter;
import biz.elabor.prebilling.services.tariffe.TariffeHelper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.tools.MathUtils;

public class MisureHelper {
    private static final Date END_OF_TIME = CalendarTools.getEndOfTime();

    public static Map<String, Map<String, String>> createDatiPod(boolean dueG, boolean delibera65, boolean attivaOnly, RestrictedResultSet rs) throws SQLException {
        String curvaMisure;
        String[][] campiCurva;
        String[][] campiDatiPdp;
        if (dueG) {
            campiDatiPdp = new String[][]{{"PuntoDispacciamento", "punto_dispacciamento"}, {"Trattamento", "trattamento_pod"}, {"Tensione", "tensione"}, {"PotContrImp", "potenza_contr_impegnata"}, {"PotDisp", "potenza_disponibile"}, {"CifreAtt", "cifre_attiva"}, {"CifreRea", "cifre_reattiva"}, {"Forfait", "forfait"}, {"GruppoMis", "gruppo_misura"}, {"Ka", "ka"}, {"Kr", "kr"}, {"Kp", "kp"}};
            campiCurva = attivaOnly ? new String[][]{{"Raccolta", "raccolta"}, {"TipoDato", "tipo_dato"}, {"Validato", "validato"}, {"PotMax", "potenza_max"}, {"Motivazione", "motivazione"}, {"MotivazioneStima", "motivazione_stima"}, {"EaF1", "EA_F1"}, {"EaF2", "EA_F2"}, {"EaF3", "EA_F3"}, {"EaF4", "EA_F4"}, {"EaF5", "EA_F5"}, {"EaF6", "EA_F6"}} : new String[][]{{"Raccolta", "raccolta"}, {"TipoDato", "tipo_dato"}, {"Validato", "validato"}, {"PotMax", "potenza_max"}, {"Motivazione", "motivazione"}, {"MotivazioneStima", "motivazione_stima"}, {"EaF1", "EA_F1"}, {"EaF2", "EA_F2"}, {"EaF3", "EA_F3"}, {"EaF4", "EA_F4"}, {"EaF5", "EA_F5"}, {"EaF6", "EA_F6"}, {"ErF1", "ER_F1"}, {"ErF2", "ER_F2"}, {"ErF3", "ER_F3"}, {"ErF4", "ER_F4"}, {"ErF5", "ER_F5"}, {"ErF6", "ER_F6"}, {"PotF1", "POT_F1"}, {"PotF2", "POT_F2"}, {"PotF3", "POT_F3"}, {"PotF4", "POT_F4"}, {"PotF5", "POT_F5"}, {"PotF6", "POT_F6"}};
            curvaMisure = "Misura";
        } else if (delibera65) {
            campiDatiPdp = new String[][]{{"PuntoDispacciamento", "punto_dispacciamento"}, {"Trattamento", "trattamento_pod"}, {"Tensione", "tensione"}, {"PotContrImp", "potenza_contr_impegnata"}, {"PotDisp", "potenza_disponibile"}};
            campiCurva = new String[][]{{"Raccolta", "raccolta"}, {"TipoDato", "tipo_dato"}, {"Validato", "validato"}, {"PotMax", "potenza_max"}};
            curvaMisure = "Curva";
        } else {
            campiDatiPdp = new String[][]{{"PuntoDispacciamento", "punto_dispacciamento"}, {"Trattamento", "trattamento_pod"}, {"Tensione", "tensione"}};
            campiCurva = new String[][]{{"Raccolta", "raccolta"}, {"TipoDato", "tipo_dato"}, {"Validato", "validato"}, {"PotMax", "potenza_max"}};
            curvaMisure = "Curva";
        }
        LinkedHashMap<String, Map<String, String>> datiPod = new LinkedHashMap<String, Map<String, String>>();
        Map<String, String> datiPdp = MisureHelper.createMap(rs, campiDatiPdp);
        Map<String, String> curva = MisureHelper.createMap(rs, campiCurva);
        datiPod.put("DatiPdp", datiPdp);
        datiPod.put(curvaMisure, curva);
        return datiPod;
    }

    public static void setTrattamento(Trattamento trattamento, Map<String, Map<String, String>> datiPod) {
        Map<String, String> datiPdp = datiPod.get("DatiPdp");
        datiPdp.put("Trattamento", trattamento.name());
    }

    public static Trattamento getTrattamento(Map<String, Map<String, String>> datiPod) {
        Map<String, String> datiPdp = datiPod.get("DatiPdp");
        String trattamento = datiPdp.get("Trattamento");
        return Trattamento.valueOf(trattamento.trim().toUpperCase());
    }

    private static Map<String, String> createMap(RestrictedResultSet rs, String[][] campi) throws SQLException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String[][] stringArray = campi;
        int n2 = campi.length;
        int n3 = 0;
        while (n3 < n2) {
            String[] campo = stringArray[n3];
            String valoreTxt = rs.getString(campo[1]);
            if (valoreTxt != null) {
                map.put(campo[0], valoreTxt);
            }
            ++n3;
        }
        return map;
    }

    public static Map<String, Map<String, String>> createDatiPod(ResultSet rs, boolean dueG, Trattamento trattamento, Set<String> cifre, String[] campiDatiPdp, String[] campiSqlDatiPdp) throws SQLException {
        String[] campiSqlMisuraFFacoltativi;
        String[] campiSqlMisuraF;
        String[] campiMisuraFFacoltativi;
        String[] campiMisuraF;
        if (dueG) {
            campiMisuraF = new String[]{"Raccolta", "TipoDato", "Validato", "MotivazioneStima", "PotMax", "EaF1", "EaF2", "EaF3", "EaF4", "EaF5", "EaF6", "ErF1", "ErF2", "ErF3", "ErF4", "ErF5", "ErF6", "PotF1", "PotF2", "PotF3", "PotF4", "PotF5", "PotF6"};
            campiMisuraFFacoltativi = new String[]{"ErcF1", "ErcF2", "ErcF3", "ErcF4", "ErcF5", "ErcF6", "EriF1", "EriF2", "EriF3", "EriF4", "EriF5", "EriF6"};
            campiSqlMisuraF = new String[]{"RACCOLTA", "TIPO_DATO", "VALIDATO", "MOTIVAZIONE_STIMA", "POTENZA_MAX", "EA_F1", "EA_F2", "EA_F3", "EA_F4", "EA_F5", "EA_F6", "ER_F1", "ER_F2", "ER_F3", "ER_F4", "ER_F5", "ER_F6", "POT_F1", "POT_F2", "POT_F3", "POT_F4", "POT_F5", "POT_F6"};
            campiSqlMisuraFFacoltativi = new String[]{"ERC_F1", "ERC_F2", "ERC_F3", "ERC_F4", "ERC_F5", "ERC_F6", "ERI_F1", "ERI_F2", "ERI_F3", "ERI_F4", "ERI_F5", "ERI_F6"};
        } else {
            campiMisuraF = new String[]{"Raccolta", "TipoDato", "Validato", "EaF1", "EaF2", "EaF3", "EaF4", "EaF5", "EaF6", "ErF1", "ErF2", "ErF3", "ErF4", "ErF5", "ErF6", "PotF1", "PotF2", "PotF3", "PotF4", "PotF5", "PotF6"};
            campiMisuraFFacoltativi = new String[]{"ErcF1", "ErcF2", "ErcF3", "ErcF4", "ErcF5", "ErcF6", "EriF1", "EriF2", "EriF3", "EriF4", "EriF5", "EriF6"};
            campiSqlMisuraF = new String[]{"RACCOLTA", "TIPO_DATO", "VALIDATO", "EA_F1", "EA_F2", "EA_F3", "EA_F4", "EA_F5", "EA_F6", "ER_F1", "ER_F2", "ER_F3", "ER_F4", "ER_F5", "ER_F6", "POT_F1", "POT_F2", "POT_F3", "POT_F4", "POT_F5", "POT_F6"};
            campiSqlMisuraFFacoltativi = new String[]{"ERC_F1", "ERC_F2", "ERC_F3", "ERC_F4", "ERC_F5", "ERC_F6", "ERI_F1", "ERI_F2", "ERI_F3", "ERI_F4", "ERI_F5", "ERI_F6"};
        }
        String[] campiMisuraM = new String[]{"Raccolta", "TipoDato", "Validato", "EaM", "ErM", "PotM"};
        String[] campiMisuraMFacoltativi = new String[]{"ErcM", "EriM"};
        String[] campiSqlMisuraM = new String[]{"RACCOLTA", "TIPO_DATO", "VALIDATO", dueG ? "EA_F3" : "EA_F1", dueG ? "ER_F3" : "ER_F1", dueG ? "POT_F3" : "POT_F1"};
        String[] campiSqlMisuraMFacoltativi = new String[]{dueG ? "ERC_F3" : "ERC_F1", dueG ? "ERI_F3" : "ERI_F1"};
        LinkedHashMap<String, Map<String, String>> datiPod = new LinkedHashMap<String, Map<String, String>>();
        Map<String, String> datiPdp = MisureHelper.createMap(rs, campiDatiPdp, campiSqlDatiPdp, cifre);
        Map<String, String> misura = MisureHelper.createMisura(rs, campiMisuraF, campiSqlMisuraF, campiMisuraM, campiSqlMisuraM, trattamento, cifre);
        misura = MisureHelper.createMisuraFacoltativi(rs, misura, campiMisuraFFacoltativi, campiSqlMisuraFFacoltativi, campiMisuraMFacoltativi, campiSqlMisuraMFacoltativi, trattamento, cifre);
        datiPod.put("DatiPdp", datiPdp);
        datiPod.put("Misura", misura);
        return datiPod;
    }

    private static Map<String, String> createMisura(ResultSet rs, String[] campiMisuraF, String[] campiSqlMisuraF, String[] campiMisuraM, String[] campiSqlMisuraM, Trattamento trattamento, Set<String> cifre) throws SQLException {
        Map<Object, Object> misura = new LinkedHashMap();
        misura = trattamento.isMono() ? MisureHelper.createMap(rs, campiMisuraM, campiSqlMisuraM, cifre) : MisureHelper.createMap(rs, campiMisuraF, campiSqlMisuraF, cifre);
        return misura;
    }

    private static Map<String, String> createMisuraFacoltativi(ResultSet rs, Map<String, String> misura, String[] campiMisuraFFacoltativi, String[] campiSqlMisuraFFacoltativi, String[] campiMisuraMFacoltativi, String[] campiSqlMisuraMFacoltativi, Trattamento trattamento, Set<String> cifre) {
        if (trattamento.isMono()) {
            MisureHelper.createMapFacoltativi(rs, misura, campiMisuraMFacoltativi, campiSqlMisuraMFacoltativi, cifre);
        } else {
            MisureHelper.createMapFacoltativi(rs, misura, campiMisuraFFacoltativi, campiSqlMisuraFFacoltativi, cifre);
        }
        return misura;
    }

    private static Map<String, String> createMapFacoltativi(ResultSet rs, Map<String, String> map, String[] campi, String[] campiSql, Set<String> cifre) {
        int index = 0;
        String[] stringArray = campi;
        int n2 = campi.length;
        int n3 = 0;
        while (n3 < n2) {
            String campo = stringArray[n3];
            String nomeCampoSql = campiSql[index];
            try {
                String valoreTxt = rs.getString(nomeCampoSql);
                if (valoreTxt == null) {
                    if (cifre.contains(campo)) {
                        map.put(campo, "");
                    }
                } else {
                    map.put(campo, valoreTxt);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ++index;
            ++n3;
        }
        return map;
    }

    private static Map<String, String> createMap(ResultSet rs, String[] campi, String[] campiSql, Set<String> cifre) throws SQLException {
        int index = 0;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String[] stringArray = campi;
        int n2 = campi.length;
        int n3 = 0;
        while (n3 < n2) {
            String campo = stringArray[n3];
            String nomeCampoSql = campiSql[index];
            String valoreTxt = rs.getString(nomeCampoSql);
            if (valoreTxt == null) {
                if (cifre.contains(campo)) {
                    map.put(campo, "");
                }
            } else {
                map.put(campo, valoreTxt);
            }
            ++index;
            ++n3;
        }
        return map;
    }

    public static void checkFasce(Mno mno, DecimalFormat format) throws InvalidFasciaValue {
        String codicePod = mno.getCodicePod();
        MisureHelper.checkDouble(codicePod, mno.getEAF4(), format);
        MisureHelper.checkDouble(codicePod, mno.getEAF5(), format);
        MisureHelper.checkDouble(codicePod, mno.getEAF6(), format);
        MisureHelper.checkDouble(codicePod, mno.getERF4(), format);
        MisureHelper.checkDouble(codicePod, mno.getERF5(), format);
        MisureHelper.checkDouble(codicePod, mno.getERF6(), format);
        MisureHelper.checkDouble(codicePod, mno.getPotF4Orig(), format);
        MisureHelper.checkDouble(codicePod, mno.getPotF5Orig(), format);
        MisureHelper.checkDouble(codicePod, mno.getPotF6Orig(), format);
    }

    public static void checkFasce(Pdo pdo, DecimalFormat format) throws InvalidFasciaValue {
        String codicePod = pdo.getCodicePod();
        MisureHelper.checkDouble(codicePod, pdo.getEAF4(), format);
        MisureHelper.checkDouble(codicePod, pdo.getEAF5(), format);
        MisureHelper.checkDouble(codicePod, pdo.getEAF6(), format);
        MisureHelper.checkDouble(codicePod, pdo.getERF4(), format);
        MisureHelper.checkDouble(codicePod, pdo.getERF5(), format);
        MisureHelper.checkDouble(codicePod, pdo.getERF6(), format);
        MisureHelper.checkDouble(codicePod, pdo.getPotF4String(), format);
        MisureHelper.checkDouble(codicePod, pdo.getPotF5String(), format);
        MisureHelper.checkDouble(codicePod, pdo.getPotF6String(), format);
    }

    private static void checkDouble(String key, String stringValue, DecimalFormat format) throws InvalidFasciaValue {
        double value;
        try {
            value = stringValue == null || stringValue.trim().isEmpty() ? 0.0 : format.parse(stringValue).doubleValue();
        }
        catch (ParseException exc) {
            value = -1.0;
        }
        if (value != 0.0) {
            throw new InvalidFasciaValue(key);
        }
    }

    public static double getAttiva(RilQuarto rQuarto) {
        Double attiva = rQuarto.getAttiva();
        return attiva == null ? 0.0 : attiva;
    }

    public static double[] getNetti(MisuraCompleta[] misure) {
        return MisureHelper.getValues(misure, misura -> misura.getNetto());
    }

    public static double[] getLordi(MisuraCompleta[] misure) {
        return MisureHelper.getValues(misure, misura -> misura.getLordo());
    }

    private static double[] getValues(MisuraCompleta[] misure, ValueGetter getter) {
        double[] values = new double[misure.length];
        int index = 0;
        while (index < misure.length) {
            values[index] = MathUtils.round(getter.getValue(misure[index]), 3);
            ++index;
        }
        return values;
    }

    public static List<Mno> merge(Collection<Mno> misureOrarie, Collection<Mno> misureNonorarie) {
        ArrayList<Mno> misure = new ArrayList<Mno>();
        Iterator<Mno> moIterator = TariffeHelper.buildMnoIterator(misureOrarie);
        Iterator<Mno> mnoIterator = TariffeHelper.buildMnoIterator(misureNonorarie);
        Mno mo = moIterator.next();
        Mno mno = mnoIterator.next();
        while (true) {
            Date dataMo = mo.getDataMisura();
            Date dataMno = mno.getDataMisura();
            if (dataMo.equals(END_OF_TIME) && dataMno.equals(END_OF_TIME)) break;
            if (dataMo.before(dataMno)) {
                misure.add(mo);
                mo = moIterator.next();
                continue;
            }
            misure.add(mno);
            mno = mnoIterator.next();
        }
        return misure;
    }
}

