/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.misure;

import biz.elabor.misure.model.WorkingPeriod;
import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.model.MisuraD65Visitor;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.Trattamento;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.text.Format;

public class MisuraPdo
implements MisuraPod {
    private Pod pod;
    private Pdo pdo;
    private Misura misAnte;
    private Misura misura;
    private String matricola;
    private boolean segnali;
    private String ka;
    private String kr;
    private String kp;
    private final DecimalFormat doubleFormat;
    private final boolean smis;

    public MisuraPdo(Pod pod, Pdo pdo, Misura misura) {
        this(pod, pdo, misura, false);
    }

    public MisuraPdo(Pod pod, Pdo pdo, Misura misura, boolean smis) {
        this.misura = misura;
        this.pod = pod;
        this.pdo = pdo;
        this.matricola = null;
        this.segnali = false;
        this.ka = "1";
        this.kr = "1";
        this.kp = "1";
        this.doubleFormat = Format.newDecimalFormat(Locale.ITALIAN, "0.000");
        this.smis = smis;
    }

    public void setKa(String ka) {
        this.ka = ka;
    }

    public void setKr(String kr) {
        this.kr = kr;
    }

    public void setKp(String kp) {
        this.kp = kp;
    }

    @Override
    public String getKey() {
        return this.pod.getCodice();
    }

    @Override
    public Pod getPod() {
        return this.pod;
    }

    @Override
    public String getCodicePod() {
        return this.pod.getCodice();
    }

    @Override
    public String getMatricolaAtt() {
        return this.matricola == null ? this.pdo.getRilMese().getMatricola() : this.matricola;
    }

    @Override
    public String getMatricolaRea() {
        return this.matricola == null ? this.pdo.getRilMese().getMatricola() : this.matricola;
    }

    @Override
    public String getMatricolaPot() {
        return this.matricola == null ? this.pdo.getRilMese().getMatricola() : this.matricola;
    }

    @Override
    public String getCifreAtt() {
        return this.pdo.getCifreAtt();
    }

    @Override
    public String getCifreRea() {
        return this.pdo.getCifreRea();
    }

    @Override
    public String getCifrePot() {
        return this.pdo.getCifrePot();
    }

    @Override
    public Date getDataMisura() {
        return this.misura.getDate();
    }

    @Override
    public Number getPotContrImp() {
        String dato = this.getDato("DatiPdp", "PotContrImp");
        return this.getNumber(dato);
    }

    private Number getNumber(String dato) {
        try {
            return dato == null ? (Number)0.0 : (Number)this.doubleFormat.parse(dato);
        }
        catch (ParseException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public Number getPotDisp() {
        String dato = this.getDato("DatiPdp", "PotDisp");
        return this.getNumber(dato);
    }

    @Override
    public String getTensione() {
        return this.getDato("DatiPdp", "Tensione");
    }

    @Override
    public Trattamento getTrattamento() {
        return this.pdo.getTrattamento();
    }

    @Override
    public Trattamento getTrattamento(Trattamento defaultValue) {
        return this.pdo.getTrattamento();
    }

    @Override
    public String getEAM() {
        return null;
    }

    @Override
    public double getEAMDouble() {
        throw new RuntimeException("not allowed");
    }

    @Override
    public String getEAF1() {
        return this.doubleFormat.format(this.getEAF1Double());
    }

    @Override
    public double getEAF1Double() {
        return this.misura.getAttiva(FasciaOraria.F1).getNetto();
    }

    @Override
    public String getEAF2() {
        return this.doubleFormat.format(this.getEAF2Double());
    }

    @Override
    public double getEAF2Double() {
        return this.misura.getAttiva(FasciaOraria.F2).getNetto();
    }

    @Override
    public String getEAF3() {
        return this.doubleFormat.format(this.getEAF3Double());
    }

    @Override
    public double getEAF3Double() {
        return this.misura.getAttiva(FasciaOraria.F3).getNetto();
    }

    @Override
    public String getERM() {
        return null;
    }

    @Override
    public double getERMDouble() {
        throw new RuntimeException("not allowed");
    }

    @Override
    public String getERF1() {
        return this.doubleFormat.format(this.getERF1Double());
    }

    @Override
    public double getERF1Double() {
        return this.misura.getReattiva(FasciaOraria.F1).getNetto();
    }

    @Override
    public String getERF2() {
        return this.doubleFormat.format(this.getERF2Double());
    }

    @Override
    public double getERF2Double() {
        return this.misura.getReattiva(FasciaOraria.F2).getNetto();
    }

    @Override
    public String getERF3() {
        return this.doubleFormat.format(this.getERF3Double());
    }

    @Override
    public double getERF3Double() {
        return this.misura.getReattiva(FasciaOraria.F3).getNetto();
    }

    @Override
    public String getPotMOrig() {
        return null;
    }

    @Override
    public double getPotMValue() {
        return 0.0;
    }

    @Override
    public String getPotF1Orig() {
        return this.doubleFormat.format(this.getPotF1Value());
    }

    @Override
    public double getPotF1Value() {
        return this.misura.getPotenza(FasciaOraria.F1).getNetto();
    }

    @Override
    public String getPotF2Orig() {
        return this.doubleFormat.format(this.getPotF2Value());
    }

    @Override
    public double getPotF2Value() {
        return this.misura.getPotenza(FasciaOraria.F2).getNetto();
    }

    @Override
    public String getPotF3Orig() {
        return this.doubleFormat.format(this.getPotF3Value());
    }

    @Override
    public double getPotF3Value() {
        return this.misura.getPotenza(FasciaOraria.F3).getNetto();
    }

    @Override
    public String getKaSegnale() {
        return this.segnali ? this.ka : null;
    }

    @Override
    public String getKrSegnale() {
        return this.segnali ? this.kr : null;
    }

    @Override
    public String getKpSegnale() {
        return this.segnali ? this.kp : null;
    }

    @Override
    public String getKaString() {
        return this.ka;
    }

    @Override
    public String getKrString() {
        return this.kr;
    }

    @Override
    public String getKpString() {
        return this.kp;
    }

    @Override
    public String getTipoDato() {
        return this.getDato(this.getCodiceFlusso().endsWith("2G") ? "Misura" : "Curva", "TipoDato");
    }

    private String getDato(String name1, String name2) {
        Map<String, Map<String, String>> datiPod = this.pdo.getDatiPod();
        Map<String, String> dati = datiPod.get(name1);
        return dati.get(name2);
    }

    public double getAttiva(FasciaOraria fascia) {
        return this.misura.getAttiva(fascia).getNetto();
    }

    public double getReattiva(FasciaOraria fascia) {
        return this.misura.getReattiva(fascia).getNetto();
    }

    public double getPotenza(FasciaOraria fascia) {
        return this.misura.getPotenza(fascia).getNetto();
    }

    public double getCommerciale(FasciaOraria fascia) {
        return this.misura.getCommerciale(fascia).getNetto();
    }

    @Override
    public Date getDate() {
        return this.misura.getDate();
    }

    public void setAttiva(FasciaOraria fascia, double value) {
        this.misura.setAttiva(fascia, value, 0.0);
    }

    public void setReattiva(FasciaOraria fascia, double value) {
        this.misura.setReattiva(fascia, value, 0.0);
    }

    public void setPotenza(FasciaOraria fascia, double value) {
        this.misura.setPotenza(fascia, value, 0.0);
    }

    @Override
    public Misura getMisura() {
        return this.misura;
    }

    @Override
    public boolean hasAttiva() {
        Date date = this.misura.getDate();
        return this.segnali ? true : this.pod.isMisuraAttiva(date);
    }

    @Override
    public boolean hasReattiva() {
        Date date = this.misura.getDate();
        return this.segnali ? true : this.pod.isMisuraReattiva(date);
    }

    @Override
    public boolean hasPotenza() {
        Date date = this.misura.getDate();
        return this.segnali ? true : this.pod.isMisuraPotenza(date);
    }

    @Override
    public Date getDataVoltura() {
        return null;
    }

    @Override
    public String getPivaDistributore() {
        return this.pdo.getPivaDistributore();
    }

    @Override
    public Set<String> getId() {
        return this.misura.getId();
    }

    @Override
    public String getPivaUtente() {
        return this.pdo.getPivaUtente();
    }

    @Override
    public Map<String, Map<String, String>> getDatiPod() {
        return this.pdo.getDatiPod();
    }

    @Override
    public String getCodPratAtt() {
        return this.pdo.getCodPratAtt();
    }

    public Pdo getPdo() {
        return this.pdo;
    }

    @Override
    public Date getSwitchout() {
        return this.pod.getSwitchout();
    }

    @Override
    public Number getKa() {
        return Double.valueOf(this.ka);
    }

    @Override
    public Number getKr() {
        return Double.valueOf(this.kr);
    }

    @Override
    public Number getKp() {
        return Double.valueOf(this.kp);
    }

    @Override
    public Date getDataMovimento() {
        return this.getDataMisura();
    }

    @Override
    public String getCdaziend() {
        return this.pod.getAzienda();
    }

    @Override
    public String getCodContrDisp() {
        return this.pdo.getCodContrDisp();
    }

    @Override
    public void accept(MisuraD65Visitor visitor) {
    }

    @Override
    public String getCodiceFlusso() {
        return this.misura.getCodiceFlusso();
    }

    @Override
    public String getNomeFile() {
        return this.pdo.getNomeFile();
    }

    @Override
    public void setCdaziend(String cdaziend) {
        this.pdo.setCdaziend(cdaziend);
    }

    @Override
    public String getCountLabel() {
        return "prest_" + this.getCodiceFlusso();
    }

    public void setMatricola(String matricola) {
        this.matricola = matricola;
    }

    public void setSegnali(boolean segnali) {
        this.segnali = segnali;
    }

    @Override
    public String getTipoMisuratore() {
        return null;
    }

    @Override
    public String getFlussoFunzionale() {
        return null;
    }

    @Override
    public Number getPotMax() {
        return this.pdo.getPotMax();
    }

    @Override
    public String getRegime() {
        return this.pdo.getRegime();
    }

    public Misura getMisAnte() {
        return this.misAnte;
    }

    public void setMisAnte(Misura misAnte) {
        this.misAnte = misAnte;
    }

    @Override
    public String getFirstId() {
        return this.pdo.getFirstId();
    }

    @Override
    public boolean useConsumi() {
        return true;
    }

    @Override
    public double[] getLastAttiva() {
        return this.pod.getLastAttiva();
    }

    @Override
    public double[] getLastReattiva() {
        return this.pod.getLastReattiva();
    }

    public void setDataMisura(Date data) {
        this.misura.setDate(data);
    }

    @Override
    public boolean isForfait() {
        return false;
    }

    @Override
    public WorkingPeriod getPeriod() {
        return this.pdo.getPeriod();
    }

    public boolean isZero() {
        return this.misura.isZero();
    }

    public String getFirstCodiceFlusso() {
        return this.pdo.getFirstCodiceFlusso();
    }

    @Override
    public String getRaccolta() {
        return this.pdo.getRaccolta();
    }

    @Override
    public boolean isCalcolata() {
        return false;
    }

    @Override
    public boolean isPdo2GR() {
        return false;
    }

    @Override
    public boolean isSmis() {
        return this.smis;
    }

    @Override
    public Date getDataPrestazione() {
        return null;
    }
}

