/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.misure;

import biz.elabor.misure.model.fasce.CalendarioFasceGiornaliero;
import biz.elabor.misure.model.fasce.CalendarioFasceMensile;
import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.misure.MisuraCompleta;
import biz.elabor.prebilling.model.misure.MisuraFasce;
import biz.elabor.prebilling.model.misure.MisureFasce;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilQuarto;
import biz.elabor.prebilling.services.letture.ConsumiHelper;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.tools.MathUtils;

public class Misura
implements MisuraFasce,
MisureFasce {
    private Date date;
    private final boolean commerciale;
    private final String codiceOfferta;
    private MisuraCompleta[] attiva;
    private MisuraCompleta[] reattiva;
    private MisuraCompleta[] reattivaCapacitiva;
    private MisuraCompleta[] reattivaInduttiva;
    private MisuraCompleta[] potenza;
    private MisuraCompleta[] attivaComm;
    private boolean stimata;
    private int fasce;
    private String codiceFlusso;
    private Set<String> id;
    private double kA;

    public Misura(Date date, boolean stimata, int fasce, String codiceFlusso) {
        this(date, stimata, fasce, codiceFlusso, "", false, null);
    }

    public Misura(Date date, boolean stimata, int fasce, String codiceFlusso, String newId, boolean commerciale, String codiceOfferta) {
        this(date, stimata, fasce, codiceFlusso, new LinkedHashSet<String>(), commerciale, codiceOfferta);
        this.addId(newId);
    }

    public Misura(Date date, boolean stimata, int fasce, String codiceFlusso, Set<String> id, boolean commerciale, String codiceOfferta) {
        this.date = date;
        this.stimata = stimata;
        this.fasce = fasce;
        this.commerciale = commerciale;
        this.codiceOfferta = codiceOfferta;
        this.kA = 0.0;
        this.attiva = Misura.newMisureComplete();
        this.reattiva = Misura.newMisureComplete();
        this.reattivaCapacitiva = Misura.newMisureComplete();
        this.reattivaInduttiva = Misura.newMisureComplete();
        this.potenza = Misura.newMisureComplete();
        this.attivaComm = Misura.newMisureComplete();
        this.codiceFlusso = codiceFlusso;
        this.id = id;
    }

    private static MisuraCompleta[] newMisureComplete() {
        MisuraCompleta[] misuraCompletas = new MisuraCompleta[FasciaOraria.values().length];
        int index = 0;
        while (index < misuraCompletas.length) {
            misuraCompletas[index] = new MisuraCompleta(0.0, 0.0);
            ++index;
        }
        return misuraCompletas;
    }

    public void addId(String newId) {
        if (newId != null && !newId.isEmpty()) {
            this.id.add(newId);
        }
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public double getValue(FasciaOraria fascia) {
        return this.getAttiva(fascia).getNetto();
    }

    @Override
    public MisuraCompleta getAttiva(FasciaOraria fascia) {
        return this.attiva[fascia.ordinal()];
    }

    public MisuraCompleta[] getAttiva() {
        return this.attiva;
    }

    @Override
    public MisuraCompleta getReattiva(FasciaOraria fascia) {
        return this.reattiva[fascia.ordinal()];
    }

    public MisuraCompleta[] getReattiva() {
        return this.reattiva;
    }

    @Override
    public MisuraCompleta getPotenza(FasciaOraria fascia) {
        return this.potenza[fascia.ordinal()];
    }

    public MisuraCompleta[] getPotenza() {
        return this.potenza;
    }

    public MisuraCompleta[] getCommerciale() {
        return this.attivaComm;
    }

    public MisuraCompleta getCommerciale(FasciaOraria fascia) {
        return this.attivaComm[fascia.ordinal()];
    }

    public boolean hasCommerciale() {
        return this.commerciale;
    }

    public String getCodiceOfferta() {
        return this.codiceOfferta;
    }

    public int add(RilGiorno rilGiorno, int startIndex, String expectedFlusso, CalendarioFasceMensile calArera, CalendarioFasceMensile calComm) {
        Date currDate = rilGiorno.getDate();
        ElaborCalendar calendar = new ElaborCalendar(currDate);
        int giorno = calendar.getGiorno();
        CalendarioFasceGiornaliero cfgArera = calArera.getFasciaGiornaliera(giorno);
        CalendarioFasceGiornaliero cfgComm = calComm == null ? null : calComm.getFasciaGiornaliera(giorno);
        int index = 0;
        boolean interrupted = false;
        for (RilQuarto rilQuarto : rilGiorno) {
            index = rilQuarto.getIndex();
            if (index < startIndex) continue;
            String codiceFlussoRil = rilQuarto.getCodiceFlusso();
            if (!Misura.matchFlusso(expectedFlusso, codiceFlussoRil)) {
                interrupted = true;
                break;
            }
            calendar.setIndex(index);
            int ora = calendar.getOra();
            FasciaOraria fascia = cfgArera.getFascia(ora);
            this.addAttiva(fascia, rilQuarto);
            this.addReattiva(fascia, rilQuarto);
            this.addPotenza(fascia, rilQuarto);
            String newId = rilQuarto.getId();
            this.addId(newId);
            if (cfgComm == null) continue;
            FasciaOraria fasciaComm = cfgComm.getFascia(ora);
            this.addCommerciale(fasciaComm, rilQuarto);
        }
        return interrupted ? index : 100;
    }

    private static boolean matchFlusso(String expected, String current) {
        String fixExpected = expected.equalsIgnoreCase("rfo2g") ? "PDO2G" : expected;
        String fixCurrent = current.equalsIgnoreCase("rfo2g") ? "PDO2G" : current;
        return fixExpected.equalsIgnoreCase(fixCurrent);
    }

    private void addConsumo(MisuraCompleta misura, Double value, double ka) {
        if (value != null) {
            double netto = value;
            double kMisura = ka == 0.0 ? 1.0 : ka;
            double lordo = netto * kMisura;
            misura.add(netto, lordo);
            this.kA = ConsumiHelper.updateK(this.kA, kMisura);
        }
    }

    private void addCommerciale(FasciaOraria fascia, RilQuarto value) {
        this.addConsumo(this.attivaComm[fascia.ordinal()], value.getAttiva(), value.getKa());
    }

    private void addAttiva(FasciaOraria fascia, RilQuarto value) {
        this.addConsumo(this.attiva[fascia.ordinal()], value.getAttiva(), value.getKa());
    }

    private void addReattiva(FasciaOraria fascia, RilQuarto value) {
        this.addConsumo(this.reattiva[fascia.ordinal()], value.getReattiva(), value.getKa());
    }

    private void addPotenza(FasciaOraria fascia, RilQuarto value) {
        double netto = value.getPotenza();
        double ka = value.getKa();
        double lordo = netto * (ka == 0.0 ? 1.0 : ka);
        this.potenza[fascia.ordinal()].setMax(netto, lordo);
    }

    public void setAttiva(FasciaOraria fascia, double netto, double ka) {
        double kFascia = ka == 0.0 ? 1.0 : ka;
        this.kA = ConsumiHelper.updateK(this.kA, kFascia);
        this.attiva[fascia.ordinal()].set(netto, netto * kFascia);
    }

    public void setReattiva(FasciaOraria fascia, double netto, double ka) {
        this.reattiva[fascia.ordinal()].set(netto, netto * (ka == 0.0 ? 1.0 : ka));
    }

    public void setReattivaCapacitiva(FasciaOraria fascia, double netto, double ka) {
        this.reattivaCapacitiva[fascia.ordinal()].set(netto, netto * (ka == 0.0 ? 1.0 : ka));
    }

    public void setReattivaInduttiva(FasciaOraria fascia, double netto, double ka) {
        this.reattivaInduttiva[fascia.ordinal()].set(netto, netto * (ka == 0.0 ? 1.0 : ka));
    }

    public void setPotenza(FasciaOraria fascia, double netto, double ka) {
        this.potenza[fascia.ordinal()].set(netto, netto * (ka == 0.0 ? 1.0 : ka));
    }

    public boolean isStimata() {
        return this.stimata;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int getFasce() {
        return this.fasce;
    }

    @Deprecated
    public void align(PrebillingConfiguration configuration) {
        this.align(configuration, 0.0, 0.0, 0.0);
    }

    public void align(PrebillingConfiguration configuration, double ka, double kr, double kp) {
        boolean trunking = configuration.isTrunking();
        int nCifreAttiva = configuration.getNCifreAttiva(ka);
        double sumAttiva = Misura.truncate(this.attiva, trunking, nCifreAttiva);
        if (this.commerciale) {
            double sumCommer = Misura.truncate(this.attivaComm, trunking, nCifreAttiva);
            double diff = sumCommer - sumAttiva;
            int index = FasciaOraria.values().length - 2;
            while (diff != 0.0 && index >= 0) {
                if (this.attivaComm[index].getNetto() - diff >= 0.0) {
                    this.attivaComm[index].add(-diff, 0.0);
                    diff = 0.0;
                } else {
                    diff -= this.attivaComm[index].getNetto();
                    this.attivaComm[index].setNetto(0.0);
                }
                --index;
            }
        }
        int nCifreReattiva = configuration.getNCifreReattiva(kr);
        Misura.truncate(this.reattiva, trunking, nCifreReattiva);
        int nCifrePotenza = configuration.getNCifrePotenza(kp);
        Misura.truncate(this.potenza, trunking, nCifrePotenza);
    }

    private static double truncate(MisuraCompleta[] values, boolean trunking, int nCifre) {
        double sum = 0.0;
        int index = 0;
        while (index < FasciaOraria.values().length) {
            if (trunking) {
                values[index].setNetto(MathUtils.floor(values[index].getNetto(), nCifre));
            }
            sum += values[index].getNetto();
            ++index;
        }
        return sum;
    }

    public boolean isZero() {
        boolean zero = true;
        Iterator<FasciaOraria> iterator = Arrays.asList(FasciaOraria.values()).iterator();
        while (zero && iterator.hasNext()) {
            FasciaOraria fascia = iterator.next();
            boolean bl = zero = this.getAttiva(fascia).getNetto() == 0.0 && this.getReattiva(fascia).getNetto() == 0.0 && this.getPotenza(fascia).getNetto() == 0.0;
        }
        return zero;
    }

    public String getCodiceFlusso() {
        return this.codiceFlusso;
    }

    public void setCodiceFlusso(String codiceFlusso) {
        this.codiceFlusso = codiceFlusso;
    }

    public Set<String> getId() {
        return this.id;
    }

    public double getKa() {
        return this.kA;
    }
}

