/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.misure;

import biz.elabor.misure.model.WorkingPeriod;
import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.model.misure.DatiFunzionali;
import biz.elabor.prebilling.model.misure.DefaultDatiFlusso;
import biz.elabor.prebilling.model.misure.MisureHelper;
import biz.elabor.prebilling.model.misure.Trattamento;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Map;
import org.homelinux.elabor.structures.KeyRecord;

public class DefaultDatiFunzionali
extends DefaultDatiFlusso
implements KeyRecord<String>,
DatiFunzionali {
    private final String codicePod;
    private final String codPratAtt;
    private final Date dataInizio;
    private final Map<String, Map<String, String>> datiPod;
    private final DecimalFormat doubleFormat;
    private final DateFormat dateFormat;
    private final String codiceFlusso;

    public DefaultDatiFunzionali(String id, String flusso, String codPratAtt, String codicePod, String pIvaUtente, String pIvaDistributore, String codContrDisp, String cdaziend, String nomeFile, Date dataInizio, Map<String, Map<String, String>> datiPod, String delibera, String regime) {
        super(pIvaUtente, pIvaDistributore, codContrDisp, cdaziend, nomeFile, id, delibera, regime);
        this.codPratAtt = codPratAtt;
        this.codicePod = codicePod;
        this.dataInizio = dataInizio;
        this.datiPod = datiPod;
        this.doubleFormat = BasicRecordCreatorHelper.getDoubleFormat();
        this.dateFormat = BasicRecordCreatorHelper.getDateFormat();
        this.codiceFlusso = flusso == null ? "" : flusso;
    }

    public String getCodiceFlusso() {
        return this.codiceFlusso;
    }

    @Override
    public String getCodPratAtt() {
        return this.codPratAtt;
    }

    @Override
    public Map<String, Map<String, String>> getDatiPod() {
        return this.datiPod;
    }

    @Override
    public Map<String, String> getDatiPdp() {
        return this.datiPod.get("DatiPdp");
    }

    @Override
    public Trattamento getTrattamento() {
        return MisureHelper.getTrattamento(this.datiPod);
    }

    public void setTrattamento(Trattamento trattamento) {
        MisureHelper.setTrattamento(trattamento, this.datiPod);
    }

    @Override
    public String getCodicePod() {
        return this.codicePod;
    }

    @Override
    public String getKey() {
        return this.codicePod;
    }

    public String getStringDatiPdP(String name) {
        Map<String, String> datiPdp = this.datiPod.get("DatiPdp");
        String stringaDatiPdp = datiPdp.get(name);
        return stringaDatiPdp == null ? null : stringaDatiPdp.trim();
    }

    @Override
    public Number getNumberDatiPdP(String name) {
        Number value;
        try {
            String stringaDatiPdp = this.getStringDatiPdP(name);
            value = stringaDatiPdp == null ? (Number)null : (Number)this.doubleFormat.parse(stringaDatiPdp);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return value;
    }

    public Date getDateDatiPdP(String name) {
        Date value;
        try {
            String stringaDatiPdp = this.getStringDatiPdP(name);
            value = stringaDatiPdp == null || stringaDatiPdp.isEmpty() ? null : this.dateFormat.parse(stringaDatiPdp);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return value;
    }

    @Override
    public String getTensione() {
        return this.getStringDatiPdP("Tensione");
    }

    @Override
    public Number getPotDisp() {
        return this.getNumberDatiPdP("PotDisp");
    }

    @Override
    public Number getPotImp() {
        return this.getNumberDatiPdP("PotContrImp");
    }

    @Override
    public String getCodiceTariffa() {
        return this.getStringDatiPdP("CodiceTariffa");
    }

    @Override
    public String getServizioTutela() {
        return this.getStringDatiPdP("ServizioTutela");
    }

    @Override
    public Date getDataInizio() {
        return this.dataInizio;
    }

    @Override
    public String getPuntoDispacciamento() {
        return this.getStringDatiPdP("PuntoDispacciamento");
    }

    @Override
    public Date getDataMessaRegime() {
        return this.getDateDatiPdP("DataMessaRegime");
    }

    @Override
    public String getTipoMisuratore() {
        return this.getStringDatiPdP("TipoMisuratore");
    }

    @Override
    public String getResidenza() {
        return this.getStringDatiPdP("Residenza");
    }

    @Override
    public String getDisalimentabilita() {
        return this.getStringDatiPdP("Disalimentabilita");
    }

    @Override
    public String getConfigurazioneMisuratore() {
        return this.getStringDatiPdP("ConfigurazioneMisuratore");
    }

    @Override
    public WorkingPeriod getPeriod() {
        return new WorkingPeriod(this.dataInizio);
    }

    public Number getKa() {
        return this.getNumberDatiPdP("Ka");
    }

    public Number getKr() {
        return this.getNumberDatiPdP("Kr");
    }

    public Number getKp() {
        return this.getNumberDatiPdP("Kp");
    }
}

