/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.indici;

import biz.elabor.misure.model.WorkingPeriod;
import biz.elabor.prebilling.common.utils.CommonDownloadPerseoHelper;
import biz.elabor.prebilling.common.utils.InvalidUrlException;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.IndiciDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.indici.CurvaIndiciGiornaliera;
import biz.elabor.prebilling.model.indici.CurvaIndiciMensile;
import biz.elabor.prebilling.model.indici.IndiceOrario;
import biz.elabor.prebilling.model.prebilling.BasicOfferta;
import biz.elabor.prebilling.model.prebilling.Offerta;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.services.StrategyHelper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.tools.StringUtils;

public class MappaIndici {
    private final int anno;
    private final Month mese;
    private final IndiciDao indiciDao;
    private final PrebillingConfiguration configuration;
    private final Map<BasicOfferta, CurvaIndiciMensile> mappaIndici;
    private final Map<BasicOfferta, CurvaIndiciMensile> mappaIndiciPerseo;
    private final ServiceStatus status;

    public MappaIndici(int anno, Month mese, IndiciDao indiciDao, PrebillingConfiguration configuration, ServiceStatus status) {
        this.anno = anno;
        this.mese = mese;
        this.indiciDao = indiciDao;
        this.configuration = configuration;
        this.status = status;
        this.mappaIndici = new HashMap<BasicOfferta, CurvaIndiciMensile>();
        this.mappaIndiciPerseo = new HashMap<BasicOfferta, CurvaIndiciMensile>();
    }

    public CurvaIndiciMensile get(Offerta offerta, TalkManager talkManager) throws DataNotFoundException {
        CurvaIndiciMensile curvaIndiciMensile;
        if (this.mappaIndici.isEmpty()) {
            this.loadMappaIndici();
        }
        if ((curvaIndiciMensile = this.getCurvaMensile(offerta, talkManager)) == null) {
            Date date = CalendarTools.getDate(this.anno, this.mese, 1);
            DateFormat meseAnnoFormat = StrategyHelper.getMeseAnnoFormat();
            String key = String.valueOf(offerta.getKey().toString()) + "/" + offerta.getMercato() + "/" + offerta.getZona() + " - mese " + meseAnnoFormat.format(date);
            throw new DataNotFoundException("indici.notfound", key, ErroriElaborazione.INDICE_NOTFOUND.ordinal());
        }
        return curvaIndiciMensile;
    }

    private CurvaIndiciMensile getCurvaMensile(Offerta offerta, TalkManager talkManager) throws DataNotFoundException {
        CurvaIndiciMensile curvaIndiciMensile;
        block5: {
            String codicePerseo = offerta.getCodicePerseo();
            CurvaIndiciMensile oldCurvaIndiciMensile = this.mappaIndici.get(offerta);
            if (StringUtils.isEmpty(codicePerseo)) {
                curvaIndiciMensile = oldCurvaIndiciMensile;
            } else {
                curvaIndiciMensile = this.mappaIndiciPerseo.get(offerta);
                if (curvaIndiciMensile == null) {
                    try {
                        curvaIndiciMensile = this.loadFromUrl(offerta);
                        this.mappaIndiciPerseo.put(offerta, curvaIndiciMensile);
                        this.indiciDao.upsertIndiciMensili(offerta, curvaIndiciMensile, oldCurvaIndiciMensile, talkManager);
                    }
                    catch (DataNotFoundException exc) {
                        curvaIndiciMensile = oldCurvaIndiciMensile;
                        if (curvaIndiciMensile != null) break block5;
                        throw exc;
                    }
                }
            }
        }
        return curvaIndiciMensile;
    }

    private CurvaIndiciMensile loadFromUrl(Offerta offerta) throws DataNotFoundException {
        CurvaIndiciMensile curva;
        String baseUrl = this.configuration.getUrlPrezziEle();
        String codicePerseo = offerta.getCodicePerseo();
        DateFormat plainDateFormat = StrategyHelper.getPlainDateFormat();
        WorkingPeriod workingPeriod = new WorkingPeriod(this.anno, this.mese);
        Date startDate = workingPeriod.getStartDate();
        String startDateFmt = plainDateFormat.format(startDate);
        Date endDate = workingPeriod.getLastDate();
        String endDateFmt = plainDateFormat.format(endDate);
        try {
            URL url = new URL(String.valueOf(baseUrl) + "/" + codicePerseo + "?startDate=" + startDateFmt + "&endDate=" + endDateFmt + "&dates=true" + "&simulation=0" + "&timeZone=CET");
            this.status.getLogger().info(url.toString());
            List<Double> values = CommonDownloadPerseoHelper.getValues(url, 1.0);
            curva = this.buildCurvaMese(values, offerta);
        }
        catch (MalformedURLException exc) {
            throw new RuntimeException(exc);
        }
        catch (InvalidUrlException | IOException exc) {
            ErroriElaborazione errore = ErroriElaborazione.PERSEO_NOTFOUND;
            String message = errore.getMessage();
            String indice = offerta.getCodIndiceEnergetico();
            int mercato = offerta.getMercato();
            int zona = offerta.getZona();
            Date inizioMese = CalendarTools.getDate(this.anno, this.mese, 1);
            String meseFmt = StrategyHelper.getMeseAnnoFormat().format(inizioMese);
            String key = String.valueOf(indice) + "/" + mercato + "/" + zona + " - mese " + meseFmt;
            throw new DataNotFoundException(message, key, errore.ordinal());
        }
        return curva;
    }

    private CurvaIndiciMensile buildCurvaMese(List<Double> values, Offerta offerta) throws DataNotFoundException {
        CurvaIndiciMensile curvaIndiciMensile;
        int mercato = offerta.getMercato();
        int zona = offerta.getZona();
        ElaborCalendar calendar = new ElaborCalendar(this.anno, this.mese);
        int hoursOfMonth = CalendarTools.getHoursOfMonth(this.anno, this.mese);
        if (values.size() == hoursOfMonth) {
            curvaIndiciMensile = new CurvaIndiciMensile(this.anno, this.mese);
            int giorno = 0;
            Date date = null;
            CurvaIndiciGiornaliera curvaIndiciGiornaliera = new CurvaIndiciGiornaliera(date);
            for (Double value : values) {
                int valueGiorno = calendar.getGiorno();
                if (giorno != valueGiorno) {
                    giorno = valueGiorno;
                    date = calendar.getDate();
                    curvaIndiciGiornaliera = new CurvaIndiciGiornaliera(date);
                    curvaIndiciMensile.add(curvaIndiciGiornaliera);
                }
                int ora = calendar.getOra();
                double indice = value;
                IndiceOrario indiceOrario = new IndiceOrario(mercato, zona, date, ora, indice);
                curvaIndiciGiornaliera.add(indiceOrario);
                calendar.addOre(1);
            }
        } else {
            ErroriElaborazione errore = ErroriElaborazione.PERSEO_NOTFOUND;
            String message = errore.getMessage();
            String indice = offerta.getCodIndiceEnergetico();
            Date inizioMese = calendar.getDate();
            String meseFmt = StrategyHelper.getMeseAnnoFormat().format(inizioMese);
            String key = String.valueOf(indice) + "/" + mercato + "/" + zona + " - mese " + meseFmt;
            throw new DataNotFoundException(message, key, errore.ordinal());
        }
        return curvaIndiciMensile;
    }

    private void loadMappaIndici() {
        List<IndiceOrario> indici = this.indiciDao.getIndici(this.anno, this.mese);
        for (IndiceOrario indice : indici) {
            CurvaIndiciGiornaliera curvaGiornaliera;
            BasicOfferta current = indice.getOfferta();
            Date data = indice.getData();
            CurvaIndiciMensile curvaMensile = this.mappaIndici.get(current);
            if (curvaMensile == null) {
                curvaMensile = new CurvaIndiciMensile(this.anno, this.mese);
                this.mappaIndici.put(current, curvaMensile);
            }
            CurvaIndiciGiornaliera curvaIndiciGiornaliera = curvaGiornaliera = curvaMensile.isEmpty() ? null : (CurvaIndiciGiornaliera)curvaMensile.get(curvaMensile.size() - 1);
            if (curvaGiornaliera == null || !data.equals(curvaGiornaliera.getData())) {
                curvaGiornaliera = new CurvaIndiciGiornaliera(data);
                curvaMensile.add(curvaGiornaliera);
            }
            curvaGiornaliera.add(indice);
        }
    }
}

