/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.indici;

import biz.elabor.prebilling.model.InvalidCurvaRilevazioniException;
import biz.elabor.prebilling.model.indici.CurvaIndiciGiornaliera;
import biz.elabor.prebilling.model.indici.IndiceOrario;
import biz.elabor.prebilling.model.indici.InvalidCurvaIndiciException;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilMese;
import java.util.ArrayList;
import java.util.Iterator;
import org.homelinux.elabor.calendar.Month;

public class CurvaIndiciMensile
extends ArrayList<CurvaIndiciGiornaliera> {
    private static final long serialVersionUID = 1L;
    private int anno;
    private Month mese;

    public CurvaIndiciMensile(int anno, Month mese) {
        this.anno = anno;
        this.mese = mese;
    }

    public int getAnno() {
        return this.anno;
    }

    public Month getMese() {
        return this.mese;
    }

    public void multiply(RilMese rilMese) throws InvalidCurvaIndiciException, InvalidCurvaRilevazioniException {
        Iterator cIterator = this.iterator();
        Iterator rIterator = rilMese.iterator();
        while (cIterator.hasNext() && rIterator.hasNext()) {
            CurvaIndiciGiornaliera cGiorno = (CurvaIndiciGiornaliera)cIterator.next();
            RilGiorno rGiorno = (RilGiorno)rIterator.next();
            cGiorno.multiply(rGiorno);
        }
        if (cIterator.hasNext()) {
            throw new InvalidCurvaIndiciException();
        }
        if (rIterator.hasNext()) {
            throw new InvalidCurvaRilevazioniException(null);
        }
    }

    public double getPrezzoMedio() {
        double totale = 0.0;
        double numero = 0.0;
        for (CurvaIndiciGiornaliera cig : this) {
            for (IndiceOrario indiceOrario : cig) {
                totale += indiceOrario.getPrezzo();
                numero += 1.0;
            }
        }
        return totale / numero;
    }
}

