/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model.calendar;

import biz.elabor.misure.model.fasce.CalendarioFasceMensile;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.calendar.CalendarMap;
import biz.elabor.prebilling.model.calendar.OffertaCommerciale;
import biz.elabor.prebilling.services.CalendarNotFoundException;
import biz.elabor.prebilling.services.StatusTransaction;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;

public class CalendarioCommercialeHelper {
    public static CalendarioFasceMensile getCalendario(String id, int anno, Month mese, String codicePod, CalendarMap calendarMap) throws CalendarNotFoundException {
        CalendarioFasceMensile calendario;
        try {
            calendario = calendarMap.get(id, anno, mese);
        }
        catch (DataNotFoundException exc) {
            throw new CalendarNotFoundException(exc, codicePod);
        }
        return calendario;
    }

    public static String getCalendarId(String codiceOfferta, StatusTransaction transaction) {
        OffertaCommerciale offerta = transaction.getOffertaCommerciale(codiceOfferta);
        return offerta.getCalendarId();
    }

    public static boolean isCommerciale(StatusTransaction transaction, String codiceOfferta, PrebillingConfiguration configuration) {
        String id = CalendarioCommercialeHelper.getCalendarId(codiceOfferta, transaction);
        return !configuration.getIdCalendarioArera().equals(id);
    }
}

