/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model;

import biz.elabor.prebilling.common.BasicServiceStatus;
import biz.elabor.prebilling.common.PrebillingError;
import biz.elabor.prebilling.common.config.Sequence;
import biz.elabor.prebilling.common.model.IdFlusso;
import biz.elabor.prebilling.common.model.ResultRecord;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.StatoContainer;
import biz.elabor.prebilling.model.AziendaContainer;
import biz.elabor.prebilling.model.DeliberaExtractor;
import biz.elabor.prebilling.model.ErrorWrapper;
import biz.elabor.prebilling.model.ListMapKeyDate;
import biz.elabor.prebilling.model.MissingCoeffPerditeException;
import biz.elabor.prebilling.model.StatusManager;
import biz.elabor.prebilling.model.TipoLetStd;
import biz.elabor.prebilling.model.calendar.CalendarMap;
import biz.elabor.prebilling.model.calendar.DefaultOffertaCommerciale;
import biz.elabor.prebilling.model.calendar.OffertaCommerciale;
import biz.elabor.prebilling.model.giada.DefaultPodMap;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.indici.MappaIndici;
import biz.elabor.prebilling.model.misure.DatiFlusso;
import biz.elabor.prebilling.model.misure.Delibera;
import biz.elabor.prebilling.model.misure.MappaMisureAzienda;
import biz.elabor.prebilling.model.misure.MisuraContatorePod;
import biz.elabor.prebilling.model.misure.MisuraNonoraria;
import biz.elabor.prebilling.model.misure.MisuraNonorariaPod;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.misure.Misure;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Mno2GE;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.Rno;
import biz.elabor.prebilling.model.misure.Scarto;
import biz.elabor.prebilling.model.misure.Snf;
import biz.elabor.prebilling.model.misure.Sof;
import biz.elabor.prebilling.model.misure.Trattamento;
import biz.elabor.prebilling.model.pra.PraMap;
import biz.elabor.prebilling.model.prebilling.DispatchingFlussi;
import biz.elabor.prebilling.model.prebilling.Offerta;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.model.statomisure.PdoResult;
import biz.elabor.prebilling.model.statomisure.SnfResult;
import biz.elabor.prebilling.model.statomisure.SofResult;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.model.statopod.UpdateStatoPod;
import biz.elabor.prebilling.model.tariffe.Comune;
import biz.elabor.prebilling.services.letture.GruppoFlussi;
import biz.elabor.prebilling.services.letture.MisuraMno;
import biz.elabor.prebilling.services.letture.TrattamentoHandler;
import biz.elabor.prebilling.services.letture.WriteLetstdService;
import biz.elabor.prebilling.services.reseller.FlussoReseller;
import biz.elabor.prebilling.services.reseller.ResellerPodMap;
import biz.elabor.prebilling.services.switched.SnfD65;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.tariffe.Tariffa;
import biz.elabor.prebilling.services.tariffe.TariffaMultiApplicazione;
import biz.elabor.prebilling.services.tariffe.TariffeMesePod;
import biz.elabor.prebilling.services.volture.ExtMno;
import biz.elabor.prebilling.services.volture.VolturaIVResult;
import biz.elabor.prebilling.services.volture.model.Voltura;
import biz.elabor.prebilling.services.volture.model.VolturaIV;
import biz.elabor.prebilling.util.DefaultMapWriter;
import biz.elabor.prebilling.util.MapWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.structures.StructuresHelper;
import org.homelinux.elabor.structures.classifier.RecordMap;
import org.homelinux.elabor.structures.listmap.BasicListMap;
import org.homelinux.elabor.structures.listmap.DefaultListMapKey;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.structures.listmap.ListMapKey;
import org.homelinux.elabor.structures.listmap.SafeListMap;
import org.homelinux.elabor.structures.safe.DefaultRecordMap;
import org.homelinux.elabor.structures.safe.DefaultSafeListMap;
import org.homelinux.elabor.structures.safe.DefaultSafeMap;
import org.homelinux.elabor.structures.safe.RecordSafeListMap;
import org.homelinux.elabor.structures.safe.SafeMap;

public class ServiceStatus
extends BasicServiceStatus
implements StatoContainer,
StatusManager {
    public static final String MIDDLEWARE = "middleware";
    public static final String PNO_TECNICA = "flussi_non_orari_tecnici";
    public static final String PNO_PERIODO = "flussi_non_orari_periodo";
    private static final List<String> FLUSSI_LETTURE_ORARIE = Arrays.asList("PDO", "RFO", "PDO2G", "RFO2G");
    private MappaMisureAzienda pnos;
    private RecordSafeListMap<String, Pdo> pdoMap;
    private DefaultPodMap allPods;
    private PodMap podMap;
    private Map<String, Misure<Voltura>> misureOrarieVolturaNoCrm;
    private Misure<Mno> misureVno;
    private Misure<Mno> pdo2grv;
    private ListMapKey<String, Mno> snms;
    private ListMapKeyDate<Snf> snfs;
    private ListMapKeyDate<Sof> sofs;
    private DefaultSafeMap<String, Offerta> offerte;
    private ListMap<String, PraticaVolo> piv;
    private Misure<Mno> vnosCrm;
    private Map<String, Misure<Voltura>> vnoNoCrm;
    private ListMapKey<String, Mno> smnsCrm;
    private Map<String, Misure<Mno>> smnsNoCrm;
    private MappaIndici mappaIndici;
    private List<Rno> rno;
    private List<Scarto> scarti;
    private DefaultSafeMap<String, Reseller> resellers;
    private ListMap<String, TariffaMultiApplicazione> tariffeMedieMensiliReseller;
    private ListMap<String, TariffaMultiApplicazione> tariffeMedieMensiliDispatcher;
    private SafeMap<String, Mno> pnosRiallineamento;
    private ListMapKeyDate<SnfD65> snfsCrm;
    private Map<String, List<SnfD65>> snfsNoCrm;
    private ListMapKeyDate<Sof> sofsCrm;
    private Map<String, List<Sof>> sofsNoCrm;
    private CalendarMap calendarMap;
    private Map<Date, Map<String, Pdo>> rfoMap;
    private List<PdoResult> pdoElaborati;
    private List<PdoResult> pdoSospesi;
    private List<MnoResult> pnoElaborati;
    private List<MnoResult> pnoSospesi;
    private List<MnoResult> pdo2GRElaborati;
    private List<MnoResult> pdo2GRSospesi;
    private List<MnoResult> pdo2GRObsoleti;
    private List<MnoResult> pdo2GREsclusi;
    private List<MnoResult> pnoObsoleti;
    private List<MnoResult> snmElaborati;
    private List<MnoResult> snmSospesi;
    private List<MnoResult> snmObsoleti;
    private ListMap<String, SnfResult> snfElaborati;
    private ListMap<String, SnfResult> snfSospesi;
    private ListMap<String, SnfResult> snfObsoleti;
    private List<SofResult> sofElaborati;
    private List<SofResult> sofSospesi;
    private List<SofResult> sofObsoleti;
    private ListMap<String, SnfResult> snfEsclusi;
    private List<MnoResult> vnoElaborati;
    private List<MnoResult> vnoSospesi;
    private List<MnoResult> vnoObsoleti;
    private List<MnoResult> vnoEsclusi;
    private List<PdoResult> rfoObsoleti;
    private List<PdoResult> rfoElaborati;
    private List<PdoResult> rfoSospesi;
    private List<PdoResult> pdoObsoleti;
    private List<PdoResult> pdoEsclusi;
    private List<PdoResult> rfoEsclusi;
    private List<MnoResult> pnoEsclusi;
    private List<MnoResult> rnoElaborati;
    private List<MnoResult> rnoSospesi;
    private List<PdoResult> pdoEsportati;
    private List<MnoResult> pnoEsportati;
    private List<MnoResult> pdo2GREsportati;
    private List<MnoResult> smisEsportati;
    private List<SofResult> sofEsportati;
    private List<SnfResult> snfEsportati;
    private List<MnoResult> snmEsportati;
    private List<MnoResult> rnoEsportati;
    private List<PdoResult> rfoEsportati;
    private List<MnoResult> vnoEsportati;
    private List<MnoResult> smEsportati;
    private List<MnoResult> rtEsportati;
    private List<MnoResult> smisElaborati;
    private List<MnoResult> smisSospesi;
    private List<MnoResult> smisEsclusi;
    private List<MnoResult> smisObsoleti;
    private Set<String> erroriTariffe;
    private List<StatoPod> statiPod;
    private SafeListMap<String, Prestazione> prestazioni;
    private ListMap<Delibera, Pdo> pdos1GXml;
    private List<Pdo> pdo2GNRXml;
    private List<Pdo> rfo2GNRXml;
    private List<Snf> f2gXml;
    private ListMap<Delibera, Snf> snfs1GXml;
    private ListMap<Delibera, Mno> snms1GXml;
    private List<Mno> snms2GXml;
    private ListMap<Delibera, Sof> sofs1GXml;
    private ListMap<Delibera, Pdo> rfosXml;
    private ListMap<Delibera, Mno> vnosXml;
    private ListMap<Delibera, Mno> smXml;
    private ListMap<Delibera, Mno> rtXml;
    private DispatchingFlussi dispatchingFlussi;
    private ListMapKey<String, Mno> smisXml;
    private RecordMap<String, Mno2GE> vno2gea;
    private RecordMap<String, Mno2GE> vno2ger;
    private RecordMap<String, Mno2GE> misure2gEA;
    private RecordMap<String, Mno2GE> misure2gER;
    private RecordMap<String, Mno2GE> rfo2gREa;
    private RecordMap<String, Mno2GE> misure2gERc;
    private RecordMap<String, Mno2GE> misure2gERi;
    private RecordMap<String, Mno2GE> rfo2gRer;
    private RecordMap<String, Mno2GE> rfo2gRerc;
    private RecordMap<String, Mno2GE> rfo2gReri;
    private RecordMap<String, Mno2GE> rno2gea;
    private RecordMap<String, Mno2GE> rno2ger;
    private RecordMap<String, Mno2GE> rno2gerc;
    private RecordMap<String, Mno2GE> rno2geri;
    private RecordMap<String, Mno2GE> rnv2gea;
    private RecordMap<String, Mno2GE> rnv2ger;
    private RecordMap<String, Mno2GE> rnv2gerc;
    private RecordMap<String, Mno2GE> rnv2geri;
    private RecordMap<String, Mno2GE> rsn2gea;
    private RecordMap<String, Mno2GE> rsn2ger;
    private RecordMap<String, Mno2GE> rsn2gerc;
    private RecordMap<String, Mno2GE> rsn2geri;
    private ListMap<Delibera, Mno> pno1GXml;
    private ListMap<Delibera, Mno> ds1GXml;
    private ListMap<Delibera, Mno> dsr1GXml;
    private List<Mno> ds2GXml;
    private List<Mno> dsr2GXml;
    private List<Mno> pno2GXml;
    private List<Mno> vno2GXml;
    private List<Mno> rt2GXml;
    private List<Mno> sm2GXml;
    private RecordMap<String, Mno2GE> snm2ger;
    private RecordMap<String, Mno2GE> snm2gea;
    private ListMap<String, Mno> rsnRnv;
    private ListMap<Delibera, Mno> rnvXml;
    private List<MnoResult> rnvEsportati;
    private ListMap<Delibera, Mno> rsnXml;
    private List<MnoResult> rsnEsportati;
    private List<UpdateStatoPod> updateStatiRichiesta;
    private Map<String, PraticaVolo> virtualPiv;
    private Map<String, String> suspendedPod;
    private Map<TipoLetStd, MapWriter> misureDispatcherWriter;
    private Map<String, Map<TipoLetStd, MapWriter>> misureOrarieWriter;
    private Map<String, Map<TipoLetStd, MapWriter>> misureNonorarieWriter;
    private Map<String, Map<String, MapWriter>> rettificheDispatcherWriter;
    private Map<String, Map<String, MapWriter>> rettificheIVDispatcherWriter;
    private Map<String, Map<String, MapWriter>> rettificheResellerWriter;
    private Map<String, Map<String, MapWriter>> rettificheIVResellerWriter;
    private Map<String, MapWriter> misureTecnicheWriter;
    private Map<String, MapWriter> riconfVoltureIVWriter;
    private MapWriter misureTecnicheDispatcherWriter;
    private Map<String, MapWriter> switchoutXmlWriter;
    private Map<String, MapWriter> switchoutCsvWriter;
    private Map<String, MapWriter> rettificheSwitchoutCsvWriter;
    private MapWriter rettificheSwitchoutDispatcher;
    private ListMap<Delibera, Mno> rnosXml;
    private ListMap<Delibera, Mno> rnos2gXml;
    private ListMap<Delibera, Mno> rsns2gXml;
    private ListMap<Delibera, Mno> rnvs2gXml;
    private List<Mno> rtr2gXml;
    private SafeMap<String, OffertaCommerciale> offerteCommerciali;
    private Map<String, ListMap<String, MisuraContatorePod>> riconfigurazioni;
    private String idCalendarioArera;
    private Map<String, String> misureType;
    private ListMap<String, Mno> pnoConsolidamento;
    private ListMap<String, Mno> pdoConsolidamento;
    private ListMap<Delibera, Mno> pnosXmlPod;
    private ListMap<Delibera, Mno> rnosXmlPod;
    private ListMap<Delibera, Pdo> pdoXmlPod;
    private ListMap<Delibera, Mno> rnvsXmlPod;
    private List<MnoResult> pdo2gObsoleti;
    private List<MnoResult> pdo2gSospesi;
    private List<MnoResult> pdo2gEsclusi;
    private List<MnoResult> pdo2gElaborati;
    private ListMap<Delibera, Pdo> rfoXmlPod;
    private ListMap<Delibera, Mno> rsnsXmlPod;
    private List<Snf> f2gsXmlPod;
    private BasicListMap<Delibera, Snf> snfsXmlPod;
    private ListMapKey<String, Mno> smisXmlPod;
    private BasicListMap<Delibera, Mno> vnosXmlPod;
    private List<Mno> pno2GXmlPod;
    private RecordMap<String, Mno2GE> pno2geaXmlPod;
    private RecordMap<String, Mno2GE> pno2gerXmlPod;
    private BasicListMap<Delibera, Mno> snmsXmlPod;
    private List<Mno> snms2GXmlPod;
    private RecordMap<String, Mno2GE> snm2gerXmlPod;
    private RecordMap<String, Mno2GE> snm2geaXmlPod;
    private ListMap<Delibera, Sof> sofsXmlPod;
    private List<Mno> pdo2GRXml;
    private List<Mno> rfo2GRXml;
    private List<Mno> pdo2gRXmlPod;
    private RecordMap<String, Mno2GE> pdo2gReaXmlPod;
    private RecordMap<String, Mno2GE> pdo2gRerXmlPod;
    private Map<String, Mno> riconfigurazioniPod2GR;
    private List<FlussoReseller> flussiReseller;
    private ResellerPodMap resellerPodMap;
    private List<Pdo> logRfo;
    private List<Mno> misureDefault;
    private PrebillingConfiguration configuration;
    private List<MisuraMno> riconfigurazioniMno;
    private DefaultSafeListMap<String, Pdo> pdoReseller;
    private DefaultSafeListMap<String, Pdo> pdoDispatcher;
    private Map<Date, Map<String, Pdo>> rfoReseller;
    private Map<Date, Map<String, Pdo>> rfoDispatcher;
    private Map<Destinatari, ListMap<StatoMisure, ResultRecord<Pdo, PrebillingError>>> tariffeOrarieResult;
    private Map<Destinatari, ListMap<StatoMisure, ResultRecord<MisuraNonoraria, PrebillingError>>> tariffeNonorarieResult;
    private Map<String, List<VolturaIV>> voltureIV;
    private List<VolturaIVResult> voltureIVElaborate;
    private List<VolturaIVResult> voltureIVSospese;
    private Map<String, ListMap<String, MisuraNonorariaPod>> misureLateProcessing;
    private SafeMap<Integer, Map<Date, Double>> coeffPerdite;
    private PraMap praMap;
    private SafeMap<String, Comune> comuniMap;
    private List<Tariffa> tariffeElaborateDispatcher;
    private List<Tariffa> tariffeElaborateReseller;
    private List<MisuraNonoraria> letture;
    private int commitCount;
    private ListMap<Delibera, Mno> vpsXml;
    private ListMap<Delibera, Mno> vp2gsXml;
    private ListMap<Delibera, Mno> vpRsXml;
    private ListMap<Delibera, Mno> vpR2gsXml;
    private ListMap<Delibera, Mno> avsXml;
    private ListMap<Delibera, Mno> av2gsXml;
    private ListMap<Delibera, Mno> avRsXml;
    private ListMap<Delibera, Mno> avR2gsXml;
    private Map<Date, Map<String, ListMap<GruppoFlussi, Mno>>> misurePrestazioni;

    public ServiceStatus(PrebillingConfiguration configuration, Sequence sequence) {
        super(configuration.getIdEsecuzione("prebilling", sequence));
        this.configuration = configuration;
        this.misureOrarieVolturaNoCrm = new LinkedHashMap<String, Misure<Voltura>>();
        this.snfsCrm = new ListMapKeyDate("snfCrm");
        this.sofsCrm = new ListMapKeyDate("sofcrm");
        this.snfsNoCrm = new LinkedHashMap<String, List<SnfD65>>();
        this.sofsNoCrm = new LinkedHashMap<String, List<Sof>>();
        this.vno2gea = new DefaultRecordMap<String, Mno2GE>();
        this.vno2ger = new DefaultRecordMap<String, Mno2GE>();
        this.rno2gea = new DefaultRecordMap<String, Mno2GE>();
        this.rno2ger = new DefaultRecordMap<String, Mno2GE>();
        this.rno2gerc = new DefaultRecordMap<String, Mno2GE>();
        this.rno2geri = new DefaultRecordMap<String, Mno2GE>();
        this.rnv2gea = new DefaultRecordMap<String, Mno2GE>();
        this.rnv2ger = new DefaultRecordMap<String, Mno2GE>();
        this.rnv2gerc = new DefaultRecordMap<String, Mno2GE>();
        this.rnv2geri = new DefaultRecordMap<String, Mno2GE>();
        this.rsn2gea = new DefaultRecordMap<String, Mno2GE>();
        this.rsn2ger = new DefaultRecordMap<String, Mno2GE>();
        this.rsn2gerc = new DefaultRecordMap<String, Mno2GE>();
        this.rsn2geri = new DefaultRecordMap<String, Mno2GE>();
        this.misure2gEA = new DefaultRecordMap<String, Mno2GE>();
        this.misure2gER = new DefaultRecordMap<String, Mno2GE>();
        this.misure2gERc = new DefaultRecordMap<String, Mno2GE>();
        this.misure2gERi = new DefaultRecordMap<String, Mno2GE>();
        this.rfo2gREa = new DefaultRecordMap<String, Mno2GE>();
        this.rfo2gRerc = new DefaultRecordMap<String, Mno2GE>();
        this.rfo2gReri = new DefaultRecordMap<String, Mno2GE>();
        this.rfo2gRer = new DefaultRecordMap<String, Mno2GE>();
        this.rfo2gRerc = new DefaultRecordMap<String, Mno2GE>();
        this.rfo2gReri = new DefaultRecordMap<String, Mno2GE>();
        this.snm2gea = new DefaultRecordMap<String, Mno2GE>();
        this.snm2ger = new DefaultRecordMap<String, Mno2GE>();
        this.rnvEsportati = new ArrayList<MnoResult>();
        this.rsnEsportati = new ArrayList<MnoResult>();
        this.updateStatiRichiesta = new ArrayList<UpdateStatoPod>();
        this.suspendedPod = new HashMap<String, String>();
        this.misureTecnicheWriter = new LinkedHashMap<String, MapWriter>();
        this.riconfVoltureIVWriter = new LinkedHashMap<String, MapWriter>();
        this.misureTecnicheDispatcherWriter = new DefaultMapWriter();
        this.switchoutXmlWriter = new LinkedHashMap<String, MapWriter>();
        this.switchoutCsvWriter = new LinkedHashMap<String, MapWriter>();
        this.rettificheSwitchoutCsvWriter = new LinkedHashMap<String, MapWriter>();
        this.rettificheSwitchoutDispatcher = new DefaultMapWriter();
        this.pdo2gElaborati = new ArrayList<MnoResult>();
        this.pdo2gObsoleti = new ArrayList<MnoResult>();
        this.pdo2gEsclusi = new ArrayList<MnoResult>();
        this.pdo2gSospesi = new ArrayList<MnoResult>();
        this.rfo2GNRXml = new ArrayList<Pdo>();
        this.rfo2GRXml = new ArrayList<Mno>();
        this.pdo2gRXmlPod = new ArrayList<Mno>();
        this.pdo2gReaXmlPod = new DefaultRecordMap<String, Mno2GE>();
        this.pdo2gRerXmlPod = new DefaultRecordMap<String, Mno2GE>();
        this.pno2geaXmlPod = new DefaultRecordMap<String, Mno2GE>();
        this.pno2gerXmlPod = new DefaultRecordMap<String, Mno2GE>();
        this.snm2geaXmlPod = new DefaultRecordMap<String, Mno2GE>();
        this.snm2gerXmlPod = new DefaultRecordMap<String, Mno2GE>();
        this.rno = new ArrayList<Rno>();
        this.voltureIVElaborate = new ArrayList<VolturaIVResult>();
        this.voltureIVSospese = new ArrayList<VolturaIVResult>();
        this.snms = new DefaultListMapKey<String, Mno>();
        this.misureLateProcessing = new HashMap<String, ListMap<String, MisuraNonorariaPod>>();
        this.tariffeElaborateDispatcher = new ArrayList<Tariffa>();
        this.tariffeElaborateReseller = new ArrayList<Tariffa>();
        this.rsnRnv = new BasicListMap<String, Mno>();
        this.resetLetture();
        this.letture = new ArrayList<MisuraNonoraria>();
        this.misurePrestazioni = new HashMap<Date, Map<String, ListMap<GruppoFlussi, Mno>>>();
        this.commitCount = 0;
    }

    public void resetLetture() {
        this.riconfigurazioniPod2GR = new HashMap<String, Mno>();
        this.pdo2gElaborati = new ArrayList<MnoResult>();
        this.pdo2gEsclusi = new ArrayList<MnoResult>();
        this.pdo2gObsoleti = new ArrayList<MnoResult>();
        this.pdo2gSospesi = new ArrayList<MnoResult>();
        this.pnoSospesi = new ArrayList<MnoResult>();
        this.pdo2GRElaborati = new ArrayList<MnoResult>();
        this.pdo2GRSospesi = new ArrayList<MnoResult>();
        this.pdo2GRObsoleti = new ArrayList<MnoResult>();
        this.pdo2GREsclusi = new ArrayList<MnoResult>();
        this.pnoObsoleti = new ArrayList<MnoResult>();
        this.pnoEsclusi = new ArrayList<MnoResult>();
        this.pdoElaborati = new ArrayList<PdoResult>();
        this.pnoElaborati = new ArrayList<MnoResult>();
        this.snmElaborati = new ArrayList<MnoResult>();
        this.snmSospesi = new ArrayList<MnoResult>();
        this.snmObsoleti = new ArrayList<MnoResult>();
        this.sofSospesi = new ArrayList<SofResult>();
        this.sofObsoleti = new ArrayList<SofResult>();
        this.sofElaborati = new ArrayList<SofResult>();
        this.snfSospesi = new BasicListMap<String, SnfResult>();
        this.snfObsoleti = new BasicListMap<String, SnfResult>();
        this.snfElaborati = new BasicListMap<String, SnfResult>();
        this.snfEsclusi = new BasicListMap<String, SnfResult>();
        this.vnoElaborati = new ArrayList<MnoResult>();
        this.vnoSospesi = new ArrayList<MnoResult>();
        this.vnoObsoleti = new ArrayList<MnoResult>();
        this.vnoEsclusi = new ArrayList<MnoResult>();
        this.rfoObsoleti = new ArrayList<PdoResult>();
        this.rfoElaborati = new ArrayList<PdoResult>();
        this.rfoSospesi = new ArrayList<PdoResult>();
        this.pdoObsoleti = new ArrayList<PdoResult>();
        this.pdoSospesi = new ArrayList<PdoResult>();
        this.pdoEsclusi = new ArrayList<PdoResult>();
        this.rfoEsclusi = new ArrayList<PdoResult>();
        this.rnoElaborati = new ArrayList<MnoResult>();
        this.rnoSospesi = new ArrayList<MnoResult>();
        this.smisElaborati = new ArrayList<MnoResult>();
        this.smisSospesi = new ArrayList<MnoResult>();
        this.smisEsclusi = new ArrayList<MnoResult>();
        this.smisObsoleti = new ArrayList<MnoResult>();
        this.erroriTariffe = new HashSet<String>();
        this.statiPod = new ArrayList<StatoPod>();
        this.pdoEsportati = new ArrayList<PdoResult>();
        this.pnoEsportati = new ArrayList<MnoResult>();
        this.pdo2GREsportati = new ArrayList<MnoResult>();
        this.smisEsportati = new ArrayList<MnoResult>();
        this.sofEsportati = new ArrayList<SofResult>();
        this.snfEsportati = new ArrayList<SnfResult>();
        this.snmEsportati = new ArrayList<MnoResult>();
        this.rfoEsportati = new ArrayList<PdoResult>();
        this.rnoEsportati = new ArrayList<MnoResult>();
        this.vnoEsportati = new ArrayList<MnoResult>();
        this.smEsportati = new ArrayList<MnoResult>();
        this.rtEsportati = new ArrayList<MnoResult>();
        this.misureOrarieWriter = new LinkedHashMap<String, Map<TipoLetStd, MapWriter>>();
        this.misureNonorarieWriter = new LinkedHashMap<String, Map<TipoLetStd, MapWriter>>();
        this.rettificheDispatcherWriter = new HashMap<String, Map<String, MapWriter>>();
        this.rettificheIVDispatcherWriter = new HashMap<String, Map<String, MapWriter>>();
        this.rettificheResellerWriter = new HashMap<String, Map<String, MapWriter>>();
        this.rettificheIVResellerWriter = new HashMap<String, Map<String, MapWriter>>();
        this.misureDispatcherWriter = new HashMap<TipoLetStd, MapWriter>();
        this.riconfigurazioni = new LinkedHashMap<String, ListMap<String, MisuraContatorePod>>();
        this.logRfo = new ArrayList<Pdo>();
        this.misureDefault = new ArrayList<Mno>();
        this.riconfigurazioniMno = new ArrayList<MisuraMno>();
        this.tariffeOrarieResult = new LinkedHashMap<Destinatari, ListMap<StatoMisure, ResultRecord<Pdo, PrebillingError>>>();
        this.tariffeNonorarieResult = new LinkedHashMap<Destinatari, ListMap<StatoMisure, ResultRecord<MisuraNonoraria, PrebillingError>>>();
    }

    @Deprecated
    public Map<Date, Map<String, Pdo>> getRfoReseller() {
        return this.rfoReseller;
    }

    @Deprecated
    public Map<Date, Map<String, Pdo>> getRfoDispatcher() {
        return this.rfoDispatcher;
    }

    public void setCalendarMap(CalendarMap calendarMap, SafeMap<String, OffertaCommerciale> offerteCommerciali, String idCalendarioArera) {
        this.calendarMap = calendarMap;
        this.offerteCommerciali = offerteCommerciali;
        this.idCalendarioArera = idCalendarioArera;
    }

    public void setPdo(RecordSafeListMap<String, Pdo> pdoMap) {
        this.pdoMap = pdoMap;
    }

    public void addPdo(Pdo newPdo) {
        this.pdoMap.add(newPdo);
    }

    public RecordSafeListMap<String, Pdo> getPdoMap() {
        return this.pdoMap;
    }

    public void setVno(Misure<Mno> vno) {
        this.misureVno = vno;
    }

    public Misure<Mno> getVno() {
        return this.misureVno;
    }

    public void setPdo2GRV(Misure<Mno> pdo2grv) {
        this.pdo2grv = pdo2grv;
    }

    public Misure<Mno> getPdo2GRV() {
        return this.pdo2grv;
    }

    public ListMapKey<String, Mno> getSnms() {
        return this.snms;
    }

    public void addSnm(Mno snm) {
        this.snms.add(snm);
    }

    public void addSnm(List<Mno> snm) {
        this.snms.addAll(snm);
    }

    public void setSmisXmlPod(ListMapKey<String, Mno> smis) {
        this.smisXmlPod = smis;
    }

    public ListMapKey<String, Mno> getSmisXmlPod() {
        return this.smisXmlPod;
    }

    public void setSnfs(List<Snf> snfs) {
        this.snfs = new ListMapKeyDate("snf");
        for (Snf snf : snfs) {
            String codiceFlusso = snf.getCodiceFlusso();
            if (codiceFlusso.equalsIgnoreCase("F2G")) {
                snf.setTrattamento(Trattamento.F);
            }
            this.snfs.add(snf);
        }
    }

    public ListMapKeyDate<Snf> getSnfs() {
        return this.snfs;
    }

    public ListMapKeyDate<Sof> getSofs() {
        return this.sofs;
    }

    public void setSofs(List<Sof> sofs) {
        this.sofs = new ListMapKeyDate("sof");
        this.sofs.addAll(sofs);
    }

    public void setOfferte(List<Offerta> offerte) {
        this.offerte = new DefaultSafeMap(new ErrorWrapper("offerta.pod", ErroriElaborazione.OFFERTA_NOTFOUND));
        this.offerte.addAll(offerte);
    }

    public SafeMap<String, Offerta> getOfferte() {
        return this.offerte;
    }

    public void setTariffeMedieMensiliReseller(ListMap<String, TariffaMultiApplicazione> tariffe) {
        this.tariffeMedieMensiliReseller = tariffe;
    }

    public ListMap<String, TariffaMultiApplicazione> getTariffeMedieMensiliReseller() {
        return this.tariffeMedieMensiliReseller;
    }

    public void setTariffeMedieMensiliDispatcher(ListMap<String, TariffaMultiApplicazione> tariffe) {
        this.tariffeMedieMensiliDispatcher = tariffe;
    }

    public ListMap<String, TariffaMultiApplicazione> getTariffeMedieMensiliDispatcher() {
        return this.tariffeMedieMensiliDispatcher;
    }

    public ListMap<String, PraticaVolo> getPiv() {
        return this.piv;
    }

    public void setPiv(ListMap<String, PraticaVolo> piv) {
        this.piv = piv;
    }

    public Misure<Mno> getVnosCrm() {
        return this.vnosCrm;
    }

    public void setVnosCrm(Misure<Mno> vnosCrm) {
        this.vnosCrm = vnosCrm;
    }

    public Map<String, Misure<Voltura>> getVnoNoCrm() {
        return this.vnoNoCrm;
    }

    public void setVnosNoCrm(Map<String, Misure<Voltura>> vnoNoCrm) {
        this.vnoNoCrm = vnoNoCrm;
    }

    public ListMapKey<String, Mno> getSmnsCrm() {
        return this.smnsCrm;
    }

    public void setSmnsCrm(ListMapKey<String, Mno> snmsCrm) {
        this.smnsCrm = snmsCrm;
    }

    public Map<String, Misure<Mno>> getSmnsNoCrm() {
        return this.smnsNoCrm;
    }

    public void setSmnsNoCrm(Map<String, Misure<Mno>> smnsNoCrm) {
        this.smnsNoCrm = smnsNoCrm;
    }

    public MappaIndici getMappaIndici() {
        return this.mappaIndici;
    }

    public void setMappaIndici(MappaIndici mappaIndici) {
        this.mappaIndici = mappaIndici;
    }

    public void addRno(List<Rno> rnoList) {
        this.rno.addAll(rnoList);
    }

    public void addRno(Rno newRno) {
        this.rno.add(newRno);
    }

    public List<Rno> getRno() {
        return this.rno;
    }

    public void setScarti(List<Scarto> scarti) {
        this.scarti = scarti;
    }

    public List<Scarto> getScarti() {
        return this.scarti;
    }

    public MappaMisureAzienda getPnos() {
        return this.pnos;
    }

    public void setPno(MappaMisureAzienda pnos) {
        this.pnos = pnos;
    }

    public SafeMap<String, Reseller> getResellers() {
        return this.resellers;
    }

    public void setResellers(List<Reseller> resellers) {
        ErrorWrapper error = new ErrorWrapper("reseller", ErroriElaborazione.RESELLER_NOT_FOUND);
        this.resellers = new DefaultSafeMap(error);
        this.resellers.addAll(resellers);
    }

    public Map<String, Misure<Voltura>> getMisureOrarieVolturaNoCrm() {
        return this.misureOrarieVolturaNoCrm;
    }

    public void addMisuraOrariaVolturaNoCrm(String azienda, Voltura misuraPod) {
        Misure<Voltura> misure = this.misureOrarieVolturaNoCrm.get(azienda);
        if (misure == null) {
            misure = new Misure("misuraOrariaNoCrm");
            this.misureOrarieVolturaNoCrm.put(azienda, misure);
        }
        misure.add(misuraPod);
    }

    public SafeMap<String, Mno> getRiallineamentoPnos() {
        return this.pnosRiallineamento;
    }

    public void setRiallineamentoPnos(SafeMap<String, Mno> pnos) {
        this.pnosRiallineamento = pnos;
    }

    public Map<Date, Map<String, Pdo>> getRfoMap() {
        return this.rfoMap;
    }

    public void setRfoMap(Map<Date, Map<String, Pdo>> rfoMap) {
        this.rfoMap = rfoMap;
    }

    public void addPdoSospeso(PdoResult pdoResult) {
        this.pdoSospesi.add(pdoResult);
    }

    public List<PdoResult> getPdoSospesi() {
        return this.pdoSospesi;
    }

    public void addSofCrm(Sof sof) {
        this.sofsCrm.add(sof);
    }

    public ListMapKeyDate<Sof> getSofsCrm() {
        return this.sofsCrm;
    }

    public void addSnfCrm(SnfD65 snfD65) {
        this.snfsCrm.add(snfD65);
    }

    public ListMapKeyDate<SnfD65> getSnfsCrm() {
        return this.snfsCrm;
    }

    public void addSnfNoCrm(SnfD65 snf) {
        ServiceStatus.addSNoCrm(snf, this.snfsNoCrm);
    }

    public Map<String, List<SnfD65>> getSnfsNoCrm() {
        return this.snfsNoCrm;
    }

    public void addSofNoCrm(Sof sof) {
        ServiceStatus.addSNoCrm(sof, this.sofsNoCrm);
    }

    public Map<String, List<Sof>> getSofsNoCrm() {
        return this.sofsNoCrm;
    }

    public CalendarMap getCalendarMap() {
        return this.calendarMap;
    }

    public void addPnoSospeso(MnoResult result) {
        this.pnoSospesi.add(result);
    }

    public void addPdo2GRElaborato(MnoResult result) {
        this.pdo2GRElaborati.add(result);
    }

    public void addPdo2GRSospeso(MnoResult result) {
        this.pdo2GRSospesi.add(result);
    }

    public void addPdo2GRObsoleto(MnoResult result) {
        this.pdo2GRObsoleti.add(result);
    }

    public void addPdo2GREscluso(MnoResult result) {
        this.pdo2GREsclusi.add(result);
    }

    public void addPnoObsoleto(MnoResult result) {
        this.pnoObsoleti.add(result);
    }

    @Override
    public List<MnoResult> getPdo2GRElaborati() {
        return this.pdo2GRElaborati;
    }

    @Override
    public List<MnoResult> getPdo2GRSospesi() {
        return this.pdo2GRSospesi;
    }

    @Override
    public List<MnoResult> getPdo2GRObsoleti() {
        return this.pdo2GRObsoleti;
    }

    @Override
    public List<MnoResult> getPdo2GREsclusi() {
        return this.pdo2GREsclusi;
    }

    public List<MnoResult> getPnoSospesi() {
        return this.pnoSospesi;
    }

    @Override
    public List<MnoResult> getPnoObsoleti() {
        return this.pnoObsoleti;
    }

    public List<PdoResult> getPdoElaborati() {
        return this.pdoElaborati;
    }

    public void addPdoElaborato(String azienda, PdoResult newPdo) {
        Pdo record = (Pdo)newPdo.getRecord();
        record.setCdaziend(azienda);
        this.pdoElaborati.add(newPdo);
    }

    public void addPdoObsoleto(PdoResult pdoResult) {
        this.pdoObsoleti.add(pdoResult);
    }

    public List<PdoResult> getPdoObsoleti() {
        return this.pdoObsoleti;
    }

    public List<MnoResult> getPnoElaborati() {
        return this.pnoElaborati;
    }

    public void addPnoElaborato(MnoResult result) {
        this.pnoElaborati.add(result);
    }

    public List<MnoResult> getSnmSospesi() {
        return this.snmSospesi;
    }

    public void addSnmSospeso(MnoResult snm) {
        this.snmSospesi.add(snm);
    }

    @Override
    public List<MnoResult> getSnmObsoleti() {
        return this.snmObsoleti;
    }

    public void addSnmObsoleto(MnoResult snm) {
        this.snmObsoleti.add(snm);
    }

    public void addSnmElaborato(MnoResult snmResult) {
        this.snmElaborati.add(snmResult);
    }

    public List<MnoResult> getSnmElaborati() {
        return this.snmElaborati;
    }

    @Override
    public void addSnfElaborato(SnfResult result) {
        SnfD65 record = (SnfD65)result.getRecord();
        String tabella = record.getTabella();
        this.snfElaborati.add(tabella, result);
    }

    @Override
    public ListMap<String, SnfResult> getSnfElaborati() {
        return this.snfElaborati;
    }

    public void addSnfSospeso(SnfResult result) {
        SnfD65 record = (SnfD65)result.getRecord();
        String tabella = record.getTabella();
        this.snfSospesi.add(tabella, result);
    }

    public void addSnfObsoleto(SnfResult result) {
        SnfD65 record = (SnfD65)result.getRecord();
        String tabella = record.getTabella();
        this.snfObsoleti.add(tabella, result);
    }

    @Override
    public ListMap<String, SnfResult> getSnfSospesi() {
        return this.snfSospesi;
    }

    @Override
    public ListMap<String, SnfResult> getSnfObsoleti() {
        return this.snfObsoleti;
    }

    public void addSnfEscluso(SnfResult result) {
        SnfD65 record = (SnfD65)result.getRecord();
        String tabella = record.getTabella();
        this.snfEsclusi.add(tabella, result);
    }

    @Override
    public ListMap<String, SnfResult> getSnfEsclusi() {
        return this.snfEsclusi;
    }

    public void addSofElaborato(SofResult result) {
        this.sofElaborati.add(result);
    }

    public List<SofResult> getSofElaborati() {
        return this.sofElaborati;
    }

    public void addSofSospeso(SofResult sofResult) {
        this.sofSospesi.add(sofResult);
    }

    public void addSofObsoleto(SofResult sofResult) {
        this.sofObsoleti.add(sofResult);
    }

    public List<SofResult> getSofSospesi() {
        return this.sofSospesi;
    }

    @Override
    public List<SofResult> getSofObsoleti() {
        return this.sofObsoleti;
    }

    public List<MnoResult> getVnoSospesi() {
        return this.vnoSospesi;
    }

    public List<MnoResult> getVnoElaborati() {
        return this.vnoElaborati;
    }

    public void addVnoElaborato(MnoResult vnoResult) {
        this.vnoElaborati.add(vnoResult);
    }

    public void addVnoSospeso(MnoResult vnoResult) {
        this.vnoSospesi.add(vnoResult);
    }

    public void addVnoObsoleto(MnoResult vnoResult) {
        this.vnoObsoleti.add(vnoResult);
    }

    @Override
    public List<MnoResult> getVnoObsoleti() {
        return this.vnoObsoleti;
    }

    public void addVnoEscluso(MnoResult vnoResult) {
        this.vnoEsclusi.add(vnoResult);
    }

    public void addRnvEsportato(MnoResult result) {
        this.rnvEsportati.add(result);
    }

    public void addRsnEsportato(MnoResult result) {
        this.rsnEsportati.add(result);
    }

    @Override
    public Iterable<MnoResult> getRnvEsportati() {
        return this.rnvEsportati;
    }

    @Override
    public Iterable<MnoResult> getRsnEsportati() {
        return this.rsnEsportati;
    }

    public List<MnoResult> getVnoEsclusi() {
        return this.vnoEsclusi;
    }

    public List<PdoResult> getRfoObsoleti() {
        return this.rfoObsoleti;
    }

    public void addRfoObsoleto(PdoResult rfoResult) {
        this.rfoObsoleti.add(rfoResult);
    }

    public List<PdoResult> getRfoElaborati() {
        return this.rfoElaborati;
    }

    public void addRfoElaborato(String azienda, PdoResult result) {
        Pdo record = (Pdo)result.getRecord();
        record.setCdaziend(azienda);
        this.rfoElaborati.add(result);
    }

    public List<PdoResult> getRfoSospesi() {
        return this.rfoSospesi;
    }

    public void addRfoSospeso(PdoResult rfoResult) {
        this.rfoSospesi.add(rfoResult);
    }

    public void addPdoEscluso(PdoResult result) {
        this.pdoEsclusi.add(result);
    }

    public void addRfoEscluso(PdoResult result) {
        this.rfoEsclusi.add(result);
    }

    public List<PdoResult> getPdoEsclusi() {
        return this.pdoEsclusi;
    }

    public List<PdoResult> getRfoEsclusi() {
        return this.rfoEsclusi;
    }

    public void addPnoEscluso(MnoResult result) {
        this.pnoEsclusi.add(result);
    }

    public List<MnoResult> getPnoEsclusi() {
        return this.pnoEsclusi;
    }

    public void addRnoElaborato(MnoResult result) {
        this.rnoElaborati.add(result);
    }

    public List<MnoResult> getRnoElaborati() {
        return this.rnoElaborati;
    }

    public void addPdoEsportato(PdoResult pdoResult) {
        this.pdoEsportati.add(pdoResult);
    }

    public void addPdo2GREsportati(MnoResult result) {
        this.pdo2GREsportati.add(result);
    }

    public void addPnoEsportato(MnoResult pnoResult) {
        this.pnoEsportati.add(pnoResult);
    }

    public Set<String> getErroriTariffe() {
        return this.erroriTariffe;
    }

    @Override
    public List<StatoPod> getStatiPod() {
        return this.statiPod;
    }

    private void addStatoPod(StatoPod statoPod) {
        this.statiPod.add(statoPod);
    }

    public void addStatiPod(List<StatoPod> stati) {
        for (StatoPod statoPod : stati) {
            this.addStatoPod(statoPod);
        }
    }

    public void setPrestazioni(SafeListMap<String, Prestazione> prestazioni) {
        this.prestazioni = prestazioni;
    }

    public SafeListMap<String, Prestazione> getPrestazioni() {
        return this.prestazioni;
    }

    @Override
    public Iterable<MnoResult> getPnoEsportati() {
        List<MnoResult> ephemeral = this.pnoEsportati;
        this.pnoEsportati = new ArrayList<MnoResult>();
        return ephemeral;
    }

    @Override
    public Iterable<MnoResult> getPdo2GREsportati() {
        List<MnoResult> ephemeral = this.pdo2GREsportati;
        this.pdo2GREsportati = new ArrayList<MnoResult>();
        return ephemeral;
    }

    public void addSmisEsportato(MnoResult result) {
        this.smisEsportati.add(result);
    }

    @Override
    public Iterable<MnoResult> getSmisEsportati() {
        return this.smisEsportati;
    }

    @Override
    public Iterable<PdoResult> getPdoEsportati() {
        List<PdoResult> ephemeral = this.pdoEsportati;
        this.pdoEsportati = new ArrayList<PdoResult>();
        return ephemeral;
    }

    public void addSofEsportato(SofResult result) {
        this.sofEsportati.add(result);
    }

    @Override
    public Iterable<SofResult> getSofEsportati() {
        return this.sofEsportati;
    }

    public void addSnfEsportato(SnfResult result) {
        this.snfEsportati.add(result);
    }

    @Override
    public Iterable<SnfResult> getSnfEsportati() {
        return this.snfEsportati;
    }

    public void addSnmEsportato(MnoResult result) {
        this.snmEsportati.add(result);
    }

    @Override
    public Iterable<MnoResult> getSnmEsportati() {
        return this.snmEsportati;
    }

    public void addRnoEsportato(MnoResult result) {
        this.rnoEsportati.add(result);
    }

    @Override
    public Iterable<MnoResult> getRnoEsportati() {
        return this.rnoEsportati;
    }

    public void addRfoEsportato(PdoResult result) {
        this.rfoEsportati.add(result);
    }

    @Override
    public Iterable<PdoResult> getRfoEsportati() {
        return this.rfoEsportati;
    }

    public void setPdos1GXml(List<Pdo> pdos1GXml) {
        this.pdos1GXml = new BasicListMap<Delibera, Pdo>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.pdos1GXml.addAll(pdos1GXml, extractor);
    }

    public ListMap<Delibera, Pdo> getPdos1GXml() {
        ListMap<Delibera, Pdo> effemeral = this.pdos1GXml;
        this.pdos1GXml = null;
        return effemeral;
    }

    public void setPdo2GNRXml(List<Pdo> pdo2GNRXml) {
        this.pdo2GNRXml = pdo2GNRXml;
    }

    public List<Pdo> getPdos2GNRXml() {
        List<Pdo> ephemeral = this.pdo2GNRXml;
        this.pdo2GNRXml = null;
        return ephemeral;
    }

    public void setRfo2GNRXml(List<Pdo> rfo2GNRXml) {
        this.rfo2GNRXml = rfo2GNRXml;
    }

    public List<Pdo> getRfo2GNRXml() {
        return this.rfo2GNRXml;
    }

    public List<Mno> getPdo2GRXml() {
        List<Mno> ephemeral = this.pdo2GRXml;
        this.pdo2GRXml = new ArrayList<Mno>();
        return ephemeral;
    }

    public void setPdo2GRXml(List<Mno> pdo2GRXml) {
        this.pdo2GRXml = pdo2GRXml;
    }

    public void setRfo2GRXml(List<Mno> rfo2GRXml) {
        this.rfo2GRXml = rfo2GRXml;
    }

    public List<Mno> getRfo2GRXml() {
        return this.rfo2GRXml;
    }

    public void setSnfs1GXml(List<Snf> snfsXml) {
        this.snfs1GXml = new BasicListMap<Delibera, Snf>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.snfs1GXml.addAll(snfsXml, extractor);
    }

    public void setF2GXml(List<Snf> f2gXml) {
        this.f2gXml = f2gXml;
    }

    public ListMap<Delibera, Snf> getSnfsXml() {
        return this.snfs1GXml;
    }

    public List<Snf> getF2gXml() {
        return this.f2gXml;
    }

    public void setSnmsXmlPod(List<Mno> snmsXml) {
        this.snmsXmlPod = new BasicListMap();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.snmsXmlPod.addAll(snmsXml, extractor);
    }

    public ListMap<Delibera, Mno> getSnmsXmlPod() {
        return this.snmsXmlPod;
    }

    public void setSnms1GXml(List<Mno> snmsXml) {
        this.snms1GXml = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.snms1GXml.addAll(snmsXml, extractor);
    }

    public ListMap<Delibera, Mno> getSnms1GXml() {
        return this.snms1GXml;
    }

    public ListMap<Delibera, Mno> getVpsXml() {
        return this.vpsXml;
    }

    public ListMap<Delibera, Mno> getVp2gsXml() {
        return this.vp2gsXml;
    }

    public ListMap<Delibera, Mno> getVpRsXml() {
        return this.vpRsXml;
    }

    public ListMap<Delibera, Mno> getVpR2gsXml() {
        return this.vpR2gsXml;
    }

    public void setVpXml(List<Mno> vpsXml) {
        this.vpsXml = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.vpsXml.addAll(vpsXml, extractor);
    }

    public void setVp2gXml(List<Mno> vp2gsXml) {
        this.vp2gsXml = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.vp2gsXml.addAll(vp2gsXml, extractor);
    }

    public void setVpRXml(List<Mno> vpRsXml) {
        this.vpRsXml = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.vpRsXml.addAll(vpRsXml, extractor);
    }

    public void setVpR2gXml(List<Mno> vpR2gsXml) {
        this.vpR2gsXml = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.vpR2gsXml.addAll(vpR2gsXml, extractor);
    }

    public ListMap<Delibera, Mno> getAvsXml() {
        return this.avsXml;
    }

    public void setAvXml(List<Mno> avsXml) {
        this.avsXml = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.avsXml.addAll(avsXml, extractor);
    }

    public ListMap<Delibera, Mno> getAvR2gsXml() {
        return this.avR2gsXml;
    }

    public void setAvR2gXml(List<Mno> avR2gsXml) {
        this.avR2gsXml = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.avR2gsXml.addAll(avR2gsXml, extractor);
    }

    public ListMap<Delibera, Mno> getAv2gsXml() {
        return this.av2gsXml;
    }

    public void setAv2gXml(List<Mno> av2gsXml) {
        this.av2gsXml = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.av2gsXml.addAll(av2gsXml, extractor);
    }

    public ListMap<Delibera, Mno> getAvRsXml() {
        return this.avRsXml;
    }

    public void setAvRXml(List<Mno> avRsXml) {
        this.avRsXml = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.avRsXml.addAll(avRsXml, extractor);
    }

    public void setSnms2GXml(List<Mno> snms2GXml) {
        this.snms2GXml = snms2GXml;
    }

    public List<Mno> getSnms2GXml() {
        return this.snms2GXml;
    }

    public void setSnms2GXmlPod(List<Mno> snms2GXmlPod) {
        this.snms2GXmlPod = snms2GXmlPod;
    }

    public List<Mno> getSnms2GXmlPod() {
        return this.snms2GXmlPod;
    }

    public void setSofs1GXml(List<Sof> sofsXml) {
        BasicListMap<Delibera, Sof> listMap = new BasicListMap<Delibera, Sof>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        listMap.addAll(sofsXml, extractor);
        this.sofs1GXml = listMap;
    }

    public ListMap<Delibera, Sof> getSofsXml() {
        return this.sofs1GXml;
    }

    public void setSofsXmlPod(List<Sof> sofsXml) {
        BasicListMap<Delibera, Sof> listMap = new BasicListMap<Delibera, Sof>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        listMap.addAll(sofsXml, extractor);
        this.sofsXmlPod = listMap;
    }

    public ListMap<Delibera, Sof> getSofsXmlPod() {
        return this.sofsXmlPod;
    }

    public void setRfosXml(List<Pdo> rfosXml) {
        this.rfosXml = new BasicListMap<Delibera, Pdo>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.rfosXml.addAll(rfosXml, extractor);
    }

    public ListMap<Delibera, Pdo> getRfosXml() {
        return this.rfosXml;
    }

    public void addRnoSospeso(MnoResult result) {
        this.rnoSospesi.add(result);
    }

    public List<MnoResult> getRnoSospesi() {
        return this.rnoSospesi;
    }

    public void addSmisEscluso(MnoResult result) {
        this.smisEsclusi.add(result);
    }

    public void addSmisObsoleto(MnoResult result) {
        this.smisObsoleti.add(result);
    }

    public void addSmisElaborato(MnoResult result) {
        this.smisElaborati.add(result);
    }

    public void addSmisSospeso(MnoResult result) {
        this.smisSospesi.add(result);
    }

    public void addSmEsportato(MnoResult result) {
        this.smEsportati.add(result);
    }

    public void addRtEsportato(MnoResult result) {
        this.rtEsportati.add(result);
    }

    public void addVnoEsportato(MnoResult result) {
        this.vnoEsportati.add(result);
    }

    public List<MnoResult> getSmEsportati() {
        return this.smEsportati;
    }

    public List<MnoResult> getRtEsportati() {
        return this.rtEsportati;
    }

    public List<MnoResult> getVnoEsportati() {
        return this.vnoEsportati;
    }

    public void setSmXml(List<Mno> smXml) {
        this.smXml = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.smXml.addAll(smXml, extractor);
    }

    public void setRtXml(List<Mno> rtXml) {
        this.rtXml = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.rtXml.addAll(rtXml, extractor);
    }

    public void setVnosXml(List<Mno> vnosXml) {
        this.vnosXml = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.vnosXml.addAll(vnosXml, extractor);
    }

    public ListMap<Delibera, Mno> getVnosXml() {
        return this.vnosXml;
    }

    public ListMap<Delibera, Mno> getRtXml() {
        return this.rtXml;
    }

    public ListMap<Delibera, Mno> getSmXml() {
        return this.smXml;
    }

    public void setVnosXmlPod(List<Mno> vnosXmlPod) {
        this.vnosXmlPod = new BasicListMap();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.vnosXmlPod.addAll(vnosXmlPod, extractor);
    }

    public ListMap<Delibera, Mno> getVnosXmlPod() {
        return this.vnosXmlPod;
    }

    private static <S extends AziendaContainer> void addSNoCrm(S item, Map<String, List<S>> map) {
        String azienda = item.getCdaziend();
        List<S> list = map.get(azienda);
        if (list == null) {
            list = new ArrayList<S>();
            map.put(azienda, list);
        }
        list.add(item);
    }

    public void setDispatchingFlussi(DispatchingFlussi dispatchingFlussi) {
        this.dispatchingFlussi = dispatchingFlussi;
    }

    public DispatchingFlussi getDispatchingFlussi() {
        return this.dispatchingFlussi;
    }

    @Override
    public Iterable<MnoResult> getSmisElaborati() {
        return this.smisElaborati;
    }

    @Override
    public Iterable<MnoResult> getSmisSospesi() {
        return this.smisSospesi;
    }

    @Override
    public Iterable<MnoResult> getSmisEsclusi() {
        return this.smisEsclusi;
    }

    @Override
    public Iterable<MnoResult> getSmisObsoleti() {
        return this.smisObsoleti;
    }

    public void addSmis(Pod pod, ExtMno smis) {
        this.pnos.addSmis(pod, smis);
    }

    public void setSmisXml(ListMapKey<String, Mno> smis) {
        this.smisXml = smis;
    }

    public ListMapKey<String, Mno> getSmisXml() {
        return this.smisXml;
    }

    public void setVno2gea(List<Mno2GE> vno2gea) {
        this.vno2gea.addAll(vno2gea);
    }

    public RecordMap<String, Mno2GE> getVno2gea() {
        return this.vno2gea;
    }

    public void setVno2ger(List<Mno2GE> vno2ger) {
        this.vno2ger.addAll(vno2ger);
    }

    public RecordMap<String, Mno2GE> getVno2ger() {
        return this.vno2ger;
    }

    public RecordMap<String, Mno2GE> getMisure2gEA() {
        RecordMap<String, Mno2GE> ephemeral = this.misure2gEA;
        this.misure2gEA = new DefaultRecordMap<String, Mno2GE>();
        return ephemeral;
    }

    public void setRno2gea(List<Mno2GE> pno2gea) {
        this.rno2gea.addAll(pno2gea);
    }

    public RecordMap<String, Mno2GE> getRno2gRer() {
        return this.rno2ger;
    }

    public RecordMap<String, Mno2GE> getRno2gRerc() {
        return this.rno2gerc;
    }

    public RecordMap<String, Mno2GE> getRno2gReri() {
        return this.rno2geri;
    }

    public void setRno2ger(List<Mno2GE> pno2ger) {
        this.rno2ger.addAll(pno2ger);
    }

    public void setRno2gerc(List<Mno2GE> pno2gerc) {
        this.rno2gerc.addAll(pno2gerc);
    }

    public void setRno2geri(List<Mno2GE> pno2geri) {
        this.rno2geri.addAll(pno2geri);
    }

    public RecordMap<String, Mno2GE> getRno2gRea() {
        return this.rno2gea;
    }

    public void setRnv2gea(List<Mno2GE> rnv2gea) {
        this.rnv2gea.addAll(rnv2gea);
    }

    public void setRnv2ger(List<Mno2GE> rnv2ger) {
        this.rnv2ger.addAll(rnv2ger);
    }

    public void setRnv2gerc(List<Mno2GE> rnv2gerc) {
        this.rnv2gerc.addAll(rnv2gerc);
    }

    public void setRnv2geri(List<Mno2GE> rnv2geri) {
        this.rnv2geri.addAll(rnv2geri);
    }

    public RecordMap<String, Mno2GE> getRnv2gRea() {
        return this.rnv2gea;
    }

    public RecordMap<String, Mno2GE> getRnv2gRer() {
        return this.rnv2ger;
    }

    public RecordMap<String, Mno2GE> getRnv2gRerc() {
        return this.rnv2gerc;
    }

    public RecordMap<String, Mno2GE> getRnv2gReri() {
        return this.rnv2geri;
    }

    public void setRsn2gea(List<Mno2GE> rsn2gea) {
        this.rsn2gea.addAll(rsn2gea);
    }

    public RecordMap<String, Mno2GE> getRsn2gRea() {
        return this.rsn2gea;
    }

    public void setRsn2ger(List<Mno2GE> rsn2ger) {
        this.rsn2ger.addAll(rsn2ger);
    }

    public void setRsn2gerc(List<Mno2GE> rsn2gerc) {
        this.rsn2gerc.addAll(rsn2gerc);
    }

    public void setRsn2geri(List<Mno2GE> rsn2geri) {
        this.rsn2geri.addAll(rsn2geri);
    }

    public RecordMap<String, Mno2GE> getRsn2gRer() {
        return this.rsn2ger;
    }

    public RecordMap<String, Mno2GE> getRsn2gRerc() {
        return this.rsn2gerc;
    }

    public RecordMap<String, Mno2GE> getRsn2gReri() {
        return this.rsn2geri;
    }

    public void setMisure2gEA(List<Mno2GE> misure2gEA) {
        this.misure2gEA.addAll(misure2gEA);
    }

    public RecordMap<String, Mno2GE> getMisure2gER() {
        RecordMap<String, Mno2GE> ephemeral = this.misure2gER;
        this.misure2gER = new DefaultRecordMap<String, Mno2GE>();
        return ephemeral;
    }

    public void setMisure2gER(List<Mno2GE> misure2gER) {
        this.misure2gER.addAll(misure2gER);
    }

    public void setRfo2gREa(List<Mno2GE> rfo2gREa) {
        this.rfo2gREa.addAll(rfo2gREa);
    }

    public RecordMap<String, Mno2GE> getMisure2gERc() {
        RecordMap<String, Mno2GE> ephemeral = this.misure2gERc;
        this.misure2gERc = new DefaultRecordMap<String, Mno2GE>();
        return ephemeral;
    }

    public void setMisure2gERc(List<Mno2GE> misure2gERc) {
        this.misure2gERc.addAll(misure2gERc);
    }

    public RecordMap<String, Mno2GE> getMisure2gERi() {
        RecordMap<String, Mno2GE> ephemeral = this.misure2gERi;
        this.misure2gERi = new DefaultRecordMap<String, Mno2GE>();
        return ephemeral;
    }

    public void setMisure2gERi(List<Mno2GE> misure2gERi) {
        this.misure2gERi.addAll(misure2gERi);
    }

    public RecordMap<String, Mno2GE> getRfo2gREa() {
        return this.rfo2gREa;
    }

    public void setRfo2gRer(List<Mno2GE> rfo2gRer) {
        this.rfo2gRer.addAll(rfo2gRer);
    }

    public RecordMap<String, Mno2GE> getRfo2gRer() {
        return this.rfo2gRer;
    }

    public void setRfo2gRerc(List<Mno2GE> rfo2gRerc) {
        this.rfo2gRerc.addAll(rfo2gRerc);
    }

    public RecordMap<String, Mno2GE> getRfo2gRerc() {
        return this.rfo2gRerc;
    }

    public void setRfo2gReri(List<Mno2GE> rfo2gReri) {
        this.rfo2gReri.addAll(rfo2gReri);
    }

    public RecordMap<String, Mno2GE> getRfo2gReri() {
        return this.rfo2gReri;
    }

    public void setPno2geaXmlPod(List<Mno2GE> pno2gea) {
        this.pno2geaXmlPod.addAll(pno2gea);
    }

    public void setPno2gerXmlPod(List<Mno2GE> pno2ger) {
        this.pno2gerXmlPod.addAll(pno2ger);
    }

    public RecordMap<String, Mno2GE> getPno2geaXmlPod() {
        return this.pno2geaXmlPod;
    }

    public RecordMap<String, Mno2GE> getPno2gerXmlPod() {
        return this.pno2gerXmlPod;
    }

    public RecordMap<String, Mno2GE> getSnm2geaXmlPod() {
        return this.snm2geaXmlPod;
    }

    public RecordMap<String, Mno2GE> getSnm2gerXmlPod() {
        return this.snm2gerXmlPod;
    }

    public void setSnm2geaXmlPod(List<Mno2GE> pno2gea) {
        this.snm2geaXmlPod.addAll(pno2gea);
    }

    public void setSnm2gerXmlPod(List<Mno2GE> pno2ger) {
        this.snm2gerXmlPod.addAll(pno2ger);
    }

    public RecordMap<String, Mno2GE> getSnm2gea() {
        return this.snm2gea;
    }

    public RecordMap<String, Mno2GE> getSnm2ger() {
        return this.snm2ger;
    }

    public void setSnm2gea(List<Mno2GE> snm2gea) {
        this.snm2gea.addAll(snm2gea);
    }

    public void setSnm2ger(List<Mno2GE> snm2ger) {
        this.snm2ger.addAll(snm2ger);
    }

    public void setPno1GXml(List<Mno> pno1GXml) {
        BasicListMap<Delibera, Mno> listMap = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        listMap.addAll(pno1GXml, extractor);
        this.pno1GXml = listMap;
    }

    public void setDS1GXml(List<Mno> mno) {
        BasicListMap<Delibera, Mno> listMap = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        listMap.addAll(mno, extractor);
        this.ds1GXml = listMap;
    }

    public void setDS2GXml(List<Mno> mno) {
        this.ds2GXml = mno;
    }

    public void setDSR2GXml(List<Mno> mno) {
        this.dsr2GXml = mno;
    }

    public void setDSR1GXml(List<Mno> mno) {
        BasicListMap<Delibera, Mno> listMap = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        listMap.addAll(mno, extractor);
        this.dsr1GXml = listMap;
    }

    public void setPnoXmlPod(List<Mno> pnos) {
        BasicListMap<Delibera, Mno> listMap = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        listMap.addAll(pnos, extractor);
        this.pnosXmlPod = listMap;
    }

    public ListMap<Delibera, Mno> getPnoXmlPod() {
        return this.pnosXmlPod;
    }

    public void setRnoXmlPod(List<Mno> rnos) {
        BasicListMap<Delibera, Mno> listMap = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        listMap.addAll(rnos, extractor);
        this.rnosXmlPod = listMap;
    }

    public ListMap<Delibera, Mno> getRnoXmlPod() {
        return this.rnosXmlPod;
    }

    public void setRnvXmlPod(List<Mno> rnvs) {
        BasicListMap<Delibera, Mno> listMap = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        listMap.addAll(rnvs, extractor);
        this.rnvsXmlPod = listMap;
    }

    public ListMap<Delibera, Mno> getRnvXmlPod() {
        return this.rnvsXmlPod;
    }

    public void setRsnXmlPod(List<Mno> rsns) {
        BasicListMap<Delibera, Mno> listMap = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        listMap.addAll(rsns, extractor);
        this.rsnsXmlPod = listMap;
    }

    public ListMap<Delibera, Mno> getRsnXmlPod() {
        return this.rsnsXmlPod;
    }

    public void setF2gXmlPod(List<Snf> f2gs) {
        this.f2gsXmlPod = f2gs;
    }

    public void setSnfXmlPod(List<Snf> snfs) {
        this.snfsXmlPod = new BasicListMap();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.snfsXmlPod.addAll(snfs, extractor);
    }

    public List<Snf> getF2gXmlPod() {
        return this.f2gsXmlPod;
    }

    public BasicListMap<Delibera, Snf> getSnfXmlPod() {
        return this.snfsXmlPod;
    }

    public void setPdoXmlPod(List<Pdo> pdos) {
        BasicListMap<Delibera, Pdo> listMap = new BasicListMap<Delibera, Pdo>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        listMap.addAll(pdos, extractor);
        this.pdoXmlPod = listMap;
    }

    public List<Mno> getPdo2GRXmlPod() {
        return this.pdo2gRXmlPod;
    }

    public void setRfoXmlPod(List<Pdo> rfos) {
        BasicListMap<Delibera, Pdo> listMap = new BasicListMap<Delibera, Pdo>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        listMap.addAll(rfos, extractor);
        this.rfoXmlPod = listMap;
    }

    public ListMap<Delibera, Pdo> getRfoXmlPod() {
        return this.rfoXmlPod;
    }

    public ListMap<Delibera, Pdo> getPdoXmlPod() {
        return this.pdoXmlPod;
    }

    public void setPno2GXml(List<Mno> pno2GXml) {
        this.pno2GXml = pno2GXml;
    }

    public List<Mno> getPno2GXml() {
        return this.pno2GXml;
    }

    public void setVno2GXml(List<Mno> vno2GXml) {
        this.vno2GXml = vno2GXml;
    }

    public void setRt2GXml(List<Mno> rt2GXml) {
        this.rt2GXml = rt2GXml;
    }

    public void setSm2GXml(List<Mno> sm2GXml) {
        this.sm2GXml = sm2GXml;
    }

    public List<Mno> getRtr2GXml() {
        return this.rtr2gXml;
    }

    public void setRtr2GRXml(List<Mno> rtr2GRXml) {
        this.rtr2gXml = rtr2GRXml;
    }

    public List<Mno> getVno2GXml() {
        return this.vno2GXml;
    }

    public List<Mno> getRt2GXml() {
        return this.rt2GXml;
    }

    public List<Mno> getSm2GXml() {
        return this.sm2GXml;
    }

    public List<Mno> getPno2GXmlPod() {
        return this.pno2GXmlPod;
    }

    public void setPno2GXmlPod(List<Mno> pno2GXml) {
        this.pno2GXmlPod = pno2GXml;
    }

    public ListMap<Delibera, Mno> getPno1GXml() {
        ListMap<Delibera, Mno> ephemeral = this.pno1GXml;
        this.pno1GXml = null;
        return ephemeral;
    }

    public ListMap<Delibera, Mno> getDS1GXml() {
        ListMap<Delibera, Mno> ephemeral = this.ds1GXml;
        this.ds1GXml = null;
        return ephemeral;
    }

    public List<Mno> getDS2GXml() {
        List<Mno> ephemeral = this.ds2GXml;
        this.ds2GXml = null;
        return ephemeral;
    }

    public List<Mno> getDSR2GXml() {
        List<Mno> ephemeral = this.dsr2GXml;
        this.dsr2GXml = null;
        return ephemeral;
    }

    public ListMap<Delibera, Mno> getDSR1GXml() {
        ListMap<Delibera, Mno> ephemeral = this.dsr1GXml;
        this.dsr1GXml = null;
        return ephemeral;
    }

    public DefaultPodMap getAllPods() {
        return this.allPods;
    }

    public void setAllPods(DefaultPodMap allPods) {
        this.allPods = allPods;
    }

    public PodMap getPodMap() {
        return this.podMap;
    }

    public void setPodMap(PodMap podMap) {
        this.podMap = podMap;
    }

    public void setRsnRnv(ListMap<String, Mno> rsnRnv) {
        this.rsnRnv = rsnRnv;
    }

    public void addRsvRnv(ListMap<String, Mno> newRsnRnv) {
        this.rsnRnv.addAll(newRsnRnv);
    }

    public ListMap<String, Mno> getRsnRnv() {
        return this.rsnRnv;
    }

    public void setRnvXml(List<Mno> rnvXml) {
        this.rnvXml = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.rnvXml.addAll(rnvXml, extractor);
    }

    public ListMap<Delibera, Mno> getRnvXml() {
        return this.rnvXml;
    }

    public void setRsnXml(List<Mno> rsnXml) {
        this.rsnXml = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.rsnXml.addAll(rsnXml, extractor);
    }

    public ListMap<Delibera, Mno> getRsnXml() {
        return this.rsnXml;
    }

    public void addSmisSospesi(Collection<ExtMno> smisList, ErroriElaborazione errore, String descrizione) {
        for (ExtMno smis : smisList) {
            Mno mno = smis.getMno();
            MnoResult result = new MnoResult(mno, errore, descrizione);
            this.addSmisSospeso(result);
        }
    }

    public void addMnoSospesi(Collection<Mno> pnoTecniche, PrebillingError errore, String descrizione, Date endDate) {
        for (Mno mno : pnoTecniche) {
            if (!mno.getDataMisura().before(endDate)) continue;
            MnoResult result = new MnoResult(mno, errore, descrizione);
            if (mno.getCodiceFlusso().toUpperCase().startsWith("PDO")) {
                this.addPdo2GRSospeso(result);
                continue;
            }
            this.addPnoSospeso(result);
        }
    }

    public void addPdo2GRSospesi(Collection<Mno> pnoTecniche, PrebillingError errore, String descrizione, Date endDate) {
        for (Mno mno : pnoTecniche) {
            if (!mno.getDataMisura().before(endDate)) continue;
            MnoResult result = new MnoResult(mno, errore, descrizione);
            this.addPdo2GRSospeso(result);
        }
    }

    public void addPnoEsclusi(Collection<Mno> esclusi, ErroriElaborazione errore, String descrizione) {
        for (Mno pno : esclusi) {
            MnoResult result = new MnoResult(pno, errore, descrizione);
            this.addPnoEscluso(result);
        }
    }

    public void addPdo2GREsclusi(Collection<Mno> esclusi, ErroriElaborazione errore, String descrizione) {
        for (Mno pno : esclusi) {
            MnoResult result = new MnoResult(pno, errore, descrizione);
            this.addPdo2GREscluso(result);
        }
    }

    public void addVnoSospesi(List<Mno> mnos, ErroriElaborazione errore, String descrizione) {
        for (Mno vno : mnos) {
            MnoResult result = new MnoResult(vno, errore, descrizione);
            this.addVnoSospeso(result);
        }
    }

    public void addUpdateStatiRichiesta(UpdateStatoPod statoPod) {
        this.updateStatiRichiesta.add(statoPod);
    }

    @Override
    public List<UpdateStatoPod> getUpdateStatiRichiesta() {
        return this.updateStatiRichiesta;
    }

    public void setVirtualPiv(Map<String, PraticaVolo> virtualPiv) {
        this.virtualPiv = virtualPiv;
    }

    public Map<String, PraticaVolo> getVirtualPiv() {
        return this.virtualPiv;
    }

    public void suspendPod(String codicePod, String description) {
        this.suspendedPod.put(codicePod, description);
    }

    public Map<String, String> getSuspendedPod() {
        return this.suspendedPod;
    }

    public Map<String, Map<TipoLetStd, MapWriter>> getMisureOrarieWriter() {
        return this.misureOrarieWriter;
    }

    public Map<String, Map<String, MapWriter>> getRettificheResellerWriter() {
        return this.rettificheResellerWriter;
    }

    public Map<String, Map<String, MapWriter>> getRettificheDispatcherWriter() {
        return this.rettificheDispatcherWriter;
    }

    public Map<String, Map<String, MapWriter>> getRettificheIVDispatcherWriter() {
        return this.rettificheIVDispatcherWriter;
    }

    public Map<String, Map<String, MapWriter>> getRettificheIVResellerWriter() {
        return this.rettificheIVResellerWriter;
    }

    public Map<String, Map<TipoLetStd, MapWriter>> getMisureNonorarieWriter() {
        return this.misureNonorarieWriter;
    }

    public Map<TipoLetStd, MapWriter> getMisureDispatcherWriter() {
        return this.misureDispatcherWriter;
    }

    private Map<TipoLetStd, MapWriter> getMisureOrarieWriter(String azienda) {
        Map<String, Map<TipoLetStd, MapWriter>> misureWriter = this.misureOrarieWriter;
        return ServiceStatus.getKeyMisureWriterMap(azienda, misureWriter);
    }

    public MapWriter getMisureOrarieWriter(String azienda, TipoLetStd tipo) {
        Map<TipoLetStd, MapWriter> misureWriterMap = this.getMisureOrarieWriter(azienda);
        return ServiceStatus.getKeyMisureWriter(tipo, misureWriterMap);
    }

    private Map<TipoLetStd, MapWriter> getMisureNonorarieWriter(String azienda) {
        Map<String, Map<TipoLetStd, MapWriter>> misureWriter = this.misureNonorarieWriter;
        return ServiceStatus.getKeyMisureWriterMap(azienda, misureWriter);
    }

    public MapWriter getMisureNonorarieWriter(String azienda, TipoLetStd tipo) {
        Map<TipoLetStd, MapWriter> misureWriter = this.getMisureNonorarieWriter(azienda);
        return ServiceStatus.getKeyMisureWriter(tipo, misureWriter);
    }

    public MapWriter getRettificheDispatcherWriter(String codiceFlusso, String azienda) {
        return ServiceStatus.getMisureWriter(codiceFlusso, azienda, this.rettificheDispatcherWriter);
    }

    public MapWriter getRettificheResellerWriter(String codiceFlusso, String azienda) {
        return ServiceStatus.getMisureWriter(codiceFlusso, azienda, this.rettificheResellerWriter);
    }

    public Map<String, MapWriter> getMisureTecnicheWriter() {
        return this.misureTecnicheWriter;
    }

    public Map<String, MapWriter> getRiconfigurazioniVoltureIVWriter() {
        return this.riconfVoltureIVWriter;
    }

    public MapWriter getMisureTecnicheDispatcherWriter() {
        return this.misureTecnicheDispatcherWriter;
    }

    public MapWriter getMisureTecnicheWriter(String azienda) {
        return ServiceStatus.getKeyMisureWriter(azienda, this.misureTecnicheWriter);
    }

    public MapWriter getRiconfigurazioniVoltureIVWriter(String azienda) {
        return ServiceStatus.getKeyMisureWriter(azienda, this.riconfVoltureIVWriter);
    }

    public MapWriter getSwitchoutXmlWriter(String key) {
        Map<String, MapWriter> misureWriter = this.switchoutXmlWriter;
        return ServiceStatus.getKeyMisureWriter(key, misureWriter);
    }

    public MapWriter getSwitchoutCsvWriter(String key) {
        Map<String, MapWriter> misureWriter = this.switchoutCsvWriter;
        return ServiceStatus.getKeyMisureWriter(key, misureWriter);
    }

    public MapWriter getRettificheSwitchoutCsvWriter(String azienda) {
        Map<String, MapWriter> misureWriter = this.rettificheSwitchoutCsvWriter;
        return ServiceStatus.getKeyMisureWriter(azienda, misureWriter);
    }

    public MapWriter getRettificheSwitchoutDispatcher() {
        return this.rettificheSwitchoutDispatcher;
    }

    public void addRettificheSwitchoutDispatcher(List<MisuraPod> rettifiche) {
        if (!rettifiche.isEmpty()) {
            MisuraPod misuraPod = rettifiche.get(0);
            String codicePod = misuraPod.getCodicePod();
            WriteLetstdService service = new WriteLetstdService(codicePod, this.configuration);
            Trattamento trattamento = misuraPod.getTrattamento();
            TrattamentoHandler handler = trattamento.getHandler();
            service.write(rettifiche, this.rettificheSwitchoutDispatcher, handler, false);
        }
    }

    public static MapWriter getMisureWriter(String codiceFlusso, String azienda, Map<String, Map<String, MapWriter>> misureWriter) {
        Map<String, MapWriter> misureFlussoWriter = misureWriter.get(codiceFlusso);
        if (misureFlussoWriter == null) {
            misureFlussoWriter = new LinkedHashMap<String, MapWriter>();
            misureWriter.put(codiceFlusso, misureFlussoWriter);
        }
        return ServiceStatus.getKeyMisureWriter(azienda, misureFlussoWriter);
    }

    private static <K> MapWriter getKeyMisureWriter(K key, Map<K, MapWriter> misureFlussoWriter) {
        Class<?> typeClass = new DefaultMapWriter().getClass();
        return StructuresHelper.getOrCreate(key, misureFlussoWriter, typeClass);
    }

    private static Map<TipoLetStd, MapWriter> getKeyMisureWriterMap(String azienda, Map<String, Map<TipoLetStd, MapWriter>> misureFlussoWriter) {
        Class<?> typeClass = new HashMap().getClass();
        return StructuresHelper.getOrCreate(azienda, misureFlussoWriter, typeClass);
    }

    public Map<String, MapWriter> getSwitchoutCsvWriter() {
        return this.switchoutCsvWriter;
    }

    public Map<String, MapWriter> getRettificheSwitchoutCsvWriter() {
        return this.rettificheSwitchoutCsvWriter;
    }

    public Map<String, MapWriter> getSwitchoutXmlWriter() {
        return this.switchoutXmlWriter;
    }

    public void setRnoXml(List<Mno> rnos) {
        this.rnosXml = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.rnosXml.addAll(rnos, extractor);
    }

    public ListMap<Delibera, Mno> getRnoXml() {
        return this.rnosXml;
    }

    public void setRno2GXml(List<Mno> rnos) {
        this.rnos2gXml = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.rnos2gXml.addAll(rnos, extractor);
    }

    public void setRnv2GXml(List<Mno> rnos) {
        this.rnvs2gXml = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.rnvs2gXml.addAll(rnos, extractor);
    }

    public ListMap<Delibera, Mno> getRno2GXml() {
        return this.rnos2gXml;
    }

    public ListMap<Delibera, Mno> getRnv2GXml() {
        return this.rnvs2gXml;
    }

    public void setRsn2GXml(List<Mno> rnos) {
        this.rsns2gXml = new BasicListMap<Delibera, Mno>();
        DeliberaExtractor extractor = new DeliberaExtractor();
        this.rsns2gXml.addAll(rnos, extractor);
    }

    public ListMap<Delibera, Mno> getRsn2GXml() {
        return this.rsns2gXml;
    }

    public OffertaCommerciale getOffertaCommerciale(String codiceOfferta) {
        OffertaCommerciale offertaCommerciale;
        try {
            offertaCommerciale = (OffertaCommerciale)this.offerteCommerciali.get(codiceOfferta);
        }
        catch (DataNotFoundException e2) {
            offertaCommerciale = new DefaultOffertaCommerciale(codiceOfferta, this.idCalendarioArera);
        }
        return offertaCommerciale;
    }

    public void addRiconfigurazioni(String azienda, ListMap<String, MisuraContatorePod> newRiconfigurazioni) {
        ListMap<String, MisuraContatorePod> ricListMap = this.riconfigurazioni.get(azienda);
        if (ricListMap == null) {
            ricListMap = new BasicListMap<String, MisuraContatorePod>();
            this.riconfigurazioni.put(azienda, ricListMap);
        }
        for (Map.Entry entry : newRiconfigurazioni.entrySet()) {
            String prefix = (String)entry.getKey();
            List values = (List)entry.getValue();
            ricListMap.put(prefix, values);
        }
    }

    public boolean checkRiconfigurazione2GR(String codicePod) {
        return !this.riconfigurazioniPod2GR.containsKey(codicePod);
    }

    public void addRiconfigurazionePod2GR(Mno mno) {
        String codicePod = mno.getCodicePod();
        this.riconfigurazioniPod2GR.put(codicePod, mno);
    }

    public Map<String, Mno> getRiconfigurazioniPod2GR() {
        return this.riconfigurazioniPod2GR;
    }

    public Map<String, ListMap<String, MisuraContatorePod>> getRiconfigurazioni() {
        return this.riconfigurazioni;
    }

    public Map<String, String> getMisureType() {
        return this.misureType;
    }

    public void setMisureType(Map<String, String> misureType) {
        this.misureType = misureType;
    }

    public void setMnoConsolidamento(ListMap<String, Mno> pnoAux) {
        this.pnoConsolidamento = pnoAux;
    }

    public ListMap<String, Mno> getMnoConsolidamento() {
        return this.pnoConsolidamento;
    }

    public void setPdoConsolidamento(ListMap<String, Mno> pdoConsolidamento) {
        this.pdoConsolidamento = pdoConsolidamento;
    }

    public ListMap<String, Mno> getPdoConsolidamento() {
        return this.pdoConsolidamento;
    }

    public void addPdo2gObsoleto(MnoResult result) {
        this.pdo2gObsoleti.add(result);
    }

    public void addPdo2gSospeso(MnoResult result) {
        this.pdo2gSospesi.add(result);
    }

    public void addPdo2gEscluso(MnoResult result) {
        this.pdo2gEsclusi.add(result);
    }

    public void addPdo2gElaborato(MnoResult result) {
        this.pdo2gElaborati.add(result);
    }

    @Override
    public List<MnoResult> getPdo2gObsoleti() {
        return this.pdo2gObsoleti;
    }

    @Override
    public List<MnoResult> getPdo2gSospesi() {
        return this.pdo2gSospesi;
    }

    @Override
    public List<MnoResult> getPdo2gEsclusi() {
        return this.pdo2gEsclusi;
    }

    @Override
    public List<MnoResult> getPdo2gElaborati() {
        return this.pdo2gElaborati;
    }

    public void setPdo2GRXmlPod(List<Mno> pdo2GRXmlPod) {
        this.pdo2gRXmlPod = pdo2GRXmlPod;
    }

    public void setPdo2gReaXmlPod(List<Mno2GE> pdo2gReaXmlPod) {
        this.pdo2gReaXmlPod.addAll(pdo2gReaXmlPod);
    }

    public void setPdo2gRerXmlPod(List<Mno2GE> pdo2gReaXmlPod) {
        this.pdo2gRerXmlPod.addAll(pdo2gReaXmlPod);
    }

    public RecordMap<String, Mno2GE> getPdo2gReaXmlPod() {
        return this.pdo2gReaXmlPod;
    }

    public RecordMap<String, Mno2GE> getPdo2gRerXmlPod() {
        return this.pdo2gRerXmlPod;
    }

    public void setFlussiReseller(List<FlussoReseller> flussiReseller) {
        this.flussiReseller = flussiReseller;
    }

    public List<FlussoReseller> getFlussiReseller() {
        return this.flussiReseller;
    }

    public void setResellerPodMap(ResellerPodMap resellerPodMap) {
        this.resellerPodMap = resellerPodMap;
    }

    public ResellerPodMap getResellerPodMap() {
        return this.resellerPodMap;
    }

    public void addLogRfo(Pdo rfo) {
        this.logRfo.add(rfo);
    }

    public List<Pdo> getLogRfo() {
        return this.logRfo;
    }

    @Override
    public List<Mno> getMisureDefault() {
        return this.misureDefault;
    }

    public PrebillingConfiguration getConfiguration() {
        return this.configuration;
    }

    public List<MisuraMno> getRiconfigurazioniMno() {
        return this.riconfigurazioniMno;
    }

    public void addRiconfigurazioneMno(MisuraMno misuraMno) {
        this.riconfigurazioniMno.add(misuraMno);
    }

    @Deprecated
    public void setPdoReseller(List<Pdo> pdo) {
        this.pdoReseller = ServiceStatus.buildPdoMap(pdo);
    }

    @Deprecated
    public void setRfoReseller(Map<Date, Map<String, Pdo>> rfo) {
        this.rfoReseller = rfo;
    }

    @Deprecated
    public void setRfoDispatcher(Map<Date, Map<String, Pdo>> rfo) {
        this.rfoDispatcher = rfo;
    }

    @Deprecated
    public void setPdoDispatcher(List<Pdo> pdo) {
        this.pdoDispatcher = ServiceStatus.buildPdoMap(pdo);
    }

    @Deprecated
    public DefaultSafeListMap<String, Pdo> getPdoReseller() {
        return this.pdoReseller;
    }

    @Deprecated
    public DefaultSafeListMap<String, Pdo> getPdoDispatcher() {
        return this.pdoDispatcher;
    }

    private static DefaultSafeListMap<String, Pdo> buildPdoMap(List<Pdo> pdo) {
        ErrorWrapper error = new ErrorWrapper("pdo", ErroriElaborazione.PDO_NOTFOUND);
        DefaultSafeListMap<String, Pdo> pdoMap = new DefaultSafeListMap<String, Pdo>(error);
        pdoMap.addAll(pdo);
        return pdoMap;
    }

    public void addTariffeOrarieResult(Destinatari destinatari, StatoMisure stato, ResultRecord<Pdo, PrebillingError> result) {
        ServiceStatus.addTariffeResult(this.tariffeOrarieResult, destinatari, stato, result);
    }

    public void addTariffeNonorarieResult(Destinatari destinatari, StatoMisure stato, ResultRecord<MisuraNonoraria, PrebillingError> result) {
        ServiceStatus.addTariffeResult(this.tariffeNonorarieResult, destinatari, stato, result);
    }

    private static <T extends IdFlusso> void addTariffeResult(Map<Destinatari, ListMap<StatoMisure, ResultRecord<T, PrebillingError>>> tariffeResult, Destinatari destinatari, StatoMisure stato, ResultRecord<T, PrebillingError> result) {
        List results;
        String messaggio = result.getMessaggio();
        Set<String> resultId = result.getId();
        ListMap<StatoMisure, ResultRecord<T, PrebillingError>> mappaStati = tariffeResult.get((Object)destinatari);
        if (mappaStati == null) {
            mappaStati = new BasicListMap<StatoMisure, ResultRecord<T, PrebillingError>>();
            tariffeResult.put(destinatari, mappaStati);
        }
        if ((results = (List)mappaStati.get(stato)) == null) {
            mappaStati.add(stato, result);
        } else {
            ResultRecord prev = StructuresHelper.findFirst(results, current -> current.getId().equals(resultId));
            if (prev == null) {
                mappaStati.add(stato, result);
            } else if (!messaggio.isEmpty()) {
                int index = results.indexOf(prev);
                results.set(index, result);
            }
        }
    }

    @Override
    public Map<Destinatari, ListMap<StatoMisure, ResultRecord<Pdo, PrebillingError>>> getTariffeOrarieResult() {
        return this.tariffeOrarieResult;
    }

    @Override
    public Map<Destinatari, ListMap<StatoMisure, ResultRecord<MisuraNonoraria, PrebillingError>>> getTariffeNonorarieResult() {
        return this.tariffeNonorarieResult;
    }

    public void setVoltureIV(Map<String, List<VolturaIV>> voltureIV2) {
        this.voltureIV = voltureIV2;
    }

    public Map<String, List<VolturaIV>> getVoltureIV() {
        return this.voltureIV;
    }

    public void addVolturaIVElaborata(VolturaIVResult result) {
        this.voltureIVElaborate.add(result);
    }

    public void addVolturaIVSospesa(VolturaIVResult result) {
        this.voltureIVSospese.add(result);
    }

    @Override
    public List<VolturaIVResult> getVoltureIVElaborate() {
        return this.voltureIVElaborate;
    }

    public MapWriter getMisureDispatcherWriter(TipoLetStd tipo) {
        return ServiceStatus.getKeyMisureWriter(tipo, this.misureDispatcherWriter);
    }

    public void addMisuraLateProcessing(MisuraNonorariaPod misura) {
        String azienda = misura.getPod().getAzienda();
        ListMap<String, MisuraNonorariaPod> misureAzienda = this.misureLateProcessing.get(azienda);
        if (misureAzienda == null) {
            misureAzienda = new BasicListMap<String, MisuraNonorariaPod>();
            this.misureLateProcessing.put(azienda, misureAzienda);
        }
        String prestazione = misura.getPrestazione();
        misureAzienda.add(prestazione, misura);
    }

    public Map<String, ListMap<String, MisuraNonorariaPod>> getMisureLateProcessing() {
        return this.misureLateProcessing;
    }

    public void setCoeffPerdite(SafeMap<Integer, Map<Date, Double>> coeffPerdite) {
        this.coeffPerdite = coeffPerdite;
    }

    public double getCoeffPerdite(int livello, Date data) throws MissingCoeffPerditeException, DataNotFoundException {
        Integer key = livello;
        Map coeffPerditeLivello = (Map)this.coeffPerdite.get(key);
        Iterator iterator = coeffPerditeLivello.keySet().iterator();
        double coeffPerditeData = -1.0;
        while (iterator.hasNext()) {
            Date dataAliquota = (Date)iterator.next();
            if (dataAliquota.after(data)) break;
            coeffPerditeData = (Double)coeffPerditeLivello.get(dataAliquota);
        }
        if (coeffPerditeData <= 0.0) {
            throw new MissingCoeffPerditeException(livello, data);
        }
        return coeffPerditeData;
    }

    public void setPraMap(PraMap praMap) {
        this.praMap = praMap;
    }

    public PraMap getPraMap() {
        return this.praMap;
    }

    public int getIdZona(String cdComIst) throws DataNotFoundException {
        return ((Comune)this.comuniMap.get(cdComIst)).getIdZona();
    }

    public void setComuniMap(SafeMap<String, Comune> comuniMap) {
        this.comuniMap = comuniMap;
    }

    public void addTariffeElaborateDispatcher(Map<String, TariffeMesePod> mappaTariffeAzienda) {
        for (TariffeMesePod tariffePod : mappaTariffeAzienda.values()) {
            for (List list : tariffePod.values()) {
                this.tariffeElaborateDispatcher.addAll(list);
            }
        }
    }

    public void addTariffeElaborateReseller(Map<String, TariffeMesePod> mappaTariffeAzienda) {
        for (TariffeMesePod tariffePod : mappaTariffeAzienda.values()) {
            for (List list : tariffePod.values()) {
                this.tariffeElaborateReseller.addAll(list);
            }
        }
    }

    public List<Tariffa> getTariffeElaborateDispatcher() {
        return this.tariffeElaborateDispatcher;
    }

    public List<Tariffa> getTariffeElaborateReseller() {
        return this.tariffeElaborateReseller;
    }

    @Override
    public List<MisuraNonoraria> getLetture() {
        return this.letture;
    }

    public void addLettura(MisuraNonoraria lettura) {
        String codiceFlusso = lettura.getCodiceFlusso();
        if (!FLUSSI_LETTURE_ORARIE.contains(codiceFlusso)) {
            this.letture.add(lettura);
        }
    }

    public void addLetture(List<? extends MisuraNonoraria> misure) {
        for (MisuraNonoraria misuraNonoraria : misure) {
            this.addLettura(misuraNonoraria);
        }
    }

    public void resetTariffeBatch() {
        this.tariffeElaborateDispatcher = new ArrayList<Tariffa>();
        this.tariffeElaborateReseller = new ArrayList<Tariffa>();
        this.tariffeOrarieResult = new LinkedHashMap<Destinatari, ListMap<StatoMisure, ResultRecord<Pdo, PrebillingError>>>();
        this.tariffeNonorarieResult = new LinkedHashMap<Destinatari, ListMap<StatoMisure, ResultRecord<MisuraNonoraria, PrebillingError>>>();
    }

    public void removeTariffeResult(String codicePod, String messaggio, PrebillingError errore) {
        ServiceStatus.removeResults(codicePod, messaggio, errore, this.tariffeOrarieResult);
        ServiceStatus.removeResults(codicePod, messaggio, errore, this.tariffeNonorarieResult);
    }

    private static <T extends DatiFlusso> void removeResults(String codicePod, String messaggio, PrebillingError errore, Map<Destinatari, ListMap<StatoMisure, ResultRecord<T, PrebillingError>>> results) {
        for (ListMap<StatoMisure, ResultRecord<T, PrebillingError>> destResult : results.values()) {
            ArrayList<ResultRecord> toBeAdded = new ArrayList<ResultRecord>();
            for (List list : destResult) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ResultRecord result = (ResultRecord)iterator.next();
                    DatiFlusso record = (DatiFlusso)result.getRecord();
                    String currPod = record.getCodicePod();
                    if (!currPod.equals(codicePod)) continue;
                    iterator.remove();
                    result.setMessaggio(messaggio);
                    result.setErrore(errore);
                    toBeAdded.add(result);
                }
            }
            for (ResultRecord resultRecord : toBeAdded) {
                destResult.add(StatoMisure.SOSPESO, resultRecord);
            }
        }
    }

    public void setCommitCount(int commitCount) {
        this.commitCount = commitCount;
    }

    public int getCommitCount() {
        return this.commitCount;
    }

    public void addMisuraPrestazione(String codicePod, Mno mno) {
        ListMap<GruppoFlussi, Mno> prestazioniPod;
        Date dataPrestazione = mno.getDataPrestazione();
        Map<String, ListMap<GruppoFlussi, Mno>> prestazioniData = this.misurePrestazioni.get(dataPrestazione);
        if (prestazioniData == null) {
            prestazioniData = new LinkedHashMap<String, ListMap<GruppoFlussi, Mno>>();
            this.misurePrestazioni.put(dataPrestazione, prestazioniData);
        }
        if ((prestazioniPod = prestazioniData.get(codicePod)) == null) {
            prestazioniPod = new BasicListMap<GruppoFlussi, Mno>();
            prestazioniData.put(codicePod, prestazioniPod);
        }
        String codiceFlusso = mno.getCodiceFlusso();
        GruppoFlussi gruppo = GruppoFlussi.getFromFlusso(codiceFlusso);
        prestazioniPod.add(gruppo, mno);
    }

    public Map<Date, Map<String, ListMap<GruppoFlussi, Mno>>> getMisurePrestazioni() {
        return this.misurePrestazioni;
    }

    @Override
    public void count(String counter, String codiceProcesso) {
        this.count(counter, codiceProcesso, 1);
    }
}

