/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model;

import biz.elabor.prebilling.model.misure.DateContainer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.structures.KeyRecord;
import org.homelinux.elabor.structures.safe.SimpleSafeListMap;

public class ListMapKeyDate<T extends DateContainer & KeyRecord<String>>
extends SimpleSafeListMap<String, T> {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd-MM-yyyy");

    public ListMapKeyDate(String label) {
        super(label);
    }

    public T get(String codice, Date dataMisura) throws DataNotFoundException {
        ElaborCalendar calendar = new ElaborCalendar(dataMisura);
        calendar.setGiorno(1);
        calendar.addMesi(2);
        calendar.addGiorni(-1);
        Date lastDate = calendar.getDate();
        return this.get(codice, dataMisura, lastDate);
    }

    public T get(String codice, Date dataMisura, Date lastDate) throws DataNotFoundException {
        List misure = (List)this.get(codice);
        DateContainer value = null;
        Iterator iterator = misure.iterator();
        while (value == null && iterator.hasNext()) {
            DateContainer misura = (DateContainer)iterator.next();
            Date date = misura.getDate();
            if (date.after(lastDate)) break;
            if (!dataMisura.before(date)) continue;
            value = misura;
        }
        if (value == null) {
            String label = this.getLabel();
            String formatDate = DATE_FORMAT.format(dataMisura);
            throw new DataNotFoundException(String.valueOf(label) + ".notfound", String.valueOf(codice) + "/" + formatDate);
        }
        return (T)value;
    }
}

