/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.model;

import biz.elabor.prebilling.model.InvalidCurvaRilevazioniException;
import biz.elabor.prebilling.model.indici.CurvaIndiciGiornaliera;
import biz.elabor.prebilling.model.indici.CurvaIndiciMensile;
import biz.elabor.prebilling.model.indici.IndiceOrario;
import biz.elabor.prebilling.model.indici.InvalidCurvaIndiciException;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.misure.RilQuarto;
import biz.elabor.prebilling.services.HelperTest;
import java.util.Date;
import junit.framework.TestCase;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.DaysOfMonthIterator;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;

public class CurvaIndiciMensileTest
extends TestCase {
    public void testMultiply() throws InvalidCurvaIndiciException, InvalidCurvaRilevazioniException {
        CurvaIndiciMensile curva = new CurvaIndiciMensile(2017, Month.JUNE);
        int giorno = 1;
        while (giorno <= 30) {
            Date data = CalendarTools.getDate(2016, Month.JUNE, giorno);
            CurvaIndiciGiornaliera curvaGiorno = new CurvaIndiciGiornaliera(data);
            int ora = 1;
            while (ora <= 24) {
                curvaGiorno.add(new IndiceOrario(1, 2, data, ora, ora % 3 * 100));
                ++ora;
            }
            curva.add(curvaGiorno);
            ++giorno;
        }
        RilMese rilMese = new RilMese(null, 2016, Month.JUNE, null);
        DaysOfMonthIterator iterator = new DaysOfMonthIterator(2016, Month.JUNE);
        ElaborCalendar calendar = new ElaborCalendar(2016, Month.JUNE);
        while (iterator.hasNext()) {
            int giorno2 = iterator.next();
            calendar.setGiorno(giorno2);
            Date date = calendar.getDate();
            RilGiorno rilGiorno = new RilGiorno(date);
            int quarto = 0;
            while (quarto < 96) {
                RilQuarto rilQuarto = HelperTest.createRilQuarto(quarto, giorno2 * quarto, giorno2 * quarto * 2, giorno2 * quarto * 2, giorno2 * quarto * 2);
                rilGiorno.add(rilQuarto);
                ++quarto;
            }
            rilMese.add(rilGiorno);
        }
        curva.multiply(rilMese);
        CurvaIndiciMensileTest.assertEquals(600.0, ((IndiceOrario)((CurvaIndiciGiornaliera)curva.get(0)).get(0)).getPrezzo(), 1.0E-6);
        CurvaIndiciMensileTest.assertEquals(4400.0, ((IndiceOrario)((CurvaIndiciGiornaliera)curva.get(0)).get(1)).getPrezzo(), 1.0E-6);
        CurvaIndiciMensileTest.assertEquals(0.0, ((IndiceOrario)((CurvaIndiciGiornaliera)curva.get(0)).get(2)).getPrezzo(), 1.0E-6);
        CurvaIndiciMensileTest.assertEquals(34200.0, ((IndiceOrario)((CurvaIndiciGiornaliera)curva.get(0)).get(21)).getPrezzo(), 1.0E-6);
        CurvaIndiciMensileTest.assertEquals(71600.0, ((IndiceOrario)((CurvaIndiciGiornaliera)curva.get(0)).get(22)).getPrezzo(), 1.0E-6);
        CurvaIndiciMensileTest.assertEquals(0.0, ((IndiceOrario)((CurvaIndiciGiornaliera)curva.get(0)).get(23)).getPrezzo(), 1.0E-6);
        CurvaIndiciMensileTest.assertEquals(18000.0, ((IndiceOrario)((CurvaIndiciGiornaliera)curva.get(29)).get(0)).getPrezzo(), 1.0E-6);
        CurvaIndiciMensileTest.assertEquals(132000.0, ((IndiceOrario)((CurvaIndiciGiornaliera)curva.get(29)).get(1)).getPrezzo(), 1.0E-6);
        CurvaIndiciMensileTest.assertEquals(0.0, ((IndiceOrario)((CurvaIndiciGiornaliera)curva.get(29)).get(2)).getPrezzo(), 1.0E-6);
        CurvaIndiciMensileTest.assertEquals(1026000.0, ((IndiceOrario)((CurvaIndiciGiornaliera)curva.get(29)).get(21)).getPrezzo(), 1.0E-6);
        CurvaIndiciMensileTest.assertEquals(2148000.0, ((IndiceOrario)((CurvaIndiciGiornaliera)curva.get(29)).get(22)).getPrezzo(), 1.0E-6);
        CurvaIndiciMensileTest.assertEquals(0.0, ((IndiceOrario)((CurvaIndiciGiornaliera)curva.get(29)).get(23)).getPrezzo(), 1.0E-6);
    }
}

