/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.functest;

import biz.elabor.prebilling.functest.FunctionalTest;
import biz.elabor.prebilling.services.NullMockStatoPod;
import java.text.ParseException;
import java.util.Date;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;

class MockCsvStatoPod
extends NullMockStatoPod {
    private final String[] row;

    public MockCsvStatoPod(String[] row) {
        this.row = row;
    }

    @Override
    public boolean getFlmisCon() {
        return true;
    }

    @Override
    public int getNuprogre() {
        return Integer.parseInt(this.row[5].trim());
    }

    @Override
    public String getCpGestore() {
        return this.row[4].trim();
    }

    @Override
    public String getStato() {
        return this.row[0].trim();
    }

    @Override
    public Date getDataCessazione() {
        return MockCsvStatoPod.getDate(this.row[3]);
    }

    @Override
    public Date getDataMovimento() {
        return MockCsvStatoPod.getDate(this.row[2]);
    }

    @Override
    public Date getDataAttivazione() {
        return this.row.length > 13 && !this.row[13].trim().isEmpty() ? MockCsvStatoPod.getDate(this.row[13]) : CalendarTools.getDate(2018, Month.APRIL, 15);
    }

    @Override
    public String getPod() {
        return this.row[0].trim();
    }

    private static Date getDate(String value) {
        try {
            return value.trim().isEmpty() ? null : FunctionalTest.DATE_FORMAT.parse(value.trim());
        }
        catch (ParseException exc) {
            throw new RuntimeException(exc);
        }
    }

    @Override
    public boolean isPraticaAnnullata() {
        return this.row[6].trim().equals("true");
    }

    @Override
    public boolean getFlagOrario() {
        return this.row[7].trim().equals("true");
    }

    @Override
    public String getNuMatrA() {
        return this.row.length > 8 && !this.row[8].trim().isEmpty() ? this.row[8].trim() : "spimatr";
    }

    @Override
    public String getNuMatricBio() {
        return "";
    }

    @Override
    public String getCdunipre() {
        return this.row.length > 9 ? this.row[9].trim() : null;
    }

    @Override
    public String getCdFlusso() {
        return this.row.length > 10 ? this.row[10].trim() : "SNF";
    }

    @Override
    public String getCf() {
        return this.row.length > 12 && !this.row[12].trim().isEmpty() ? this.row[12].trim() : null;
    }

    @Override
    public String getServizioTutela() {
        return "sertutold";
    }

    @Override
    public Date getDataPrestazione() {
        String data = this.row.length > 11 ? this.row[11].trim() : null;
        try {
            return data == null || data.trim().isEmpty() ? null : FunctionalTest.DATE_FORMAT.parse(data);
        }
        catch (ParseException exc) {
            throw new RuntimeException(exc);
        }
    }

    @Override
    public String getCpUtente() {
        return this.row.length > 14 ? this.row[14].trim() : null;
    }

    @Override
    public boolean isFlMisBio() {
        return this.row.length > 15 ? Boolean.parseBoolean(this.row[15].trim()) : false;
    }
}

