/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.functest;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.misure.model.fasce.FasciaOraria2G;
import biz.elabor.prebilling.common.dao.StatoElaborazione;
import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.common.model.Applicazione;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.common.model.TipoFlat;
import biz.elabor.prebilling.common.model.TipoTrattamento;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.config.map.DefaultConfigurationInstance;
import biz.elabor.prebilling.functest.CSVMockDaoHelper;
import biz.elabor.prebilling.functest.CSVMockGiadaDao;
import biz.elabor.prebilling.functest.CSVMockIndiciDao;
import biz.elabor.prebilling.functest.CSVMockMisureDao;
import biz.elabor.prebilling.functest.CSVMockPrebillingConfiguration;
import biz.elabor.prebilling.functest.CSVMockPrebillingDao;
import biz.elabor.prebilling.functest.MockMessageSource;
import biz.elabor.prebilling.functest.TestInitialiser;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Mno2GE;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.misure.RilQuarto;
import biz.elabor.prebilling.model.misure.Rno;
import biz.elabor.prebilling.services.HelperTest;
import biz.elabor.prebilling.services.letture.PrebillingTestHelper;
import biz.elabor.prebilling.web.common.JsonRequestHandler;
import biz.elabor.test.TextTestHelper;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.DaysOfMonthIterator;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.csv.CsvReader;
import org.homelinux.elabor.file.FileSystemTools;
import org.homelinux.elabor.file.InvalidFileFormat;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class FunctionalTest
extends TestCase {
    static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String[] PREFISSI = new String[]{"Ea", "Er", "Pot"};
    private static String id;

    public void notestSingoloCSV() throws IOException, ParseException, InvalidFileFormat, InvalidParameterValue {
        File outputFolder = CSVMockPrebillingConfiguration.getOutputFolder();
        TextTestHelper.clearFolder(outputFolder);
        CSVMockPrebillingConfiguration configuration = new CSVMockPrebillingConfiguration();
        File samplesFolder = new File("samples");
        File file = new File(samplesFolder, "test-016-export-xml-filtri-pno2g");
        FunctionalTest.testCSV(configuration, outputFolder, file);
    }

    public void testCSV() throws IOException, ParseException, InvalidFileFormat, InvalidParameterValue {
        File outputFolder = CSVMockPrebillingConfiguration.getOutputFolder();
        TextTestHelper.clearFolder(outputFolder);
        CSVMockPrebillingConfiguration configuration = new CSVMockPrebillingConfiguration();
        File samplesFolder = new File("samples");
        Object[] files = samplesFolder.listFiles();
        Arrays.sort(files);
        Object[] objectArray = files;
        int n2 = files.length;
        int n3 = 0;
        while (n3 < n2) {
            Object file = objectArray[n3];
            if (((File)file).isDirectory() && ((File)file).getName().startsWith("test-")) {
                System.err.println(((File)file).getAbsolutePath());
                FunctionalTest.testCSV(configuration, outputFolder, (File)file);
            }
            ++n3;
        }
    }

    private static void testCSV(CSVMockPrebillingConfiguration configuration, File outputFolder, File testFolder) throws IOException, ParseException, InvalidFileFormat, InvalidParameterValue {
        id = "";
        File tmpFolder = configuration.getTmpFolder();
        TextTestHelper.clearFolder(tmpFolder);
        TextTestHelper.clearFolder(outputFolder);
        FunctionalTest.assertTrue(testFolder.exists());
        configuration.setCrm(testFolder);
        configuration.setTrunking(testFolder);
        CSVMockGiadaDao giadaDao = new CSVMockGiadaDao(testFolder);
        double mult = configuration.isTrunking() ? 1.00003 : 1.0;
        CSVMockMisureDao misureDao = new CSVMockMisureDao(testFolder, mult);
        CSVMockPrebillingDao prebillingDao = new CSVMockPrebillingDao(testFolder);
        CSVMockIndiciDao indiciDao = new CSVMockIndiciDao(testFolder);
        TalkManager talkManager = new TalkManager();
        MockMessageSource messageSource = new MockMessageSource();
        talkManager.setMessageSource(messageSource);
        DefaultConfigurationInstance configurationInstance = new DefaultConfigurationInstance(prebillingDao, misureDao, giadaDao, indiciDao, configuration);
        JsonRequestHandler handler = FunctionalTest.loadInitialiser(testFolder, configurationInstance, talkManager);
        if (handler != null) {
            FunctionalTest.touchFile(testFolder, configuration);
            String json = handler.handleRequest(configurationInstance);
            FunctionalTest.checkResponse(testFolder, json);
            List<String[]> statiPdo = misureDao.getStatiPdo();
            FunctionalTest.checkPdoStatus(testFolder, statiPdo);
            List<String[]> statiSnm = misureDao.getStatiSnm();
            FunctionalTest.checkSnmStatus(testFolder, statiSnm);
            List<String[]> statiSnf = misureDao.getStatiSnf();
            FunctionalTest.checkSnfStatus(testFolder, statiSnf);
            List<String[]> statiPno = misureDao.getStatiPno();
            FunctionalTest.checkPnoStatus(testFolder, statiPno);
            List<String[]> statiSmis = misureDao.getStatiSmis();
            FunctionalTest.checkSmisStatus(testFolder, statiSmis);
            List<String[]> statiSof = misureDao.getStatiSof();
            FunctionalTest.checkSofStatus(testFolder, statiSof);
            List<String[]> statiVno = misureDao.getStatiVno();
            FunctionalTest.checkVnoStatus(testFolder, statiVno);
            List<String[]> statiRnv = misureDao.getStatiRnv();
            FunctionalTest.checkRnvStatus(testFolder, statiRnv);
            List<String[]> statiRsn = misureDao.getStatiRsn();
            FunctionalTest.checkRsnStatus(testFolder, statiRsn);
            List<String[]> statiRfo = misureDao.getStatiRfo();
            FunctionalTest.checkRfoStatus(testFolder, statiRfo);
            List<String[]> statiRno = misureDao.getStatiRno();
            FunctionalTest.checkRnoStatus(testFolder, statiRno);
            List<TipoStato> sequenzaStati = prebillingDao.getSequenzaStati();
            FunctionalTest.checkSequenzaStati(sequenzaStati, testFolder);
            File checkFolder = new File(testFolder, "output");
            TextTestHelper.checkFolder(checkFolder, outputFolder);
            List<String[]> statiPod = misureDao.getStatiPod();
            FunctionalTest.checkStatiPod(testFolder, statiPod);
            List<String[]> updateStatiPod = misureDao.getUpdateStatiPod();
            FunctionalTest.checkUpdateStatiPod(testFolder, updateStatiPod);
            TextTestHelper.clearFolder(outputFolder);
            outputFolder.delete();
        }
    }

    private static void checkUpdateStatiPod(File testFolder, List<String[]> actual) throws IOException {
        int actualSize;
        String fileName = "stato-pod-update.csv";
        List<String[]> expected = FunctionalTest.loadStato(testFolder, "stato-pod-update.csv");
        int expectedSize = expected.size();
        if (expectedSize != (actualSize = actual.size())) {
            String filePath = new File(testFolder, "stato-pod-update.csv").getAbsolutePath();
            System.err.println(filePath);
        }
        int index = 0;
        while (index < Math.min(expectedSize, actualSize)) {
            int actualRowLength;
            String[] actualRow = actual.get(index);
            String[] expectedRow = expected.get(index);
            int expectedRowLength = expectedRow.length;
            if (expectedRowLength != (actualRowLength = actualRow.length)) {
                String filePath = new File(testFolder, "stato-pod-update.csv").getAbsolutePath();
                System.err.println(filePath);
            }
            int rowIndex = 0;
            while (rowIndex < expectedRowLength) {
                FunctionalTest.assertEquals(expectedRow[rowIndex], actualRow[rowIndex]);
                ++rowIndex;
            }
            FunctionalTest.assertEquals(expectedRowLength, actualRowLength);
            ++index;
        }
        FunctionalTest.assertEquals(expectedSize, actualSize);
    }

    private static void checkStatiPod(File testFolder, List<String[]> actual) throws IOException {
        int actualSize;
        String fileName = "stato-pod-out.csv";
        List<String[]> expected = FunctionalTest.loadStato(testFolder, "stato-pod-out.csv");
        int expectedSize = expected.size();
        if (expectedSize != (actualSize = actual.size())) {
            String filePath = new File(testFolder, "stato-pod-out.csv").getAbsolutePath();
            System.err.println(filePath);
        }
        int index = 0;
        while (index < Math.min(expectedSize, actualSize)) {
            String[] actualRow = actual.get(index);
            String[] expectedRow = expected.get(index);
            int expectedRowLength = expectedRow.length;
            int actualRowLength = actualRow.length;
            if (actualRow[actualRowLength - 1] == null) {
                --actualRowLength;
            }
            if (expectedRowLength != actualRowLength) {
                String filePath = new File(testFolder, "stato-pod-out.csv").getAbsolutePath();
                System.err.println(filePath);
            }
            int rowIndex = 0;
            while (rowIndex < expectedRowLength) {
                FunctionalTest.assertEquals(expectedRow[rowIndex], actualRow[rowIndex]);
                ++rowIndex;
            }
            FunctionalTest.assertEquals(expectedRowLength, actualRowLength);
            ++index;
        }
        FunctionalTest.assertEquals(expectedSize, actualSize);
    }

    private static void checkVnoStatus(File testFolder, List<String[]> stati) throws IOException {
        FunctionalTest.checkMisureStatus(testFolder, "stato-vno-out.csv", stati);
    }

    private static void checkRnvStatus(File testFolder, List<String[]> stati) throws IOException {
        FunctionalTest.checkMisureStatus(testFolder, "stato-rnv-out.csv", stati);
    }

    private static void checkRsnStatus(File testFolder, List<String[]> stati) throws IOException {
        FunctionalTest.checkMisureStatus(testFolder, "stato-rsn-out.csv", stati);
    }

    private static void checkSmisStatus(File testFolder, List<String[]> stati) throws IOException {
        FunctionalTest.checkMisureStatus(testFolder, "stato-smis-out.csv", stati);
    }

    private static void checkPnoStatus(File testFolder, List<String[]> stati) throws IOException {
        FunctionalTest.checkMisureStatus(testFolder, "stato-pno-out.csv", stati);
    }

    private static void checkSnmStatus(File testFolder, List<String[]> stati) throws IOException {
        FunctionalTest.checkMisureStatus(testFolder, "stato-snm-out.csv", stati);
    }

    private static void checkSnfStatus(File testFolder, List<String[]> stati) throws IOException {
        FunctionalTest.checkMisureStatus(testFolder, "stato-snf-out.csv", stati);
    }

    private static void checkSofStatus(File testFolder, List<String[]> stati) throws IOException {
        FunctionalTest.checkMisureStatus(testFolder, "stato-sof-out.csv", stati);
    }

    private static void checkPdoStatus(File testFolder, List<String[]> stati) throws IOException {
        FunctionalTest.checkMisureStatus(testFolder, "stato-pdo-out.csv", stati);
    }

    private static void checkRfoStatus(File testFolder, List<String[]> stati) throws IOException {
        FunctionalTest.checkMisureStatus(testFolder, "stato-rfo-out.csv", stati);
    }

    private static void checkRnoStatus(File testFolder, List<String[]> stati) throws IOException {
        FunctionalTest.checkMisureStatus(testFolder, "stato-rno-out.csv", stati);
    }

    private static void checkMisureStatus(File testFolder, String fileName, List<String[]> actual) throws IOException {
        int actualSize;
        List<String[]> expected = FunctionalTest.loadStato(testFolder, fileName);
        int expectedSize = expected.size();
        if (expectedSize != (actualSize = actual.size())) {
            String filePath = new File(testFolder, fileName).getAbsolutePath();
            System.err.println(filePath);
        }
        int index = 0;
        while (index < Math.min(expectedSize, actualSize)) {
            String[] actualRow = actual.get(index);
            String[] expectedRow = expected.get(index);
            int rowIndex = 0;
            while (rowIndex < expectedRow.length) {
                FunctionalTest.assertEquals(expectedRow[rowIndex], actualRow[rowIndex]);
                ++rowIndex;
            }
            ++index;
        }
        FunctionalTest.assertEquals(expectedSize, actualSize);
    }

    @Deprecated
    private static void touchFile(File testFolder, PrebillingConfiguration configuration) throws IOException {
        File file = new File(testFolder, "touch");
        StringWriter writer = new StringWriter();
        if (file.exists()) {
            FileSystemTools.read(file, writer);
            Funzionalita funzionalita = Funzionalita.valueOf(writer.toString().trim().toUpperCase());
            File folder = ConfigurationHelper.getTmpFolder(configuration, null, funzionalita);
            folder.mkdirs();
            File touch = new File(folder, "touch");
            touch.createNewFile();
        }
    }

    private static void checkResponse(File testFolder, String json) throws UnsupportedEncodingException, IOException {
        TextTestHelper.checkJsonFile(testFolder, "response.json", json);
    }

    public static Map<String, Applicazione> loadApplicazioni(File file) throws IOException {
        LinkedHashMap<String, Applicazione> applicazioni = new LinkedHashMap<String, Applicazione>();
        if (file.exists()) {
            try (CsvReader reader = new CsvReader(";");){
                reader.setFile(file);
                String[] row = reader.getNextRow();
                while (reader.hasNext()) {
                    row = reader.next();
                    Applicazione applicazione = FunctionalTest.getApplicazione(row);
                    applicazioni.put(applicazione.getKey(), applicazione);
                }
            }
        }
        return applicazioni;
    }

    public static Map<String, StatoElaborazione> loadStato(File file) throws IOException, ParseException {
        HashMap<String, StatoElaborazione> tabellaStato = new HashMap<String, StatoElaborazione>();
        if (file.exists()) {
            try (CsvReader reader = new CsvReader(";");){
                reader.setFile(file);
                String[] row = reader.getNextRow();
                while (reader.hasNext()) {
                    row = reader.next();
                    Funzionalita funzionalita = Funzionalita.valueOf(row[0]);
                    TipoStato tipoStato = TipoStato.valueOf(row[1]);
                    Date data = CSVMockDaoHelper.getDate(row[2]);
                    StatoElaborazione stato = new StatoElaborazione(tipoStato, data, "test");
                    tabellaStato.put(funzionalita.name(), stato);
                }
            }
        }
        return tabellaStato;
    }

    public static List<String> loadSequenzaStati(File file) throws IOException {
        ArrayList<String> tipiStato = new ArrayList<String>();
        if (file.exists()) {
            try (CsvReader reader = new CsvReader(";");){
                reader.setFile(file);
                String[] row = reader.getNextRow();
                while (reader.hasNext()) {
                    row = reader.next();
                    tipiStato.add(row[0].trim());
                }
            }
        }
        return tipiStato;
    }

    public static List<String[]> loadStato(File folder, String fileName) throws IOException {
        ArrayList<String[]> rows = new ArrayList<String[]>();
        File file = new File(folder, fileName);
        if (file.exists()) {
            try (CsvReader reader = new CsvReader(";");){
                reader.setFile(file);
                String[] row = reader.getNextRow();
                while (reader.hasNext()) {
                    row = reader.next();
                    rows.add(row);
                }
            }
        }
        return rows;
    }

    public static List<Rno> loadRnos(File folder, String fileName, boolean dueG, boolean delibera65, String flusso) throws IOException, ParseException {
        ArrayList<Rno> mnos = new ArrayList<Rno>();
        File file = new File(folder, fileName);
        if (file.exists()) {
            try (CsvReader reader = new CsvReader(";");){
                reader.setFile(file);
                String[] row = reader.getNextRow();
                while (reader.hasNext()) {
                    row = reader.next();
                    Mno mno = FunctionalTest.getMno(row, dueG, delibera65, flusso);
                    mnos.add(new Rno(mno, "azienda1", true, true, true, true));
                }
            }
        }
        return mnos;
    }

    public static List<Mno> loadMnos(File folder, String fileName, boolean dueG, boolean delibera65, String flusso) throws IOException, ParseException {
        ArrayList<Mno> mnos = new ArrayList<Mno>();
        File file = new File(folder, fileName);
        if (file.exists()) {
            try (CsvReader reader = new CsvReader(";");){
                reader.setFile(file);
                String[] row = reader.getNextRow();
                while (reader.hasNext()) {
                    row = reader.next();
                    Mno mno = FunctionalTest.getMno(row, dueG, delibera65, flusso);
                    mnos.add(mno);
                }
            }
        }
        return mnos;
    }

    public static List<Mno2GE> loadPno2GEnergia(File folder, String fileName) throws IOException, ParseException {
        ArrayList<Mno2GE> pno2geList = new ArrayList<Mno2GE>();
        File file = new File(folder, fileName);
        if (file.exists()) {
            try (CsvReader reader = new CsvReader(";");){
                reader.setFile(file);
                String[] row = reader.getNextRow();
                while (reader.hasNext()) {
                    row = reader.next();
                    Mno2GE pno2ge = FunctionalTest.getPno2GE(row);
                    pno2geList.add(pno2ge);
                }
            }
        }
        return pno2geList;
    }

    private static Mno2GE getPno2GE(String[] row) throws ParseException {
        Double[] energiaOraria = FunctionalTest.generaEnergia();
        Double[] energiaFascia = new Double[6];
        String codicePod = row[0];
        Date data = CSVMockDaoHelper.getDate(row[1]);
        return new Mno2GE(codicePod, data, null, energiaOraria, energiaFascia);
    }

    private static Double[] generaEnergia() {
        Double[] energia = new Double[96];
        int index = 1;
        while (index <= energia.length) {
            energia[index - 1] = index;
            ++index;
        }
        return energia;
    }

    private static Mno getMno(String[] row, boolean dueG, boolean delibera65, String flusso) throws ParseException {
        String pivaDistributore = row[13].trim();
        String codContrDisp = row.length > 14 && !row[14].trim().isEmpty() ? row[14].trim() : "codcontrdisp";
        String codPratAtt = row.length > 15 ? row[15].trim() : null;
        String azienda = row.length > 16 && !row[16].trim().isEmpty() ? row[16].trim() : "reseller";
        boolean cottimo = row.length > 17 && !row[17].trim().isEmpty() ? Boolean.parseBoolean(row[17]) : false;
        String k2 = row.length > 18 && !row[18].trim().isEmpty() ? row[18].trim() : "1";
        StatoMisure stato = row.length > 19 && !row[19].trim().isEmpty() ? StatoMisure.valueOf(row[19].toUpperCase().trim()) : StatoMisure.VALIDATO;
        String matrAtt = row.length > 20 && !row[20].trim().isEmpty() ? row[20].trim() : "MatrAtt1234567890";
        String matrRea = "MatrRea";
        String matrPot = "MatrPot";
        if (matrAtt.contentEquals("null")) {
            matrAtt = null;
            matrRea = null;
            matrPot = null;
        }
        String raccolta = row.length > 21 && !row[21].trim().isEmpty() ? row[21].trim() : null;
        LinkedHashMap<String, Map<String, String>> datiPod = new LinkedHashMap<String, Map<String, String>>();
        LinkedHashMap<String, String> datiPdp = new LinkedHashMap<String, String>();
        datiPdp.put("Trattamento", row[7]);
        if (delibera65) {
            datiPdp.put("MatrAtt", matrAtt);
            datiPdp.put("MatrRea", matrRea);
            datiPdp.put("MatrPot", matrPot);
        }
        datiPdp.put("CifreAtt", "6");
        datiPdp.put("CifreRea", "6");
        datiPdp.put("CifrePot", "6");
        datiPdp.put("GruppoMis", cottimo ? "NO" : "SI");
        datiPdp.put("Forfait", cottimo ? "SI" : "NO");
        datiPdp.put("Tensione", "400");
        if (delibera65) {
            datiPdp.put("PotContrImp", "0");
            datiPdp.put("PotDisp", row[6]);
        }
        datiPdp.put("Ka", k2);
        datiPdp.put("Kr", k2);
        datiPdp.put("Kp", k2);
        datiPod.put("DatiPdp", datiPdp);
        Date dataMisura = CSVMockDaoHelper.getDate(row[8]);
        Date dataInizio = CSVMockDaoHelper.getDate(row[9]);
        Date dataVoltura = CSVMockDaoHelper.getDate(row[11]);
        LinkedHashMap<String, String> misureDatiPod = new LinkedHashMap<String, String>();
        int index = 0;
        String[] stringArray = PREFISSI;
        int n2 = PREFISSI.length;
        int n3 = 0;
        while (n3 < n2) {
            String value;
            Enum fascia;
            String prefix = stringArray[n3];
            ++index;
            Enum[] enumArray = FasciaOraria.values();
            int n4 = enumArray.length;
            int n5 = 0;
            while (n5 < n4) {
                fascia = enumArray[n5];
                value = row[index].isEmpty() ? null : row[index];
                misureDatiPod.put(String.valueOf(prefix) + fascia.name(), value);
                ++n5;
            }
            if (dueG) {
                enumArray = FasciaOraria2G.values();
                n4 = enumArray.length;
                n5 = 0;
                while (n5 < n4) {
                    fascia = enumArray[n5];
                    value = row[index].isEmpty() ? null : row[index];
                    misureDatiPod.put(String.valueOf(prefix) + fascia.name(), value);
                    ++n5;
                }
            }
            ++n3;
        }
        misureDatiPod.put("Erm", "100");
        misureDatiPod.put("TipoDato", "tipo");
        if (!delibera65) {
            misureDatiPod.put("Validato", "S");
        }
        if (raccolta != null) {
            misureDatiPod.put("Raccolta", raccolta);
        }
        datiPod.put("Misura", misureDatiPod);
        int nFasce = Integer.valueOf(row[4]);
        Misura misura = PrebillingTestHelper.newMisura(dataMisura, Boolean.parseBoolean(row[5]), nFasce);
        int i2 = 0;
        while (i2 < nFasce) {
            String potenza;
            String reattiva;
            FasciaOraria fascia = FasciaOraria.values()[i2];
            String attiva = row[1];
            if (!attiva.isEmpty()) {
                misura.setAttiva(fascia, Double.valueOf(attiva) * (double)(i2 + 1), 0.0);
            }
            if (!(reattiva = row[2]).isEmpty()) {
                misura.setReattiva(fascia, Double.valueOf(reattiva) * (double)(i2 + 1), 0.0);
            }
            if (!(potenza = row[3]).isEmpty()) {
                misura.setPotenza(fascia, Double.valueOf(potenza) * (double)(i2 + 1), 0.0);
            }
            ++i2;
        }
        id = String.valueOf(id) + "1";
        Mno mno = new Mno(id, flusso, row[0], misura, "pivautente", pivaDistributore, codContrDisp, codPratAtt, azienda, dataInizio, dataVoltura, datiPod, "2", "E", new Date(0L), new Date(0L), new Date(0L), "P", "filename_R.xml", delibera65 ? "65" : "479", "misura_non_oraria", stato, null, null, "R", false, null, false, false, null);
        return mno;
    }

    public static Pdo getRfo(String[] row) {
        int anno = CSVMockDaoHelper.getInteger(row[1]);
        Month mese = CSVMockDaoHelper.getMonth(row[2]);
        boolean errore = row.length >= 6 ? Boolean.parseBoolean(row[5].trim()) : false;
        String azienda = row.length > 6 ? row[6].trim() : "reseller";
        RilMese rilMese = new RilMese(row[0], anno, mese, null);
        DaysOfMonthIterator iterator = new DaysOfMonthIterator(anno, mese);
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        while (iterator.hasNext()) {
            int giorno = iterator.next();
            calendar.setGiorno(giorno);
            Date date = calendar.getDate();
            RilGiorno rilGiorno = new RilGiorno(date);
            int quarto = 0;
            while (quarto < 96) {
                RilQuarto rilQuarto = HelperTest.createRilQuarto(quarto, "RFO", "", 1.0, 1.0, 1.0, 1.0);
                rilGiorno.add(rilQuarto);
                ++quarto;
            }
            if (errore && giorno >= 10) continue;
            rilMese.add(rilGiorno);
        }
        LinkedHashMap<String, Map<String, String>> datiPod = new LinkedHashMap<String, Map<String, String>>();
        LinkedHashMap<String, String> datiPdp = new LinkedHashMap<String, String>();
        datiPdp.put("Trattamento", "O");
        datiPdp.put("MatrAtt", "matratt");
        datiPod.put("DatiPdp", datiPdp);
        String codContrDisp = row.length == 5 && !row[4].trim().isEmpty() ? row[4].trim() : "codcontrdisp";
        return new Pdo("1", false, rilMese, "pivautente", "pivadistributore", codContrDisp, null, azienda, datiPod, "", "2", null, "filename_R.xml");
    }

    public static Pdo getRfo479(String[] row) {
        int anno = CSVMockDaoHelper.getInteger(row[1]);
        Month mese = CSVMockDaoHelper.getMonth(row[2]);
        boolean errore = row.length >= 6 ? Boolean.parseBoolean(row[5].trim()) : false;
        String azienda = row.length > 6 ? row[6].trim() : "reseller";
        RilMese rilMese = new RilMese(row[0], anno, mese, null);
        DaysOfMonthIterator iterator = new DaysOfMonthIterator(anno, mese);
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        while (iterator.hasNext()) {
            int giorno = iterator.next();
            calendar.setGiorno(giorno);
            Date date = calendar.getDate();
            RilGiorno rilGiorno = new RilGiorno(date);
            int quarto = 0;
            while (quarto < 96) {
                RilQuarto rilQuarto = HelperTest.createRilQuarto(quarto, "RFO", "", quarto, quarto, quarto, quarto);
                rilGiorno.add(rilQuarto);
                ++quarto;
            }
            if (errore && giorno >= 10) continue;
            rilMese.add(rilGiorno);
        }
        LinkedHashMap<String, Map<String, String>> datiPod = new LinkedHashMap<String, Map<String, String>>();
        LinkedHashMap<String, String> datiPdp = new LinkedHashMap<String, String>();
        datiPdp.put("Trattamento", "O");
        datiPdp.put("Tensione", "1000");
        datiPod.put("DatiPdp", datiPdp);
        LinkedHashMap<String, String> misure = new LinkedHashMap<String, String>();
        misure.put("PotMax", "123.456");
        datiPod.put("Curva", misure);
        String codContrDisp = row.length == 5 && !row[4].trim().isEmpty() ? row[4].trim() : "codcontrdisp";
        Date dataRilevazione = CalendarTools.getDate(2019, Month.MAY, 9);
        return new Pdo("1", false, rilMese, "pivautente", "pivadistributore", codContrDisp, null, azienda, datiPod, "P", "2", dataRilevazione, "filename_R.xml", "479", "rettifica_misura_oraria", "R", null, null);
    }

    private static void checkSequenzaStati(List<TipoStato> actual, File testFolder) throws IOException {
        File file = new File(testFolder, "stati-out.csv");
        String filePath = file.getAbsolutePath();
        List<String> expected = FunctionalTest.loadSequenzaStati(file);
        if (expected.size() != actual.size()) {
            System.err.println(filePath);
        }
        FunctionalTest.assertEquals(expected.size(), actual.size());
        int index = 0;
        while (index < expected.size()) {
            TipoStato statoActual = actual.get(index);
            String statoExpected = expected.get(index);
            FunctionalTest.assertEquals(statoExpected, statoActual.name());
            ++index;
        }
    }

    private static Applicazione getApplicazione(String[] row) {
        int tipo = CSVMockDaoHelper.getInteger(row[0]);
        TipoFlat tipoFlat = CSVMockDaoHelper.getBoolean(row[0]) ? TipoFlat.SPREAD : TipoFlat.NON_FLAT;
        return new Applicazione("", tipo, TipoTrattamento.BOTH, tipoFlat, null);
    }

    private static JsonRequestHandler loadInitialiser(File testFolder, ConfigurationInstance configurationInstance, TalkManager talkManager) throws InvalidFileFormat, IOException, ParseException {
        JsonRequestHandler handler;
        block9: {
            handler = null;
            File file = new File(testFolder, "init.txt");
            if (file.exists()) {
                try (CsvReader reader = new CsvReader(";");){
                    reader.setFile(file);
                    if (reader.hasNext()) {
                        String[] row = reader.next();
                        if (row.length == 1) {
                            String name = row[0].trim().toUpperCase();
                            if (reader.hasNext()) {
                                row = reader.next();
                                try {
                                    TestInitialiser initialiser = TestInitialiser.valueOf(name);
                                    handler = initialiser.loadHandler(row, configurationInstance, talkManager);
                                    break block9;
                                }
                                catch (IllegalArgumentException exc) {
                                    throw new InvalidFileFormat("errore nel file " + file.getAbsolutePath() + ": " + exc.getMessage());
                                }
                            }
                            throw new InvalidFileFormat("seconda riga del file di configurazione non presente" + file.getAbsolutePath());
                        }
                        throw new InvalidFileFormat("prima riga del file di configurazione non valida" + file.getAbsolutePath());
                    }
                    throw new InvalidFileFormat("file di configurazione vuoto" + file.getAbsolutePath());
                }
            }
        }
        return handler;
    }
}

