/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.functest;

import biz.elabor.misure.model.fasce.CalendarioFasceGiornaliero;
import biz.elabor.misure.model.fasce.CalendarioFasceMensile;
import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.common.dao.StatoElaborazione;
import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.common.model.Applicazione;
import biz.elabor.prebilling.dao.NullMockPrebillingDao;
import biz.elabor.prebilling.functest.FunctionalTest;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.MockOfferteCommerciali;
import biz.elabor.prebilling.model.calendar.OffertaCommerciale;
import biz.elabor.prebilling.model.prebilling.DispatchingFlussi;
import biz.elabor.prebilling.model.prebilling.Offerta;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.tariffe.ApplicazioneReseller;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.csv.CsvReader;
import org.homelinux.elabor.structures.safe.SafeMap;

class CSVMockPrebillingDao
extends NullMockPrebillingDao {
    private List<Offerta> offerte;
    private List<Reseller> resellers;
    private Map<String, Applicazione> applicazioni;
    private Map<String, StatoElaborazione> tabellaStato;
    private Map<String, String> misureType;
    List<TipoStato> sequenzaStati;

    public CSVMockPrebillingDao(File folder) throws IOException, ParseException {
        File file = new File(folder, "reseller.csv");
        this.resellers = CSVMockPrebillingDao.loadReseller(folder);
        this.offerte = CSVMockPrebillingDao.loadOfferte(folder);
        file = new File(folder, "applicazioni.csv");
        this.applicazioni = FunctionalTest.loadApplicazioni(file);
        file = new File(folder, "stato.csv");
        this.tabellaStato = FunctionalTest.loadStato(file);
        this.sequenzaStati = new ArrayList<TipoStato>();
        this.misureType = new HashMap<String, String>();
        this.misureType.put("misura_oraria", "DettaglioMisuraPDOv2Type");
        this.misureType.put("rettifica_misura_oraria", "DettaglioMisuraPDOv2Type");
        this.misureType.put("misura_non_oraria", "DettaglioMisuraNOv2Type");
    }

    @Override
    public Iterable<ApplicazioneReseller> getApplicazioniReseller() {
        return new ArrayList<ApplicazioneReseller>();
    }

    public List<TipoStato> getSequenzaStati() {
        return this.sequenzaStati;
    }

    @Override
    public void saveStato(Funzionalita funzionalita, String azienda, TipoStato tipoStato, Date data, String idEsecuzione) {
        StatoElaborazione stato = new StatoElaborazione(tipoStato, data, idEsecuzione);
        this.tabellaStato.put(funzionalita.name(), stato);
        this.sequenzaStati.add(tipoStato);
    }

    private static List<Reseller> loadReseller(File folder) throws IOException {
        ArrayList<Reseller> resellers = new ArrayList<Reseller>();
        File file = new File(folder, "reseller.csv");
        if (file.exists()) {
            try (CsvReader reader = new CsvReader(";");){
                reader.setFile(file);
                String[] row = reader.getNextRow();
                while (reader.hasNext()) {
                    row = reader.next();
                    Reseller reseller = CSVMockPrebillingDao.getReseller(row);
                    resellers.add(reseller);
                }
            }
        }
        return resellers;
    }

    private static Reseller getReseller(String[] row) {
        boolean crm;
        String codice = row[0].trim();
        String nome = row.length > 0 ? row[0].trim() : null;
        String piva = row.length > 1 ? row[1].trim() : null;
        boolean bl = crm = row.length > 2 ? Boolean.parseBoolean(row[2].trim()) : true;
        boolean handleStato = row.length > 3 ? Boolean.parseBoolean(row[3].trim()) : !crm;
        return new Reseller(codice, nome, piva, crm, handleStato);
    }

    private static List<Offerta> loadOfferte(File folder) throws IOException {
        ArrayList<Offerta> offerte = new ArrayList<Offerta>();
        File file = new File(folder, "offerte.csv");
        if (file.exists()) {
            try (CsvReader reader = new CsvReader(";");){
                reader.setFile(file);
                String[] row = reader.getNextRow();
                while (reader.hasNext()) {
                    row = reader.next();
                    Offerta offerta = CSVMockPrebillingDao.getOfferta(row);
                    offerte.add(offerta);
                }
            }
        }
        return offerte;
    }

    private static Offerta getOfferta(String[] row) {
        String codIndiceEnergetico = row[0].trim();
        int codMercato = Integer.parseInt(row[1].trim());
        int codZona = Integer.parseInt(row[2].trim());
        return new Offerta(codIndiceEnergetico, codMercato, codZona, false, null, null, false);
    }

    @Override
    public List<Reseller> getResellers() {
        return this.resellers;
    }

    @Override
    public Reseller getReseller(String codice) {
        Reseller reseller = codice.equals("tutti") ? new Reseller("*", "tutti", null, false, false) : new Reseller(codice, codice, null, false, false);
        return reseller;
    }

    @Override
    public SafeMap<String, OffertaCommerciale> getOfferteCommerciali() {
        return new MockOfferteCommerciali();
    }

    @Override
    public Map<String, Applicazione> getApplicazioni() {
        return this.applicazioni;
    }

    @Override
    public CalendarioFasceMensile getCalendarioFasce(String id, int anno, Month mese) {
        return CSVMockPrebillingDao.getFasce(id, anno, mese);
    }

    private static CalendarioFasceMensile getFasce(String id, int anno, Month mese) {
        int pow = Integer.parseInt(id);
        CalendarioFasceMensile calendarioFasce = new CalendarioFasceMensile(id, anno, mese);
        int ngiorni = CalendarTools.getDaysOfMonth(anno, mese);
        int giorno = 1;
        while (giorno <= ngiorni) {
            CalendarioFasceGiornaliero cg = new CalendarioFasceGiornaliero(id, anno, mese, giorno);
            int ora = 1;
            while (ora <= 24) {
                cg.setFascia(ora, FasciaOraria.values()[(int)(Math.pow(ora, pow) % 3.0)]);
                ++ora;
            }
            calendarioFasce.setFasciaGiornaliera(giorno, cg);
            ++giorno;
        }
        return calendarioFasce;
    }

    @Override
    public List<Offerta> getOfferte() {
        return this.offerte;
    }

    @Override
    public DispatchingFlussi getDispatchingFlussi() {
        DispatchingFlussi dispatchingFlussi = new DispatchingFlussi();
        return dispatchingFlussi;
    }

    @Override
    public Map<String, String> getMisureType() {
        return this.misureType;
    }
}

