/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.functest;

import biz.elabor.prebilling.dao.NullMockIndiciDao;
import biz.elabor.prebilling.model.indici.IndiceOrario;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.DaysOfMonthIterable;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.csv.CsvReader;

class CSVMockIndiciDao
extends NullMockIndiciDao {
    private List<IndiceOrario> indici;

    public CSVMockIndiciDao(File folder) throws IOException {
        this.indici = CSVMockIndiciDao.getIndici(folder);
    }

    private static List<IndiceOrario> getIndici(File folder) throws IOException {
        ArrayList<IndiceOrario> indici = new ArrayList<IndiceOrario>();
        File file = new File(folder, "indici.csv");
        if (file.exists()) {
            try (CsvReader reader = new CsvReader(";");){
                reader.setFile(file);
                String[] row = reader.getNextRow();
                while (reader.hasNext()) {
                    row = reader.next();
                    List<IndiceOrario> indiciOfferta = CSVMockIndiciDao.buildIndici(row);
                    indici.addAll(indiciOfferta);
                }
            }
        }
        return indici;
    }

    private static List<IndiceOrario> buildIndici(String[] row) {
        ArrayList<IndiceOrario> indici = new ArrayList<IndiceOrario>();
        int mercato = Integer.parseInt(row[0].trim());
        int zona = Integer.parseInt(row[1].trim());
        int year = Integer.parseInt(row[2].trim());
        Month month = Month.valueOf(row[3].trim().toUpperCase());
        boolean errore = row.length <= 4 ? false : Boolean.parseBoolean(row[4].trim());
        for (int day : new DaysOfMonthIterable(year, month)) {
            Date data = CalendarTools.getDate(year, month, day);
            int ora = 1;
            while (ora <= 24) {
                IndiceOrario indice = new IndiceOrario(mercato, zona, data, ora, ora);
                if (!errore || ora < 10) {
                    indici.add(indice);
                }
                ++ora;
            }
        }
        return indici;
    }

    @Override
    public List<IndiceOrario> getIndici(int anno, Month mese) {
        return this.indici;
    }
}

