/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.functest;

import biz.elabor.prebilling.common.model.IdContratto;
import biz.elabor.prebilling.dao.ContrattoEle;
import biz.elabor.prebilling.dao.NullMockGiadaDao;
import biz.elabor.prebilling.functest.CSVMockDaoHelper;
import biz.elabor.prebilling.functest.ContrattoCondition;
import biz.elabor.prebilling.functest.FunctionalTest;
import biz.elabor.prebilling.model.giada.Fittizia;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodInstance;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.giada.RigaPod;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.arrays.Filter;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.csv.CsvReader;
import org.homelinux.elabor.structures.listmap.DefaultListMapKey;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.structures.listmap.ListMapKey;

class CSVMockGiadaDao
extends NullMockGiadaDao {
    private static final double[] ATTIVA = new double[]{0.0, 0.0, 0.0};
    private List<RigaPod> righe;
    private List<Pod> pods;
    private List<ContrattoEle> contratti;
    private ListMapKey<String, PraticaVolo> pivMap;

    public CSVMockGiadaDao(File folder) throws IOException, ParseException {
        this.fillPods(folder);
        this.fillContratti(folder);
        this.pivMap = new DefaultListMapKey<String, PraticaVolo>();
        this.pivMap.addAll(CSVMockDaoHelper.fillPiv(folder, "piv.csv"));
    }

    @Override
    public List<Fittizia> getFittizie(String codicePod) {
        return new ArrayList<Fittizia>();
    }

    private void fillContratti(File folder) throws ParseException, IOException {
        this.contratti = new ArrayList<ContrattoEle>();
        File file = new File(folder, "contratti.csv");
        if (file.exists()) {
            try (CsvReader reader = new CsvReader(";");){
                reader.setFile(file);
                String[] row = reader.getNextRow();
                while (reader.hasNext()) {
                    row = reader.next();
                    ContrattoEle contratto = CSVMockGiadaDao.getContratto(row);
                    this.contratti.add(contratto);
                }
            }
        }
    }

    private static ContrattoEle getContratto(String[] row) throws ParseException {
        String codicePod = row[0].trim();
        Date dataValidita = FunctionalTest.DATE_FORMAT.parse(row[1].trim());
        String codIndiceEnergetico = row[2].trim();
        Date dataSospensione = CSVMockGiadaDao.getDate(row[3].trim());
        Date dataRevoca = CSVMockGiadaDao.getDate(row[4].trim());
        IdContratto idContratto = new IdContratto(1, 1, 1);
        Date dataInizio = CSVMockGiadaDao.getDate(row[5].trim());
        Date dataFine = CSVMockGiadaDao.getDate(row[6].trim());
        String reseller = row[7].trim();
        int tipoApplicazione = Integer.parseInt(row[8].trim());
        Date startOfTime = new Date(0L);
        return new ContrattoEle(codicePod, reseller, dataValidita, 0, idContratto, tipoApplicazione, codIndiceEnergetico, dataSospensione, dataRevoca, dataInizio, dataFine, dataSospensione, null, "1", 0.0, null, 0, null, null, ATTIVA, 4, null, 0.0, startOfTime, 0.0, 0.0, 0.0, null, false, tipoApplicazione, 0.0, 0.0, null, null);
    }

    private static Date getDate(String value) throws ParseException {
        return value.isEmpty() ? null : FunctionalTest.DATE_FORMAT.parse(value);
    }

    private void fillPods(File folder) throws IOException, ParseException {
        this.righe = new ArrayList<RigaPod>();
        this.pods = new ArrayList<Pod>();
        File file = new File(folder, "pod.csv");
        if (file.exists()) {
            try (CsvReader reader = new CsvReader(";");){
                reader.setFile(file);
                String[] row = reader.getNextRow();
                while (reader.hasNext()) {
                    row = reader.next();
                    RigaPod riga = CSVMockGiadaDao.getRiga(row);
                    this.righe.add(riga);
                    Pod pod = CSVMockGiadaDao.getPod(row);
                    this.pods.add(pod);
                }
                Date inizio = new Date(0L);
                this.righe.add(new RigaPod("zzzz", null, false, 0, inizio, null, null, null, false, false, false, null, false, null, null, "dispatcher", null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "0", 1.0, 1.0, 1.0, false, false, inizio, null, null));
            }
        }
    }

    private static Pod getPod(String[] row) throws ParseException {
        Pod pod;
        if (row.length < 10) {
            pod = new Pod(null, false, 0, null, null, null, false, false, false, null, null, null, false, null, false, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, null);
        } else {
            String codContrDisp = row[15].trim().isEmpty() ? "codcontrdisp" : row[15].trim();
            boolean attesaSnm = row[14].isEmpty() ? Boolean.FALSE.booleanValue() : Boolean.TRUE.booleanValue();
            Date switchout = CSVMockDaoHelper.getDate(row[13]);
            pod = new Pod(row[0], CSVMockDaoHelper.getBoolean(row[2]), CSVMockDaoHelper.getInteger(row[3]), row[1], CSVMockDaoHelper.getDate(row[4]), null, CSVMockDaoHelper.getBoolean(row[8]), CSVMockDaoHelper.getBoolean(row[9]), CSVMockDaoHelper.getBoolean(row[10]), CSVMockDaoHelper.getDate(row[6]), row[11], codContrDisp, CSVMockDaoHelper.getBoolean(row[12]), switchout, attesaSnm, "", 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, null, attesaSnm, null, new ArrayList<PodInstance>());
        }
        return pod;
    }

    private static RigaPod getRiga(String[] row) throws ParseException {
        RigaPod rigaPod;
        if (row.length < 16) {
            rigaPod = new RigaPod(null, null, false, 0, null, null, null, null, false, false, false, null, false, null, null, null, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, false, new Date(0L), null, "");
        } else {
            String codContrDisp = row[15].trim().isEmpty() ? "codcontrdisp" : row[15].trim();
            String tarDis = row.length <= 16 ? "" : row[16].trim();
            boolean nuovaFornitura = row.length <= 17 ? false : CSVMockDaoHelper.getBoolean(row[17]);
            String idCalendario = row.length <= 18 ? "1" : row[18].trim();
            int k2 = row.length <= 19 ? 1 : CSVMockDaoHelper.getInteger(row[19].trim());
            Date dataInizio = CSVMockDaoHelper.getDate(row[4]);
            Date dataMax = CSVMockDaoHelper.getDate(row[6]);
            if (dataMax == null) {
                dataMax = dataInizio;
            }
            boolean commerciale = !idCalendario.equals("1");
            Date attesaSnm = CSVMockDaoHelper.getDate(row[14]);
            rigaPod = new RigaPod(row[0], row[1], CSVMockDaoHelper.getBoolean(row[2]), CSVMockDaoHelper.getInteger(row[3]), dataInizio, CSVMockDaoHelper.getDate(row[5]), dataMax, CSVMockDaoHelper.getDate(row[7]), CSVMockDaoHelper.getBoolean(row[8]), CSVMockDaoHelper.getBoolean(row[9]), CSVMockDaoHelper.getBoolean(row[10]), row[11], CSVMockDaoHelper.getBoolean(row[12]), CSVMockDaoHelper.getDate(row[13]), attesaSnm, codContrDisp, tarDis, 30.0, 0.0, nuovaFornitura, 10.0, 20.0, 30.0, 40.0, 50.0, 60.0, idCalendario, k2, k2, k2, commerciale, CSVMockDaoHelper.getBoolean(row[2]), dataInizio, null, "", attesaSnm != null, null, null, null, null);
        }
        return rigaPod;
    }

    @Override
    public List<RigaPod> getRighePod(int anno, Month mese, String cclettur) {
        return this.righe;
    }

    @Override
    public List<RigaPod> getRighePod(int anno, Month mese, String onlyPod, String cclettur, String start, int maxRows) {
        return this.righe;
    }

    @Override
    public ListMap<String, PraticaVolo> getPiv(Iterable<String> cdunipre, Date dataFine, String azienda, String codicePod) {
        return this.pivMap;
    }

    @Override
    public List<ContrattoEle> getContrattiReseller(int anno, Month mese, String codicePod, String codiceReseller) {
        ContrattoCondition condition = new ContrattoCondition(codicePod);
        Filter<ContrattoEle> filter = new Filter<ContrattoEle>(condition);
        return filter.filter(this.contratti);
    }

    @Override
    public List<ContrattoEle> getContrattiDispatcher(int anno, Month mese, String codicePod, String codiceReseller) {
        return this.getContrattiReseller(anno, mese, codicePod, codiceReseller);
    }
}

