/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao.creator;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.dao.DefaultRRS;
import biz.elabor.prebilling.dao.creator.RecordCreatorHelper;
import biz.elabor.prebilling.model.misure.Snf;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.db.RecordCreator;

public class SnfCreator
implements RecordCreator<Snf> {
    private static final Set<String> CIFRE = new HashSet<String>();
    private final DateFormat dateFormat = BasicRecordCreatorHelper.getDateFormat();

    static {
        CIFRE.add("CifreAtt");
        CIFRE.add("CifreRea");
        CIFRE.add("CifrePot");
    }

    @Override
    public Snf createRecord(ResultSet rs) throws SQLException {
        DefaultRRS restrictedRS = new DefaultRRS(rs);
        String codice = rs.getString("pod_id").trim().substring(0, 14);
        PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + codice);
        Date data = RecordCreatorHelper.getDate(restrictedRS, "DATA_INIZIO", this.dateFormat);
        Map<String, Map<String, String>> datiPod = SnfCreator.createDatiPod(rs);
        String id = rs.getString("id");
        String codContrDisp = rs.getString("CONTRATTO_DISPACCIAMENTO");
        String pivaUtente = rs.getString("PIVA_DISPATCHER");
        String pivaDistributore = rs.getString("PIVA_DISTRIBUTORE");
        String codPratAtt = rs.getString("COD_PRATICA_ATTIVAZIONE");
        String cdaziend = rs.getString("CDAZIEND");
        String nomeFile = rs.getString("NOME_FILE");
        if (cdaziend != null) {
            cdaziend = cdaziend.trim();
        }
        String flusso = rs.getString("COD_FLUSSO");
        String delibera = rs.getString("DELIBERA");
        return new Snf(id, flusso, codice, pivaUtente, pivaDistributore, codContrDisp, data, codPratAtt, cdaziend, nomeFile, datiPod, delibera, "SW_DATI_FUNZ_POD_NON_ORARI");
    }

    private static Map<String, Map<String, String>> createDatiPod(ResultSet rs) throws SQLException {
        String[] campiDatiPdp = new String[]{"Trattamento", "Tensione", "PotContrImp", "PotDisp", "Ka", "Kr", "Kp", "MatrAtt", "MatrRea", "MatrPot", "CifreAtt", "CifreRea", "CifrePot", "GruppoMis", "Forfait", "CodiceTariffa", "ServizioTutela", "Prestazioni", "PuntoDispacciamento", "TipoMisuratore", "DataMessaRegime", "Residenza", "Disalimentabilita", "ConfigurazioneMisuratore", "DataInstMisAtt", "DataInstMisRea", "DataInstMisPot"};
        String[] campiSqlDatiPdp = new String[]{"TRATTAMENTO_POD", "TENSIONE", "POTENZA_CONTR_IMPEGNATA", "POTENZA_DISPONIBILE", "KA", "KR", "KP", "MATRICOLA_MISURATORE_ATTIVA", "MATRICOLA_MISURATORE_REATTIVA", "MATRICOLA_MISURATORE_POTENZA", "CIFRE_ATTIVA", "CIFRE_REATTIVA", "CIFRE_POTENZA", "GRUPPO_MISURA", "FORFAIT", "COD_TARIFFA", "SERVIZIO_TUTELA", "PRESTAZIONI", "PUNTO_DISPACCIAMENTO", "TIPO_MISURATORE", "DATA_MESSA_REGIME", "RESIDENZA", "DISALIMENT", "CONFMIS", "DATA_INSTALLA_MISURAT_ATTIVA", "DATA_INSTALLA_MISURAT_REATTIVA", "DATA_INSTALLA_MISURAT_POTENZA"};
        LinkedHashMap<String, Map<String, String>> datiPod = new LinkedHashMap<String, Map<String, String>>();
        Map<String, String> datiPdp = SnfCreator.createMap(rs, campiDatiPdp, campiSqlDatiPdp);
        datiPod.put("DatiPdp", datiPdp);
        return datiPod;
    }

    private static Map<String, String> createMap(ResultSet rs, String[] campi, String[] campiSql) throws SQLException {
        int index = 0;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String[] stringArray = campi;
        int n2 = campi.length;
        int n3 = 0;
        while (n3 < n2) {
            String campo = stringArray[n3];
            String nomeCampoSql = campiSql[index];
            String valoreTxt = rs.getString(nomeCampoSql);
            if (valoreTxt == null) {
                if (CIFRE.contains(campo)) {
                    map.put(campo, "");
                }
            } else {
                map.put(campo, valoreTxt);
            }
            ++index;
            ++n3;
        }
        return map;
    }
}

