/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao.creator;

import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.dao.DefaultRRS;
import biz.elabor.prebilling.dao.RestrictedResultSet;
import biz.elabor.prebilling.dao.creator.PdoCreator;
import biz.elabor.prebilling.model.misure.Pdo;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.db.ConnectionManager;
import org.homelinux.elabor.db.DataAccessException;
import org.homelinux.elabor.db.QueryTemplate;

public class RecordCreatorHelper
extends BasicRecordCreatorHelper {
    private RecordCreatorHelper() {
    }

    public static Date getDate(RestrictedResultSet rs, String name, DateFormat format) throws SQLException {
        Date date;
        String value = rs.getString(name);
        try {
            date = value == null || value.trim().isEmpty() ? null : format.parse(value);
        }
        catch (ParseException e2) {
            throw new RuntimeException(e2);
        }
        return date;
    }

    public static boolean getBoolean(RestrictedResultSet rs, String name) throws SQLException {
        String value = rs.getString(name);
        return value == null ? false : "SYT1".contains(value.toUpperCase());
    }

    public static <E extends Enum<E>> E getEnum(ResultSet rs, Class<E> enumClass, String name, E defaultValue) throws SQLException {
        String value = rs.getString(name);
        return RecordCreatorHelper.getEnum(value, enumClass, defaultValue);
    }

    public static <E extends Enum<E>> E getEnum(String value, Class<E> enumClass, E defaultValue) {
        E enumValue;
        try {
            enumValue = Enum.valueOf(enumClass, value);
        }
        catch (Exception e2) {
            enumValue = defaultValue;
        }
        return enumValue;
    }

    public static List<Pdo> getPdos(QueryTemplate query, boolean complete, boolean attivaOnly, PdoCreator creator, ConnectionManager manager) {
        List<Pdo> pdos;
        try {
            Connection connection = manager.getConnection();
            try (Statement statement = connection.createStatement();){
                ResultSet rs = manager.executeQuery(query, statement);
                pdos = creator.getRecords(new DefaultRRS(rs), complete, attivaOnly);
                rs.close();
            }
        }
        catch (SQLException e2) {
            throw new DataAccessException(e2);
        }
        return pdos;
    }

    public static double getDouble(RestrictedResultSet rrs, String name, DecimalFormat format) throws SQLException {
        return RecordCreatorHelper.getDouble(rrs, name, format, 0.0);
    }

    public static double getDouble(RestrictedResultSet rrs, String name, DecimalFormat format, double defaultValue) throws SQLException {
        double value;
        String strValue = rrs.getString(name);
        try {
            value = format.parse(strValue).doubleValue();
        }
        catch (Exception exc) {
            value = defaultValue;
        }
        return value;
    }

    public static String getString(RestrictedResultSet restrictedRS, String name) throws SQLException {
        String value = restrictedRS.getString(name);
        return value == null ? null : value.trim();
    }

    public static Date getDataPrestazione(RestrictedResultSet rrs, Date dataMisura, boolean infer, DateFormat format) throws SQLException {
        Date dataPrestazione = RecordCreatorHelper.getDate(rrs, "DATA_PRESTAZIONE", format);
        if (infer && dataPrestazione == null) {
            dataPrestazione = CalendarTools.nextDay(dataMisura);
        }
        return dataPrestazione;
    }
}

