/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao.creator;

import biz.elabor.prebilling.model.pra.PraGiornaliero;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.db.RecordCreator;

public class PraGiornalieroCreator
implements RecordCreator<PraGiornaliero> {
    private final boolean quartorario;

    public PraGiornalieroCreator(boolean quartorario) {
        this.quartorario = quartorario;
    }

    @Override
    public PraGiornaliero createRecord(ResultSet rs) throws SQLException {
        int idZona = rs.getInt("ZONA_ID");
        java.sql.Date date = rs.getDate("DATA_RIFERIMENTO");
        double[] values = this.quartorario ? PraGiornalieroCreator.getValuesQuartorari(rs, date) : PraGiornalieroCreator.getValuesOrari(rs, date);
        return new PraGiornaliero(idZona, date, values);
    }

    private static double[] getValuesOrari(ResultSet rs, Date date) throws SQLException {
        int numHours = CalendarTools.getHoursOfDay(date);
        double[] values = new double[numHours];
        int ora = 0;
        while (ora < numHours) {
            values[ora] = rs.getDouble("H" + (ora + 1));
            ++ora;
        }
        return values;
    }

    private static double[] getValuesQuartorari(ResultSet rs, Date date) throws SQLException {
        int numQuarti = CalendarTools.getHoursOfDay(date) * 4;
        double[] values = new double[numQuarti];
        int ora = 0;
        while (ora < numQuarti) {
            values[ora] = rs.getDouble("QH" + (ora + 1));
            ++ora;
        }
        return values;
    }
}

