/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao.creator;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.dao.DefaultRRS;
import biz.elabor.prebilling.dao.creator.RecordCreatorHelper;
import biz.elabor.prebilling.model.indici.IndiceOrario;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import org.homelinux.elabor.db.RecordCreator;

public class IndiceOrarioCreator
implements RecordCreator<IndiceOrario> {
    private final DateFormat dateFormat = BasicRecordCreatorHelper.getDateFormat();

    @Override
    public IndiceOrario createRecord(ResultSet rs) throws SQLException {
        DefaultRRS restrictedRS = new DefaultRRS(rs);
        int mercato = rs.getInt("mercato_id");
        int zona = rs.getInt("zona_id");
        Date data = RecordCreatorHelper.getDate(restrictedRS, "data", this.dateFormat);
        String className = this.getClass().getSimpleName();
        PrebillingContext.setContext(className, "indice: " + mercato + "/" + zona);
        int ora = rs.getInt("ora");
        double prezzo = rs.getDouble("prezzo");
        return new IndiceOrario(mercato, zona, data, ora, prezzo);
    }
}

