/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao.creator;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.common.model.IdContratto;
import biz.elabor.prebilling.dao.ContrattoEle;
import biz.elabor.prebilling.dao.DefaultRRS;
import biz.elabor.prebilling.dao.creator.RecordCreatorHelper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import org.homelinux.elabor.db.RecordCreator;

public class ContrattoEleCreator
implements RecordCreator<ContrattoEle> {
    private final DateFormat dateFormat = BasicRecordCreatorHelper.getDateFormat();
    private final DecimalFormat doubleFormat = BasicRecordCreatorHelper.getDoubleFormat();

    @Override
    public ContrattoEle createRecord(ResultSet rs) throws SQLException {
        DefaultRRS restrictedRS = new DefaultRRS(rs);
        String codicePod = rs.getString("cdprerif").trim();
        PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + codicePod);
        String reseller = rs.getString("cdazirif").trim();
        String azDispatcher = rs.getString("cdaziend").trim();
        Date dataValidita = RecordCreatorHelper.getDate(restrictedRS, "dtvalidi", this.dateFormat);
        int numFasce = rs.getInt("nnfascia");
        String codIndiceEnergetico = rs.getString("cdindene");
        int tipoApplicazione = rs.getInt("cctariff");
        Date dataSospensione = RecordCreatorHelper.getDate(restrictedRS, "dtsospen", this.dateFormat);
        Date dataScadenza = RecordCreatorHelper.getDate(restrictedRS, "dtscaden", this.dateFormat);
        Date dataRevoca = RecordCreatorHelper.getDate(restrictedRS, "dtrevoca", this.dateFormat);
        Date dataInizio = RecordCreatorHelper.getDate(restrictedRS, "inizio", this.dateFormat);
        Date dataFine = RecordCreatorHelper.getDate(restrictedRS, "fine", this.dateFormat);
        IdContratto idContratto = ContrattoEleCreator.createId(rs);
        String cdUteRif = rs.getString("cduterif");
        String codiceOfferta = rs.getString("codice_offerta");
        if (codiceOfferta == null) {
            codiceOfferta = "";
        }
        double aqconsum = RecordCreatorHelper.getDouble(restrictedRS, "aqconsum", this.doubleFormat);
        double emtaruni = RecordCreatorHelper.getDouble(restrictedRS, "emtaruni", this.doubleFormat);
        double emspread = RecordCreatorHelper.getDouble(restrictedRS, "emspread", this.doubleFormat);
        double qtindene = RecordCreatorHelper.getDouble(restrictedRS, "qtindene", this.doubleFormat);
        double qtinden2 = RecordCreatorHelper.getDouble(restrictedRS, "qtinden2", this.doubleFormat);
        double qtinden3 = RecordCreatorHelper.getDouble(restrictedRS, "qtinden3", this.doubleFormat);
        double[] prezziDefault = new double[]{qtindene, qtinden2, qtinden3};
        int livello = rs.getInt("flpressi");
        double eaF1 = RecordCreatorHelper.getDouble(restrictedRS, "NULETPREF1", this.doubleFormat);
        double eaF2 = RecordCreatorHelper.getDouble(restrictedRS, "NULETPREF2", this.doubleFormat);
        double eaF3 = RecordCreatorHelper.getDouble(restrictedRS, "NULETPREF3", this.doubleFormat);
        double[] attiva = new double[]{eaF1, eaF2, eaF3};
        int nuCifre = rs.getInt("NUCIFRE");
        Date dataUltimaLettura = RecordCreatorHelper.getDate(restrictedRS, "DTLETPRE", this.dateFormat);
        String matricola = rs.getString("MATRICOLA");
        String cdComIst = rs.getString("CDCOMIST");
        double qtconfla = RecordCreatorHelper.getDouble(restrictedRS, "QTCONFLA", this.doubleFormat);
        Date dtmisora = RecordCreatorHelper.getDate(restrictedRS, "dtmisora", this.dateFormat);
        int tipoAppPenale = rs.getInt("CDAPPPEN");
        String cdindneg = rs.getString("cdindneg");
        boolean fixing = BasicRecordCreatorHelper.getBoolean(rs, "flfixing");
        double emspreneg = BasicRecordCreatorHelper.getDouble(rs, "emspreneg", this.doubleFormat);
        double qtconsum = BasicRecordCreatorHelper.getDouble(rs, "qtconsum", this.doubleFormat);
        Date dtIndice = RecordCreatorHelper.getDate(restrictedRS, "dtindice", this.dateFormat);
        return new ContrattoEle(codicePod, reseller, dataValidita, numFasce, idContratto, tipoApplicazione, codIndiceEnergetico, dataSospensione, dataRevoca, dataInizio, dataFine, dataScadenza, cdUteRif, codiceOfferta, aqconsum, prezziDefault, livello, dataUltimaLettura, matricola, attiva, nuCifre, cdComIst, qtconfla, dtmisora, emtaruni, emspread, emspreneg, cdindneg, fixing, tipoAppPenale, qtconsum, qtindene, dtIndice, azDispatcher);
    }

    private static IdContratto createId(ResultSet rs) throws SQLException {
        int codAzienda = rs.getInt("cdaziend");
        int codZona = rs.getInt("cdzona");
        int codUtente = rs.getInt("cdutente");
        return new IdContratto(codAzienda, codZona, codUtente);
    }
}

