/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.dao.TableMultiUpdateHandler;
import biz.elabor.prebilling.services.tariffe.Tariffa;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;

class TariffeElaborateInsertHandler
implements TableMultiUpdateHandler<Tariffa> {
    private final boolean dispatcher;
    private String prevPod;
    private Date prevDate;

    public TariffeElaborateInsertHandler(boolean dispatcher) {
        this.dispatcher = dispatcher;
        this.prevPod = null;
        this.prevDate = null;
    }

    @Override
    public String getQuery() {
        return "insert into tariffe_elaborate (pod, dispatcher, data_inizio, scivolo) values(?, ?, ?, ?)";
    }

    @Override
    public boolean prepare(PreparedStatement statement, Tariffa item, StatoMisure stato, String id) throws SQLException {
        boolean ok;
        String codicePod = item.getCodicePod();
        Date startDate = item.getStartDate();
        boolean bl = ok = this.prevDate == null || this.prevPod == null || !this.prevPod.equals(codicePod) || !this.prevDate.equals(startDate);
        if (ok) {
            statement.setString(1, codicePod);
            statement.setString(2, this.dispatcher ? "1" : "0");
            statement.setDate(3, new java.sql.Date(startDate.getTime()));
            statement.setString(4, item.getTariffa().isScivolo() ? "1" : "0");
        }
        this.prevPod = codicePod;
        this.prevDate = startDate;
        return ok;
    }
}

