/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.dao.TableMultiUpdateHandler;
import biz.elabor.prebilling.model.statopod.StatoPod;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

class StatiPodMultiUpdateHandler
implements TableMultiUpdateHandler<StatoPod> {
    StatiPodMultiUpdateHandler() {
    }

    @Override
    public String getQuery() {
        return "insert into STATO_POD (CDSERVIZ, POD, CF, PIVA, PIVA_DISTR, PIVA_RESELLER, PIVA_DISPATCHER, CODICE_DISPACCIAMENTO, FLAG_RESIDENTE, STATO, DATA_MOVIMENTO, NUPROGRE, DATA_ATTIVAZIONE, DATA_CESSAZIONE, CDUNIPRE, CDFLUSSO, TABELLA_RIFERIMENTO, CHIAVE_TABELLA_RIFERIMENTO, TOPONIMO, VIA, CIVICO, COMUNE_CATASTALE, CAP, FLAG_ORARIO, CDTARDIS, TENSIONE, LIVELLO_TENSIONE, POTENZA_CONTR, POTENZA_DISP, FLMISCON, FLMISREA, FLMISPOT, FLMISBIO, INMISCON, INMISREA, INMISPOT, INMISBIO, NULETA01, NULETA02, NULETA03, NULETR01, NULETR02, NULETR03, NULETP01, NULETP02, NULETP03, NULETB01, NULETB02, NULETB03, NUMATRIC_A, MOD_CONTATORE_A, FLAZZCON_A, NUCIFRE_A, NUMATRIC_R, MOD_CONTATORE_R, FLAZZCON_R, NUCIFRE_R, NUMATRIC_P, MOD_CONTATORE_P, FLAZZCON_P, NUCIFRE_P, NUMATRIC_B, MOD_CONTATORE_B, FLAZZCON_B, NUCIFRE_B, NNFASCIA, STATO_RIC, CP_UTENTE, CP_GESTORE, SERVIZIO_TUTELA, DATA_PRESTAZIONE, CODICE_OFFERTA) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    @Override
    public boolean prepare(PreparedStatement statement, StatoPod statoPod, StatoMisure stato, String id) throws SQLException {
        Date dataMovimento = statoPod.getDataMovimento();
        Date dataAttivazione = statoPod.getDataAttivazione();
        Date dataCessazione = statoPod.getDataCessazione();
        Date dataPrestazione = statoPod.getDataPrestazione();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        statement.setString(1, StatiPodMultiUpdateHandler.formatString(statoPod.getServizio()));
        statement.setString(2, StatiPodMultiUpdateHandler.formatString(statoPod.getPod()));
        statement.setString(3, StatiPodMultiUpdateHandler.formatString(statoPod.getCf()));
        statement.setString(4, StatiPodMultiUpdateHandler.formatString(statoPod.getPiva()));
        statement.setString(5, StatiPodMultiUpdateHandler.formatString(statoPod.getPivaDistributore()));
        statement.setString(6, StatiPodMultiUpdateHandler.formatString(statoPod.getPivaReseller()));
        statement.setString(7, StatiPodMultiUpdateHandler.formatString(statoPod.getPivaDispatcher()));
        statement.setString(8, StatiPodMultiUpdateHandler.formatString(statoPod.getCodiceDispacciamento()));
        statement.setString(9, StatiPodMultiUpdateHandler.formatString(statoPod.getResidenza()));
        statement.setString(10, StatiPodMultiUpdateHandler.formatString(statoPod.getStato()));
        statement.setString(11, StatiPodMultiUpdateHandler.formatDate(dateFormat, dataMovimento));
        statement.setInt(12, statoPod.getNuprogre());
        statement.setString(13, StatiPodMultiUpdateHandler.formatDate(dateFormat, dataAttivazione));
        statement.setString(14, StatiPodMultiUpdateHandler.formatDate(dateFormat, dataCessazione));
        statement.setString(15, statoPod.getCdunipre());
        statement.setString(16, statoPod.getCdFlusso());
        statement.setString(17, statoPod.getTabellaRiferimento());
        statement.setString(18, statoPod.getChiaveTabellaRiferimento());
        statement.setString(19, StatiPodMultiUpdateHandler.formatString(statoPod.getToponimo()));
        statement.setString(20, StatiPodMultiUpdateHandler.formatString(statoPod.getVia()));
        statement.setString(21, StatiPodMultiUpdateHandler.formatString(statoPod.getCivico()));
        statement.setString(22, StatiPodMultiUpdateHandler.formatString(statoPod.getComuneCatastale()));
        statement.setString(23, StatiPodMultiUpdateHandler.formatString(statoPod.getCap()));
        statement.setInt(24, statoPod.getFlagOrario() ? 1 : 0);
        statement.setString(25, StatiPodMultiUpdateHandler.formatString(statoPod.getCdtardis()));
        statement.setInt(26, statoPod.getTensione());
        statement.setString(27, StatiPodMultiUpdateHandler.formatString(statoPod.getLivelloTensione()));
        statement.setDouble(28, statoPod.getPotenzaContr());
        statement.setDouble(29, statoPod.getPotenzaDisp());
        statement.setInt(30, statoPod.getFlmisCon() ? 1 : 0);
        statement.setInt(31, statoPod.getFlmisRea() ? 1 : 0);
        statement.setInt(32, statoPod.getFlmisPot() ? 1 : 0);
        statement.setInt(33, statoPod.isFlMisBio() ? 1 : 0);
        statement.setDouble(34, statoPod.getInmisCon());
        statement.setDouble(35, statoPod.getInmisRea());
        statement.setDouble(36, statoPod.getInmisPot());
        statement.setDouble(37, statoPod.getInMisBio());
        statement.setDouble(38, statoPod.getNuLetA01());
        statement.setDouble(39, statoPod.getNuLetA02());
        statement.setDouble(40, statoPod.getNuLetA03());
        statement.setDouble(41, statoPod.getNuLetR01());
        statement.setDouble(42, statoPod.getNuLetR02());
        statement.setDouble(43, statoPod.getNuLetR03());
        statement.setDouble(44, statoPod.getNuLetP01());
        statement.setDouble(45, statoPod.getNuLetP02());
        statement.setDouble(46, statoPod.getNuLetP03());
        statement.setDouble(47, statoPod.getNuLetBio01());
        statement.setDouble(48, statoPod.getNuLetBio02());
        statement.setDouble(49, statoPod.getNuLetBio03());
        statement.setString(50, StatiPodMultiUpdateHandler.formatString(statoPod.getNuMatrA()));
        statement.setString(51, StatiPodMultiUpdateHandler.formatString(statoPod.getModContatoreA()));
        statement.setInt(52, statoPod.isFlazzconA() ? 1 : 0);
        statement.setInt(53, statoPod.getNuCifreA());
        statement.setString(54, StatiPodMultiUpdateHandler.formatString(statoPod.getNuMatrR()));
        statement.setString(55, StatiPodMultiUpdateHandler.formatString(statoPod.getModContatoreR()));
        statement.setInt(56, statoPod.isFlazzconR() ? 1 : 0);
        statement.setInt(57, statoPod.getNuCifreR());
        statement.setString(58, StatiPodMultiUpdateHandler.formatString(statoPod.getNuMatrP()));
        statement.setString(59, StatiPodMultiUpdateHandler.formatString(statoPod.getModContatoreP()));
        statement.setInt(60, statoPod.isFlazzconP() ? 1 : 0);
        statement.setInt(61, statoPod.getNuCifreP());
        statement.setString(62, StatiPodMultiUpdateHandler.formatString(statoPod.getNuMatricBio()));
        statement.setString(63, StatiPodMultiUpdateHandler.formatString(statoPod.getModContatoreBio()));
        statement.setInt(64, statoPod.isFlAzzConBio() ? 1 : 0);
        statement.setInt(65, statoPod.getNuCifreBio());
        statement.setInt(66, statoPod.getNnFascia());
        statement.setString(67, StatiPodMultiUpdateHandler.formatString(statoPod.getStatoRic()));
        statement.setString(68, StatiPodMultiUpdateHandler.formatString(statoPod.getCpUtente()));
        statement.setString(69, StatiPodMultiUpdateHandler.formatString(statoPod.getCpGestore()));
        statement.setString(70, StatiPodMultiUpdateHandler.formatString(statoPod.getServizioTutela()));
        statement.setString(71, StatiPodMultiUpdateHandler.formatDate(dateFormat, dataPrestazione));
        statement.setString(72, statoPod.getCodiceOfferta());
        return true;
    }

    private static String formatString(String value) {
        return value == null || value.isEmpty() ? " " : value;
    }

    private static String formatDate(DateFormat dateFormat, Date date) {
        return date == null ? " " : dateFormat.format(date);
    }
}

