/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.dao.AbstractRecordStatoHandler;
import biz.elabor.prebilling.dao.FlussoCondition;
import biz.elabor.prebilling.dao.MnoMultiUpdateHandler;
import biz.elabor.prebilling.dao.Pdo2GRMultiUpdateHandler;
import biz.elabor.prebilling.dao.SnfMultiUpdateHandler;
import biz.elabor.prebilling.dao.StatiPodMultiUpdateHandler;
import biz.elabor.prebilling.dao.StatoContainer;
import biz.elabor.prebilling.dao.StatoRichiestaMultiUpdateHandler;
import biz.elabor.prebilling.dao.VoltureIVMultiUpdateHandler;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.model.statomisure.SnfResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.homelinux.elabor.arrays.Filter;
import org.homelinux.elabor.exceptions.UnrecoverableException;
import org.homelinux.elabor.structures.listmap.ListMap;

class RecordStatoVoltureHandler
extends AbstractRecordStatoHandler {
    private final StatoContainer status;

    public RecordStatoVoltureHandler(Connection connection, StatoContainer status) {
        super(connection);
        this.status = status;
    }

    @Override
    public void executeMultiUpdate() throws SQLException, UnrecoverableException {
        MnoMultiUpdateHandler mnoHandler = new MnoMultiUpdateHandler(Funzionalita.LETTURE);
        Pdo2GRMultiUpdateHandler pdo2gHandler = new Pdo2GRMultiUpdateHandler(Funzionalita.LETTURE);
        Iterable<MnoResult> voltureElaborate = this.status.getVnoElaborati();
        FlussoCondition vnoCondition = new FlussoCondition(new String[]{"VNO", "PNO", "VNO2G", "PNO2G"});
        Iterable<MnoResult> vnoElaborati = new Filter<MnoResult>(vnoCondition).iterable(voltureElaborate);
        this.executeMultiUpdate(vnoElaborati, StatoMisure.ELABORATO, mnoHandler);
        FlussoCondition pdo2grvCondition = new FlussoCondition(new String[]{"PDO2G"});
        Filter<MnoResult> pd22grvFilter = new Filter<MnoResult>(pdo2grvCondition);
        Iterable<MnoResult> pdoElaborati = pd22grvFilter.iterable(voltureElaborate);
        this.executeMultiUpdate(pdoElaborati, StatoMisure.ELABORATO, pdo2gHandler);
        this.executeMultiUpdate(this.status.getVnoSospesi(), StatoMisure.SOSPESO, mnoHandler);
        this.executeMultiUpdate(this.status.getVnoObsoleti(), StatoMisure.OBSOLETO, mnoHandler);
        this.executeMultiUpdate(this.status.getVnoSospesi(), StatoMisure.SOSPESO, mnoHandler);
        this.executeMultiUpdate(this.status.getVnoEsclusi(), StatoMisure.ESCLUSO, mnoHandler);
        this.executeMultiUpdate(this.status.getVnoEsclusi(), StatoMisure.ESCLUSO, mnoHandler);
        this.executeMultiUpdate(this.status.getSmisElaborati(), StatoMisure.ELABORATO, mnoHandler);
        this.executeMultiUpdate(this.status.getSmisEsclusi(), StatoMisure.ESCLUSO, mnoHandler);
        this.executeMultiUpdate(this.status.getSmisObsoleti(), StatoMisure.OBSOLETO, mnoHandler);
        this.executeMultiUpdate(this.status.getSmisSospesi(), StatoMisure.SOSPESO, mnoHandler);
        this.executeMultiUpdate(this.status.getPnoElaborati(), StatoMisure.ELABORATO, mnoHandler);
        this.executeMultiUpdate(this.status.getRnoElaborati(), StatoMisure.ELABORATO, mnoHandler);
        this.executeFlussiInterniMultiUpdate(this.status.getSnfSospesi(), StatoMisure.SOSPESO);
        VoltureIVMultiUpdateHandler voltureIVHandler = new VoltureIVMultiUpdateHandler();
        this.executeMultiUpdate(this.status.getVoltureIVElaborate(), StatoMisure.ELABORATO, voltureIVHandler);
        StatiPodMultiUpdateHandler statiPodHandler = new StatiPodMultiUpdateHandler();
        this.executeMultiUpdate(this.status.getStatiPod(), null, statiPodHandler);
        StatoRichiestaMultiUpdateHandler statiRichiestaHandler = new StatoRichiestaMultiUpdateHandler();
        this.executeMultiUpdate(this.status.getUpdateStatiRichiesta(), null, statiRichiestaHandler);
    }

    private void executeFlussiInterniMultiUpdate(ListMap<String, SnfResult> snfs, StatoMisure stato) throws SQLException, UnrecoverableException {
        for (Map.Entry entry : snfs.entrySet()) {
            String tabella = (String)entry.getKey();
            Iterable results = (Iterable)entry.getValue();
            SnfMultiUpdateHandler handler = new SnfMultiUpdateHandler(Funzionalita.SWITCH, tabella);
            this.executeMultiUpdate(results, stato, handler);
        }
    }
}

