/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.dao.AbstractRecordStatoHandler;
import biz.elabor.prebilling.dao.MnoMultiUpdateHandler;
import biz.elabor.prebilling.dao.SnfMultiUpdateHandler;
import biz.elabor.prebilling.dao.SofMultiUpdateHandler;
import biz.elabor.prebilling.dao.StatiPodMultiUpdateHandler;
import biz.elabor.prebilling.dao.StatoContainer;
import biz.elabor.prebilling.dao.StatoRichiestaMultiUpdateHandler;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.statomisure.SnfResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.homelinux.elabor.exceptions.UnrecoverableException;
import org.homelinux.elabor.structures.listmap.ListMap;

class RecordStatoSwitchHandler
extends AbstractRecordStatoHandler {
    private final StatoContainer status;

    public RecordStatoSwitchHandler(Connection connection, StatoContainer status) {
        super(connection);
        this.status = status;
    }

    @Override
    public void executeMultiUpdate() throws SQLException, UnrecoverableException {
        SofMultiUpdateHandler sofHandler = new SofMultiUpdateHandler(Funzionalita.SWITCH);
        MnoMultiUpdateHandler mnoHandler = new MnoMultiUpdateHandler(Funzionalita.LETTURE);
        this.executeSnfMultiUpdate(this.status.getSnfElaborati(), StatoMisure.ELABORATO);
        this.executeSnfMultiUpdate(this.status.getSnfSospesi(), StatoMisure.SOSPESO);
        this.executeSnfMultiUpdate(this.status.getSnfObsoleti(), StatoMisure.OBSOLETO);
        this.executeSnfMultiUpdate(this.status.getSnfEsclusi(), StatoMisure.ESCLUSO);
        this.executeMultiUpdate(this.status.getSnmElaborati(), StatoMisure.ELABORATO, mnoHandler);
        this.executeMultiUpdate(this.status.getSnmSospesi(), StatoMisure.SOSPESO, mnoHandler);
        this.executeMultiUpdate(this.status.getSnmObsoleti(), StatoMisure.OBSOLETO, mnoHandler);
        this.executeMultiUpdate(this.status.getSofElaborati(), StatoMisure.ELABORATO, sofHandler);
        this.executeMultiUpdate(this.status.getSofSospesi(), StatoMisure.SOSPESO, sofHandler);
        this.executeMultiUpdate(this.status.getSofObsoleti(), StatoMisure.OBSOLETO, sofHandler);
        StatiPodMultiUpdateHandler statiPodHandler = new StatiPodMultiUpdateHandler();
        this.executeMultiUpdate(this.status.getStatiPod(), null, statiPodHandler);
        StatoRichiestaMultiUpdateHandler statiRichiestaHandler = new StatoRichiestaMultiUpdateHandler();
        this.executeMultiUpdate(this.status.getUpdateStatiRichiesta(), null, statiRichiestaHandler);
    }

    private void executeSnfMultiUpdate(ListMap<String, SnfResult> snfs, StatoMisure stato) throws SQLException, UnrecoverableException {
        for (Map.Entry entry : snfs.entrySet()) {
            String tabella = (String)entry.getKey();
            Iterable results = (Iterable)entry.getValue();
            SnfMultiUpdateHandler handler = new SnfMultiUpdateHandler(Funzionalita.SWITCH, tabella);
            this.executeMultiUpdate(results, stato, handler);
        }
    }
}

